import { Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { Observable } from 'rxjs';

export interface Cliente 
{
    idCliente?: number;
    nombres: string;
    dni: string;
}

@Injectable({
    providedIn: 'root'
})
export class ClienteService 
{
    private apiUrl = 'http://localhost:8091/api/v1/cliente';

    constructor(private http: HttpClient) { }

    listarClientes(): Observable<Cliente[]> 
    {
        return this.http.get<Cliente[]>(`${this.apiUrl}/listarClientes`);
    }

    crearCliente(cliente: Cliente): Observable<number> 
    {
        return this.http.post<number>(`${this.apiUrl}/crearCliente`, cliente);
    }

    actualizarCliente(cliente: Cliente): Observable<string> 
    {
        return this.http.put<string>(`${this.apiUrl}/actualizarCliente`, cliente);
    }

    eliminarCliente(id: number): Observable<string> 
    {
        return this.http.delete<string>(`${this.apiUrl}/eliminarCliente/${id}`);
    }
}
