import { Component, OnInit  } from '@angular/core';
import { ClienteService, Cliente } from 'src/app/services/cliente.service';

@Component({
    selector: 'app-listar-clientes',
    templateUrl: './listar-clientes.component.html',
    styleUrls: ['./listar-clientes.component.scss']
})
export class ListarClientesComponent implements OnInit
{
    clientes: Cliente[] = [];
    loading: boolean = true;
    errorMessage: string = '';

    constructor(private clienteService: ClienteService) { }

    ngOnInit(): void 
    {
        this.obtenerClientes();
    }

    obtenerClientes(): void 
    {
        this.clienteService.listarClientes().subscribe
        (
            ( data: Cliente[] ) => 
            {
                this.clientes = data;
                this.loading = false;
            },
            (error) => 
            {
                this.errorMessage = 'Error al cargar los clientes. Por favor, inténtelo nuevamente.';
                this.loading = false;
                console.error('Error al obtener clientes', error);
            }
        );
    }
}
