import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { ListarClientesComponent } from './components/listar-clientes/listar-clientes.component';
import { ActualizarClienteComponent } from './components/actualizar-cliente/actualizar-cliente.component';
import { CrearClienteComponent } from './components/crear-cliente/crear-cliente.component';
import { EliminarClienteComponent } from './components/eliminar-cliente/eliminar-cliente.component';

/*const routes: Routes = 
[
    { path: 'listar', component: ListarClientesComponent },
    { path: 'actualizar', component: ActualizarClienteComponent },
    { path: 'crear', component: CrearClienteComponent },
    { path: 'eliminar', component: EliminarClienteComponent }
];*/
const routes: Routes = [
    { path: 'clientes', component: ListarClientesComponent },
    { path: 'crear-cliente', component: CrearClienteComponent },
    { path: 'actualizar-cliente/:idCliente', component: ActualizarClienteComponent },
    { path: 'eliminar-cliente/:idCliente', component: EliminarClienteComponent },
    { path: '', redirectTo: '/clientes', pathMatch: 'full' },
    { path: '**', redirectTo: '/clientes' }
  ];

@NgModule({
    imports: [RouterModule.forRoot( routes )],
    exports: [RouterModule]
})
export class AppRoutingModule { }
