package com.example.demo.core.model;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import lombok.Data;

@Data
@Entity
@Table( name = "tb_cliente", schema = "esq_examen" )
public class Cliente
{
    @Id
    @GeneratedValue( strategy = GenerationType.SEQUENCE, generator = "cliente_seq" )
    @SequenceGenerator( name = "cliente_seq", sequenceName = "esq_examen.tb_cliente_seq", allocationSize = 1 )
    @Column( name = "id_cliente" )
    private Integer idCliente;

    @Column( name = "nombres" )
    private String nombres;

    @Column( name = "dni" )
    private String dni;
}
