package com.example.demo.core.controller;

import java.util.List;
import java.util.Optional;

import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.example.demo.core.model.Cliente;
import com.example.demo.core.repository.ClienteRepository;
import com.example.demo.core.request.dto.ReqCliente;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import lombok.AllArgsConstructor;

@AllArgsConstructor
@RestController
@RequestMapping( "api/v1/cliente" )
public class ClienteController
{
    private final ClienteRepository oClienteRepository;
    
    @PostMapping( path = { "/crearCliente" } )
    public Integer crearCliente( @RequestBody ReqCliente oReqCliente )
    {
        System.out.println( "Ingresa crearCliente" );
        
        ObjectMapper mapper = new ObjectMapper();
        Integer iResult = 0;
        try 
        {
            String json = mapper.writeValueAsString( oReqCliente );
            System.out.println( "Objeto en formato JSON: " + json );
            
            Cliente oCliente = new Cliente();
            oCliente.setNombres( oReqCliente.getNombres() );
            oCliente.setDni( oReqCliente.getDni() );
            oCliente = oClienteRepository.save( oCliente );
            iResult = oCliente.getIdCliente();
        } 
        catch ( Exception e ) 
        {
            e.printStackTrace();
            iResult = 0;
        }
        
        return iResult;
    }
    
    @GetMapping( "/listarClientes" )
    public List<Cliente> listarClientes()
    {
        System.out.println( "Listando clientes" );
        //para obtener el listado de clientes
        List<Cliente> oLstCliente = oClienteRepository.findAll();
        return oLstCliente;
    }
    
    @PutMapping( "/actualizarCliente/{idCliente}" )
    public String actualizarCliente( @PathVariable Integer idCliente, @RequestBody ReqCliente oReqCliente )
    {
        System.out.println( "Actualizando cliente con ID: " + idCliente );
        
        ObjectMapper mapper = new ObjectMapper();
        String json;
        try
        {
            json = mapper.writeValueAsString( oReqCliente );
            System.out.println( "Objeto en formato JSON: " + json );
        }
        catch ( JsonProcessingException e )
        {
            e.printStackTrace();
        }
        
        //buscar cliente
        Optional<Cliente> oOptCliente = oClienteRepository.findById( idCliente );
        if( oOptCliente.isPresent() )
        {
            Cliente oCliente = oOptCliente.get();
            if( oReqCliente.getNombres() != null )
            {
                oCliente.setNombres( oReqCliente.getNombres() );
            }
            if( oReqCliente.getDni() != null )
            {
                oCliente.setDni( oReqCliente.getDni() );
            }
            oClienteRepository.save( oCliente );
            
            return "Cliente actualizado correctamente";
        }
        else
        {
            return "Cliente no encontrado";
        }
    }
    
    @DeleteMapping( "/eliminarCliente/{idCliente}" )
    public String eliminarCliente( @PathVariable Integer idCliente )
    {
        Optional<Cliente> oOptCliente = oClienteRepository.findById( idCliente );
        if( oOptCliente.isPresent() )
        {
            oClienteRepository.deleteById( idCliente );
            return "Cliente eliminado correctamente";
        }
        else
        {
            return "Cliente no encontrado";
        }
    }
}
