<?php
define( 'SF_ROOT_DIR', "../../../" );
define( 'SF_APP',      'sys' );
define( 'SF_DEBUG', false );

require_once( SF_ROOT_DIR.DIRECTORY_SEPARATOR.'config'.DIRECTORY_SEPARATOR.'configGlobal.php' );

// 1. Set the content type header to indicate JSON response
header('Content-Type: application/json');

use_helper('UtilFunctions');

// Function to get the authorization header
function get_authorization_header(){
    $headers = null;
    if (isset($_SERVER['Authorization'])) {
        $headers = trim($_SERVER["Authorization"]);
    } else if (isset($_SERVER['HTTP_AUTHORIZATION'])) { // Nginx or fast CGI
        $headers = trim($_SERVER["HTTP_AUTHORIZATION"]);
    } elseif (function_exists('apache_request_headers')) {
        $requestHeaders = apache_request_headers();
        $requestHeaders = array_combine(array_map('ucwords', array_keys($requestHeaders)), array_values($requestHeaders));
        if (isset($requestHeaders['Authorization'])) {
            $headers = trim($requestHeaders['Authorization']);
        }
    }
    return $headers;
}

// Function to get the bearer token from the header
function get_bearer_token() {
    $headers = get_authorization_header();
    // Match the header to the "Bearer {token}" format
    if (!empty($headers)) {
        if (preg_match('/Bearer\s(\S+)/', $headers, $matches)) {
            return $matches[1];
        }
    }
    return null;
}

$token = get_bearer_token();
$permitir_acceso = 0;
if ($token) {
    // Validate the token (e.g., use a JWT library like https://github.com/RobDWaller/ReallySimpleJWT)
    // $isValid = YourTokenValidator::validate($token, $secret);

    // Placeholder for validation logic
    if ($token === "eyJraWQiOiJ1WkdGMFlXTnlaV1JwZEc4dVkyOXRMbU52SWl3aVJtbHljM1JPWVcxbElqIiwidHlwIjoiSldUIiwiYWxnIjoiUlMyNTYifQ.eyJpc3MiOiJFWFBFUklBTiIsInN1YiI6IndzQGRhdGFleGUuY29tIiwiZXhwIjoxNzY5MjA4NTUxLCJpYXQiOjE3NjkyMDc5NTEsImp0aSI6IjI2MjYyZjgyLTFkMmYtNGZkZC05ZWIwLTZiZTdlNWQyNzAxYiIsIkF1dGgiOiJBVVRILUJBU0lDIn0.o9hr8Kl8RUFcHf_Gnp51M1DR9FuonIP_R_GZCHEbQ6jfobkXtHTlR-9Hhf_l4k9_cPnmwsuH7jCDpdjl0AgtdzMYF4enzss4Ja77pF-_z9whUr2hErzD3KWeaMKHYGUKpmjYwlapfOqFG7dKG2xtdEXDKV9pthxeDpz8rsTlEviAYfVtM7kxywTa_ufwDt8YDolI8IX7gVYLQMD0jgzEq75t_CRaB4SUqwA9O96lyMoxwyPvXLgLNTSART2Pq3wIVDCFg5iu6i3H3pF5r2nnp5Dn99GVPvGE2yaKHLasL95xls7wW_wJ4qAz_Bl2YWG-T2uDCuHfrkMKRrFHrKiLGg") {
        //echo json_encode(["status" => "success", "message" => "Access granted to protected resource."]);
        $permitir_acceso = 1;
    } else {
        http_response_code(401); // Unauthorized
        echo json_encode(["status" => "error", "message" => "Invalid token."]);
    }
} else {
    http_response_code(401); // Unauthorized
    echo json_encode(["status" => "error", "message" => "Authorization token required."]);
}

require_once( SF_ROOT_DIR.DIRECTORY_SEPARATOR.'config'.DIRECTORY_SEPARATOR.'configGlobal.php' );

$cn = Conexion::getConexion();



$content = trim( file_get_contents( "php://input" ) );
$decoded = json_decode( $content, true );
//pr( $decoded );
$_POST   = $decoded;
$j_datos = $_POST;
$a_datos = $j_datos['datos'];





//pr( $a_datos );
if($permitir_acceso == 1)
{
    try 
    {
        $a_Result = array();
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //validaciones
        if( !is_array( $a_datos ) )
        {
            throw new Exception( "El requerimiento no es funcional." );
        }
    
        if( !isset( $a_datos['metodo'] ) )
        {
            throw new Exception( "El requerimiento no tiene los parametros establecidos." );
        }
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //Metodos:
        switch($a_datos['metodo'])
        {
            
            case "actualizar_datos_empleado" :
           
                $i_IdEmpresa = 1; ///intval( $a_datos['idempresa'] );
                $i_IdSede    = 1; ///intval( $a_datos['idsede'] );
        
                $o_MST_PersonaEmpleadoFN = new MST_PersonaEmpleadoFN();
                $o_MST_PersonaEmpleadoFN->addCondition( MST_PersonaEmpleadoFN::FlagEstadoAsistencia, "NOT IN", "('X')", false );
                $a_MST_PersonaEmpleado = $o_MST_PersonaEmpleadoFN->select();
                //$i = 1;
                $a_empleados = array();
                foreach ( $a_MST_PersonaEmpleado as $o_MST_PersonaEmpleadoBN ) 
                {
                    //pr( $o_MST_PersonaEmpleadoBN->toArray() );
                    $i = $o_MST_PersonaEmpleadoBN->getIdPersona();
                    $a_empleados[$i]['dni']              = $o_MST_PersonaEmpleadoBN->getNumeroDocumento();
                    $a_empleados[$i]['nombres']          = $o_MST_PersonaEmpleadoBN->getEmpleadoNombres();
                    $a_empleados[$i]['apellido_paterno'] = utf8_encode( $o_MST_PersonaEmpleadoBN->getEmpleadoApellidoPaterno() );
                    $a_empleados[$i]['apellido_materno'] = utf8_encode( $o_MST_PersonaEmpleadoBN->getEmpleadoApellidoMaterno() );
                    $a_empleados[$i]['estado']           = $o_MST_PersonaEmpleadoBN->getFlagEstadoAsistencia();
                    $a_empleados[$i]['idsede']           = $o_MST_PersonaEmpleadoBN->getIdSede();
                    $i++;
                }
        
                $a_Result['estado']    = 1;
                $a_Result['mensaje']   = "Exito";
                $a_Result["empleados"] = $a_empleados;
                break;
            case "listado_subfamilias":
           
                $url_friendly = $a_datos['url_friendly'];
                
                $o_MST_ClaseSubFamiliaFN = new MST_ClaseSubFamiliaFN();
                if($url_friendly)$o_MST_ClaseSubFamiliaFN->addCondition( MST_ClaseSubFamiliaFN::UrlAmigable, "=", $url_friendly, true );
                $o_MST_ClaseSubFamiliaFN->addCondition( MST_ClaseSubFamiliaFN::Estado, "=", 'A', true );
                
                $a_o_MST_ClaseSubFamiliaFN = $o_MST_ClaseSubFamiliaFN->select();
                
                //print_r($a_o_ALM_ItemMastFN);
                
                $a_MST_ClaseSubFamiliaFN = array();
                $i=0;
                //pr($_SERVER);
                foreach ( $a_o_MST_ClaseSubFamiliaFN as $o_MST_ClaseSubFamiliaFN ) 
                {
                    
                        $a_MST_ClaseSubFamiliaFN[$i]['idsubfamilia']            = $o_MST_ClaseSubFamiliaFN->getIdSubFamilia();
                        $a_MST_ClaseSubFamiliaFN[$i]['descripcion']             = utf8_encode( $o_MST_ClaseSubFamiliaFN->getDescripcionSubFamilia() );
                        $a_MST_ClaseSubFamiliaFN[$i]['url_friendly']             = $o_MST_ClaseSubFamiliaFN->getUrlAmigable();////nameToURL( $o_MST_ClaseSubFamiliaFN->getDescripcionSubFamilia() );               
                        $a_MST_ClaseSubFamiliaFN[$i]['foto']              = "https://".$_SERVER["SERVER_NAME"]."/".$o_MST_ClaseSubFamiliaFN->getUbicacionURL();
                        ////echo "update MST_ClaseSubFamilia set UrlAmigable = '".nameToURL($o_MST_ClaseSubFamiliaFN->getDescripcionSubFamilia())."' where IdSubFamilia ='".$o_MST_ClaseSubFamiliaFN->getIdSubFamilia()."';<br>";
                        //if()
                        ///$a_ALM_ItemMastFN[$i]['oferta']             = $a_LstPrecios[1]["PrecioVentaIGV"];
                        $i++;
                    
                }
                
                $a_Result['estado']    = 1;
                $a_Result['mensaje']   = "Exito";
                $a_Result["productos"] = $a_MST_ClaseSubFamiliaFN; 
                break;
            case "grabar_pedido":
                $i_IdEmpresa = 1; ///intval( $a_datos['idempresa'] );
                $i_IdSede    = 1; ///intval( $a_datos['idsede'] );
                
                if(array_key_exists('pagina', $a_datos))$pagina = $a_datos['pagina'];
                if(array_key_exists('tamano_pagina', $a_datos))$tamano_pagina = $a_datos['tamano_pagina'];
                
             
                $s_TipoProc = $this->getRequestParameter( 'tipo_proc' );
                
                $IdCompania         = myUser::getUser()->getIdBusiness();
                
                $TipoDocCliente     = $this->getRequestParameter( 'TipoDocCliente' );
                $NumDocuCliente     = $this->getRequestParameter( 'NumDocuCliente' );
                $OrdenTipoId        = $this->getRequestParameter( 'OrdenTipoId' );
                $ClienteNumero      = trim( $this->getRequestParameter( 'ClienteNumero' ) );
                $ClienteNombre      = trim( $this->getRequestParameter( 'NombreCliente' ) );
                
                $Comentario         = trim( $this->getRequestParameter( 'Comentario' ) );
                $DireccionCliente   = trim( $this->getRequestParameter( 'DireccionCliente' ) );
                //$f_TipoCambio       = GSS_TipoCambioFN::getStaticTipoCambioCobranza();
                $f_TipoCambio       = $this->getRequestParameter( 'MonedaCambioValor' );
                
                $IdAlmacen          = $this->getRequestParameter( 'AlmacenCod' );
                $AlmacenDespacho    = $this->getRequestParameter( 'AlmacenDespacho' );
                
                $IdVendedor         = $this->getRequestParameter( 'IdVendedor' );
                $IdUbigeo           = $this->getRequestParameter( 'IdUbigeo' );
                
                $FactRegla          = $this->getRequestParameter( 'FactRegla' );
        
                $ValidezOrden       = $this->getRequestParameter( 'ValidezOrden' );
                $PlazaEntregaOrden  = $this->getRequestParameter( 'PlazaEntregaOrden' );
                $CondicionVenta     = $this->getRequestParameter( 'CondicionVenta' );
                $s_OrdenCompraRef   = $this->getRequestParameter( 'OrdenCompraRef' );
                
                $s_OrdenTipoComercialId     = $this->getRequestParameter( 'OrdenTipoComercialId' );
                $s_OrdenTipoClasificacionId = $this->getRequestParameter( 'OrdenTipoClasificacionId' );
                $s_DiasAlquiler             = $this->getRequestParameter( 'DiasAlquiler' );
        
                //$a_DataValidez = VTA_OrdenBN::getArrayValidezOrden( $ValidezOrden );
                $o_MST_ValidezOfFN = new MST_ValidezOfFN();
                $o_MST_ValidezOfBN = $o_MST_ValidezOfFN->selectByPK( $ValidezOrden );
                $OrdenVenc = UtilDate::obtenerOrdenFechaVenc( $o_MST_ValidezOfBN->getCantHoras() );
                //$OrdenVenc = UtilDate::obtenerOrdenFechaVenc( ( $s_DiasAlquiler * 24 ) );
                
                $MonedaCod          = $this->getRequestParameter( 'MonedaCod' );
                $MonedaCambioValor  = $this->getRequestParameter( 'MonedaCambioValor' );
                
                $IdProyecto  = $this->getRequestParameter( 'IdProyecto' );
                
                $a_Rs = array();
                
                $con = Conexion::getConexion();
                $con->begin();
                try
                {
                    myUser::getUser()->validar_session();
        
                    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                    //recupero el id de caja y el turno
                    /*$o_FCO_CierreFN = new FCO_CierreFN();
                    $o_FCO_CierreFN->setEstado( FCO_CierreBN::ESTADO_ABIERTO );
                    $o_FCO_CierreFN->setCodVendedor( myUser::getUser()->getUserId() );
                    $a_FCO_Cierre = $o_FCO_CierreFN->select();
                    if( !$a_FCO_Cierre )
                    {
                        throw new Exception( "No se aperturo ninguna Caja." );
                    }
                    if( count( $a_FCO_Cierre ) > 1 )
                    {
                        throw new Exception( "Incongruencia de datos, por favor de revisar el Cierre de Caja." );
                    }
                    if( count( $a_FCO_Cierre ) == 1 )
                    {
                        $o_FCO_CierreBN = $a_FCO_Cierre[0];
                        $IdCaja      = $o_FCO_CierreBN->getIdCaja();
                        $IdTurno     = $o_FCO_CierreBN->getIdTurno();
                        $CodVendedor = $o_FCO_CierreBN->getCodVendedor();
                    }*/
                    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                    //VALIDACION POR EL CODIGO DE VENDEDOR
                    /*if( $CodVendedor != $IdVendedor )
                    {
                        throw new Exception( "El Codigo de Cajero es diferente a la Apertura de Caja." );
                    }*/
                    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
                    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                    //se prepara el almacen por defecto:
                    /*$a_ALM_AlmacenMast = ALM_AlmacenMastFN::recuperarAlmacenParaVentas( myUser::getUser()->getIdSucursal() );
                    if( count( $a_ALM_AlmacenMast ) == 1 )
                    {
                        $IdAlmacen = $a_ALM_AlmacenMast[0]->getIdAlmacen();
                    }
                    else
                    {
                        throw new Exception( "Se tiene que seleccionar un Almacen." );
                    }*/
                    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                    
                    //VALIDACION POR EL TIPO DE CAMBIO
                    //if( !$f_TipoCambio ){ throw new Exception( "Debe de registrar el Tipo de Cambio de hoy." ); }
                    //ahora la validacion que si es soles va 1
                    /*if( $MonedaCod == "LO" )
                    {
                        $MonedaCambioValor = 1;
                    }*/
        
                    //INFO DE LA SUCURSAL
                    $o_GSS_SucursalFN = new GSS_SucursalFN();
                    $o_GSS_SucursalBN = $o_GSS_SucursalFN->selectByPK( myUser::getUser()->getIdSucursal() );
        
                    //se busca el cliente
                    $o_MST_PersonaMastFN = new MST_PersonaMastFN();
                    $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $ClienteNumero );
                    if( !$o_MST_PersonaMastBN )
                    {
                        throw new Exception( "El Nro Documento ingresado no se encuentra registrado." );
                    }
        
                    if( $o_MST_PersonaMastBN->getTipoPersona() == MST_PersonaMastBN::PERSONA_NATURAL )
                    {
                        if( $o_MST_PersonaMastBN->getDireccion() != $DireccionCliente )
                        {
                            //se actualiza la direccion
                            $o_MST_PersonaMastDP = new MST_PersonaMastDP();
                            $o_MST_PersonaMastDP->setIdPersona( $o_MST_PersonaMastBN->getIdPersona() );
                            $o_MST_PersonaMastDP->setDireccion( $DireccionCliente );
                            $o_MST_PersonaMastDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                            $o_MST_PersonaMastDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                            //$o_MST_PersonaMastDP->update();
                        }
                    }
                    
                    $TipoDocCliente          = $o_MST_PersonaMastBN->getTipoDocumento();
                    $NumDocuCliente          = $o_MST_PersonaMastBN->getDocumento();
                    $ClienteDireccion        = $o_MST_PersonaMastBN->getDireccion();
                    $ClienteDistritoDesc     = $o_MST_PersonaMastBN->getDistritoDesc();
                    $ClienteDepartamentoDesc = $o_MST_PersonaMastBN->getDepartamentoDesc();
                    $ProvinciaDesc           = $o_MST_PersonaMastBN->getProvinciaDesc();
                    if( strpos( $NumDocuCliente, "0000" ) === false )
                    {
                        $ClienteNombre = $o_MST_PersonaMastBN->getNombreCompletoLLeno();
                    }
                    else
                    {
                        $NumDocuCliente = "00000000";
                    }
                    $VendedorAsigna     = $o_MST_PersonaMastBN->getVendedorAsignado();
                    //$CanalCliente       = $o_MST_PersonaMastBN->getCanalCliente();
                    $NivelPrecioCliente = $o_MST_PersonaMastBN->getNivelPrecioCliente();
                    
                    $o_VTA_OrdenBN = new VTA_OrdenBN();
                    $o_VTA_OrdenBN->setOrdenObs( $Comentario );
        
                    $o_VTA_OrdenBN->setOrdenImpuestoFlag( "Y" );
                    $o_VTA_OrdenBN->setOrdenExoneradoFlag( "N" );
        
                    //NUEVO PROCEDIMIENTO, POR EXONERACION DEL IGV - 2021-12-29
                    if( $o_GSS_SucursalBN->getEstaExoneradoIGV() )
                    {
                        $o_VTA_OrdenBN->setOrdenImpuestoFlag( "N" );
                        $o_VTA_OrdenBN->setOrdenExoneradoFlag( "Y" );
                    }
        
                    $o_VTA_OrdenBN->setClienteId( ( int ) $ClienteNumero );
                    $o_VTA_OrdenBN->setClienteDocCod( $TipoDocCliente );
                    $o_VTA_OrdenBN->setClienteDocNum( $NumDocuCliente );
                    $o_VTA_OrdenBN->setClienteNombre( $ClienteNombre );
                    //$o_VTA_OrdenBN->setClienteSucursal( $ClienteDireccion );
                    $o_VTA_OrdenBN->setFactDirec1( $ClienteDireccion );
                    $o_VTA_OrdenBN->setFactDirec2( $ClienteDistritoDesc );
                    $o_VTA_OrdenBN->setFactDirec3( $IdUbigeo );
                    $o_VTA_OrdenBN->setPrecioNivel( $NivelPrecioCliente );
                    $o_VTA_OrdenBN->setFactPais( "PERU" );
                    $o_VTA_OrdenBN->setFactEstado( $ProvinciaDesc );
                    $o_VTA_OrdenBN->setFactCiudad( $ClienteDepartamentoDesc );
        
                    $o_VTA_OrdenBN->setValidezOrden( $ValidezOrden );
                    $o_VTA_OrdenBN->setPlazaEntregaOrden( $PlazaEntregaOrden );
                    $o_VTA_OrdenBN->setCondicionVenta( $CondicionVenta );
                    $o_VTA_OrdenBN->setOrdenVenc( $OrdenVenc );
                    $o_VTA_OrdenBN->setOrdenCompraRef( $s_OrdenCompraRef );
                    
                    $o_VTA_OrdenBN->setDiasAlquiler( intval( $s_DiasAlquiler ) );
                    $o_VTA_OrdenBN->setIdProyecto( ( int ) $IdProyecto );
        
                    //ahora se deja actualizar la moneda y el tipo de cambio. - 2020-07-15
                    $o_VTA_OrdenBN->setMonedaCod( $MonedaCod );
                    $o_VTA_OrdenBN->setMonedaCambioValor( floatval( $MonedaCambioValor ) );
                    
                    $o_VTA_OrdenBN->setOrdenTipoId( ( int ) $OrdenTipoId );
                    
                    if( $s_TipoProc == "nvo" )
                    {
                        //NUEVO
                        $o_VTA_OrdenBN->setOrdenTipoComercialId( intval( $s_OrdenTipoComercialId ) );
                        
                        $o_VTA_OrdenBN->setOrdenTipoClasificacionId( intval( $s_OrdenTipoClasificacionId ) );
                        
                        $o_VTA_OrdenBN->setCiaCod( ( int ) $IdCompania );
                        $o_VTA_OrdenBN->setIdSucursal( myUser::getUser()->getIdSucursal() );
                        $o_VTA_OrdenBN->setPtoVtaCod( "LIM" );
        
                        //$o_VTA_OrdenBN->setIdCaja( $IdCaja );
                        //$o_VTA_OrdenBN->setIdTurno( $IdTurno );
                        
                        $s_OrdenFecha = date( "Y-m-d H:i:s" );
                        
                        $o_VTA_OrdenBN->setOrdenFecha( $s_OrdenFecha );
                        $o_VTA_OrdenBN->setAlmacenCod( $IdAlmacen );
                        $o_VTA_OrdenBN->setAlmacenDespacho( $AlmacenDespacho );
                        
                        $o_VTA_OrdenBN->setVendedorCliente( $VendedorAsigna );
        
                        $o_VTA_OrdenBN->setVendedorOrden( myUser::getUser()->getUserId() );
                        if( $this->getRequestParameter( 'IdVendedor' ) )
                        {
                            $o_VTA_OrdenBN->setVendedorOrden( $this->getRequestParameter( 'IdVendedor' ) );
                        }
        
                        //$o_VTA_OrdenBN->setPrecioNivel(  );
                        $o_VTA_OrdenBN->setFactRegla( $FactRegla );
                        
                        //$o_VTA_OrdenBN->setContactoMedio(  );
                        //$o_VTA_OrdenBN->setContactoNombre(  );
                        
                        //$o_VTA_OrdenBN->setDocReferenciaTipo(  );
                        //$o_VTA_OrdenBN->setDocReferenciaNum(  );
                        //$o_VTA_OrdenBN->setDocReferenciaFecha(  );
                        
                        //$o_VTA_OrdenBN->setOrdenImpuestoFlag(  );
                        
                        $o_VTA_OrdenBN->setMonedaCod( $MonedaCod );
                        $o_VTA_OrdenBN->setMonedaCambioValor( floatval( $MonedaCambioValor ) );
                        
                        $o_VTA_OrdenBN->setOrdenEstado( "O" );
                        
                        $o_VTA_OrdenBN->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                        $o_VTA_OrdenBN->setUsuarioCreacion( myUser::getUser()->getUserId() );
                        $o_VTA_OrdenBN->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
                        $o_VTA_OrdenBN->setUsuarioActualizacion( myUser::getUser()->getUserId() );
                        //pr( $o_VTA_OrdenBN ); exit;
                        $o_CotizacionesBL = new CotizacionesBL();
                        $o_CotizacionesBL->iniciarOrdenVenta( $o_VTA_OrdenBN );
                    }
                    else
                    {
                        //UPDATE
                        $o_VTA_OrdenBN->setOrdenId( ( int ) $i_Id );
                        
                        $o_CotizacionesBL = new CotizacionesBL();
                        $o_CotizacionesBL->iniciarOrdenVenta( $o_VTA_OrdenBN );
                    }
                    
                    $i_Id = $o_VTA_OrdenBN->getOrdenId();
                    
                    $con->commit();
                    $a_Result['estado']    = 1;
                    $a_Result['mensaje']   = "Exito se registro el Pedido";
                    $a_Result["numero_pedido"] = $i_Id;
                }
                catch ( Exception $o_Exception )
                {
                    $con->rollback();
                    $a_Rs['error']        = true;
                    $a_Rs['mensaje_error'] = $o_Exception->getMessage();
                }
                
                
                
                break;
            case "listado_productos":
                $pagina = 1;
                $tamano_pagina = 8;
                $url_friendly_subfamilia = "";
                ///$descripcion_producto = $a_datos['descripcion_producto'];
                
                if(array_key_exists('url_friendly', $a_datos))$url_friendly = $a_datos['url_friendly'];
                if(array_key_exists('url_friendly_subfamilia', $a_datos))$url_friendly_subfamilia = $a_datos['url_friendly_subfamilia'];
                if(array_key_exists('busqueda', $a_datos))$busqueda = $a_datos['busqueda'];
                if(array_key_exists('pagina', $a_datos))$pagina = (float)$a_datos['pagina'];
                if(array_key_exists('tamano_pagina', $a_datos))$tamano_pagina = (float)$a_datos['tamano_pagina'];
                if(!$pagina) $pagina = 1;
                if(!$tamano_pagina) $tamano_pagina = 8;
                
                $i_Position = ($pagina-1)*$tamano_pagina;
                $IdSubFamilia = '';
                if($url_friendly_subfamilia)
                {
                    $o_MST_ClaseSubFamiliaFN = new MST_ClaseSubFamiliaFN();
                    $o_MST_ClaseSubFamiliaFN->addCondition( MST_ClaseSubFamiliaFN::UrlAmigable, "=", $url_friendly_subfamilia, true );
                    $a_o_MST_ClaseSubFamiliaFN = $o_MST_ClaseSubFamiliaFN->select();
                    if(is_array($a_o_MST_ClaseSubFamiliaFN))
                    {
                        foreach ( $a_o_MST_ClaseSubFamiliaFN as $o_MST_ClaseSubFamiliaFN ) 
                        {
                            $IdSubFamilia = $o_MST_ClaseSubFamiliaFN->getIdSubFamilia();
                            ////echo $IdSubFamilia."*-*-*-*-"; 
                        }
                    }
                }
                $o_ALM_ItemMastFN = new ALM_ItemMastFN( );
               
                ///$o_ALM_ItemMastFN->addCondition( ALM_ItemMastFN::IdItem, "LIKE", "%%".$descripcion_producto."%" ,false);
                //$o_ALM_ItemMastFN->addCondition( ALM_ItemMastFN::IdItem, "LIKE", "00157" ,true  );
                if($busqueda) $o_ALM_ItemMastFN->addCondition( ALM_ItemMastFN::DescripcionCompleta, "LIKE", "%".$busqueda."%" ,true  );
                if($IdSubFamilia) $o_ALM_ItemMastFN->addCondition( ALM_ItemMastFN::IdSubFamilia, "=", $IdSubFamilia, true );////$o_ALM_ItemMastFN->setIdSubFamilia( (int) $IdSubFamilia);
                if($url_friendly) $o_ALM_ItemMastFN->addCondition( ALM_ItemMastFN::UrlAmigable, "=", $url_friendly, true );
                $o_ALM_ItemMastFN->addCondition( ALM_ItemMastFN::Estado, "=", 'A', true );
                $o_ALM_ItemMastFN->addCondition( ALM_ItemMastFN::IdItemTipo, "=", '01', true ); //Mercaderia
                $o_ALM_ItemMastFN->addOrderBy( ALM_ItemMastFN::DescripcionCompleta);
                
                $a_o_ALM_ItemMastFN = $o_ALM_ItemMastFN->select($i_Position , $tamano_pagina );
                
                //print_r($a_o_ALM_ItemMastFN);
                
                $a_ALM_ItemMastFN = array();
                $i=0;
                //pr($a_o_ALM_ItemMastFN);
                
                foreach ( $a_o_ALM_ItemMastFN as $o_ALM_ItemMastFN ) 
                {
                    $a_LstPrecios = MST_ListaPrecioDetalleFN::getArrayPrecios( $o_ALM_ItemMastFN->getIdItem() );
                    //pr( $a_LstPrecios);
                    if(is_array($a_LstPrecios) && count($a_LstPrecios))
                    {
                        $a_ALM_ItemMastFN[$i]['codigo']             = $o_ALM_ItemMastFN->getIdItem();
                        $a_ALM_ItemMastFN[$i]['nombre']             = $o_ALM_ItemMastFN->getDescripcionCompleta();
                        ////$a_ALM_ItemMastFN[$i]['nombre']             = utf8_encode( $o_ALM_ItemMastFN->getDescripcionCompleta() );
                        $a_ALM_ItemMastFN[$i]['detalle']            = $o_ALM_ItemMastFN->getDescripcionLarga() ;
                        //$a_ALM_ItemMastFN[$i]['url_friendly']       = nameToURL($o_ALM_ItemMastFN->getDescripcionCompleta()) ;
                        $a_ALM_ItemMastFN[$i]['url_friendly']       = $o_ALM_ItemMastFN->getUrlAmigable() ;
                        $a_ALM_ItemMastFN[$i]['unidad_medida']      = "UNID" ;
                        //echo "update ALM_ItemMast set url_friendly = '".nameToURL($o_ALM_ItemMastFN->getDescripcionCompleta())."' where IdItem ='".$o_ALM_ItemMastFN->getIdItem()."';<br>";
                        $a_ALM_ItemMastFN[$i]['precio']             = $a_LstPrecios[1]["PrecioVentaIGV"];
                        
                        $a_ALM_ItemMastFN[$i]['precio_oferta']      = "";
                        
                        if($o_ALM_ItemMastFN->getUbicacionURL())    $a_ALM_ItemMastFN[$i]['foto']              = "https://".$_SERVER["SERVER_NAME"]."".$o_ALM_ItemMastFN->getUbicacionURL();
                        else $a_ALM_ItemMastFN[$i]['foto']              = "https://".$_SERVER["SERVER_NAME"]."/sisventas/web/images/productos/default.png";
                        //if()
                        ///$a_ALM_ItemMastFN[$i]['oferta']             = $a_LstPrecios[1]["PrecioVentaIGV"];
                        $i++;
                    }
                }
                
                $a_Result['estado']    = 1;
                $a_Result['mensaje']   = "Exito";
                $a_Result["productos"] = $a_ALM_ItemMastFN; 
                break;
            
            case "actualizar_datos_empleado":
            
                $i_IdEmpresa = 1; ///intval( $a_datos['idempresa'] );
                $i_IdSede    = 1; ///intval( $a_datos['idsede'] );
        
                $o_MST_PersonaEmpleadoFN = new MST_PersonaEmpleadoFN();
                $o_MST_PersonaEmpleadoFN->addCondition( MST_PersonaEmpleadoFN::FlagEstadoAsistencia, "NOT IN", "('X')", false );
                $a_MST_PersonaEmpleado = $o_MST_PersonaEmpleadoFN->select();
                //$i = 1;
                $a_empleados = array();
                foreach ( $a_MST_PersonaEmpleado as $o_MST_PersonaEmpleadoBN ) 
                {
                    //pr( $o_MST_PersonaEmpleadoBN->toArray() );
                    $i = $o_MST_PersonaEmpleadoBN->getIdPersona();
                    $a_empleados[$i]['dni']              = $o_MST_PersonaEmpleadoBN->getNumeroDocumento();
                    $a_empleados[$i]['nombres']          = $o_MST_PersonaEmpleadoBN->getEmpleadoNombres();
                    $a_empleados[$i]['apellido_paterno'] = utf8_encode( $o_MST_PersonaEmpleadoBN->getEmpleadoApellidoPaterno() );
                    $a_empleados[$i]['apellido_materno'] = utf8_encode( $o_MST_PersonaEmpleadoBN->getEmpleadoApellidoMaterno() );
                    $a_empleados[$i]['estado']           = $o_MST_PersonaEmpleadoBN->getFlagEstadoAsistencia();
                    $a_empleados[$i]['idsede']           = $o_MST_PersonaEmpleadoBN->getIdSede();
                    $i++;
                }
        
                $a_Result['estado']    = 1;
                $a_Result['mensaje']   = "Exito";
                $a_Result["empleados"] = $a_empleados;
                break;
        
            case "cerrar_estado":
           
                $o_MST_PersonaEmpleadoFN = new MST_PersonaEmpleadoFN();
                $o_MST_PersonaEmpleadoFN->addCondition( MST_PersonaEmpleadoFN::FlagEstadoAsistencia, "NOT IN", "('X')", false );
                $a_MST_PersonaEmpleado = $o_MST_PersonaEmpleadoFN->select();
                foreach ( $a_MST_PersonaEmpleado as $o_MST_PersonaEmpleadoBN ) 
                {
                    $o_MST_PersonaEmpleadoDP = new MST_PersonaEmpleadoDP();
                    $o_MST_PersonaEmpleadoDP->setIdPersona( $o_MST_PersonaEmpleadoBN->getIdPersona() );
                    $o_MST_PersonaEmpleadoDP->setFlagEstadoAsistencia( "X" );
                    $o_MST_PersonaEmpleadoDP->setUsuarioModificacion( "webservice" );
                    $o_MST_PersonaEmpleadoDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_MST_PersonaEmpleadoDP->update();
                }
                $a_Result['estado']    = 1;
                $a_Result['mensaje']   = "Exito";
                break;
            default:
                 $a_Result['estado']    = 0;
                 $a_Result['mensaje']   = "No existe metodo";
        }
    } 
    catch ( Exception $e ) 
    {
        $a_Result['estado']    = 0;
        $a_Result['mensaje']   = $e->getMessage();
    }
    // 3. Encode the PHP array into a JSON string
    //4. Output the JSON string
    echo html_entity_decode( json_encode( $a_Result, JSON_FORCE_OBJECT ) );
    
    // 3. Encode the PHP array into a JSON string
    ///$json_response = json_encode($data, JSON_PRETTY_PRINT);
    
    // 4. Output the JSON string
    ///echo $json_response;
}
else
{
    $a_Result['estado']    = 0;
    $a_Result['mensaje']   = "No permitido";
}

