<?php
define( 'SF_ROOT_DIR', "../../../" );
//define( 'SF_ROOT_DIR', realpath( dirname( __FILE__ ) ) );
define( 'SF_APP',      'sys' );
define( 'SF_DEBUG',    false );
require_once( SF_ROOT_DIR.DIRECTORY_SEPARATOR.'config'.DIRECTORY_SEPARATOR.'configGlobal.php' );
set_memory_max_time();

error_reporting( E_ALL );
ini_set( 'display_errors', TRUE );
ini_set( 'display_startup_errors', TRUE );
date_default_timezone_set( 'Europe/London');
define( 'EOL', ( PHP_SAPI == 'cli' ) ? PHP_EOL : '<br />' );

set_header_utf8();

//----------------------------------------------------------------------------------------------------------------------------------------------------------
/** Include PHPExcel */
require_once 'PHPExcel-1.8/Classes/PHPExcel.php';
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
if( !isset( $_REQUEST['archivo'] ) )
{
    pr( "Se necesita el parametro [archivo=]" );
    exit;
}
if( isset( $_REQUEST['archivo'] ) && trim( $_REQUEST['archivo'] ) == "" )
{
    pr( "Se necesita el parametro [archivo=]" );
    exit;
}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
PARA LIMPIAR ANTES DE REALIZAR LA CARGA INICIAL

DELETE FROM ALM_ItemMast;
DELETE FROM ALM_Marca;

DELETE FROM ALM_ItemAlmacenStock;
DELETE FROM ALM_ItemStockDetHis;
DELETE FROM ALM_Kardex;
DELETE FROM ALM_OrdenGuiaFactura;
DELETE FROM ALM_RequerimientoDetalleLog;
DELETE FROM ALM_TransaccionCabecera;
DELETE FROM ALM_TransaccionDetalle;
DELETE FROM ALM_TransParaRepInv;
DELETE FROM MST_ItemUbicacion;
DELETE FROM MST_ListaPrecioDetalle;
DELETE FROM RegistroHistorial;
DELETE FROM VTA_Orden;
DELETE FROM VTA_OrdenDetalle;
DELETE FROM ALM_Lote;
DELETE FROM CP_Obligaciones;
DELETE FROM FCO_Aplicacion;
DELETE FROM FCO_Cierre;
DELETE FROM FCO_DocRecibo;
DELETE FROM MST_ClaseFamilia;
DELETE FROM MST_ClaseLinea;
DELETE FROM MST_ClaseSubFamilia;
DELETE FROM MST_ClienteMast;
*/
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

$archivo = trim( $_REQUEST['archivo'] );

if ( !file_exists( $archivo ) )
{
    pr( "EL nombre del archivo [$archivo] no existe." );
    exit;
}

$inputFileType = PHPExcel_IOFactory::identify( $archivo );
$objReader     = PHPExcel_IOFactory::createReader( $inputFileType );
$objPHPExcel   = $objReader->load( $archivo );
$sheet         = $objPHPExcel->getSheet( 0 );
$highestRow    = $sheet->getHighestRow();
$highestColumn = $sheet->getHighestColumn();

$o_DBConnect = Conexion::getConexion();

//----------------------------------------------------------------------------------------------------------------------------------------------------------
?>
<form method="POST" name="form1" action="" >
    <input type="hidden" name="Control" value="1">
    <input type="submit" value="GUARDAR" name="">
    <table cellspacing="0" cellspacing="0" border="1">
        <tr>
            <th>Nro</th>
            <th>EXISTE ITEM</th>
            <th>CODIGO</th>
            <th>DESCRIPCION</th>
            <th>DESCRIPCION SISTEMA</th>
            <th>STOCK</th>
            <th>COSTO INC IGV</th>
            <th>PRECIO INC IGV</th>
            <th>ALMACEN</th>
            <th>FECHA TRX</th>
            <th>COMPANIA</th>
            <th>SUCURSAL</th>
        </tr>
<?php
$s_IdAlmacen  = "";
$s_IdComania  = "";
$s_IdSucursal = "";

$s_FechaOriginal = "";
$fec_vencimiento = "";

$s_NombreComania  = "";
$s_NombreSucursal = "";

$o_GSS_CompaniaBN = null;

$i = 1;
for ( $row = 2; $row <= $highestRow; $row++ )
{
    $nombre_producto_sistema = "";

    if( trim( $sheet->getCell( "B".$row )->getValue() ) )
    {
        //$id_excel_prod   = strtoupper( trim( $sheet->getCell( "A".$row )->getValue() ) );
        $id_excel        = strtoupper( trim( $sheet->getCell( "A".$row )->getValue() ) );
        $codigo_producto = str_pad( strtoupper( trim( $sheet->getCell( "B".$row )->getValue() ) ), 5, "0", STR_PAD_LEFT );
        $nombre_producto = strtoupper( trim( $sheet->getCell( "C".$row )->getValue() ) );
        $stock_producto  = ( trim( $sheet->getCell( "D".$row )->getValue() ) );
        $costo_producto  = round( floatval( trim( $sheet->getCell( "E".$row )->getValue() ) ), 2 ); //INCLUDO IGV
        $precio_final    = floatval( trim( $sheet->getCell( "F".$row )->getValue() ) ); //SE ASUME QUE EL PRECIO ESTA INCLUIDO EL IGV
        $cod_almacen     = ( trim( $sheet->getCell( "G".$row )->getValue() ) );
        $fecha_trx       = ( trim( $sheet->getCell( "H".$row )->getValue() ) );
        //$fec_vencimiento = ( trim( $sheet->getCell( "I".$row )->getValue() ) );

        //VALIDACIONES
        if( $costo_producto > $precio_final )
        {
            //pr( "El Producto [$codigo_producto] tiene el costo mayor que el precio" );
        }

        //$fec_vencimiento = date( 'Y-m-d', PHPExcel_Shared_Date::ExcelToPHP( $fec_vencimiento ) );
        $lote_producto   = "000";
        if( $fecha_trx )
        {
            $fecha_trx = date( 'Y-m-d H:i:s', PHPExcel_Shared_Date::ExcelToPHP( $fecha_trx ) );
            if( $fec_vencimiento == "" )
            {
                $fec_vencimiento = UtilDate::sumarDias( $fecha_trx, 30 );
            }
        }
        $s_IdAlmacen = $cod_almacen;
        $s_Exite     = "NO";

        if( intval( $stock_producto ) > 0 )
        {
            $o_ALM_ItemMastBN = ALM_ItemMastFN::buscarItemxId( $codigo_producto ); //BUSCAR POR EL CODIGO DE BARRAS.
            if( $o_ALM_ItemMastBN )
            {
                if( $o_ALM_ItemMastBN->getEstado() == "I" )
                {
                    continue;
                }
                $s_Exite = "SI";
                $nombre_producto_sistema = $o_ALM_ItemMastBN->getDescripcionCompleta();
                $a_DataValores[] = array( "IdItem" => $codigo_producto, "Cantidad" => $stock_producto, "Costo" => $costo_producto, "Lote" => $lote_producto, "FechaVenci" => $fec_vencimiento, "PrecioFinal" => $precio_final );
            }
            $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
            $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $s_IdAlmacen );
            if( $o_ALM_AlmacenMastBN )
            {
                $s_IdSucursal = $o_ALM_AlmacenMastBN->getIdSucursal();
                $s_IdComania  = $o_ALM_AlmacenMastBN->getIdCompania();

                $s_NombreComania = $o_ALM_AlmacenMastBN->getObjectCompania()->getDescripcionCorta();
                $s_NombreSucursal = $o_ALM_AlmacenMastBN->getDescripcionSucursal();
            }
            ?>
            <tr>
                <td align="center"><?=$i?></td>
                <td align="center"><?=$s_Exite?></td>
                <td align="center"><?=$codigo_producto?></td>
                <td><?=$nombre_producto?></td>
                <td><?=$nombre_producto_sistema?></td>
                <td align="center"><?=$stock_producto?></td>
                <td align="center"><?=$costo_producto?></td>
                <td align="center"><?=$precio_final?></td>
                <td align="center"><?=$cod_almacen?></td>
                <td align="center"><?=$fecha_trx?></td>
                <td><?=$s_NombreComania?></td>
                <td><?=$s_NombreSucursal?></td>
            </tr>
            <?php
        }
        else
        {
            ?>
            <tr>
                <td align="center"><?=$i?></td>
                <td align="center">NO</td>
                <td><?=$codigo_producto?></td>
                <td>-</td>
                <td>-</td>
                <td>-</td>
                <td>-</td>
                <td>-</td>
                <td>-</td>
                <td>-</td>
                <td>-</td>
                <td>-</td>
            </tr>
            <?php
        }
    }
    $i++;
}
?>
</table>
</form>

<?php
if( isset( $_POST['Control'] ) )
{
    //$s_IdComania                 = 1; //compania, siempre validar la carga inicial, tambien inicial sesion con el usuario de la misma compania
    $s_FechaOriginal            = $fecha_trx;
    $FechaDocumento             = $fecha_trx;
    $IdTransaccionOperacion     = "I";
    //$s_IdAlmacen                  = "ALM00001"; //ALMACEN ORIGEN --- DINAMICO - se hace el cambio por cada transaccion
    //$s_IdAlmacen                  = $_REQUEST['almacen']; //ALMACEN ORIGEN --- DINAMICO - se hace el cambio por cada transaccion
    $IdTransaccion              = "STI"; //carga inicial
    $AlmacenTraslado            = ""; //ALMACEN DE DESTINO
    $IdTipoDocumento            = "CT";

    $ReferenciaTipoDocumento    = "GR";
    $ReferenciaSerieDocumento   = "1"; //
    $ReferenciaNumeroDocumento  = "1"; //

    $s_SerieDocumentoFiscal     = str_pad( $ReferenciaSerieDocumento, 4, "0", STR_PAD_LEFT );
    $s_NumeroDocumentoFiscal    = str_pad( $ReferenciaNumeroDocumento, 10, "0", STR_PAD_LEFT );

    $Comentario                 = "CARGA INICIAL"; //

    if( !GSS_TipoCambioFN::getStaticTipoCambioCobranza() )
    {
        $s_FechaSel = date( "Y-m-d" );

        $o_iVentas = new iVentas();
        $o_iVentas->registrarTipoCambio( $s_FechaSel );
    }

    $TipodeCambio = GSS_TipoCambioFN::getStaticTipoCambioVenta();

    $o_Base_ALM_TransaccionCabeceraBN = new ALM_TransaccionCabeceraBN();
    $o_Base_ALM_TransaccionCabeceraBN->setIdTransaccion( $IdTransaccion );
    //$o_Base_ALM_TransaccionCabeceraBN->setAlmacenTraslado( $AlmacenTraslado );
    $o_Base_ALM_TransaccionCabeceraBN->setIdAlmacen( $s_IdAlmacen );
    $o_Base_ALM_TransaccionCabeceraBN->setIdTransaccionOperacion( $IdTransaccionOperacion );
    $o_Base_ALM_TransaccionCabeceraBN->setFechaDocumento( $FechaDocumento );
    $o_Base_ALM_TransaccionCabeceraBN->setTipodeCambio( floatval( $TipodeCambio ) );
    $o_Base_ALM_TransaccionCabeceraBN->setMonedaCod( "LO" );
    $o_Base_ALM_TransaccionCabeceraBN->setCodigoCliente( '249' );
    $o_Base_ALM_TransaccionCabeceraBN->setCodigoProveedor( "249" );
    $o_Base_ALM_TransaccionCabeceraBN->setDescripcion( $Comentario );

    $o_Base_ALM_TransaccionCabeceraBN->setReferenciaTipoDocumento( $ReferenciaTipoDocumento );
    $o_Base_ALM_TransaccionCabeceraBN->setReferenciaNumeroDocumento( $ReferenciaNumeroDocumento );

    $o_Base_ALM_TransaccionCabeceraBN->setIdCompania( $s_IdComania );
    $o_Base_ALM_TransaccionCabeceraBN->setIdSucursal( $s_IdSucursal );
    $o_Base_ALM_TransaccionCabeceraBN->setIdTipoDocumento( $IdTipoDocumento );
    $o_Base_ALM_TransaccionCabeceraBN->setComentario( $Comentario );

    $o_Base_ALM_TransaccionCabeceraBN->setTipoDocumentoFiscal( $ReferenciaTipoDocumento );
    $o_Base_ALM_TransaccionCabeceraBN->setSerieDocumentoFiscal( $s_SerieDocumentoFiscal );
    $o_Base_ALM_TransaccionCabeceraBN->setNumeroDocumentoFiscal( $s_NumeroDocumentoFiscal );
    /////////////////

    $s_Mensaje = "";
    $i_Id      = "X";

    pr( "GUARDAR" );

    $con = Conexion::getConexion();
    $con->begin();
    try
    {
        pr( "---------------------------------------------------------------------------------------------------------------------" );

        $o_ALM_TransaccionCabeceraBN = clone $o_Base_ALM_TransaccionCabeceraBN;

        $a_MovientoDetalle = array();
        foreach ( $a_DataValores as $i_Key => $a_Valores )
        {
            if( floatval( $a_Valores['Costo'] ) <= 0 )
            {
                pr( "No tiene Costo asignado -> ".$a_Valores['IdItem'] );
                exit;
            }

            //ENTONCES AHORA SE ASIGNA EL COSTO Y PRECIO
            $f_MontoCostoIGV = round( floatval( $a_Valores['Costo'] ), 2 );
            $f_MontoCosto    = round( ( $f_MontoCostoIGV / 1.18 ), 2 );

            $b_ControPrecio     = true;
            $f_PrecioVenta      = 0;
            $f_PrecioVentaIGV   = 0;
            $f_TotalIGV         = 0;
            if( floatval( $a_Valores['PrecioFinal'] ) > 0 )
            {
                $f_PrecioVentaIGV = round( floatval( $a_Valores['PrecioFinal'] ), 2 );
                $f_PrecioVenta    = round( ( $f_PrecioVentaIGV  / 1.18 ), 2 );
                $f_TotalIGV       = round( $f_PrecioVentaIGV - $f_PrecioVenta, 2 );
            }
            else
            {
                $b_ControPrecio = false;
            }

            if( $b_ControPrecio )
            {
                //POR DEFECTO EL ID DE LA CABECERA DE LISTA DE PRECIO ES 1
                //POR DEFECTO EL RANGO ES 1
                $o_MST_RangoDetalleFN = new MST_RangoDetalleFN();
                $o_MST_RangoDetalleFN->setIdRango( 1 );
                $a_MST_RangoDetalle = $o_MST_RangoDetalleFN->select();

                foreach( $a_MST_RangoDetalle as $o_MST_RangoDetalleBN )
                {
                    $o_MST_ListaPrecioDetalleFN = new MST_ListaPrecioDetalleFN();
                    $o_MST_ListaPrecioDetalleFN->setIdCompania( 1 );
                    $o_MST_ListaPrecioDetalleFN->setIdSucursal( 1 );
                    $o_MST_ListaPrecioDetalleFN->setIdItem( $a_Valores['IdItem'] );
                    $o_MST_ListaPrecioDetalleFN->setIdTipoLista( 1 ); //POR DEFECTO
                    $o_MST_ListaPrecioDetalleFN->setIdRango( 1 );
                    $o_MST_ListaPrecioDetalleFN->setIdRangoDetalle( $o_MST_RangoDetalleBN->getIdRangoDetalle() );
                    $a_MST_ListaPrecioDetalle = $o_MST_ListaPrecioDetalleFN->select();

                    $o_DefaultDP = new MST_ListaPrecioDetalleDP();
                    $o_DefaultDP->setIdCompania( 1 );
                    $o_DefaultDP->setIdSucursal( 1 );
                    $o_DefaultDP->setIdListaPreciCab( 1 );
                    $o_DefaultDP->setIdItem( $a_Valores['IdItem'] );
                    $o_DefaultDP->setIdTipoLista( 1 );
                    $o_DefaultDP->setIdRango( 1 );
                    $o_DefaultDP->setIdRangoDetalle( $o_MST_RangoDetalleBN->getIdRangoDetalle() );
                    $o_DefaultDP->setIdTipoPrecio( "1" );
                    $o_DefaultDP->setPrecioCosto( $f_MontoCosto );
                    $o_DefaultDP->setPrecioCostoIGV( $f_MontoCostoIGV );
                    $o_DefaultDP->setPrecioVenta( $f_PrecioVenta );
                    $o_DefaultDP->setMontoIGV( $f_TotalIGV );
                    $o_DefaultDP->setPrecioVentaIGV( $f_PrecioVentaIGV );
                    $o_DefaultDP->setMontoDescuento( 0 );
                    $o_DefaultDP->setPorcentajeDescuento( 0 );
                    $o_DefaultDP->setDescuentoFlag( "N" );
                    $o_DefaultDP->setEstado( "A" );

                    if( $a_MST_ListaPrecioDetalle )
                    {
                        //update
                        $i_IdDet = $a_MST_ListaPrecioDetalle[0]->getIdListaPreciDet();
                        $o_DefaultDP->setIdListaPreciDet( $i_IdDet );

                        $o_DefaultDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_DefaultDP->update();
                    }
                    else
                    {
                        //insert
                        $i_IdDet = MST_ListaPrecioDetalleDP::recuperarId();

                        $o_DefaultDP->setIdListaPreciDet( $i_IdDet );

                        $o_DefaultDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                        $o_DefaultDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                        $o_DefaultDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_DefaultDP->save();
                    }
                }
            }

            $i_IdUnidadMedidaAsig = ALM_ItemMastFN::getItemUnidadVentaAsignada( $a_Valores['IdItem'] ); //UNI MEDIDA ASIGNADA
            
            //ahora se actualiza el costo al item
            $o_ALM_ItemMastDP = new ALM_ItemMastDP();
            $o_ALM_ItemMastDP->setIdItem( $a_Valores['IdItem'] );
            $o_ALM_ItemMastDP->setPrecioCosto( $f_MontoCosto );
            $o_ALM_ItemMastDP->setPrecioVenta( $f_MontoCostoIGV );
            //$o_ALM_ItemMastDP->setPrecioUnitarioLocal( round( floatval( $a_Valores['Costo'] ) / 1.18, 4 ) );
            //$o_ALM_ItemMastDP->setPrecioUnitarioDolares( round( floatval( $a_Valores['Costo'] ) / 1.18, 4 ) );
            $o_ALM_ItemMastDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_ALM_ItemMastDP->setUsuarioModificacion( "wtaype" );
            $o_ALM_ItemMastDP->update_varios();

            $o_ALM_TransaccionDetalleBN = new ALM_TransaccionDetalleBN();
            $o_ALM_TransaccionDetalleBN->setIdItem( $a_Valores['IdItem'] );
            $o_ALM_TransaccionDetalleBN->setCantidad( intval( $a_Valores['Cantidad'] ) );
            $o_ALM_TransaccionDetalleBN->setPrecioUnitario( $f_MontoCosto );
            $o_ALM_TransaccionDetalleBN->setLote( $a_Valores['Lote'] );
            $o_ALM_TransaccionDetalleBN->setFechaVencimiento( $a_Valores['FechaVenci'] );
            $o_ALM_TransaccionDetalleBN->setFechaVencimientoLote( $a_Valores['FechaVenci'] );
            $o_ALM_TransaccionDetalleBN->setUnidadCodigo( $i_IdUnidadMedidaAsig );
            
            $o_ALM_TransaccionDetalleBN->setIdTransaccionCab( $IdTransaccion );
            $o_ALM_TransaccionDetalleBN->setFechaDocumentoCab( $FechaDocumento );
            
            $a_MovientoDetalle[] = $o_ALM_TransaccionDetalleBN;

            //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //AHORA SE GUARDA EL LOG PARA POSTERIORMENTE RECUPERAR EL PRECIO
            $f_TipoCambio        = $o_ALM_TransaccionCabeceraBN->getTipodeCambio();
            $f_PrecioUnitario    = $f_MontoCosto;
            $f_PrecioUnitarioIGV = $f_MontoCostoIGV;

            if( $o_ALM_TransaccionCabeceraBN->getMonedaCod() == "LO" )
            {
                $f_PrecioUnitarioMN = $f_PrecioUnitario;
                $f_PrecioUnitarioME = round( $f_PrecioUnitario / $f_TipoCambio, 2 );

                $f_PrecioUnitarioIGVMN = $f_PrecioUnitarioIGV;
                $f_PrecioUnitarioIGVME = round( $f_PrecioUnitarioIGV / $f_TipoCambio, 2 );
            }
            if( $o_ALM_TransaccionCabeceraBN->getMonedaCod() == "EX" )
            {
                $f_PrecioUnitarioMN = round( $f_PrecioUnitario * $f_TipoCambio, 2 ) ;
                $f_PrecioUnitarioME = $f_PrecioUnitario;

                $f_PrecioUnitarioIGVMN = round( $f_PrecioUnitarioIGV * $f_TipoCambio, 2 );
                $f_PrecioUnitarioIGVME = $f_PrecioUnitarioIGV;
            }

            $i_IdRequerimientoLog = ALM_RequerimientoDetalleLogFN::recuperarId();

            $o_ALM_RequerimientoDetalleLogDP = new ALM_RequerimientoDetalleLogDP();
            $o_ALM_RequerimientoDetalleLogDP->setIdRequerimientoLog( $i_IdRequerimientoLog );
            $o_ALM_RequerimientoDetalleLogDP->setTipo( "TX" );
            $o_ALM_RequerimientoDetalleLogDP->setIdRequerimiento( intval( $o_ALM_TransaccionCabeceraBN->getIdNumeroDocumento() ) );
            $o_ALM_RequerimientoDetalleLogDP->setIdCompania( $s_IdComania );
            $o_ALM_RequerimientoDetalleLogDP->setIdSucursal( $s_IdSucursal );
            $o_ALM_RequerimientoDetalleLogDP->setIdRequerimientoDetalle( ( $i_Key + 1 ) );
            $o_ALM_RequerimientoDetalleLogDP->setIdPersona( intval( $o_ALM_TransaccionCabeceraBN->getCodigoCliente() ) );
            $o_ALM_RequerimientoDetalleLogDP->setIdItem( $o_ALM_TransaccionDetalleBN->getIdItem() );
            $o_ALM_RequerimientoDetalleLogDP->setIdMoneda( $o_ALM_TransaccionDetalleBN->getIdMoneda() );
            $o_ALM_RequerimientoDetalleLogDP->setTipoCambio( $f_TipoCambio );
            $o_ALM_RequerimientoDetalleLogDP->setCantidad( $o_ALM_TransaccionDetalleBN->getCantidad() );

            $o_ALM_RequerimientoDetalleLogDP->setPrecioUnitario( $f_PrecioUnitario );
            $o_ALM_RequerimientoDetalleLogDP->setPrecioUnitarioMN( $f_PrecioUnitarioMN );
            $o_ALM_RequerimientoDetalleLogDP->setPrecioUnitarioME( $f_PrecioUnitarioME );
            $o_ALM_RequerimientoDetalleLogDP->setPrecioUnitarioIGV( $f_PrecioUnitarioIGV );
            $o_ALM_RequerimientoDetalleLogDP->setPrecioUnitarioIGVMN( $f_PrecioUnitarioIGVMN );
            $o_ALM_RequerimientoDetalleLogDP->setPrecioUnitarioIGVME( $f_PrecioUnitarioIGVME );

            $o_ALM_RequerimientoDetalleLogDP->setUsuarioCreacion( "wtaype" );
            $o_ALM_RequerimientoDetalleLogDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
            $o_ALM_RequerimientoDetalleLogDP->setUsuarioModificacion( "wtaype" );
            $o_ALM_RequerimientoDetalleLogDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_ALM_RequerimientoDetalleLogDP->save();
            //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        }
        
        $o_ALM_TransaccionCabeceraBN->setArrayMovientoDetalle( $a_MovientoDetalle );

        //pr( $o_ALM_TransaccionCabeceraBN ); exit;

        $o_MovimientoBL = new MovimientoBL();
        $o_MovimientoBL->GuardarMovientoTransaccion( $o_ALM_TransaccionCabeceraBN );
        
        //AQUI SE VA APROVECHA EN HACER UN PROCEDIMIENTO PARA TOMAR UNA FOTO AL STOCK FISICO POR DIA - 20200813
        $o_ALM_ItemStockDetHisDP = new ALM_ItemStockDetHisDP();
        $o_ALM_ItemStockDetHisDP->setIdCompania( $s_IdComania );
        $o_ALM_ItemStockDetHisDP->setIdSucursal( $s_IdSucursal );
        $o_ALM_ItemStockDetHisDP->setIdFecha( $s_FechaOriginal );
        $o_ALM_ItemStockDetHisDP->deleteCompPeriodo();
        $o_ALM_ItemStockDetHisDP->realizarFotoStockFisico();

        $i_Id = $o_ALM_TransaccionCabeceraBN->getIdTransaccionCabeceraConcat();
        $s_Mensaje .= "Transaccion Id: ".$i_Id."\n";
        pr( $s_Mensaje );

        pr( "---------------------------------------------------------------------------------------------------------------------" );

        $con->commit();
    }
    catch ( Exception $o_Exception )
    {
        $con->rollback();
        pr( $o_Exception );
    }

}