<?php
//referencia
//http://www.redecodifica.com/consultar-ruc-de-una-empresa-con-sunat-peru-php-javascript/
class consulta_sunat
{
    protected $ruc;
    
    public function getRuc()
    {
        return $this->ruc;
    }
    public function setRuc($ruc)
    {
        $this->ruc = $ruc;
    }
    
    public function get_content()
    {
        $a_Result = array( );
        try
        {
            $ruc = $this->getRuc();
            if( $ruc == "" )
            {
                throw new Exception( "Se necesita RUC para poder continuar." );
            }
            
            $s_data_json = json_encode( array( "ruc" => $ruc ) );
            $RUTA_API = "https://api.sunat.cloud/ruc/$ruc";
            
            $curl = curl_init();
            curl_setopt_array
            (
                    $curl,
                    array
                    (
                            CURLOPT_SSL_VERIFYPEER => false,
                            CURLOPT_URL            => $RUTA_API,
                            CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_ENCODING       => "",
                            CURLOPT_MAXREDIRS      => 10,
                            CURLOPT_TIMEOUT        => 30,
                            CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
                            CURLOPT_CUSTOMREQUEST  => "GET",
                            CURLOPT_HTTPGET        => true
                    )
                    );
            
            $s_Result = curl_exec( $curl );
            $err = curl_error( $curl );
            curl_close( $curl );
            if ( $err ){ throw new Exception( "cURL Error #:" . $err ); }
            
            $a_Result = json_decode( $s_Result, true );
            
            if( !$a_Result )
            {
                throw new Exception( "API - SUNAT, lanzo una excepcion no controlada, RUC errado o no disponible." );
            }
            $a_Result["error"] = false;
        }
        catch ( Exception $o_Exception )
        {
            $a_Result["error"] = true;
            $a_Result["mensaje_error"] = $o_Exception->getMessage();
        }
        
        return $a_Result;
    }
}