<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of LayoutDefault
 *
 * @author Willy
 */
class LayoutDefault
{
    protected $s_NameStyle;
    protected $s_NameScript;
    protected $o_Action;
    
    public function setDefaultValues()
    {
        $this->s_NameStyle  = "JQuery";
        $this->s_NameScript = "JQuery";
        $this->o_Action     = null;
    }
    
    protected function include_http_metas()
    {
        ob_start();
        ob_implicit_flush( 0 );
        ?>
                <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
                <!--<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />-->
        <?php
        echo ob_get_clean();
    }

    protected function include_metas()
    {
        ob_start();
        ob_implicit_flush( 0 );
        ?>
          <meta name="title" content="Systems" />
          <meta name="robots" content="index, follow" />
          <meta name="description" content="project" />
          <meta name="keywords" content="project" />
          <meta name="language" content="es" />  
          <meta name="viewport" content="width=device-width, initial-scale=1">
          <meta name="theme-color" content="navy" />
        <?php
        echo ob_get_clean();
    }

    protected function include_title()
    {
        ob_start();
        ob_implicit_flush( 0 );
        ?>
          <title> <?=Constantes::TITULO_APPLICATION?> </title>
        <?php
        echo ob_get_clean();
    }

    public function setStyleName( $param )
    {
        $this->s_NameStyle = $param;
    }

    protected function StyleSheetsJQuery()
    {
        $dir_url = Constantes::ROOT_DIR_APP;
        ob_start();
        ob_implicit_flush( 0 );
        ?>
        <link rel="stylesheet" type="text/css" media="screen" href="<?php echo $dir_url ?>web/css/jquery/default/main.css" />
        <link rel="stylesheet" type="text/css" media="screen" href="<?php echo $dir_url ?>web/css/jquery/default/grid.css" />
        <link rel="stylesheet" type="text/css" media="screen" href="<?php echo $dir_url ?>web/css/jquery/default/tab.css" />
          
        <!-- <link rel="stylesheet" type="text/css" href="<?php echo $dir_url ?>/web/css/jquery/themes/start/jquery-ui.css"> -->
        <link rel="stylesheet" type="text/css" href="<?php echo $dir_url ?>web/css/jquery/themes/start_1.12.1/jquery-ui.css">
          
        <link rel="stylesheet" type="text/css" href="<?php echo $dir_url ?>web/css/jquery/jquery.message/jquery.message.css">
        <link rel="stylesheet" type="text/css" href="<?php echo $dir_url ?>web/css/jquery.fancybox.css" />
          
        <link rel="stylesheet" type="text/css" href="<?php echo $dir_url ?>web/css/jquery/jqgrid/ui.jqgrid.css" />


        <?php
        echo ob_get_clean();
    }
    
    protected function include_stylesheets()
    {
        $s_ConcatStyleName =  "StyleSheets".$this->s_NameStyle;
        if( method_exists( $this, $s_ConcatStyleName ) )
        {
            echo $this->$s_ConcatStyleName();
        }
    }

    public function setScriptName( $param )
    {
        $this->s_NameScript = $param;
    }

    protected function JavaScriptJQuery()
    {
        $dir_url = Constantes::ROOT_DIR_APP;
        ob_start();
        ob_implicit_flush( 0 );
        ?>
            <!-- <script type="text/javascript" src="<?php echo $dir_url ?>/web/js/jquery/jquery-1.10.2.js"></script> -->
            <!-- <script type="text/javascript" src="<?php echo $dir_url ?>/web/js/jquery/ui-1.10.3/jquery-ui.js"></script> -->
            <script type="text/javascript" src="<?php echo $dir_url ?>web/js/jquery/jquery-3.1.1.js"></script>
            <script type="text/javascript" src="<?php echo $dir_url ?>web/js/jquery/ui-1.12.1.custom/jquery-ui.js"></script>
            
            <!--<script type="text/javascript" src="<?php //echo $dir_url ?>/web/js/jquery/autocomplete/jquery.autocomplete.js"></script>-->
            <script type="text/javascript" src="<?php echo $dir_url ?>web/js/jquery/default/jquery.validate.js"></script>
            
            <script type="text/javascript" src="<?php echo $dir_url ?>web/js/jquery/ajax_upload/AjaxUpload.2.0.min.js"></script>
            
            <script type="text/javascript" src="<?php echo $dir_url ?>web/js/jquery/default/jquery.fancybox.js"></script>
            
            <script type="text/javascript" src="<?php echo $dir_url ?>web/js/jquery/default/index.js"></script>
            <script type="text/javascript" src="<?php echo $dir_url ?>web/js/jquery/default/php.js"></script>
            
            <script type="text/ecmascript" src="<?php echo $dir_url ?>web/js/jquery/jqgrid/jquery.jqGrid.js"></script>
            <script type="text/ecmascript" src="<?php echo $dir_url ?>web/js/jquery/jqgrid/i18n/grid.locale-es.js"></script>
            
            <script type="text/javascript" src="<?php echo $dir_url ?>web/js/jquery/blockui/jquery.blockui.js"></script>
            
            <!-- https://github.com/jaaulde/cookies -->
            <!-- https://github.com/carhartl/jquery-cookie -->
            <script type="text/javascript" src="<?php echo Constantes::ROOT_DIR_APP ?>web/lib/jquery/js/jquery.cookie.js"></script>

            <script type="text/javascript" src="<?php echo $dir_url ?>web/lib/underscore/underscore.js"></script>

            <script>
            $
            (
                function() 
                {
                    //Array para dar formato en espanol
                    $.datepicker.regional['es'] = 
                    {
                        closeText       : 'Cerrar', 
                        prevText        : 'Previo', 
                        nextText        : 'Proximo',
                        monthNames      : ['Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre'],
                        monthNamesShort : ['Ene','Feb','Mar','Abr','May','Jun','Jul','Ago','Sep', 'Oct', 'Nov', 'Dic'],
                        monthStatus     : 'Ver otro mes', 
                        yearStatus      : 'Ver otro a&ntilde;o',
                        dayNames        : ['Domingo', 'Lunes', 'Martes', 'Mi&eacute;rcoles', 'Jueves', 'Viernes', 'Sabado'],
                        dayNamesShort   : ['Dom', 'Lun', 'Mar', 'Mie', 'Jue', 'Vie', 'Sab'],
                        dayNamesMin     : ['Do', 'Lu', 'Ma', 'Mi', 'Ju', 'Vi', 'Sa'],
                        dateFormat      : 'dd/mm/yy', 
                        firstDay        : 0,
                        initStatus      : 'Selecciona la fecha', 
                        isRTL           : false
                    };
                    $.datepicker.setDefaults( $.datepicker.regional['es'] );
                }
            );
            </script>
            <script type="text/javascript" src="<?php echo $dir_url ?>web/js/jquery/default/tab.js"></script>
            <script type="text/javascript" src="<?php echo $dir_url ?>web/js/jquery/default/grid.js"></script>
        <?php
        echo ob_get_clean();
    }

    protected function JavaScriptBootstrap()
    {
        ob_start();
        ob_implicit_flush( 0 );
        ?>
        <script type="text/javascript" src="<?php echo Constantes::ROOT_DIR_APP ?>web/lib/bootstrap/js/popper.min.js"></script>
        <script type="text/javascript" src="<?php echo Constantes::ROOT_DIR_APP ?>web/lib/bootstrap/js/bootstrap.min.4.2.1.js"></script>
        <script type="text/javascript" src="<?php echo Constantes::ROOT_DIR_APP ?>web/lib/bootstrap/font-awesome/js/all.js" integrity="" crossorigin="anonymous"></script>
        <script type="text/javascript" src="<?php echo Constantes::ROOT_DIR_APP ?>web/lib/bootstrap/js/jquery.mCustomScrollbar.concat.min.js"></script>
        <script type="text/javascript" src="<?php echo Constantes::ROOT_DIR_APP ?>web/lib/bootstrap/js/bootstrap-notify.min.js"></script>
        <?php
        echo ob_get_clean();
    }
    
    protected function StyleSheetsBootstrap()
    {
        ob_start();
        ob_implicit_flush( 0 );
        ?>
        <link rel="stylesheet" type="text/css" href="<?php echo Constantes::ROOT_DIR_APP ?>web/lib/bootstrap/css/bootstrap.min.4.2.1.css" />
        <link rel="stylesheet" type="text/css" href="<?php echo Constantes::ROOT_DIR_APP ?>web/lib/bootstrap/css/floating-labels.css">
        <link rel="stylesheet" type="text/css" href="<?php echo Constantes::ROOT_DIR_APP ?>web/lib/bootstrap/font-awesome/css/font-awesome.min.css" >
        <link rel="stylesheet" type="text/css" href="<?php echo Constantes::ROOT_DIR_APP ?>web/lib/bootstrap/css/style3.css">
        <link rel="stylesheet" type="text/css" href="<?php echo Constantes::ROOT_DIR_APP ?>web/lib/bootstrap/css/jquery.mCustomScrollbar.min.css">
        <link rel="stylesheet" type="text/css" href="<?php echo Constantes::ROOT_DIR_APP ?>web/lib/bootstrap/css/animate.min.css">
        <?php
        echo ob_get_clean();
    }

    protected function JavaScriptChartJS()
    {
        ob_start();
        ob_implicit_flush( 0 );
        ?>
        <script type="text/javascript" src="<?php echo Constantes::ROOT_DIR_APP ?>web/lib/chart.js/dist/Chart.min.js"></script>
        <script type="text/javascript" src="<?php echo Constantes::ROOT_DIR_APP ?>web/lib/chart.js/samples/utils.js"></script>
        <?php
        echo ob_get_clean();
    }

    protected function include_javascripts()
    {
        $s_ConcatScriptName =  "JavaScript".$this->s_NameScript;
        if( method_exists( $this, $s_ConcatScriptName ) )
        {
            echo $this->$s_ConcatScriptName();
        }
    }
    
    public function setActionResult( $o_Action )
    {
        $this->v_ResultAction = $o_Action;
    }
    
    public function setObjectAction( $o_Action )
    {
        $this->o_Action = $o_Action;
    }

    protected $LoginAccess = false;
    public function setIsLoginAccess()
    {
        $this->LoginAccess = true;
    }
    public function getIsLoginAccess()
    {
        return $this->LoginAccess;
    }
    
    protected $UseBootstrap = false;
    public function setUseBootstrap()
    {
        $this->UseBootstrap = true;
    }
    public function getUseBootstrap()
    {
        return $this->UseBootstrap;
    }

    protected $UseChartJS = false;
    public function setUseChartJS()
    {
        $this->UseChartJS = true;
    }
    public function getUseChartJS()
    {
        return $this->UseChartJS;
    }

    protected $a_LstLib = array();
    public function addLibTemplate( $v_Param, $b_CrtlMin = true )
    {
        $a_LstLib    = array();
        $a_LstLibJS  = array();
        $a_LstLibCSS = array();
        if( is_array( $v_Param ) )
        {
            $a_LstLib = array_merge( $a_LstLib, $v_Param );
        }
        else
        {
            array_unshift( $a_LstLib, $v_Param );
        }
        foreach ( $a_LstLib as $s_Value ) 
        {
            $s_Lib    = "web".DIRECTORY_SEPARATOR."lib".DIRECTORY_SEPARATOR;
            $s_DirLib = SF_ROOT_DIR.DIRECTORY_SEPARATOR.$s_Lib.$s_Value.DIRECTORY_SEPARATOR;

            if( file_exists( $s_DirLib ) )
            {
                $s_CarpetaBase = Constantes::ROOT_DIR_APP."web/lib/".$s_Value."/";
                $s_CarpetaJS   = $s_DirLib."js".DIRECTORY_SEPARATOR;
                $s_CarpetaCSS  = $s_DirLib."css".DIRECTORY_SEPARATOR;

                if( file_exists( $s_CarpetaJS ) )
                {
                    if ( $dh = opendir( $s_CarpetaJS ) ) 
                    {
                        while ( ( $s_File = readdir( $dh ) ) !== false ) 
                        {
                            if( $s_File == "." || $s_File == ".." ) continue;

                            if( $b_CrtlMin )
                            {
                                if( strpos( $s_File, ".min." ) !== false )
                                {
                                    array_unshift( $a_LstLibJS, str_replace( "\\", "/", $s_CarpetaBase."js/".$s_File ) );
                                }
                            }
                            else
                            {
                                if( strpos( $s_File, ".min." ) === false )
                                {
                                    array_unshift( $a_LstLibJS, str_replace( "\\", "/", $s_CarpetaBase."js/".$s_File ) );
                                }
                            }
                        }
                        closedir( $dh );
                    }
                }

                if( file_exists( $s_CarpetaCSS ) )
                {
                    if ( $dh = opendir( $s_CarpetaCSS ) ) 
                    {
                        while ( ( $s_File = readdir( $dh ) ) !== false ) 
                        {
                            if( $s_File == "." || $s_File == ".." ) continue;

                            if( $b_CrtlMin )
                            {
                                if( strpos( $s_File, ".min." ) !== false )
                                {
                                    array_unshift( $a_LstLibCSS, str_replace( "\\", "/", $s_CarpetaBase."css/".$s_File ) );
                                }
                            }
                            else
                            {
                                if( strpos( $s_File, ".min." ) === false )
                                {
                                    array_unshift( $a_LstLibCSS, str_replace( "\\", "/", $s_CarpetaBase."css/".$s_File ) );
                                }
                            }
                        }
                        closedir( $dh );
                    }
                }

                $this->a_LstLib['js']  = $a_LstLibJS;
                $this->a_LstLib['css'] = $a_LstLibCSS;
            }
        }
    }

    public function initialize()
    {
        ///////////////////////////////////////////////////////////////////////////////////////////////
        //parametros
        $o_Action = $this->o_Action;
        $a_Atributos = get_object_vars( $o_Action );
        foreach( $a_Atributos as $s_VarName => $u_VarDefaultValue ){ eval( "\$".$s_VarName." = \$o_Action->".$s_VarName.";" ); }
        ///////////////////////////////////////////////////////////////////////////////////////////////
        $s_Class  = ParameterWR::getInstance()->getModule();
        $s_Module = strtolower( $s_Class );
        $s_Action = ParameterWR::getInstance()->getActions();
        $s_Methods = ucwords( $s_Action );
        //$s_Module = strtolower( $s_Action );
        ///////////////////////////////////////////////////////////////////////////////////////////////
        //pr( $this->v_ResultAction );
        try
        {
            if( $this->v_ResultAction == ViewResponse::NONE )
            {
                return true;
            }
            $s_FileTemp = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.SF_APP.DIRECTORY_SEPARATOR."modules".DIRECTORY_SEPARATOR.$s_Module.DIRECTORY_SEPARATOR."templates".DIRECTORY_SEPARATOR.$s_Action."Success.php";
            if( ViewResponse::getInstance()->getMethod() )
            {
                if( is_readable( $s_FileTemp ) )
                {
                    //si es un template
                    ?>
                    <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
                    <html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">

                        <head>

                            <?php $this->include_http_metas() ?>

                            <?php $this->include_metas() ?>

                            <?php $this->include_title() ?>

                            <link rel="shortcut icon" href="/favicon.ico" />

                            <?php $this->include_stylesheets() ?>

                            <?php $this->include_javascripts() ?>

                            <?php if( $this->getUseBootstrap() ){ ?>
                                <?php $this->JavaScriptBootstrap() ?>
                                <?php $this->StyleSheetsBootstrap() ?>
                            <?php } ?>

                            <?php if( $this->getUseChartJS() ){ ?>
                                <?php $this->JavaScriptChartJS() ?>
                            <?php } ?>

                            <?php if( $this->a_LstLib ){ ?>
                                <?php foreach ( $this->a_LstLib['js'] as $s_Value ) { ?>
                                    <script type="text/javascript" src="<?php echo $s_Value ?>"></script>
                                <?php } ?>
                                <?php foreach ( $this->a_LstLib['css'] as $s_Value ) { ?>
                                    <link rel="stylesheet" type="text/css" href="<?php echo $s_Value ?>">
                                <?php } ?>
                            <?php } ?>

                        </head>

                        <body>

                            <?php 
                            if( $this->getIsLoginAccess() )  
                            {
                                use_helper( 'MainWT' );

                                ob_start();
                                ob_implicit_flush( 0 );
                                require( $s_FileTemp );
                                $content = ob_get_clean();

                                main_head_wt( $content );

                                //return true;
                            }
                            else
                            {
                                require( $s_FileTemp );
                            }
                            ?>

                        </body>

                    </html>
                    <?php
                }
                else
                {
                    if( $this->v_ResultAction != ViewResponse::NONE )
                    {
                        echo "\n\nNo se encontro el archivo {$s_Action}Success.php\n<br>";
                    }
                }
            }
            else
            {
                if( is_readable( $s_FileTemp ) )
                {
                    //si podria ser el resultado de un ajax
                    require( $s_FileTemp );
                }
                else
                {
                    if( $this->v_ResultAction != ViewResponse::NONE )
                    {
                        echo "\n\nNo se encontro el archivo {$s_Action}Success.php\n<br>";
                    }
                }
            }
        } 
        catch ( Exception $o_Exception ) 
        {
            $s_MensajeError = $o_Exception->getMessage();
            echo '<div class="ui-widget" style="margin: 2px;"><div class="ui-state-error ui-corner-all" style="padding: 0 .7em;"><p><span class="ui-icon ui-icon-alert" style="float: left; margin-right: .3em;"></span><strong>Error:</strong> '.$s_MensajeError.'</p></div></div>';
        }

        return true;
    }
}
