<?php
/* Busqueda de registros de la tabla VTA_TipoDocumento redefinidos por el usuario. */
class VTA_TipoDocumentoFN extends BaseVTA_TipoDocumentoFN
{
    public static function selectActivo()
    {
        $o_VTA_TipoDocumentoFN = new VTA_TipoDocumentoFN();
        $o_VTA_TipoDocumentoFN->setEstado( "A" );
        $o_VTA_TipoDocumentoFN->addCondition( VTA_TipoDocumentoFN::CodigoFiscal, "<>", "" );
        $o_VTA_TipoDocumentoFN->setGenerarProvisionFlag( "S" );
        $a_VTA_TipoDocumento = $o_VTA_TipoDocumentoFN->select();
        return $a_VTA_TipoDocumento;
    }
    
    public static function buscarDocParaLogistica()
    {
        $o_VTA_TipoDocumentoFN = new VTA_TipoDocumentoFN();
        $o_VTA_TipoDocumentoFN->setEstado( "A" );
        //$o_VTA_TipoDocumentoFN->addCondition( VTA_TipoDocumentoFN::DescripcionIngles, "IN", "('PVTA','LGCA')", false );
        $o_VTA_TipoDocumentoFN->addCondition( VTA_TipoDocumentoFN::DescripcionIngles, "IS", "NOT NULL", false );
        $o_VTA_TipoDocumentoFN->addOrderBy( "COALESCE( Secuencia, '999' ) " );
        $a_VTA_TipoDocumento = $o_VTA_TipoDocumentoFN->select();
        return $a_VTA_TipoDocumento;
    }
    
    public static function getObjectVTATipoDocumento( $s_Id )
    {
        $o_VTA_TipoDocumentoFN = new VTA_TipoDocumentoFN();
        $o_VTA_TipoDocumentoBN = $o_VTA_TipoDocumentoFN->selectByPK( $s_Id );
        return $o_VTA_TipoDocumentoBN;
    }
}
?>