<?php
class VTA_OrdenFN extends BaseVTA_OrdenFN
{
    public function selectTotales()
    {
        if( $this->getOrdenTipoId() )
        {
            $this->setOrdenTipoId( null );
        }
        
        $s_SQLQuery = "SELECT
                        SUM(OrdenAfecto) SumaOrdenAfecto,
                        SUM(OrdenAfectoMN) SumaOrdenAfectoMN,
                        SUM(OrdenInafecto) SumaOrdenInafecto,
                        SUM(OrdenInafectoMN) SumaOrdenInafectoMN,
                        SUM(OrdenImpuesto) SumaOrdenImpuesto,
                        SUM(OrdenImpuestoMN) SumaOrdenImpuestoMN,
                        SUM(OrdenNeto) SumaOrdenNeto,
                        SUM(OrdenNetoMN) SumaOrdenNetoMN
                      ";
        $s_SQLQuery .= " FROM VTA_Orden WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        $s_SQLQuery .= " AND OrdenTipoId=2  ";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_SQLQuery )->executeQuery();
        $o_ResultSet->next();
        $o_row = $o_ResultSet->getRow();
        
        return $o_row;
    }
    
    public static function findOrdenByNum( $s_OrdenNum )
    {
        $s_Sql = "SELECT * FROM VTA_Orden where OrdenNum='$s_OrdenNum';";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        if( $o_ResultSet->getRecordCount() > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow();
            $o_VTA_OrdenFN = new VTA_OrdenFN();
            $o_VTA_OrdenBN = $o_VTA_OrdenFN->insertObjectBN( $a_SQLRow );
            return $o_VTA_OrdenBN;
        }
        return null;
    }

    public static function findOrdenByNumToArray( $s_OrdenNum )
    {
        $s_Sql = "SELECT * FROM VTA_Orden where OrdenNum='$s_OrdenNum';";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        if( $o_ResultSet->getRecordCount() > 0 )
        {
            $o_ResultSet->next();
            $a_row = $o_ResultSet->getRow();
            return $a_row;
        }
        return null;
    }

    public static function findExpiredOrder()
    {
        //se tiene que pensar en realizar el modulo de solicitudes...
        $s_FechaHoraActual = date( "Y-m-d H:i:s" );
        $s_Sql = "SELECT
                    ( SELECT COUNT(*) FROM VTA_OrdenDetalle where OrdenId=VTA_Orden.OrdenId ),
                    VTA_Orden.*
                    FROM VTA_Orden
                    where 1=1
                    AND OrdenVenc<'$s_FechaHoraActual' and OrdenEstado in ('O','R')
                    AND (SELECT COUNT(*) FROM VTA_Documento WHERE DocumentoParentId=VTA_Orden.OrdenId AND TipoVenta='ANT' AND Estado='CE') = 0 -- NO SE ANULAN ORDEN QUE TIENEN ASOCIADO ANTICIPOS
                    -- AND OrdenTipoId=1 -- por ahora todos los tipo de ordenes, master o estandar
                    /*AND ( SELECT COUNT(*) FROM VTA_OrdenDetalle where OrdenId=VTA_Orden.OrdenId )>0*/ ;";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        $a_Rows = array();
        if( $o_ResultSet->getRecordCount() > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow();
                $o_VTA_OrdenFN = new VTA_OrdenFN();
                $o_VTA_OrdenBN = $o_VTA_OrdenFN->insertObjectBN( $a_SQLRow );
                $a_Rows[] = $o_VTA_OrdenBN;
            }
        }
        return $a_Rows;
    }
}
?>