<?php
/* Busqueda de registros de la tabla TR_RutaDetalle redefinidos por el usuario. */
class TR_RutaDetalleFN extends BaseTR_RutaDetalleFN
{
    public static function existeDocumentoreferencia( $s_DocRef )
    {
        $s_Sql = "SELECT RutaDocDespacho FROM TR_RutaDetalle WHERE RutaDocDespacho='$s_DocRef' AND RutaDetEstado<>'R';";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        if( $o_ResultSet->getRecordCount() > 0 )
        {
            return true;
        }
        return false;
    }
    public static function buscarConsolidadoRuta( $s_DocRef, $s_Tipo )
    {
        $s_Where = "";
        if( $s_Tipo == "1" )
        {
            $s_Where = " AND CONCAT( O.DocumentoCod, '', O.DocumentoSerie, '-', O.DocumentoNumero ) IN ( '$s_DocRef' ) ";
        }
        if( $s_Tipo == "2" )
        {
            $s_Where = " AND CONCAT( O.DocumentoCod, '', O.DocumentoSerie, '-', O.DocumentoNumero ) IN ( SELECT RutaDocDespacho FROM TR_RutaDetalle WHERE IdRuta='$s_DocRef' ) ";
        }
        $s_Sql = "
                    SELECT
                    SUM(D.CantidadPedida) CantidadPedida,
                    SUM(I.PesoGramos*D.CantidadPedida) PesoGramos,
                     I.IdItem, I.CodigoBarras, I.DescripcionCompleta, L.Descripcion LineaDesc, F.Descripcion FamiliaDesc, L.IdLinea, F.IdFamilia
                    FROM VTA_Documento O
                      INNER JOIN VTA_DocumentoDetalle D ON O.IdTipoDocumento=D.IdTipoDocumento  AND O.IdCompania=D.IdCompania AND O.NumeroDocumento=D.NumeroDocumento
                        LEFT JOIN ALM_ItemMast I ON I.IdItem=D.ItemCodigo
                          LEFT JOIN MST_ClaseLinea L ON L.IdLinea=I.IdLinea
                            LEFT JOIN MST_ClaseFamilia F ON I.IdFamilia=F.IdFamilia AND I.IdLinea=F.IdLinea
                    WHERE 1=1
                        AND O.Estado IN ('CE','AN') 
                    $s_Where
                    GROUP BY I.IdItem
                    ORDER BY I.DescripcionCompleta;
            ";
        $a_Data = array();
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        if( $o_ResultSet->getRecordCount() > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_Data[] = $o_ResultSet->getRow();
            }
        }
        return $a_Data;
    }
    
    public static function recuperarFiltroSerie()
    {
        $s_Sql = "SELECT SerieDocumentoRef
                FROM TR_RutaDetalle
                GROUP BY SerieDocumentoRef
                HAVING SerieDocumentoRef IS NOT NULL;";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        $a_Series = array();
        while( $o_ResultSet->next() ) 
        {
            $a_SQLRow = $o_ResultSet->getRow();
            $a_Series[$a_SQLRow['SerieDocumentoRef']] = $a_SQLRow['SerieDocumentoRef'];
        }
        return $a_Series;
    }
}