<?php
/* Busqueda de registros de la tabla GSS_ParametroMast redefinidos por el usuario. */
class GSS_ParametroMastFN extends BaseGSS_ParametroMastFN
{
	
    public function getIdValorParametro()
    {
        switch( $this->getTipodeDatoFlag() )
        {
            case 'N': $valor   = $this->getNumero();
                break;
            case 'T': $valor   = $this->getTexto();
                break;
            case 'D': $valor   = $this->getFecha();
                break;
            case 'B':
                $s_Value = $this->getTexto();
                if( $s_Value == "NO" || $s_Value == "N" )
                {
                    return false;
                }
                if( $s_Value == "SI" || $s_Value == "S" || $s_Value == "Y" )
                {
                    return true;
                }
                $i_Value = $this->getNumero();
                if( $i_Value )
                {
                    return true;
                }
                if( !$i_Value )
                {
                    return false;
                }
                return false;
                break;
        }
        return $valor;
    }

    public static function getTextoIgvActual( $Tipo = 'Exp' )
    {
        /*$o_GSS_ParametroMastFN = new GSS_ParametroMastFN();
        $o_GSS_ParametroMastBN = $o_GSS_ParametroMastFN->selectByPK( -1, 'AL', 'IGV' );*/
        $o_GSS_ParametroMastBN = GSS_ParametroMastFN::getObjBeanParamPorCodigos( 'AL', 'IGV' );
        switch( $Tipo )
        {
            case "Exp":
                $s_TextoIGV = $o_GSS_ParametroMastBN->getExplicacion();
            break;
            case "Texto":
                $s_TextoIGV = $o_GSS_ParametroMastBN->getTexto();
            break;
            case "Numero":
                $s_TextoIGV = $o_GSS_ParametroMastBN->getNumero();
            break;
        }
        return $s_TextoIGV;
    }
    
    public static function getObjBeanParamPorCodigos( $s_IdAplicacionCodigo, $s_IdParametroClave )
    {
        if( myUser::getUser()->getIdBusiness() )
        {
            $i_IdCompania = myUser::getUser()->getIdBusiness();
            $o_GSS_ParametroMastFN = new GSS_ParametroMastFN();
            $o_GSS_ParametroMastBN = $o_GSS_ParametroMastFN->selectByPK( $i_IdCompania, $s_IdAplicacionCodigo, $s_IdParametroClave );
            if( $o_GSS_ParametroMastBN )
            {
                return $o_GSS_ParametroMastBN;
            }
            if( !$o_GSS_ParametroMastBN )
            {
                $o_GSS_ParametroMastBN = $o_GSS_ParametroMastFN->selectByPK( -1, $s_IdAplicacionCodigo, $s_IdParametroClave );
                if( $o_GSS_ParametroMastBN )
                {
                    return $o_GSS_ParametroMastBN;
                }
            }
        }
        return null;
    }
    
    public static function getValorParam( $s_IdAplicacionCodigo, $s_IdParametroClave )
    {
        $o_GSS_ParametroMastBN = GSS_ParametroMastFN::getObjBeanParamPorCodigos( $s_IdAplicacionCodigo, $s_IdParametroClave );
        $v_Valor = "";
        if( $o_GSS_ParametroMastBN )
        {
            $v_Valor = $o_GSS_ParametroMastBN->getIdValorParametro();
        }
        return $v_Valor;
    }

    public static function getValorPorTipo( $s_IdAplicacionCodigo, $s_IdParametroClave )
    {
        $o_GSS_ParametroMastBN = GSS_ParametroMastFN::getObjBeanParamPorCodigos( $s_IdAplicacionCodigo, $s_IdParametroClave );
        if( $o_GSS_ParametroMastBN )
        {
            if( $o_GSS_ParametroMastBN->getEstado() == "A" )
            {
                switch ( $o_GSS_ParametroMastBN->getTipodeDatoFlag() ) 
                {
                    case 'N': //numerico
                        return $o_GSS_ParametroMastBN->getNumero();
                    break;
                    case 'T': //texto
                        return $o_GSS_ParametroMastBN->getTexto();
                    break;
                    case 'D': //fecha
                        return $o_GSS_ParametroMastBN->getFecha();
                    break;
                    case 'B': //booleano
                        $s_Value = $o_GSS_ParametroMastBN->getTexto();
                        if( $s_Value == "NO" || $s_Value == "N" )
                        {
                            return false;
                        }
                        if( $s_Value == "SI" || $s_Value == "S" )
                        {
                            return true;
                        }
                        $i_Value = $o_GSS_ParametroMastBN->getNumero();
                        if( $i_Value )
                        {
                            return true;
                        }
                        if( !$i_Value )
                        {
                            return false;
                        }
                        return false;
                    break;
                }
            }
        }
        return null;
    }
}