<?php
/* Busqueda de registros de la tabla GSS_Banco redefinidos por el usuario. */
class GSS_BancoFN extends BaseGSS_BancoFN
{
    public static function selectActivos()
    {
        $o_GSS_BancoFN = new GSS_BancoFN();
        $o_GSS_BancoFN->setEstado( "A" );
        $o_GSS_BancoFN->addOrderBy( GSS_BancoFN::DescripcionLocal );
        return $o_GSS_BancoFN->select();
    }
    
    public static function selectActivoCuenta()
    {
        $o_GSS_BancoFN = new GSS_BancoFN();
        $o_GSS_BancoFN->setEstado( "A" );
        $o_GSS_BancoFN->addOrderBy( GSS_BancoFN::DescripcionLocal );
        $a_GSS_Banco = $o_GSS_BancoFN->select();
        $a_DataBancos = array();
        foreach ( $a_GSS_Banco as $o_GSS_BancoBN )
        {
            $o_MST_CuentaBancariaFN = new MST_CuentaBancariaFN();
            $o_MST_CuentaBancariaFN->setIdBanco( $o_GSS_BancoBN->getIdBanco() );
            $a_MST_CuentaBancaria = $o_MST_CuentaBancariaFN->select();
            if( $a_MST_CuentaBancaria )
            {
                if( count( $a_MST_CuentaBancaria ) == 1 )
                {
                    if( $a_MST_CuentaBancaria[0]->getFlagDetraccion() )
                    {
                        $o_GSS_BancoBN->setDescripcionLocal( $o_GSS_BancoBN->getDescripcionLocal()." - DETRACCION" );
                    }
                }
                $a_DataBancos[] = $o_GSS_BancoBN;
            }            
        }
        return $a_DataBancos;
    }
    
    public static function getObjectById( $i_IdBanco )
    {
        $o_GSS_BancoFN = new GSS_BancoFN();
        $o_GSS_BancoBN = $o_GSS_BancoFN->selectByPK( $i_IdBanco );
        return $o_GSS_BancoBN;
    }
    
    public static function buscarBancoCuencaBancaria( $a_Params = array() )
    {
        $s_Where = "";
        if( $a_Params )
        {
            if( isset( $a_Params['IdBanco'] ) && $a_Params['IdBanco'] != "" )
            {
                $s_Where .= " AND C.Idbanco='{$a_Params['IdBanco']}' ";
            }
            if( isset( $a_Params['IdMoneda'] ) && $a_Params['IdMoneda'] != "" )
            {
                $s_Where .= " AND C.IdMoneda='{$a_Params['IdMoneda']}' ";
            }
            if( isset( $a_Params['IdCuenta'] ) && $a_Params['IdCuenta'] != "" )
            {
                $s_Where .= " AND C.IdCuenta='{$a_Params['IdCuenta']}' ";
            }
        }
        $s_Sql = "SELECT *
                    FROM GSS_Banco B
                      INNER JOIN MST_CuentaBancaria C ON B.IdBanco=C.IdBanco
                    WHERE 1=1
                        $s_Where
                    ORDER BY B.DescripcionLocal;";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        $a_Data = array();
        while( $o_ResultSet->next() )
        {
            $a_SQLRow = $o_ResultSet->getRow();
            $a_Data[] = $a_SQLRow;
        }
        return $a_Data;
    }
}
?>