<?php
/* Busqueda de registros de la tabla ALM_ItemMast redefinidos por el usuario. */
class ALM_ItemMastFN extends BaseALM_ItemMastFN
{
    /**
     * Recupero el Id + 1
     *
     * @return int
     */
    public static function recuperarId( $IdLinea=null )
    {
        $o_utilGenerateId = new utilGenerateId();
        $o_utilGenerateId->setIdCompania( "-1" );
        $o_utilGenerateId->setTipoCorrelativo( "ALM" );
        $o_utilGenerateId->setSerie( "ITEM" );
        $i_IdItem = $o_utilGenerateId->generateStringId();

        $s_IdItem = str_pad( $i_IdItem, 5, "0", STR_PAD_LEFT );

        //$s_CodigoLinea = MST_ClaseLineaFN::recuperarValor( $IdLinea, "Codigo" );
        //$s_IdFinalItem = $s_CodigoLinea.$s_IdItem;

        $s_IdFinalItem = $s_IdItem;

        return $s_IdFinalItem;
    }

    public static function getObjectItem( $s_ItemId )
    {
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $s_ItemId );
        return $o_ALM_ItemMastBN;
    }
	
    public static function getItemCantidadMedidaAsignada( $s_ItemId )
    {
        return ALM_ItemMastFN::getObjectItem( $s_ItemId )->getCantidadUnidad();
    }

    public static function getItemUnidadVentaAsignada( $s_ItemId )
    {
        return ALM_ItemMastFN::getObjectItem( $s_ItemId )->getUnidadVenta();
    }

    public static function getItemUnidadAlmacenajeAsignada( $s_ItemId )
    {
        return ALM_ItemMastFN::getObjectItem( $s_ItemId )->getUnidadAlmacenaje();
    }

    public static function getItemUnidadCompraAsignada( $s_ItemId )
    {
        return ALM_ItemMastFN::getObjectItem( $s_ItemId )->getUnidadCompra();
    }

    //es el costo en moneda nacional
    public static function getItemPrecioUnitarioLocal( $s_ItemId )
    {
        return floatval( ALM_ItemMastFN::getObjectItem( $s_ItemId )->getPrecioUnitarioLocal() );
    }

    public static function getStaticDescripcionItem( $s_ItemId )
    {
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $s_ItemId );
        if( $o_ALM_ItemMastBN )
        {
            return $o_ALM_ItemMastBN->getDescripcionCompleta();
        }
        return "";
    }

    public static function SiManejaLoteFlag( $s_ItemId )
    {
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $s_ItemId );
        if( $o_ALM_ItemMastBN )
        {
            return $o_ALM_ItemMastBN->SiManejaLote();
        }
        return null;
    }

    public static function existeDirImagen( $s_IdItem )
    {
        return false;
    }
	
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    protected static $GroupByAlmacen  = null;
    public static function setGroupByAlmacen( $v )
    {
        self::$GroupByAlmacen = $v;
    }
    public static function getGroupByAlmacen()
    {
        return self::$GroupByAlmacen;
    }
    protected static $GroupByLote  = null;
    public static function setGroupByLote( $v )
    {
        self::$GroupByLote = $v;
    }
    public static function getGroupByLote()
    {
        return self::$GroupByLote;
    }

    protected static $BuscarPorTermino;
    public static function setBuscarPorTermino( $v )
    {
        self::$BuscarPorTermino = $v;
    }
    public static function getBuscarPorTermino()
    {
        return self::$BuscarPorTermino;
    }

    /**
     * @param $s_Termino
     * @return ALM_ItemMastBN[]
     * @throws SQLException
     */
    public function selectAutocomplet( $s_Termino )
    {
        $s_Where = $this->buildConsult();
        $s_Sql = "
        SELECT * 
        FROM ALM_ItemMast 
        WHERE 
              ( $s_Where AND IdItem LIKE '%$s_Termino%' ) 
           OR ( $s_Where AND DescripcionCompleta LIKE '%$s_Termino%' ) 
           OR ( $s_Where AND CodigoBarrasFabricante LIKE '%$s_Termino%' )
           OR ( $s_Where AND CodigoInterno LIKE '%$s_Termino%' )
           OR ( $s_Where AND NumeroDeParte LIKE '%$s_Termino%' )
        ";
        //pr( $s_Sql );
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        $a_Data = array();
        while( $o_ResultSet->next() )
        {
            $a_SQLRow = $o_ResultSet->getRow();
            $o_ALM_ItemMastBN = $this->insertObjectBN( $a_SQLRow );
            $a_Data[] = $o_ALM_ItemMastBN;
        }
        return $a_Data;
    }

    /* Busca varios registros por los campos establecidos */
    public function selectdos( $i_Position = null, $i_Rows = null )
    {
        $s_LeftJoin = "";

        if ( !is_null( $this->getIdAlmacen() ) ) $s_LeftJoin .= " AND ALM_ItemAlmacenStock.IdAlmacen   = '".$this->getIdAlmacen()."' ";
        if ( !is_null( $this->getIdCompania() ) ) $s_LeftJoin .= "  AND ALM_ItemAlmacenStock.IdCompania=".$this->getIdCompania()."  ";

        $s_SQLQuery = "
SELECT 
ALM_ItemMast.IdItem,
ALM_ItemTipo.DescripcionLocal DescripcionTipoItem,
ALM_ItemAlmacenStock.IdAlmacen, 
ALM_AlmacenMast.DescripcionLocal DescripcionAlmacen,
ALM_ItemAlmacenStock.IdLote, 
MAX(ALM_ItemAlmacenStock.FechaVencimiento ) FechaVencimiento,
ALM_ItemMast.UnidadVenta IdUniMedVenta,
ALM_ItemMast.CantidadUnidad,
MST_UnidadMast.DescripcionCorta UniMedVentaDesc,
ALM_Marca.DescripcionLocal Marca,

SUM( ALM_ItemAlmacenStock.StockDisponible ) StockDisponible,
SUM( ALM_ItemAlmacenStock.StockReservado ) StockReservado,
SUM( ALM_ItemAlmacenStock.StockFisico ) StockFisico,

MST_UnidadMast.UnidadEquivalenteFlag, MST_UnidadMast.UsoFraccionFlag, MST_UnidadMast.EsUnidadMinimaFlag,

ALM_ItemMast.* 

            ";
        //$s_SQLQuery .= $this->getSelectColumns();
        
        $s_SQLQuery .= "FROM ALM_ItemMast 
        					left JOIN ALM_ItemAlmacenStock ON ALM_ItemMast.IdItem=ALM_ItemAlmacenStock.IdItem $s_LeftJoin
                                left join ALM_Marca on ALM_ItemMast.IdMarca=ALM_Marca.IdMarca
                                    left join ALM_AlmacenMast on ALM_AlmacenMast.IdAlmacen=ALM_ItemAlmacenStock.IdAlmacen
                                        left join MST_UnidadMast on MST_UnidadMast.IdUnidad=ALM_ItemMast.UnidadVenta
                                            left join ALM_ItemTipo on ALM_ItemMast.IdItemTipo=ALM_ItemTipo.IdItemTipo
        				WHERE ";

        $s_Where = $this->buildConsult();
        //$s_SQLQuery .= $this->buildConsult();

        if ( !is_null( $this->getConStock() ) ) $s_Where .= "  AND ALM_ItemAlmacenStock.StockDisponible > 0 ";
        if( !is_null( $this->getIdColor() ) ){ $s_Where .= " and ALM_ItemMast.IdItem in ( SELECT IdItem FROM MST_RelacionReferenciaProducto where IdColor=".$this->getIdColor()." ) "; }
        if( !is_null( $this->getIdCatTalla() ) ){ $s_Where .= " and ALM_ItemMast.IdItem in ( SELECT IdItem FROM MST_RelacionReferenciaProducto where IdCatTalla=".$this->getIdCatTalla()." ) "; }
        if( !is_null( $this->getIdTalla() ) ){ $s_Where .= " and ALM_ItemMast.IdItem in ( SELECT IdItem FROM MST_RelacionReferenciaProducto where IdTalla in ( SELECT IdTalla FROM MST_Talla where Descripcion like '%".$this->getIdTalla()."%' ) ) "; }
        if( !is_null( $this->getIdReferencia() ) ){ $s_Where .= " and ALM_ItemMast.IdItem in ( SELECT IdItem FROM MST_RelacionReferenciaProducto where IdReferencia in ( SELECT IdReferencia FROM MST_ReferenciaProducto WHERE Descripcion LIKE '%".$this->getIdReferencia()."%' ) ) "; }

        $s_SQLQuery .= " ( $s_Where ) ";


        if( ALM_ItemMastFN::getBuscarPorTermino() )
        {
            $s_Termino = ALM_ItemMastFN::getBuscarPorTermino();
            $s_SQLQuery .= " OR ( CodigoInterno LIKE '%$s_Termino%' ) ";
            $s_SQLQuery .= " OR ( NumeroDeParte LIKE '%$s_Termino%' ) ";
            $s_SQLQuery .= " OR ( CodigoBarrasFabricante LIKE '%$s_Termino%' ) ";
        }
        
        $s_SQLQuery .= " GROUP BY ALM_ItemMast.IdItem  "; //ALM_ItemAlmacenStock.IdLote [se agrega si el cliente quiere ver sus detalles con lote]
        if( ALM_ItemMastFN::getGroupByAlmacen() )
        {
            $s_SQLQuery .= " , ALM_ItemAlmacenStock.IdAlmacen ";
        }
        if( ALM_ItemMastFN::getGroupByLote() )
        {
            $s_SQLQuery .= " , ALM_ItemAlmacenStock.IdLote ";
        }
        
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_ALM_ItemMastBN = array();
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_SQLQuery )->executeQuery();

        //pr( $s_SQLQuery ); exit;

        while( $o_ResultSet->next() ) 
        {
            $a_SQLRow = $o_ResultSet->getRow();
            $o_ALM_ItemMastBN = $this->insertObjectBN( $a_SQLRow );

            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //se agrega metodo por el tipo de item - 2019-10-16
            $o_ALM_ItemMastBN->setDescripcionTipoItem( $a_SQLRow['DescripcionTipoItem'] );
            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            $ConcatUni = "";
            $i_IdUnidadMedidaAsig    = $a_SQLRow['IdUniMedVenta']; //UNI MEDIDA ASIGNADA
            //$o_ASI_MST_UnidadMastBN = MST_UnidadMastFN::select_one( $i_IdUnidadMedidaAsig );   //unidad de medida asignada
            if( $a_SQLRow['EsUnidadMinimaFlag'] )
            {
                //si es unidad minima se muestra el stock como lo busco
                $i_Dividir = 1;
            }
            elseif ( $a_SQLRow['UnidadEquivalenteFlag'] && $a_SQLRow['UsoFraccionFlag'] ) 
            {
                $i_Dividir = floatval( $a_SQLRow['CantidadUnidad'] );
                //$ConcatUni = "x".round( $a_SQLRow['CantidadUnidad'], 0 );
            }
            elseif ( $a_SQLRow['UnidadEquivalenteFlag'] && !$a_SQLRow['UsoFraccionFlag'] && !$a_SQLRow['EsUnidadMinimaFlag'] ) 
            {
                $a_MST_UnidadConversionMast = MST_UnidadMastFN::find_uni_eq( $i_IdUnidadMedidaAsig );
                $i_Dividir = $a_MST_UnidadConversionMast[0]->getCantidadEquivalente();
                //$o_ALM_ItemMastBN->setDivisor( $i_Dividir );
            }
            //pr( $i_Dividir );
            if( !$i_Dividir ) $i_Dividir = 1;
            //$o_ALM_ItemMastBN->setDivisor( $i_Dividir );
            $o_ALM_ItemMastBN->setUnidadEquivalenteFlag( $a_SQLRow['UnidadEquivalenteFlag'] );
            $o_ALM_ItemMastBN->setUsoFraccionFlag( $a_SQLRow['UsoFraccionFlag'] );
            $o_ALM_ItemMastBN->setEsUnidadMinimaFlag( $a_SQLRow['EsUnidadMinimaFlag'] );
            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            $o_MST_ListaPrecioDetalleBN = null;
            $PrecioFinal = 0;
            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            //$b_CtrlUniUsoFrcc = $o_ALM_ItemMastBN->getObjectUnidad()->getUsoFraccionFlag();
            //$o_ALM_ItemMastBN->setStockActual( floatval( $a_SQLRow->StockActual ) );
            $o_ALM_ItemMastBN->setIdAlmacen( $a_SQLRow['IdAlmacen'] );
            $o_ALM_ItemMastBN->setDescripcionAlmacen( $a_SQLRow['DescripcionAlmacen'] );
            $o_ALM_ItemMastBN->setIdLote( $a_SQLRow['IdLote'] );
            $o_ALM_ItemMastBN->setFechaVencimientoLote( $a_SQLRow['FechaVencimiento'] );
            $o_ALM_ItemMastBN->setIdUniMedVenta( $a_SQLRow['IdUniMedVenta'] );
            $o_ALM_ItemMastBN->setUniMedVentaDesc(  $a_SQLRow['UniMedVentaDesc'].$ConcatUni ); //ejem | 100xCAJA | 100xCAJA

            $o_ALM_ItemMastBN->setStockDisponible( !$a_SQLRow['StockDisponible'] ? 0 : $a_SQLRow['StockDisponible'] );

            //$o_ALM_ItemMastBN->setStockMinimo    ( $a_SQLRow->StockMinimo );

            //$o_ALM_ItemMastBN->setCantidadLotes( $a_SQLRow['CantidadLotes'] );

            $o_ALM_ItemMastBN->setIdMarca( $a_SQLRow['Marca'] );
            $a_ALM_ItemMastBN[] = $o_ALM_ItemMastBN;
        }
        //pr( $a_ALM_ItemMastBN ); exit;
        return $a_ALM_ItemMastBN;
	}
	
    public function selectdosNumRows()
    {
    	$s_SQLQuery = "SELECT COUNT(*) AS cnt FROM ( ";
        $s_SQLQuery .= "SELECT DISTINCT ALM_ItemMast.* ";        
        $s_SQLQuery .= "FROM ALM_ItemMast 
        					LEFT JOIN ALM_ItemAlmacenStock ON ALM_ItemMast.IdItem=ALM_ItemAlmacenStock.IdItem
                                left join ALM_ItemTipo on ALM_ItemMast.IdItemTipo=ALM_ItemTipo.IdItemTipo
        				WHERE ";
        $s_SQLQuery .= $this->buildConsult();

        //$s_SQLQuery .= " AND COALESCE( ( SELECT Estado FROM ALM_Lote WHERE LoteNumero=ALM_ItemAlmacenStock.IdLote AND IdItem=ALM_ItemMast.IdItem ), 'A' ) = 'A' ";
        
        if ( !is_null( $this->getIdAlmacen() ) ) $s_SQLQuery .= " AND ALM_ItemAlmacenStock.IdAlmacen   = '".$this->getIdAlmacen()."' ";
        if ( !is_null( $this->getConStock() ) ) $s_SQLQuery .= "  AND ALM_ItemAlmacenStock.StockDisponible > 0 ";
        
        $s_SQLQuery .= " ) A";

        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_SQLQuery )->executeQuery();
        $o_ResultSet->next();
        $num_rows = $o_ResultSet->getInt( 'cnt' );
        return $num_rows;
    }
    
    public function selectstocks( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ALM_ItemAlmacenStock.StockFisico, ALM_ItemAlmacenStock.StockReservado, ALM_ItemAlmacenStock.StockDisponible, ALM_ItemAlmacenStock.IdLote, 
                              ALM_ItemAlmacenStock.FechaVencimiento, ALM_ItemMast.*
                        FROM ALM_ItemMast
                          INNER JOIN ALM_ItemAlmacenStock ON ALM_ItemMast.IdItem=ALM_ItemAlmacenStock.IdItem
                        WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( !is_null( $this->getIdAlmacen() ) ) $s_SQLQuery .= " AND ALM_ItemAlmacenStock.IdAlmacen   = '".$this->getIdAlmacen()."' ";
        if ( !is_null( $this->getConStock() ) ) $s_SQLQuery .= "  AND ALM_ItemAlmacenStock.StockFisico > 0 ";
        
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_ALM_ItemMastBN = null;
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_SQLQuery )->executeQuery();
        while( $o_ResultSet->next() ) 
        {
            $a_SQLRow = $o_ResultSet->getRow();
            $o_ALM_ItemMastBN = $this->insertObjectBN( $a_SQLRow );
            //$o_ALM_ItemMastBN->setStockActual( $a_SQLRow->StockFisico );

            $o_ALM_ItemMastBN->setStockFisico( $a_SQLRow['StockFisico'] );
            $o_ALM_ItemMastBN->setStockReservado( $a_SQLRow['StockReservado'] );
            $o_ALM_ItemMastBN->setStockDisponible( $a_SQLRow['StockDisponible'] );

            $o_ALM_ItemMastBN->setFechaVencimientoLote( $a_SQLRow['FechaVencimiento'] );
            $o_ALM_ItemMastBN->setIdLote( $a_SQLRow['IdLote'] );
            $a_ALM_ItemMastBN[] = $o_ALM_ItemMastBN;
        }
        return $a_ALM_ItemMastBN;
    }
    
    public function selectstocksNumRows()
    {
        return 99999;
    }
    
    public static function buscarItemObjxNumdeParte( $i_NumParte )
    {
        $s_Sql = "SELECT * FROM ALM_ItemMast WHERE NumeroDeParte='$i_NumParte';";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        $o_ALM_ItemMastBN = null;
        if( $o_ResultSet->getRecordCount() > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow();
            $o_ALM_ItemMastFN = new ALM_ItemMastFN();
            $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->insertObjectBN( $a_SQLRow );
        }
        return $o_ALM_ItemMastBN;
    }
    
    public static function buscarItemObjxCodBarras( $s_CodigoBarras )
    {
        $s_Sql = "SELECT * FROM ALM_ItemMast WHERE CodigoBarras='$s_CodigoBarras';";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        $o_ALM_ItemMastBN = null;
        if( $o_ResultSet->getRecordCount() > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow();
            $o_ALM_ItemMastFN = new ALM_ItemMastFN();
            $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->insertObjectBN( $a_SQLRow );
        }
        return $o_ALM_ItemMastBN;
    }
    
    public static function buscarItemxId( $s_IdItem )
    {
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $s_IdItem );
        return $o_ALM_ItemMastBN;
    }
    
    public static function getResulsetAllItem()
    {
        /*
        $s_Sql = "SELECT * FROM ALM_ItemMast WHERE Estado='A'";
        $o_DBConnect = Conexion::getConexion();
        $o_SQLResult = mysql_query( $s_Sql, $o_DBConnect->getResource() );
        return $o_SQLResult;
        */
    }
    
    public static function existeItemReposicion()
    {
        $s_Sql = "
                    SELECT COUNT(*) CNT
                    FROM MST_StockReposicionCabecera C
                      LEFT JOIN MST_StockReposicionDetalle D ON C.IdCompania=D.IdCompania AND C.IdSucursal=D.IdSucursal AND C.IdAlmacen=D.IdAlmacen AND C.IdPersona=D.IdPersona
                        LEFT JOIN ALM_ItemAlmacenStock S ON S.IdAlmacen=D.IdAlmacen AND S.IdItem=D.IdItem
                          LEFT JOIN ALM_ItemMast I ON I.IdItem=D.IdItem
                    WHERE 1=1
                    AND C.Estado='A'
                    AND S.StockActual<D.StockMinimo
                    ;
        ";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        $o_ResultSet->next();
        return $o_ResultSet->getInt( 'CNT' );
    }
    
    public static function recuperarDetalleReposicion()
    {
        $s_Sql = "
                    SELECT
                    I.IdItem, I.DescripcionCompleta, D.StockMinimo, S.StockActual, C.IdPersona, IF(TipoPersona='J',NombreCompleto,CONCAT(Nombres,' ', ApellidoPaterno, ' ', ApellidoMaterno)) NombreCompletoEmp
                    FROM MST_StockReposicionCabecera C
                      LEFT JOIN MST_StockReposicionDetalle D ON C.IdCompania=D.IdCompania AND C.IdSucursal=D.IdSucursal AND C.IdAlmacen=D.IdAlmacen AND C.IdPersona=D.IdPersona
                        LEFT JOIN ALM_ItemAlmacenStock S ON S.IdAlmacen=D.IdAlmacen AND S.IdItem=D.IdItem
                          LEFT JOIN MST_PersonaMast P ON P.IdPersona=C.IdPersona
                            LEFT JOIN ALM_ItemMast I ON I.IdItem=D.IdItem
                    WHERE 1=1
                    AND C.Estado='A'
                    AND S.StockActual<D.StockMinimo;
        ";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        return $o_ResultSet;
        /*$a_data = array();
        if( mysql_num_rows( $o_SQLResult ) )
        {
            return $o_SQLResult;

            while ( $a_row = mysql_fetch_array( $o_SQLResult, MYSQL_ASSOC ) )
            {
                $a_data[] = $a_row;
            }
        }
        return $a_data;*/
    }

    public static function buscarItemPorParamUbicacion( $s_IdCategoria, $s_IdTipoUbicacion )
    {
        $s_Sql = "
                    SELECT ALM_ItemMast.*
                    FROM MST_ItemUbicacion
                      LEFT JOIN ALM_ItemMast on MST_ItemUbicacion.IdItem=ALM_ItemMast.IdItem
                    WHERE IdCategoria='$s_IdCategoria' and IdTipoUbicacion='$s_IdTipoUbicacion';
                 ";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        $a_ALM_ItemMast = array();
        while( $o_ResultSet->next() ) 
        {
            $a_SQLRow = $o_ResultSet->getRow();
            $o_ALM_ItemMastFN = new ALM_ItemMastFN();
            $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->insertObjectBN( $a_SQLRow );
            $a_ALM_ItemMast[] = $o_ALM_ItemMastBN;
        }
        return $a_ALM_ItemMast;
    }

    /*public static function buscarItemPorParametros( $a_Param )
    {
        $s_Where = "";
        if( isset( $a_Param['IdItem'] ) && $a_Param['IdItem'] != ""  )
        {
            $s_Where .= " AND I.IdItem='{$a_Param['IdItem']}' ";
        }
        if( isset( $a_Param['IdLinea'] ) && $a_Param['IdLinea'] != "" )
        {
            $s_Where .= " AND I.IdLinea='{$a_Param['IdLinea']}' ";
        }
        if( isset( $a_Param['IdFamilia'] ) && $a_Param['IdFamilia'] != "" )
        {
            $s_Where .= " AND I.IdFamilia='{$a_Param['IdFamilia']}' ";
        }
        if( isset( $a_Param['IdMarca'] ) && $a_Param['IdMarca'] != "" )
        {
            $s_Where .= " AND I.IdMarca='{$a_Param['IdMarca']}' ";
        }

        $s_Sql = "
        SELECT
          I.IdItem, I.DescripcionCompleta, NumeroDeParte, M.DescripcionLocal MarcaDesc, L.Descripcion LineaDesc, F.Descripcion FamiliaDesc, PrecioCosto,
          SUM(S.StockFisico) StockFisico
        FROM ALM_ItemMast I
            LEFT JOIN MST_ClaseLinea L ON I.IdLinea=L.IdLinea
                LEFT JOIN MST_ClaseFamilia F ON I.IdFamilia=F.IdFamilia
                    LEFT JOIN ALM_Marca M ON I.IdMarca=M.IdMarca
                        LEFT JOIN ALM_ItemAlmacenStock S ON S.IdItem=I.IdItem
        WHERE 1=1
            $s_Where
        GROUP BY I.IdItem
        having StockFisico > 0
        ";
        //pr( $s_Sql );
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        $a_ALM_ItemMast = array();
        while( $o_ResultSet->next() ) 
        {
            $a_SQLRow = $o_ResultSet->getRow();
            $a_ALM_ItemMast[] = $a_SQLRow;
        }
        return $a_ALM_ItemMast;
    }*/

    public static function buscarItemPorParametros( $a_Param )
    {
        $IdCompania = myUser::getUser()->getIdCompania();
        $s_Where = "";
        if( isset( $a_Param['IdItem'] ) && $a_Param['IdItem'] != ""  )
        {
            $s_Where .= " AND I.IdItem='{$a_Param['IdItem']}' ";
        }
        if( isset( $a_Param['IdLinea'] ) && $a_Param['IdLinea'] != "" )
        {
            $s_Where .= " AND I.IdLinea='{$a_Param['IdLinea']}' ";
        }
        if( isset( $a_Param['IdFamilia'] ) && $a_Param['IdFamilia'] != "" )
        {
            $s_Where .= " AND I.IdFamilia='{$a_Param['IdFamilia']}' ";
        }
        if( isset( $a_Param['IdMarca'] ) && $a_Param['IdMarca'] != "" )
        {
            $s_Where .= " AND I.IdMarca='{$a_Param['IdMarca']}' ";
        }

        $s_Where .= " AND S.IdCompania=' $IdCompania' ";

        $s_Sql = "
        SELECT
          I.IdItem, I.DescripcionCompleta, NumeroDeParte, M.DescripcionLocal MarcaDesc, L.Descripcion LineaDesc, F.Descripcion FamiliaDesc, I.PrecioCosto PrecioCosto,
          SUM(S.StockFisico) StockFisico
        FROM ALM_ItemMast I
            LEFT JOIN MST_ClaseLinea L ON I.IdLinea=L.IdLinea
                LEFT JOIN MST_ClaseFamilia F ON I.IdFamilia=F.IdFamilia
                    LEFT JOIN ALM_Marca M ON I.IdMarca=M.IdMarca
                        LEFT JOIN ALM_ItemAlmacenStock S ON S.IdItem=I.IdItem
                        	-- LEFT JOIN (SELECT * FROM MST_ListaPrecioDetalle XX WHERE XX.IdTipoPrecio = 1) X ON X.IdItem = I.IdItem
        WHERE 1=1
            $s_Where AND I.Estado = 'A' -- AND StockFisico > 0
        GROUP BY I.DescripcionCompleta, I.IdItem
        HAVING StockFisico > 0
        ";
        //pr( $s_Sql );
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        $a_ALM_ItemMast = array();
        while( $o_ResultSet->next() )
        {
            $a_SQLRow = $o_ResultSet->getRow();
            $a_ALM_ItemMast[] = $a_SQLRow;
        }
        return $a_ALM_ItemMast;
    }

    public static function buscarItemPorParametros2( $a_Param )
    {
        $IdCompania = myUser::getUser()->getIdCompania();
        $s_Where = "";
        if( isset( $a_Param['IdItem'] ) && $a_Param['IdItem'] != ""  )
        {
            $s_Where .= " AND I.IdItem='{$a_Param['IdItem']}' ";
        }
        if( isset( $a_Param['IdLinea'] ) && $a_Param['IdLinea'] != "" )
        {
            $s_Where .= " AND I.IdLinea='{$a_Param['IdLinea']}' ";
        }
        if( isset( $a_Param['IdFamilia'] ) && $a_Param['IdFamilia'] != "" )
        {
            $s_Where .= " AND I.IdFamilia='{$a_Param['IdFamilia']}' ";
        }
        if( isset( $a_Param['IdMarca'] ) && $a_Param['IdMarca'] != "" )
        {
            $s_Where .= " AND I.IdMarca='{$a_Param['IdMarca']}' ";
        }

        $s_Where .= " AND S.IdCompania=' $IdCompania' ";

        $s_Sql = "
        SELECT
          I.IdItem, I.DescripcionCompleta, NumeroDeParte, M.DescripcionLocal MarcaDesc, L.Descripcion LineaDesc, F.Descripcion FamiliaDesc, I.PrecioCosto PrecioCosto,
          SUM(S.StockFisico) StockFisico
        FROM ALM_ItemMast I
            LEFT JOIN MST_ClaseLinea L ON I.IdLinea=L.IdLinea
                LEFT JOIN MST_ClaseFamilia F ON I.IdFamilia=F.IdFamilia
                    LEFT JOIN ALM_Marca M ON I.IdMarca=M.IdMarca
                        LEFT JOIN ALM_ItemAlmacenStock S ON S.IdItem=I.IdItem
                        	-- LEFT JOIN  (SELECT * FROM MST_ListaPrecioDetalle XX WHERE XX.IdTipoPrecio = 1) X ON X.IdItem = I.IdItem
        WHERE 1=1
            $s_Where AND I.Estado = 'A'
        GROUP BY I.IdItem
        ORDER BY I.DescripcionCompleta
        -- having StockFisico > 0
        ";
        //pr( $s_Sql );
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        $a_ALM_ItemMast = array();
        while( $o_ResultSet->next() )
        {
            $a_SQLRow = $o_ResultSet->getRow();
            $a_ALM_ItemMast[] = $a_SQLRow;
        }
        return $a_ALM_ItemMast;
    }
}