<?php
/* Busqueda de registros de la tabla ALM_ItemAlmacenStock redefinidos por el usuario. */
class ALM_ItemAlmacenStockFN extends BaseALM_ItemAlmacenStockFN
{
    protected static $GroupByAlmacen  = null;
    public static function setGroupByAlmacen( $v )
    {
        self::$GroupByAlmacen = $v;
    }
    public static function getGroupByAlmacen()
    {
        return self::$GroupByAlmacen;
    }
    protected static $GroupByLote  = null;
    public static function setGroupByLote( $v )
    {
        self::$GroupByLote = $v;
    }
    public static function getGroupByLote()
    {
        return self::$GroupByLote;
    }

    public function selectdos( $i_Position = null, $i_Rows = null )
    {
        $s_Campos  = "";

        if( ALM_ItemAlmacenStockFN::getGroupByAlmacen() )
        {
            $s_Campos  .= " SUM(StockFisico) SumaStockFisico, ";
        }

        $s_SQLQuery = "
            SELECT 
                $s_Campos
                MST_ClaseLinea.Descripcion LineaDescripcion, ALM_Marca.DescripcionLocal MarcaDesc, ALM_ItemMast.NumeroDeParte,
                ALM_ItemAlmacenStock.*
            FROM ALM_ItemAlmacenStock
                LEFT JOIN ALM_ItemMast ON ALM_ItemMast.IdItem=ALM_ItemAlmacenStock.IdItem
                    LEFT JOIN MST_ClaseLinea ON MST_ClaseLinea.IdLinea=ALM_ItemMast.IdLinea
                        LEFT JOIN ALM_Marca ON ALM_ItemMast.IdMarca=ALM_Marca.IdMarca
            WHERE 
        ";
        $s_SQLQuery .= $this->buildConsult();

        if( !is_null( $this->getIdProveedor() ) ){ $s_SQLQuery .= " and ALM_ItemAlmacenStock.IdItem in ( SELECT IdItem FROM MST_RelacionReferenciaProducto where IdProveedor=".$this->getIdProveedor()." ) "; }
        if( !is_null( $this->getIdReferencia() ) ){ $s_SQLQuery .= " and ALM_ItemAlmacenStock.IdItem in ( SELECT IdItem FROM MST_RelacionReferenciaProducto where IdReferencia in ( SELECT IdReferencia FROM MST_ReferenciaProducto WHERE Descripcion LIKE '%".$this->getIdReferencia()."%' ) ) "; }
        if( !is_null( $this->getIdColor() ) ){ $s_SQLQuery .= " and ALM_ItemAlmacenStock.IdItem in ( SELECT IdItem FROM MST_RelacionReferenciaProducto where IdColor=".$this->getIdColor()." ) "; }
        if( !is_null( $this->getIdCatTalla() ) ){ $s_SQLQuery .= " and ALM_ItemAlmacenStock.IdItem in ( SELECT IdItem FROM MST_RelacionReferenciaProducto where IdCatTalla=".$this->getIdCatTalla()." ) "; }
        if( !is_null( $this->getIdTalla() ) ){ $s_SQLQuery .= " and ALM_ItemAlmacenStock.IdItem in ( SELECT IdItem FROM MST_RelacionReferenciaProducto where IdTalla in ( SELECT IdTalla FROM MST_Talla where Descripcion like '%".$this->getIdTalla()."%' ) ) "; }

        if( ALM_ItemAlmacenStockFN::getGroupByAlmacen() )
        {
            $s_SQLQuery .= " GROUP BY ALM_ItemMast.IdItem ";
        }

        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }

        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        //pr( $s_SQLQuery );

        $a_ALM_ItemAlmacenStock = array();
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_SQLQuery )->executeQuery();
        while( $o_ResultSet->next() )
        {
            $a_SQLRow = $o_ResultSet->getRow();
            $o_ALM_ItemAlmacenStockBN = $this->insertObjectBN( $a_SQLRow );

            if( ALM_ItemAlmacenStockFN::getGroupByAlmacen() )
            {
                $o_ALM_ItemAlmacenStockBN->setStockFisico( floatval( $a_SQLRow['SumaStockFisico'] ) );
            }

            $o_ALM_ItemAlmacenStockBN->setLineaDescripcion( $a_SQLRow['LineaDescripcion'] );
            $o_ALM_ItemAlmacenStockBN->setMarcaDesc( $a_SQLRow['MarcaDesc'] );
            $o_ALM_ItemAlmacenStockBN->setPartNumber( $a_SQLRow['NumeroDeParte'] );

            $a_ALM_ItemAlmacenStock[] = $o_ALM_ItemAlmacenStockBN;
        }
        return $a_ALM_ItemAlmacenStock;
    }

    public function selectdosNumRows()
    {
        $s_SQLQuery = "
            SELECT COUNT(*) AS cnt 
            FROM ALM_ItemAlmacenStock
                LEFT JOIN ALM_ItemMast ON ALM_ItemMast.IdItem=ALM_ItemAlmacenStock.IdItem
                    LEFT JOIN MST_ClaseLinea ON MST_ClaseLinea.IdLinea=ALM_ItemMast.IdLinea
            WHERE
        ";
        $s_SQLQuery .= $this->buildConsult();

        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_SQLQuery )->executeQuery();
        $o_ResultSet->next();
        $num_rows = $o_ResultSet->getInt( 'cnt' );
        return $num_rows;
    }

    public static function recuperarStockActual( $i_IdCompania, $s_IdItem, $s_IdAlmacen, $s_IdLote=ALM_ItemAlmacenStockBN::LOTE_POR_DEFECTO, $s_IdCondicion=ALM_ItemAlmacenStockBN::CONDICION_POR_DEFECTO )
    {
        $o_ALM_ItemAlmacenStockFN = new ALM_ItemAlmacenStockFN();
        $o_ALM_ItemAlmacenStockBN = $o_ALM_ItemAlmacenStockFN->selectByPK( $i_IdCompania, $s_IdItem, $s_IdAlmacen, $s_IdCondicion , $s_IdLote );
        $f_StockActual = 0;
        if( $o_ALM_ItemAlmacenStockBN )
        {
            //$f_StockActual = $o_ALM_ItemAlmacenStockBN->getStockActual();
            $f_StockActual = $o_ALM_ItemAlmacenStockBN->getStockDisponible();
        }
        return floatval( $f_StockActual );
    }

    public static function recuperarStockDisponible( $i_IdCompania, $s_IdItem, $s_IdAlmacen, $s_IdLote=ALM_ItemAlmacenStockBN::LOTE_POR_DEFECTO, $s_IdCondicion=ALM_ItemAlmacenStockBN::CONDICION_POR_DEFECTO )
    {
        $o_ALM_ItemAlmacenStockFN = new ALM_ItemAlmacenStockFN();
        $o_ALM_ItemAlmacenStockBN = $o_ALM_ItemAlmacenStockFN->selectByPK( $i_IdCompania, $s_IdItem, $s_IdAlmacen, $s_IdCondicion , $s_IdLote );
        $f_StockDisponible = 0;
        if( $o_ALM_ItemAlmacenStockBN )
        {
            $f_StockDisponible = $o_ALM_ItemAlmacenStockBN->getStockDisponible();
        }
        return floatval( $f_StockDisponible );
    }
    
    public static function recuperarFechaVencimientoLote( $i_IdCompania, $s_IdItem, $s_IdAlmacen, $s_IdLote=ALM_ItemAlmacenStockBN::LOTE_POR_DEFECTO, $s_IdCondicion=ALM_ItemAlmacenStockBN::CONDICION_POR_DEFECTO )
    {
        $o_ALM_ItemAlmacenStockFN = new ALM_ItemAlmacenStockFN();
        $o_ALM_ItemAlmacenStockBN = $o_ALM_ItemAlmacenStockFN->selectByPK( $i_IdCompania, $s_IdItem, $s_IdAlmacen, $s_IdCondicion , $s_IdLote );
        $s_FechaVencimiento = "";
        if( $o_ALM_ItemAlmacenStockBN )
        {
            $s_FechaVencimiento = $o_ALM_ItemAlmacenStockBN->getFechaVencimiento();
        }
        return $s_FechaVencimiento;
    }
    
    public static function recuperarLotes( $i_IdCompania, $s_IdAlmacen, $s_IdItem, $b_Stock=true )
    {
        $o_ALM_ItemAlmacenStockFN = new ALM_ItemAlmacenStockFN();
        //$o_ALM_ItemAlmacenStockFN->setDebug( 1 );
        $o_ALM_ItemAlmacenStockFN->setIdCompania( $i_IdCompania );
        $o_ALM_ItemAlmacenStockFN->setIdAlmacen( $s_IdAlmacen );
        $o_ALM_ItemAlmacenStockFN->setIdItem( $s_IdItem );
        if( $b_Stock )
        {
            $o_ALM_ItemAlmacenStockFN->addCondition( ALM_ItemAlmacenStockFN::StockFisico, ">", 0, false );
        }
        $o_ALM_ItemAlmacenStockFN->addCondition( "COALESCE( ( SELECT Estado FROM ALM_Lote WHERE LoteNumero=ALM_ItemAlmacenStock.IdLote AND IdItem=ALM_ItemAlmacenStock.IdItem ), 'A' )", "=", "'A'", false );
        $o_ALM_ItemAlmacenStockFN->addOrderBy( ALM_ItemAlmacenStockFN::FechaVencimiento );
        //$o_ALM_ItemAlmacenStockFN->addOrderBy( ALM_ItemAlmacenStockFN::StockDisponible, false );
        $a_ALM_ItemAlmacenStock = $o_ALM_ItemAlmacenStockFN->select();

        return $a_ALM_ItemAlmacenStock;
    }
    
    public static function recuperarDataConSaldoAnt( $s_PeriodoAnt )
    {
        /*
        $s_Sql = "SELECT S.IdCompania, S.IdItem, S.IdAlmacen, S.IdLote, H.IdPeriodo, COALESCE(H.Cantidad,0.00) Cantidad
                    FROM ALM_ItemAlmacenStock S
                        LEFT JOIN ALM_ItemStockDetHis H ON S.IdItem=H.IdItem AND S.IdAlmacen=H.IdAlmacen AND S.IdCondicion='0' AND S.IdLote=H.IdLote AND S.IdCompania=H.IdCompania AND H.IdPeriodo='$s_PeriodoAnt'  
                    
                    ;"; //WHERE S.IdItem='MEDI0000720'
        $o_DBConnect = Conexion::getConexion();
        $o_SQLResult = mysql_query( $s_Sql, $o_DBConnect->getResource() );
        return $o_SQLResult;*/
    }
    
    public static function buscarProductosPorVencer()
    {
        $s_Where = "";
        if( myUser::getUser()->getIdSucursal() )
        {
            $s_Where .= " AND A.IDSucursal='".myUser::getUser()->getIdSucursal()."' ";
        }
        $s_Sql = "SELECT S.IdAlmacen, S.StockActual, A.DescripcionLocal, A.IdSucursal, S.IdLote, S.FechaVencimiento,
                        DATE_SUB(S.FechaVencimiento, INTERVAL 2 MONTH) FechaCalculo, NOW() FechaAhora, I.IdItem, I.CodigoBarras,
                        I.DescripcionCompleta
                    FROM ALM_ItemMast I
                      LEFT JOIN ALM_ItemAlmacenStock S ON S.IdItem=I.IdItem
                        LEFT JOIN ALM_AlmacenMast A ON S.IdAlmacen=A.IdAlmacen
                    WHERE 1=1
                        AND I.Estado='A'
                        AND I.ManejoxLoteFlag='S'
                        AND DATE_SUB( S.FechaVencimiento, INTERVAL 2 MONTH ) <= NOW()
                        $s_Where
                        AND S.IdLote<>'000'
                        AND S.StockActual>0
                    ORDER BY I.DescripcionCompleta;";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        return $o_ResultSet;
    }
    
    public static function buscarSumaStockxItemAlmacen( $s_IdItem, $s_IdAlmacen )
    {
        $s_Sql = "SELECT SUM(StockActual) StockActual FROM ALM_ItemAlmacenStock WHERE IdItem='$s_IdItem' AND IdAlmacen='$s_IdAlmacen';";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        $o_ResultSet->next();
        $a_Row = $o_ResultSet->getRow();
        return floatval( $a_Row['StockActual'] ) ;
        /*
        SELECT
        ( SELECT SUM(StockActual) StockActual FROM ALM_ItemAlmacenStock WHERE IdItem=ALM_ItemMast.IdItem ),
        ALM_ItemMast.*
        FROM ALM_ItemMast
        WHERE 1=1
        AND Estado='A'
        AND ( SELECT SUM(StockActual) StockActual FROM ALM_ItemAlmacenStock WHERE IdItem=ALM_ItemMast.IdItem ) > 0
        ORDER BY DescripcionCompleta;
        */
    }

    public static function getStockFisicoTotal( $s_IdItem, $s_IdAlmacen=null, $s_IdLote=null )
    {
        $s_Where = "";
        if( $s_IdAlmacen )
        {
            $s_Where .= " AND IdAlmacen='$s_IdAlmacen' ";
        }
        if( $s_IdLote )
        {
            $s_Where .= " AND IdLote='$s_IdLote' ";
        }
        $s_Sql = "SELECT SUM(StockFisico) StockFisico FROM ALM_ItemAlmacenStock WHERE IdItem='$s_IdItem' $s_Where ;";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        $o_ResultSet->next();
        $a_Row = $o_ResultSet->getRow();
        return floatval( $a_Row['StockFisico'] ) ;
    }
    
    public static function getStockDisponibleTotal( $s_IdItem, $s_IdAlmacen=null )
    {
        $s_Where = "";
        if( $s_IdAlmacen )
        {
            $s_Where .= " AND IdAlmacen='$s_IdAlmacen' ";
        }
        $s_Sql = "SELECT SUM(StockDisponible) StockDisponible FROM ALM_ItemAlmacenStock WHERE IdItem='$s_IdItem' $s_Where ;";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        $o_ResultSet->next();
        $a_Row = $o_ResultSet->getRow();
        return floatval( $a_Row['StockDisponible'] ) ;
    }
}
?>