<?php
/* Mantenimiento de los registros de la tabla VTA_Orden redefinidos por el usaurio */
class VTA_OrdenDP extends BaseVTA_OrdenDP
{
    public static function generarId( $s_OrdenTipoId )
    {
        $o_VTA_OrdenTipoFN = new VTA_OrdenTipoFN();
        $o_VTA_OrdenTipoBN = $o_VTA_OrdenTipoFN->selectByPK( $s_OrdenTipoId );
        
        $s_Prf = $o_VTA_OrdenTipoBN->getOrdenTipoPrefijo();
        
        $o_utilGenerateId = new utilGenerateId();
        //$o_utilGenerateId->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_utilGenerateId->setIdCompania( -1 );
        $o_utilGenerateId->setTipoCorrelativo( "VTA" );
        $o_utilGenerateId->setSerie( $o_VTA_OrdenTipoBN->getDocRefTipo() );
        $i_IdOrd = $o_utilGenerateId->generateIntId();
        $o_utilGenerateId->setSerie( $s_Prf );
        $i_Id = $o_utilGenerateId->generateIntId();
        
        $o_Obj = $o_utilGenerateId->getObjCorrelativoMast();
        
        $s_Codigo = $s_Prf.str_repeat( '0', strlen( $o_Obj->getCorrelativoHasta() ) - strlen( $i_Id ) ).$i_Id;
        
        return array( "id" => $i_IdOrd, "cod" => $s_Codigo );
    }
    
    public static function generarIdNum( $s_OrdenTipoId )
    {
        $o_VTA_OrdenTipoFN = new VTA_OrdenTipoFN();
        $o_VTA_OrdenTipoBN = $o_VTA_OrdenTipoFN->selectByPK( $s_OrdenTipoId );
        
        $s_Prf = $o_VTA_OrdenTipoBN->getOrdenTipoPrefijo();
        
        $o_utilGenerateId = new utilGenerateId();
        $o_utilGenerateId->setIdCompania( -1 );
        $o_utilGenerateId->setTipoCorrelativo( "VTA" );
        $o_utilGenerateId->setSerie( $s_Prf );
        $i_Id = $o_utilGenerateId->generateIntId();
        
        $o_Obj = $o_utilGenerateId->getObjCorrelativoMast();
        
        $s_Codigo = $s_Prf.str_repeat( '0', strlen( $o_Obj->getCorrelativoHasta() ) - strlen( $i_Id ) ).$i_Id;
        
        return array( "cod" => $s_Codigo );
    }


    public static function actualizarCabaceraMontos( $OrdenId )
    {
        $o_VTA_OrdenFN = new VTA_OrdenFN();
        $o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $OrdenId );
        
        //el tipo de cambio de la cabecera
        $f_TipoCob = $o_VTA_OrdenBN->getMonedaCambioValor();
        
        //ahora recupero la moneda de la Orden de Venta
        $s_OrdenMonedaCod = $o_VTA_OrdenBN->getMonedaCod();
        
        //se pregunta el control de impuesto por cabecera de la cotizacion
        $b_ControlImpuesto  = $o_VTA_OrdenBN->esGravadaConImpuesto();
        //otra pregunta, si esta exonerado del igv - 2021-12-29
        $b_ControlExonerado = $o_VTA_OrdenBN->esExoneradodeIGV();
        
        //para recuperar la moneda del sistema
        $o_MST_ListaPrecioCabeceraFN = new MST_ListaPrecioCabeceraFN();
        $o_MST_ListaPrecioCabeceraBN = $o_MST_ListaPrecioCabeceraFN->selectByPK( myUser::getUser()->getIdBusiness(), myUser::getUser()->getIdSucursal() );
        if( !$o_MST_ListaPrecioCabeceraBN )
        {
            $o_MST_ListaPrecioCabeceraBN = $o_MST_ListaPrecioCabeceraFN->buscaListaPrecioAlternativo();
        }
        
        $o_VTA_OrdenDetalleFN = new VTA_OrdenDetalleFN();
        $o_VTA_OrdenDetalleFN->setOrdenId( $OrdenId );
        $o_VTA_OrdenDetalleFN->addCondition( VTA_OrdenDetalleFN::ItemTipo, "IN", "('P','S')", false );
        $a_VTA_OrdenDetalle = $o_VTA_OrdenDetalleFN->select();
        
        $f_SubTotalVenta   = 0.00;
        $f_SubTotalVentaMN = 0.00;
        
        $f_TotalConIGV     = 0.00;
        $f_TotalConIGVMN   = 0.00;
        $f_TotalSinIGV     = 0.00;
        $f_TotalSinIGVMN   = 0.00;
        $f_TotalExoneado   = 0;
        $f_TotalExoneadoMN = 0;
        
        $f_SubTotalImpuesto   = 0.00;
        $f_SubTotalImpuestoMN = 0.00;

        $f_OrdenNeto   = 0.00;
        $f_OrdenNetoMN = 0.00;

        if( $a_VTA_OrdenDetalle )
        {
            foreach( $a_VTA_OrdenDetalle as $o_VTA_OrdenDetalleBN )
            {
                //pr( $o_VTA_OrdenDetalleBN->getOrdenDetalleSubTotalVentaMN() );
                $s_AfectoImpuesto = $o_VTA_OrdenDetalleBN->getOrdenDetalleAfectoImpuesto();

                $f_SubTotalVenta   = ( $o_VTA_OrdenDetalleBN->getOrdenDetalleSubTotalVenta() ) + $f_SubTotalVenta;
                $f_SubTotalVentaMN = ( $o_VTA_OrdenDetalleBN->getOrdenDetalleSubTotalVentaMN() ) + $f_SubTotalVentaMN;

                $f_SubTotalImpuesto   = ( $o_VTA_OrdenDetalleBN->getOrdenDetalleSubTotalImpuesto() ) + $f_SubTotalImpuesto;
                $f_SubTotalImpuestoMN = ( $o_VTA_OrdenDetalleBN->getOrdenDetalleSubTotalImpuestoMN() ) + $f_SubTotalImpuestoMN;

                if( !$b_ControlExonerado )
                {
                    if( $s_AfectoImpuesto == "Y" )
                    {
                        $f_TotalConIGV   = ( $o_VTA_OrdenDetalleBN->getOrdenDetalleSubTotalVenta() ) + $f_TotalConIGV;
                        $f_TotalConIGVMN = ( $o_VTA_OrdenDetalleBN->getOrdenDetalleSubTotalVentaMN() ) + $f_TotalConIGVMN;
                    }
                    else
                    {
                        $f_TotalSinIGV   = ( $o_VTA_OrdenDetalleBN->getOrdenDetalleSubTotalVenta() ) + $f_TotalSinIGV;
                        $f_TotalSinIGVMN = ( $o_VTA_OrdenDetalleBN->getOrdenDetalleSubTotalVentaMN() ) + $f_TotalSinIGVMN;
                    }
                }
                if( $b_ControlExonerado )
                {
                    $f_TotalExoneado   = ( $o_VTA_OrdenDetalleBN->getOrdenDetalleSubTotalVenta() ) + $f_TotalExoneado;
                    $f_TotalExoneadoMN = ( $o_VTA_OrdenDetalleBN->getOrdenDetalleSubTotalVentaMN() ) + $f_TotalExoneadoMN;
                }

                $f_OrdenNeto   = $o_VTA_OrdenDetalleBN->getOrdenDetalleSubTotalNeto() + $f_OrdenNeto;
                $f_OrdenNetoMN = $o_VTA_OrdenDetalleBN->getOrdenDetalleSubTotalNetoMN() + $f_OrdenNetoMN;
            }
        }
        
        $o_VTA_OrdenDP = new VTA_OrdenDP();
        $o_VTA_OrdenDP->setOrdenId( $OrdenId );
        $o_VTA_OrdenDP->setOrdenVenta( $f_SubTotalVenta );
        $o_VTA_OrdenDP->setOrdenVentaMN( $f_SubTotalVentaMN );
        $o_VTA_OrdenDP->setOrdenAfecto( $f_TotalConIGV );
        $o_VTA_OrdenDP->setOrdenAfectoMN( $f_TotalConIGVMN );
        $o_VTA_OrdenDP->setMontoExonerado( $f_TotalExoneado );
        $o_VTA_OrdenDP->setMontoExoneradoMN( $f_TotalExoneadoMN );
        $o_VTA_OrdenDP->setOrdenInafecto( $f_TotalSinIGV );
        $o_VTA_OrdenDP->setOrdenInafectoMN( $f_TotalSinIGVMN );
        $o_VTA_OrdenDP->setOrdenImpuesto( $f_SubTotalImpuesto );
        $o_VTA_OrdenDP->setOrdenImpuestoMN( $f_SubTotalImpuestoMN );
        //$o_VTA_OrdenDP->setOrdenNeto( utilMath::fnround( $f_TotalConIGV + $f_TotalSinIGV + $f_SubTotalImpuesto, 2 ) );
        $o_VTA_OrdenDP->setOrdenNeto( $f_OrdenNeto );
        //$o_VTA_OrdenDP->setOrdenNetoMN( utilMath::fnround( $f_TotalConIGVMN + $f_TotalSinIGVMN + $f_SubTotalImpuestoMN, 2 ) );
        $o_VTA_OrdenDP->setOrdenNetoMN( $f_OrdenNetoMN );
        
        $o_VTA_OrdenDP->setOrdenBaseImponible( $f_SubTotalVenta );
        $o_VTA_OrdenDP->setOrdenBaseImponibleMN( $f_TotalConIGVMN + $f_TotalSinIGVMN );
        $o_VTA_OrdenDP->setOrdenImpuestoConDscto( $f_SubTotalImpuesto );
        $o_VTA_OrdenDP->setOrdenImpuestoConDsctoMN( $f_SubTotalImpuestoMN );
        $o_VTA_OrdenDP->setOrdenTotalaPagar( $f_OrdenNeto );
        $o_VTA_OrdenDP->setOrdenTotalaPagarMN( $f_OrdenNetoMN );

        if( $b_ControlExonerado )
        {
            $b_ControlImpuesto = false;
        }
        
        if( ( $o_VTA_OrdenBN->getOrdenDscto() > 0 ) || ( $o_VTA_OrdenBN->getMontoAnticipo() > 0 ) )
        {
            $f_TotalImponible       = 0;
            $f_TotalImponibleMN     = 0;
            $f_TotalImpConDscto     = 0;
            $f_TotalImpConDsctoMN   = 0;
            $f_TotalaPagar          = 0;
            $f_TotalaPagarMN        = 0;
            
            //////////////////////////////////////////////////////////////////////////////////////////
            //SE RECUPERA VALOR DE IGV ACTUAL
            /*$o_GSS_ParametroMastFN = new GSS_ParametroMastFN();
            $o_GSS_ParametroMastBN = $o_GSS_ParametroMastFN->selectByPK( -1, 'AL', 'IGV' );
            $f_ValorIGV = floatval( $o_GSS_ParametroMastBN->getNumero() );
            $f_ValorIGVMasUno = floatval( $o_GSS_ParametroMastBN->getNumero() ) + 1;*/
            $f_ValorIGV       = GSS_ParametroMastFN::getValorPorTipo( "AL", "IGV" ); //0.18
            $f_ValorIGVMasUno = $f_ValorIGV + 1;  //1.18
            //////////////////////////////////////////////////////////////////////////////////////////
            
            if( $b_ControlImpuesto )
            {
                $f_TotalAnticipo    = $o_VTA_OrdenBN->getMontoAnticipo();
                $f_TotalDescuento   = $o_VTA_OrdenBN->getOrdenDscto();
                $f_SumaDescuento    = $f_TotalAnticipo + $f_TotalDescuento;

                $f_DsctoMulti        = ( $o_VTA_OrdenBN->getDsctoCod() / 100 );
                $f_TotalDsctoGrabado = ( $o_VTA_OrdenBN->getOrdenAfecto() - $f_TotalAnticipo ) * $f_DsctoMulti ;
                $f_TotalGravada      = round( $o_VTA_OrdenBN->getOrdenAfecto() - $f_TotalDsctoGrabado - $f_TotalAnticipo, 2 );
                $f_TotalImponible   = ( $f_TotalGravada + $o_VTA_OrdenBN->getOrdenInafecto() + $o_VTA_OrdenBN->getMontoExonerado() );
                //pr( $f_TotalImponible );

                //$f_TotalImponible   = $f_SubTotalVenta - $f_SumaDescuento;
                //$f_TotalImpConDscto = round( $f_TotalImponible * $f_ValorIGV, 2 );
                $f_TotalImpConDscto = round( $f_TotalGravada * $f_ValorIGV, 2 );
                $f_TotalaPagar      = $f_TotalImponible + $f_TotalImpConDscto;
            }
            else
            {
                $f_TotalAnticipo    = $o_VTA_OrdenBN->getMontoAnticipo();
                $f_TotalDescuento   = $o_VTA_OrdenBN->getOrdenDscto();
                $f_SumaDescuento    = $f_TotalAnticipo + $f_TotalDescuento;
                $f_TotalImponible   = $f_SubTotalVenta - $f_SumaDescuento;
                $f_TotalImpConDscto = 0;
                $f_TotalaPagar      = $f_TotalImponible + $f_TotalImpConDscto;
            }
            
            if( $o_MST_ListaPrecioCabeceraBN->getIdMoneda() == "LO" ) //MONEDA DE LA LISTA DE PRECIOS ES SOLES
            {
                if( $s_OrdenMonedaCod == "LO" )
                {
                    //$f_TotalDescuentoMN     = $f_TotalDescuento;
                    $f_TotalImponibleMN     = $f_TotalImponible;
                    $f_TotalImpConDsctoMN   = $f_TotalImpConDscto;
                    $f_TotalaPagarMN        = $f_TotalaPagar;
                }
                if( $s_OrdenMonedaCod == "EX" )
                {
                    //$f_TotalDescuentoMN     = round( $f_TotalDescuento * $f_TipoCob, 2 );
                    $f_TotalImponibleMN     = round( $f_TotalImponible * $f_TipoCob, 2 );
                    $f_TotalImpConDsctoMN   = round( $f_TotalImpConDscto * $f_TipoCob, 2 );
                    $f_TotalaPagarMN        = $f_TotalImponibleMN + $f_TotalImpConDsctoMN;
                }
            }
            
            //$o_VTA_OrdenDP->setOrdenDscto( $f_TotalDescuento );
            //$o_VTA_OrdenDP->setOrdenDsctoMN( $f_TotalDescuento );
            $o_VTA_OrdenDP->setOrdenBaseImponible( $f_TotalImponible );
            $o_VTA_OrdenDP->setOrdenBaseImponibleMN( $f_TotalImponibleMN );
            $o_VTA_OrdenDP->setOrdenImpuestoConDscto( $f_TotalImpConDscto );
            $o_VTA_OrdenDP->setOrdenImpuestoConDsctoMN( $f_TotalImpConDsctoMN );
            $o_VTA_OrdenDP->setOrdenTotalaPagar( $f_TotalaPagar );
            $o_VTA_OrdenDP->setOrdenTotalaPagarMN( $f_TotalaPagarMN );
        }
        
        $o_VTA_OrdenDP->setUsuarioActualizacion( myUser::getUser()->getUserId() );
        $o_VTA_OrdenDP->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
        $o_VTA_OrdenDP->update();
        
        //VTA_OrdenDP::actualizarCabaceraMontos2( $OrdenId );
    }
    
    public static function actualizarCabaceraMontos2( $OrdenId )
    {
        $o_VTA_OrdenFN = new VTA_OrdenFN();
        $o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $OrdenId );
        
        //el tipo de cambio de la cabecera
        $f_TipoCob = $o_VTA_OrdenBN->getMonedaCambioValor();
        
        //ahora recupero la moneda de la Orden de Venta
        $s_OrdenMonedaCod = $o_VTA_OrdenBN->getMonedaCod();
        
        //se pregunta el control de impuesto por cabecera de la cotizacion
        $b_ControlImpuesto = $o_VTA_OrdenBN->esGravadaConImpuesto();
        
        //para recuperar la moneda del sistema
        $o_MST_ListaPrecioCabeceraFN = new MST_ListaPrecioCabeceraFN();
        $o_MST_ListaPrecioCabeceraBN = $o_MST_ListaPrecioCabeceraFN->selectByPK( myUser::getUser()->getIdBusiness(), myUser::getUser()->getIdSucursal() );
        if( !$o_MST_ListaPrecioCabeceraBN )
        {
            $o_MST_ListaPrecioCabeceraBN = $o_MST_ListaPrecioCabeceraFN->buscaListaPrecioAlternativo();
        }
        
        $o_VTA_ProductoFinalFN = new VTA_ProductoFinalFN();
        $o_VTA_ProductoFinalFN->setOrdenId( $OrdenId );
        $a_VTA_ProductoFinal = $o_VTA_ProductoFinalFN->select();
        
        $f_SubTotalVenta        = 0;
        $f_SubTotalVentaMN      = 0;
        $f_SubTotalImpuesto     = 0;
        $f_SubTotalImpuestoMN   = 0;
        $f_OrdenNeto            = 0;
        $f_OrdenNetoMN          = 0;
        
        $f_SumaDsctoTotal   = 0;
        $f_SumaImponible    = 0;
        $f_SumaImpConDscto  = 0;
        $f_SumaTotalaPagar  = 0;
        
        foreach ( $a_VTA_ProductoFinal as $o_VTA_ProductoFinalBN )
        {
            $f_SubTotalVenta    = $f_SubTotalVenta    + $o_VTA_ProductoFinalBN->getSubTotalSinIGV();
            $f_SubTotalImpuesto = $f_SubTotalImpuesto + $o_VTA_ProductoFinalBN->getImpuestoSubTotal();
            $f_OrdenNeto        = $f_OrdenNeto        + $o_VTA_ProductoFinalBN->getPrecioTotalConIGV();
        }
        
        if( $o_MST_ListaPrecioCabeceraBN->getIdMoneda() == "LO" ) //MONEDA DE LA LISTA DE PRECIOS ES SOLES
        {
            if( $s_OrdenMonedaCod == "LO" )
            {
                $f_SubTotalVentaMN      = $f_SubTotalVenta;
                $f_SubTotalImpuestoMN   = $f_SubTotalImpuesto;
                $f_OrdenNetoMN          = $f_OrdenNeto;
            }
            if( $s_OrdenMonedaCod == "EX" )
            {
                $f_SubTotalVentaMN      = round( $f_SubTotalVenta * $f_TipoCob, 2 );
                $f_OrdenNetoMN          = round( $f_OrdenNeto * $f_TipoCob, 2 );
                $f_SubTotalImpuestoMN   = $f_OrdenNetoMN - $f_SubTotalVentaMN;
            }
        }
        
        $o_VTA_OrdenDP = new VTA_OrdenDP();
        $o_VTA_OrdenDP->setOrdenId( $OrdenId );
        $o_VTA_OrdenDP->setOrdenVenta( $f_SubTotalVenta );
        $o_VTA_OrdenDP->setOrdenVentaMN( $f_SubTotalVentaMN );
        
        if( $b_ControlImpuesto )
        {
            $o_VTA_OrdenDP->setOrdenAfecto( $f_SubTotalVenta );
            $o_VTA_OrdenDP->setOrdenAfectoMN( $f_SubTotalVentaMN );
            $o_VTA_OrdenDP->setOrdenInafecto( 0 );
            $o_VTA_OrdenDP->setOrdenInafectoMN( 0 );
        }
        else
        {
            $o_VTA_OrdenDP->setOrdenAfecto( 0 );
            $o_VTA_OrdenDP->setOrdenAfectoMN( 0 );
            $o_VTA_OrdenDP->setOrdenInafecto( $f_SubTotalVenta );
            $o_VTA_OrdenDP->setOrdenInafectoMN( $f_SubTotalVentaMN );
        }
        
        $o_VTA_OrdenDP->setOrdenImpuesto( $f_SubTotalImpuesto );
        $o_VTA_OrdenDP->setOrdenImpuestoMN( $f_SubTotalImpuestoMN );
        $o_VTA_OrdenDP->setOrdenNeto( $f_OrdenNeto );
        $o_VTA_OrdenDP->setOrdenNetoMN( $f_OrdenNetoMN );
        
        $o_VTA_OrdenDP->setOrdenBaseImponible( $f_SubTotalVenta );
        $o_VTA_OrdenDP->setOrdenBaseImponibleMN( $f_SubTotalVentaMN );
        $o_VTA_OrdenDP->setOrdenImpuestoConDscto( $f_SubTotalImpuesto );
        $o_VTA_OrdenDP->setOrdenImpuestoConDsctoMN( $f_SubTotalImpuestoMN );
        $o_VTA_OrdenDP->setOrdenTotalaPagar( $f_OrdenNeto );
        $o_VTA_OrdenDP->setOrdenTotalaPagarMN( $f_OrdenNetoMN );
        
        if( ( $o_VTA_OrdenBN->getOrdenDscto() > 0 ) || ( $o_VTA_OrdenBN->getMontoAnticipo() > 0 ) )
        {
            //$f_TotalDescuento       = 0;
            //$f_TotalDescuentoMN     = 0;
            $f_TotalImponible       = 0;
            $f_TotalImponibleMN     = 0;
            $f_TotalImpConDscto     = 0;
            $f_TotalImpConDsctoMN   = 0;
            $f_TotalaPagar          = 0;
            $f_TotalaPagarMN        = 0;
            
            //////////////////////////////////////////////////////////////////////////////////////////
            //SE RECUPERA VALOR DE IGV ACTUAL
            /*$o_GSS_ParametroMastFN = new GSS_ParametroMastFN();
            $o_GSS_ParametroMastBN = $o_GSS_ParametroMastFN->selectByPK( -1, 'AL', 'IGV' );
            $f_ValorIGV = floatval( $o_GSS_ParametroMastBN->getNumero() );
            $f_ValorIGVMasUno = floatval( $o_GSS_ParametroMastBN->getNumero() ) + 1;*/
            $f_ValorIGV       = GSS_ParametroMastFN::getValorPorTipo( "AL", "IGV" ); //0.18
            $f_ValorIGVMasUno = $f_ValorIGV + 1;  //1.18
            //////////////////////////////////////////////////////////////////////////////////////////
            
            if( $b_ControlImpuesto )
            {
                $f_TotalAnticipo    = $o_VTA_OrdenBN->getMontoAnticipo();
                $f_TotalDescuento   = $o_VTA_OrdenBN->getOrdenDscto();
                $f_SumaDescuento    = $f_TotalAnticipo + $f_TotalDescuento;
                $f_TotalImponible   = $f_SubTotalVenta - $f_SumaDescuento;
                $f_TotalImpConDscto = round( $f_TotalImponible * $f_ValorIGV, 2 );
                $f_TotalaPagar      = $f_TotalImponible + $f_TotalImpConDscto;
            }
            else
            {
                $f_TotalAnticipo    = $o_VTA_OrdenBN->getMontoAnticipo();
                $f_TotalDescuento   = $o_VTA_OrdenBN->getOrdenDscto();
                $f_SumaDescuento    = $f_TotalAnticipo + $f_TotalDescuento;
                $f_TotalImponible   = $f_SubTotalVenta - $f_SumaDescuento;
                $f_TotalImpConDscto = 0;
                $f_TotalaPagar      = $f_TotalImponible + $f_TotalImpConDscto;
            }
            
            if( $o_MST_ListaPrecioCabeceraBN->getIdMoneda() == "LO" ) //MONEDA DE LA LISTA DE PRECIOS ES SOLES
            {
                if( $s_OrdenMonedaCod == "LO" )
                {
                    //$f_TotalDescuentoMN     = $f_TotalDescuento;
                    $f_TotalImponibleMN     = $f_TotalImponible;
                    $f_TotalImpConDsctoMN   = $f_TotalImpConDscto;
                    $f_TotalaPagarMN        = $f_TotalaPagar;
                }
                if( $s_OrdenMonedaCod == "EX" )
                {
                    //$f_TotalDescuentoMN     = round( $f_TotalDescuento * $f_TipoCob, 2 );
                    $f_TotalImponibleMN     = round( $f_TotalImponible * $f_TipoCob, 2 );
                    $f_TotalImpConDsctoMN   = round( $f_TotalImpConDscto * $f_TipoCob, 2 );
                    $f_TotalaPagarMN        = $f_TotalImponibleMN + $f_TotalImpConDsctoMN;
                }
            }
            
            //$o_VTA_OrdenDP->setOrdenDscto( $f_TotalDescuento );
            //$o_VTA_OrdenDP->setOrdenDsctoMN( $f_TotalDescuentoMN );
            $o_VTA_OrdenDP->setOrdenBaseImponible( $f_TotalImponible );
            $o_VTA_OrdenDP->setOrdenBaseImponibleMN( $f_TotalImponibleMN );
            $o_VTA_OrdenDP->setOrdenImpuestoConDscto( $f_TotalImpConDscto );
            $o_VTA_OrdenDP->setOrdenImpuestoConDsctoMN( $f_TotalImpConDsctoMN );
            $o_VTA_OrdenDP->setOrdenTotalaPagar( $f_TotalaPagar );
            $o_VTA_OrdenDP->setOrdenTotalaPagarMN( $f_TotalaPagarMN );
        }
        
        $o_VTA_OrdenDP->setUsuarioActualizacion( myUser::getUser()->getUserId() );
        $o_VTA_OrdenDP->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
        $o_VTA_OrdenDP->update();
    }

    public static function actualizarFormaPago( $i_OrdenId, $s_FormaPago )
    {
        $o_VTA_OrdenDP = new VTA_OrdenDP();
        $o_VTA_OrdenDP->setOrdenId( $i_OrdenId );
        $o_VTA_OrdenDP->setFormaPagoDesc( $s_FormaPago );
        $o_VTA_OrdenDP->setUsuarioActualizacion( myUser::getUser()->getUserId() );
        $o_VTA_OrdenDP->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
        $o_VTA_OrdenDP->update();
    }
}