<?php
/* Mantenimiento de los registros de la tabla VTA_Documento redefinidos por el usaurio */
class VTA_DocumentoDP extends BaseVTA_DocumentoDP
{
    public function actualizarDocumentoCabacera()
    {
        $o_VTA_DocumentoFN = new VTA_DocumentoFN();

        $a_Field = array();
        if( $this->getIdTipoDocumentoRef() )
        {
            $a_Field[] = " IdTipoDocumento = '".$this->getIdTipoDocumentoRef()."' ";
        }
        if( $this->getDocumentoCod() )
        {
            $a_Field[] = " DocumentoCod = '".$this->getDocumentoCod()."' ";
        }
        if( $this->getDocumentoSerie() )
        {
            $a_Field[] = " DocumentoSerie = '".$this->getDocumentoSerie()."' ";
        }
        if( $this->getFechaDocumento() )
        {
            $a_Field[] = " FechaDocumento = '".$this->getFechaDocumento()."' ";
            $a_Field[] = " Periodo = '".str_replace( "-", "", substr( $this->getFechaDocumento(), 0, 7 ) )."' ";
        }

        $a_Field[] = " UsuarioModificacion = '".myUser::getUser()->getUserId()."' ";
        $a_Field[] = " FechaModificacion = '".date( "Y-m-d H:i:s" )."' ";

        $s_SQLQuery = "UPDATE VTA_Documento SET ";
        $s_SQLQuery .= implode( ",", $a_Field );
        $s_SQLQuery .= " WHERE  IdTipoDocumento = '".$this->getIdTipoDocumento()."' AND  IdCompania = ".$this->getIdCompania()." AND  NumeroDocumento = '".$this->getNumeroDocumento()."';";
        Conexion::getConexion()->createStatement()->executeQuery( $s_SQLQuery );
        //ahora se actualiza los detalles
        if( $this->getIdTipoDocumentoRef() )
        {
            $s_SQLQuery = "UPDATE VTA_DocumentoDetalle SET IdTipoDocumento='".$this->getIdTipoDocumentoRef()."' ";
            $s_SQLQuery .= " WHERE  IdTipoDocumento = '".$this->getIdTipoDocumento()."' AND  IdCompania = ".$this->getIdCompania()." AND NumeroDocumento = '".$this->getNumeroDocumento()."';";
            Conexion::getConexion()->createStatement()->executeQuery( $s_SQLQuery );
        }
        return true;
    }

    public static function actualizarCabaceraMontos( $IdTipoDocumento, $IdCompania, $NumeroDocumento, $IdAlmacen="" )
    {
        $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
        $o_VTA_DocumentoDetalleFN->setIdTipoDocumento( $IdTipoDocumento );
        $o_VTA_DocumentoDetalleFN->setIdCompania( $IdCompania );
        $o_VTA_DocumentoDetalleFN->setNumeroDocumento( $NumeroDocumento );
        $a_VTA_DocumentoDetalle = $o_VTA_DocumentoDetalleFN->select();
         
        /*$f_TotalSiExIGV = 0.00;
        $f_TotalNoExIGV = 0.00;
        $f_TotalIGV     = 0.00;
        $f_TotalDscto   = 0.00;*/
        
        
        $f_SubTotalVenta   = 0.00;
        $f_SubTotalVentaMN = 0.00;
        
        $f_TotalConIGV    = 0.00;
        $f_TotalConIGVMN  = 0.00;
        $f_TotalSinIGV    = 0.00;
        $f_TotalSinIGVMN  = 0.00;
        
        $f_SubTotalImpuesto   = 0.00;
        $f_SubTotalImpuestoMN = 0.00;
        
        if( $a_VTA_DocumentoDetalle )
        {
            foreach ( $a_VTA_DocumentoDetalle as $o_VTA_DocumentoDetalleBN )
            {
                $s_IGVExonerado = $o_VTA_DocumentoDetalleBN->getIGVExoneradoFlag();
                
                $f_SubTotalVenta = $o_VTA_DocumentoDetalleBN->getMontoSubTotal() + $f_SubTotalVenta;
                $f_SubTotalVentaMN = $o_VTA_DocumentoDetalleBN->getMontoSubTotalMN() + $f_SubTotalVentaMN;
                
                $f_SubTotalImpuesto   = ( $o_VTA_DocumentoDetalleBN->getMontoSubTotalImpuesto() ) + $f_SubTotalImpuesto;
                $f_SubTotalImpuestoMN = ( $o_VTA_DocumentoDetalleBN->getMontoSubTotalImpuestoMN() ) + $f_SubTotalImpuestoMN;
                
                if( $s_IGVExonerado == "N" )
                {
                    $f_TotalConIGV   = ( $o_VTA_DocumentoDetalleBN->getMontoSubTotal() ) + $f_TotalConIGV;
                    $f_TotalConIGVMN = ( $o_VTA_DocumentoDetalleBN->getMontoSubTotalMN() ) + $f_TotalConIGVMN;
                }
                else
                {
                    $f_TotalSinIGV   = ( $o_VTA_DocumentoDetalleBN->getMontoSubTotal() ) + $f_TotalSinIGV;
                    $f_TotalSinIGVMN = ( $o_VTA_DocumentoDetalleBN->getMontoSubTotalMN() ) + $f_TotalSinIGVMN;
                }
                
            }
        }
        $o_VTA_DocumentoDP = new VTA_DocumentoDP();
        $o_VTA_DocumentoDP->setIdTipoDocumento( $IdTipoDocumento );
        $o_VTA_DocumentoDP->setIdCompania( ( int ) $IdCompania );
        $o_VTA_DocumentoDP->setNumeroDocumento( $NumeroDocumento );
        
        /*$o_VTA_DocumentoDP->setMontoAfecto( $f_TotalNoExIGV );
        $o_VTA_DocumentoDP->setMontoNoAfecto( $f_TotalSiExIGV );
        $o_VTA_DocumentoDP->setMontoImpuestos( $f_TotalIGV );
        $o_VTA_DocumentoDP->setMontoImpuestoVentas( $f_TotalIGV );
        $o_VTA_DocumentoDP->setMontoDescuentos( $f_TotalDscto );
        $o_VTA_DocumentoDP->setMontoTotal( $f_TotalNoExIGV + $f_TotalSiExIGV + $f_TotalIGV );*/
        
        $o_VTA_DocumentoDP->setMontoSubTotal( $f_SubTotalVenta );
        $o_VTA_DocumentoDP->setMontoSubTotalMN( $f_SubTotalVentaMN );
        $o_VTA_DocumentoDP->setMontoAfecto( $f_TotalConIGV );
        $o_VTA_DocumentoDP->setMontoAfectoMN( $f_TotalConIGVMN );
        $o_VTA_DocumentoDP->setMontoNoAfecto( $f_TotalSinIGV );
        $o_VTA_DocumentoDP->setMontoNoAfectoMN( $f_TotalSinIGVMN );
        $o_VTA_DocumentoDP->setMontoImpuestos( $f_SubTotalImpuesto );
        $o_VTA_DocumentoDP->setMontoImpuestoMN( $f_SubTotalImpuestoMN );
        $o_VTA_DocumentoDP->setMontoTotal( $f_TotalConIGV + $f_TotalSinIGV + $f_SubTotalImpuesto );
        $o_VTA_DocumentoDP->setMontoTotalMN( $f_TotalConIGVMN + $f_TotalSinIGVMN + $f_SubTotalImpuestoMN );

        //$o_VTA_DocumentoDP->setIdAlmacen( $IdAlmacen );
        $o_VTA_DocumentoDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
        $o_VTA_DocumentoDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );

        $o_VTA_DocumentoDP->update();

        ////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //ahora se actualiza Tablas relacionadas con el los Comprobantes
        $o_SRV_UbicacionClienteDetDP = new SRV_UbicacionClienteDetDP();
        $o_SRV_UbicacionClienteDetDP->setNumeroDocumento( $NumeroDocumento );
        $o_SRV_UbicacionClienteDetDP->setMontoTotal( $f_TotalConIGV + $f_TotalSinIGV + $f_SubTotalImpuesto );
        $o_SRV_UbicacionClienteDetDP->actualizarCamposPorRemoto();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////

        return true;
    }

    public function actualizarIdCierre()
    {
        $s_Where = "";
        if( $this->getVendedor() )
        {
            $s_Where = " AND Vendedor='".$this->getVendedor()."' ";
        }
        if( $this->getIdTurno() )
        {
            $s_Where = " AND IdTurno='".$this->getIdTurno()."' ";
        }
        $s_Sql = "update VTA_Documento set IdCierre='".$this->getIdCierre()."' where 1=1 and IdCaja='".$this->getIdCaja()."' and Estado in ( 'CE','AN') and IdCierre is null $s_Where ;";
        Conexion::getConexion()->createStatement()->executeQuery( $s_Sql );
    }
    
    public static function actualizarFormaPago( $IdTipoDocumento, $NumeroDocumento, $s_FormaPago )
    {
        if( myUser::getUser()->getIdBusiness() )
        {
            $o_VTA_DocumentoDP = new VTA_DocumentoDP();
            $o_VTA_DocumentoDP->setIdTipoDocumento( $IdTipoDocumento );
            $o_VTA_DocumentoDP->setIdCompania( myUser::getUser()->getIdBusiness() );
            $o_VTA_DocumentoDP->setNumeroDocumento( $NumeroDocumento );
            $o_VTA_DocumentoDP->setIdFormaPago( $s_FormaPago );
            $o_VTA_DocumentoDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_VTA_DocumentoDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_VTA_DocumentoDP->update();
        }
    }
}
?>