<?php
/* Metodos de acceso a los campos de la tabla TR_RutaDetalle redefinidos por el usuario */
class TR_RutaDetalleBN extends BaseTR_RutaDetalleBN
{
    //ESTADO
    const ESTADO_ANULADO     = "A"; //ANULADO
    const ESTADO_PENDIENTE   = "P"; //CUANDO RECIEN SE REGISTRA
    //const ESTADO_CERRADO     = "C"; //CUANDO SE CIERRA LA RUTA PARA QUE YA NO SE REGISTRE MAS DETALLES
    const ESTADO_CARGANDO    = "G"; //CARGANDO ITEMS AL CAMION, O CONFIRMAR LA CARGA AL CAMION
    const ESTADO_LISTO       = "L"; //CUANDO ESTA EN EL CARRO CARGADO, CONSOLIDADO
    const ESTADO_EN_RUTA     = "F"; //CUANDO EL VEHICULO SALE CON LOS PAQUETES
    const ESTADO_ENTREGADO   = "E"; //CUANDO SE ENTREGO SATISFACTORIAMENTE LOS PRODUCTOS
    const ESTADO_REPROGRAMAR = "R"; //CUANDO SE DEVUELVE EL PRODUCTO Y SE TIENE QUE ASIGNAR A OTRO TURNO Y CHOFER
    
    public static function getArrayEstados( $s_Estado = null )
    {
        $a_sEstado = array
        (
            TR_RutaDetalleBN::ESTADO_ANULADO     => "ANULADO",
            TR_RutaDetalleBN::ESTADO_PENDIENTE   => "PENDIENTE",
            //TR_RutaDetalleBN::ESTADO_CERRADO     => "CERRADO",
            TR_RutaDetalleBN::ESTADO_CARGANDO    => "CARGANDO",
            TR_RutaDetalleBN::ESTADO_LISTO       => "LISTO",
            TR_RutaDetalleBN::ESTADO_EN_RUTA     => "EN TRANSITO",
            TR_RutaDetalleBN::ESTADO_ENTREGADO   => "ENTREGADO",
            TR_RutaDetalleBN::ESTADO_REPROGRAMAR => "REPROGRAMAR",
        );
        if( !is_null( $s_Estado ) )
        {
            return $a_sEstado[$s_Estado];
        }
        return $a_sEstado;
    }
    
    public function getEstadoDesc()
    {
        return TR_RutaDetalleBN::getArrayEstados( $this->getRutaDetEstado() );
    }
    
    public function getIdConcat()
    {
        return $this->getIdRuta()."_".$this->getIdRutaLinea();
    }
    
    public function getObjectVTADocumento()
    {
        $o_VTA_DocumentoBN = VTA_DocumentoFN::selectByDocumentNumber( $this->getDocumentRefId() );
        return $o_VTA_DocumentoBN;
    }
    
    public function getVTADocumentoEstado()
    {
        return $this->getObjectVTADocumento()->getEstado();
    }
    
    public function getClienteDesc()
    {
        $o_VTA_DocumentoBN = VTA_DocumentoFN::selectByDocumentNumber( $this->getDocumentRefId() );
        return $o_VTA_DocumentoBN->getClienteNombre();
    }
    
    public function getMontoTotalDocumento()
    {
        $o_VTA_DocumentoBN = VTA_DocumentoFN::selectByDocumentNumber( $this->getDocumentRefId() );
        return $o_VTA_DocumentoBN->getMontoTotal();
    }
    
    public function getClienteContactoDesc()
    {
        $o_VTA_DocumentoBN = VTA_DocumentoFN::selectByDocumentNumber( $this->getDocumentRefId() );
        return $o_VTA_DocumentoBN->getObjectCliente()->getContacto();
    }
    
    public function getClienteTelefonoFijo()
    {
        $o_VTA_DocumentoBN = VTA_DocumentoFN::selectByDocumentNumber( $this->getDocumentRefId() );
        return $o_VTA_DocumentoBN->getObjectCliente()->getTelefono();
    }
    
    public function getClienteTelefonoCelular()
    {
        $o_VTA_DocumentoBN = VTA_DocumentoFN::selectByDocumentNumber( $this->getDocumentRefId() );
        return $o_VTA_DocumentoBN->getObjectCliente()->getCelular();
    }
    
    public function getObjectRuta()
    {
        $o_TR_RutaFN = new TR_RutaFN();
        $o_TR_RutaBN = $o_TR_RutaFN->selectByPK( $this->getIdRuta() );
        return $o_TR_RutaBN;
    }
    
    public function getSerieNumeroGuia()
    {
        if( $this->getSerieDocumentoRef() )
        {
            return $this->getSerieDocumentoRef()."-".$this->getNumeroDocumentoRef();
        }
        return "";
    }
    
    public function getRutaDocumento()
    {
        return $this->getObjectRuta()->getRutaDocumento();
    }
    
    public function getRutaFechaProgramada()
    {
        return $this->getObjectRuta()->getRutaFechaProgramada();
    }
    
    public function getRutaFechaProgramadaTurno()
    {
        return substr( $this->getObjectRuta()->getRutaFechaProgramada(), 0 , 10 )." ".$this->getObjectRuta()->getTurnoDesc();
    }
    
    public function getTurnoDesc()
    {
        return $this->getObjectRuta()->getTurnoDesc();
    }
    
    public function getVehiculoDesc()
    {
        return $this->getObjectRuta()->getVehiculoDesc();
    }
    
    public function getChoferDesc()
    {
        return $this->getObjectRuta()->getChoferDesc();
    }
}
?>