<?php
/* Metodos de acceso a los campos de la tabla SR_GuiaRemisionH redefinidos por el usuario */
class SR_GuiaRemisionHBN extends BaseSR_GuiaRemisionHBN
{
    const ESTADO_ANULADO    = "A";
    const ESTADO_COMPLETADO = "C";
    
    const ESTADO_SUNAT_ERROR     = "X";
    const ESTADO_SUNAT_PENDIENTE = "P";
    const ESTADO_SUNAT_ENVIADO   = "E";
    
    const ESTADO_DEVOLUCION_PENDIENTE  = "P";
    const ESTADO_DEVOLUCION_COMPLETADO = "C";
    
    public static function getArrayEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
                SR_GuiaRemisionHBN::ESTADO_ANULADO    => "ANULADO",
                SR_GuiaRemisionHBN::ESTADO_COMPLETADO => "COMPLETADO"
        );
        if( !is_null( $sEstado ) )
        {
            return $a_sEstado[$sEstado];
        }
        return $a_sEstado;
    }
    
    public function getEstadoDesc()
    {
        return SR_GuiaRemisionHBN::getArrayEstados( $this->getEstado() );
    }
    
    public static function getArrayDevolucionEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
                SR_GuiaRemisionHBN::ESTADO_DEVOLUCION_PENDIENTE  => "PENDIENTE",
                SR_GuiaRemisionHBN::ESTADO_DEVOLUCION_COMPLETADO => "COMPLETADO"
        );
        if( !is_null( $sEstado ) )
        {
            return $a_sEstado[$sEstado];
        }
        return $a_sEstado;
    }
    
    public function getDevolucionEstadoDesc()
    {
        return SR_GuiaRemisionHBN::getArrayDevolucionEstados( $this->getEstadoDevolucion() );
    }
    
    public static function getArraySunatEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
            self::ESTADO_SUNAT_PENDIENTE => "PENDIENTE",
            self::ESTADO_SUNAT_ENVIADO   => "ENVIADO",
            self::ESTADO_SUNAT_ERROR     => "ERROR"
        );
        if( !is_null( $sEstado ) )
        {
            if( isset( $a_sEstado[$sEstado] ) )
            {
                return $a_sEstado[$sEstado];
            }
        }
        return $a_sEstado;
    }

    public function getSunatEstadoDesc()
    {
        return SR_GuiaRemisionHBN::getArraySunatEstados( $this->getEstadoSunat() );
    }
    
    public function getObjectProyecto()
    {
        $o_VTA_PrsProyectosFN = new VTA_PrsProyectosFN();
        $o_VTA_PrsProyectosBN = $o_VTA_PrsProyectosFN->selectByPK( $this->getIdProyecto() );
        return $o_VTA_PrsProyectosBN;
    }
    
    public function getProyectoNombre()
    {
        return $this->getObjectProyecto()->getNombreProyecto();
    }
    
    public function getGuiaSerieNumeroConcat()
    {
        return $this->getGuiaSerie()."-".$this->getGuiaNumero();
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /// //"01" = "VENTA" | "14" = "VENTA SUJETA A CONFIRMACION DEL COMPRADOR" | "02" = "COMPRA" | "04" = "TRASLADO ENTRE ESTABLECIMIENTOS DE LA MISMA EMPRESA" | "18" = "TRASLADO EMISOR ITINERANTE CP" | "08" = "IMPORTACION" |"09" = "EXPORTACION" | "19" = "TRASLADO A ZONA PRIMARIA" | "13" = "OTROS"
    static $a_MotivoTraslado = array
    (
        1 => array( "Descripcion" => "VENTA",                                               "CodigoSunat" => "-", "CodigoSunatPr" => "01", "Estado" => "A" ),
        2 => array( "Descripcion" => "COMPRA",                                              "CodigoSunat" => "-", "CodigoSunatPr" => "02", "Estado" => "I" ),
        3 => array( "Descripcion" => "TRASLADO ENTRE ESTABLECIMIENTOS DE LA MISMA EMPRESA", "CodigoSunat" => "-", "CodigoSunatPr" => "04", "Estado" => "A" ),
        4 => array( "Descripcion" => "IMPORTACION",                                         "CodigoSunat" => "-", "CodigoSunatPr" => "08", "Estado" => "I" ),
        5 => array( "Descripcion" => "EXPORTACION",                                         "CodigoSunat" => "-", "CodigoSunatPr" => "09", "Estado" => "I" ),
        6 => array( "Descripcion" => "OTROS",                                               "CodigoSunat" => "-", "CodigoSunatPr" => "13", "Estado" => "A" ),
        7 => array( "Descripcion" => "VENTA SUJETA A CONFIRMACION DEL COMPRADOR",           "CodigoSunat" => "-", "CodigoSunatPr" => "14", "Estado" => "I" ),
        8 => array( "Descripcion" => "TRASLADO EMISOR ITINERANTE CP",                       "CodigoSunat" => "-", "CodigoSunatPr" => "18", "Estado" => "I" ),
        9 => array( "Descripcion" => "TRASLADO A ZONA PRIMARIA",                            "CodigoSunat" => "-", "CodigoSunatPr" => "19", "Estado" => "I" )
    );

    public static function getArrayMotivoTraslado( $s_Param = null )
    {
        if( !is_null( $s_Param ) )
        {
            if( isset( SR_GuiaRemisionHBN::$a_MotivoTraslado[$s_Param] ) )
            {
                return SR_GuiaRemisionHBN::$a_MotivoTraslado[$s_Param];
            }
            else
            {
                return "----";
            }
        }
        return SR_GuiaRemisionHBN::$a_MotivoTraslado;
    }
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /// //01 = TRANSPORTE PÚBLICO  |  02 = TRANSPORTE PRIVADO
    static $a_TipoDeTransporte = array
    (
        1 => array( "Descripcion" => "TRANSPORTE PÚBLICO", "CodigoSunat" => "-", "CodigoSunatPr" => "01", "Estado" => "A" ),
        2 => array( "Descripcion" => "TRANSPORTE PRIVADO", "CodigoSunat" => "-", "CodigoSunatPr" => "02", "Estado" => "A" ),
    );

    public static function getArrayTipoDeTransporte( $s_Param = null )
    {
        if( !is_null( $s_Param ) )
        {
            if( isset( SR_GuiaRemisionHBN::$a_TipoDeTransporte[$s_Param] ) )
            {
                return SR_GuiaRemisionHBN::$a_TipoDeTransporte[$s_Param];
            }
            else
            {
                return "----";
            }
        }
        return SR_GuiaRemisionHBN::$a_TipoDeTransporte;
    }
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
}
