<?php
/* Metodos de acceso a los campos de la tabla SR_DevolucionTransaccion redefinidos por el usuario */
class SR_DevolucionTransaccionBN extends BaseSR_DevolucionTransaccionBN
{
    const TIPO_NORMAL    = "NORMAL";
    const TIPO_REVERSION = "REVERSION";
    
    public function getObjectEstadoDevolucion()
    {
        $o_SR_EstadoDevolucionFN = new SR_EstadoDevolucionFN();
        $o_SR_EstadoDevolucionBN = $o_SR_EstadoDevolucionFN->selectByPK( $this->getEstadoDevolucionId() );
        return $o_SR_EstadoDevolucionBN;
    }
    
    public function getEstadoDevolucionDesc()
    {
        return $this->getObjectEstadoDevolucion()->getDescripcion();
    }
    
    public function getObjectAlmacen( $s_IdAlmacen )
    {
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $s_IdAlmacen );
        return $o_ALM_AlmacenMastBN;
    }
    
    public function getAlmacenOrigenDesc()
    {
        return $this->getObjectAlmacen( $this->getIdAlmacenOrigen() )->getDescripcionLocal();
    }
    
    public function getAlmacenDestinoDesc()
    {
        return $this->getObjectAlmacen( $this->getIdAlmacenDestino() )->getDescripcionLocal();
    }
    
    public function getSerieNumeroReferencia()
    {
        return $this->getTipoDocumentoFiscal().$this->getSerieDocumentoFiscal()."-".$this->getNumeroDocumentoFiscal();
    }
    
    public function getArrayDetallesTransacciones()
    {
        $o_ALM_TransaccionDetalleFN = new ALM_TransaccionDetalleFN();
        $o_ALM_TransaccionDetalleFN->setIdCompania( $this->getIdCompania() );
        $o_ALM_TransaccionDetalleFN->setIdTipoDocumento( $this->getIdTipoDocumento() );
        $o_ALM_TransaccionDetalleFN->setIdNumeroDocumento( $this->getIdNumeroDocumento() );
        $a_ALM_TransaccionDetalle = $o_ALM_TransaccionDetalleFN->select();
        return $a_ALM_TransaccionDetalle;
    }

    public function getArrayDevolucionDetallePorEstado()
    {
        $o_SR_DevolucionDetalleFN = new SR_DevolucionDetalleFN();
        $o_SR_DevolucionDetalleFN->setDevolucionCabId( $this->getDevolucionCabId() );
        $o_SR_DevolucionDetalleFN->setEstadoDevolucionId( $this->getEstadoDevolucionId() );
        $a_SR_DevolucionDetalle = $o_SR_DevolucionDetalleFN->select();
        return $a_SR_DevolucionDetalle;
    }
}
?>