<?php
/* Metodos de acceso a los campos de la tabla PRO_CierreMensual redefinidos por el usuario */
class PRO_CierreMensualBN extends BasePRO_CierreMensualBN
{
    const ESTADO_ABIERTO = "A";
    const ESTADO_CERRADO = "C";
    
    public static function getArrayEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
            PRO_CierreMensualBN::ESTADO_ABIERTO => "ABIERTO",
            PRO_CierreMensualBN::ESTADO_CERRADO => "CERRADO"
        );
        if( !is_null( $sEstado ) )
        {
            return $a_sEstado[$sEstado];
        }
        return $a_sEstado;
    }
    
    public function getEstadoDesc()
    {
        return PRO_CierreMensualBN::getArrayEstados( $this->getEstado() );
    }
    
    public function getIdCierre()
    {
        return $this->getIdCompania()."_".$this->getIdPeriodo();
    }
    
    public function getPeriodoDesc()
    {
        return substr( $this->getIdPeriodo(), 0, 4 )."-".substr( $this->getIdPeriodo(), -2 );
    }
    
    public function getAbrirPeriodoFlag()
    {
        $i_AnioPeriodo = intval( substr( $this->getIdPeriodo(), 0, 4 ) );
        $i_PeriodoSig = ( intval( substr( $this->getIdPeriodo(), -2 ) ) + 1 );
        if( $i_PeriodoSig == 13 )
        {
            $i_PeriodoSig = 1;
            $i_AnioPeriodo++;
        }
        $s_PeriodoSig = $i_AnioPeriodo.str_pad( $i_PeriodoSig, 2, "0", STR_PAD_LEFT );
        //pr( $s_PeriodoSig );
        $o_PRO_CierreMensualFN = new PRO_CierreMensualFN();
        $o_PRO_CierreMensualBN = $o_PRO_CierreMensualFN->selectByPK( $this->getIdCompania(), $s_PeriodoSig );
        if( $o_PRO_CierreMensualBN )
        {
            if( $o_PRO_CierreMensualBN->getEstado() == PRO_CierreMensualBN::ESTADO_ABIERTO  )
            {
                return true;
            }
        }
        return false;
    }
}
?>