<?php
/* Metodos de acceso a los campos de la tabla MST_StockReposicionCabecera redefinidos por el usuario */
class MST_StockReposicionCabeceraBN extends BaseMST_StockReposicionCabeceraBN
{
    public function getIdConcat()
    {
        if( $this->getIdCompania() )
        {
            return $this->getIdCompania()."_".$this->getIdSucursal()."_".$this->getIdAlmacen()."_".$this->getIdPersona();
        }
        return null;
    }
    
    public function getCompaniaDesc()
    {
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $this->getIdCompania() );
        return $o_GSS_CompaniaBN->getDescripcionCorta();
    }
    
    public function getSucursalDesc()
    {
        $o_GSS_SucursalFN = new GSS_SucursalFN();
        $o_GSS_SucursalBN = $o_GSS_SucursalFN->selectByPK( $this->getIdSucursal() );
        if( $o_GSS_SucursalBN )
        {
            return $o_GSS_SucursalBN->getDescripcion();
        }
        return "";
    }
    
    public function getAlmacenDesc()
    {
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $this->getIdAlmacen() );
        return $o_ALM_AlmacenMastBN->getDescripcionLocal();
    }
    
    public function getProveedorDes()
    {
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $this->getIdPersona() );
        if( !$o_MST_PersonaMastBN )
        {
            $o_MST_PersonaMastBN = new MST_PersonaMastBN();
        }
        return $o_MST_PersonaMastBN->getNombreCompleto();
    }
}
?>