<?php
/* Metodos de acceso a los campos de la tabla MST_ReferenciaProducto redefinidos por el usuario */
class MST_ReferenciaProductoBN extends BaseMST_ReferenciaProductoBN
{
    //ESTADO
    const ESTADO_PENDIENTE = "P";
    const ESTADO_COMPLETO  = "C";
    const ESTADO_ANULADO   = "A";

    public static function getArrayEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
            MST_ReferenciaProductoBN::ESTADO_PENDIENTE => "PENDIENTE",
            MST_ReferenciaProductoBN::ESTADO_COMPLETO  => "COMPLETADO",
            MST_ReferenciaProductoBN::ESTADO_ANULADO  => "ANULADO",
        );
        if( !is_null( $sEstado ) )
        {
            return $a_sEstado[$sEstado];
        }
        return $a_sEstado;
    }

    public function getEstadoDesc()
    {
        return MST_ReferenciaProductoBN::getArrayEstados( $this->getEstado() );
    }

    protected $IdCatTalla;
    public function setIdCatTalla( $v )
    {
        $this->IdCatTalla = $v;
    }

    public function getIdCatTalla()
    {
        return $this->IdCatTalla;
    }

    public function getProveedorDesc()
    {
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $this->getIdProveedor() );
        if( $o_MST_PersonaMastBN )
        {
            return $o_MST_PersonaMastBN->getNombreCompleto();
        }
        return "";
    }

    public function getCodigo()
    {
        return $this->getIdReferencia();
    }
}
?>