<?php
/* M�todos de acceso a los campos de la tabla MST_PersonaMast redefinidos por el usuario */
class MST_PersonaMastBN extends BaseMST_PersonaMastBN
{
    const ESTADO_ACTIVO   = "A";
    const ESTADO_INACTIVO = "I";
    
    public static function getArrayEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
            MST_PersonaMastBN::ESTADO_ACTIVO   => "ACTIVO",
            MST_PersonaMastBN::ESTADO_INACTIVO => "INACTIVO"
        );
        if( !is_null( $sEstado ) )
        {
            return $a_sEstado[$sEstado];
        }
        return $a_sEstado;
    }
    
    public function getEstadoDesc()
    {
        return MST_PersonaMastBN::getArrayEstados( $this->getEstado() );
    }

    //TASA PARA RETENCIONES
    static $a_IdRetenciones = array
    (
        1 => array( "CodigoSunat" => "01", "CodigoSunatPr" => 1, "Descripcion" => "TASA 3%", "Tasa" => 3 )
    );

    public static function getArrayRetenciones( $i_Id = null )
    {
        if( !is_null( $i_Id ) )
        {
            if( isset( MST_PersonaMastBN::$a_IdRetenciones[$i_Id] ) )
            {
                return MST_PersonaMastBN::$a_IdRetenciones[$i_Id];
            }
            else
            {
                return array();
            }
        }
        return MST_PersonaMastBN::$a_IdRetenciones;
    }

    public function getRetencionDesc()
    {
        $a_Valores = MST_PersonaMastBN::getArrayRetenciones( $this->getIdRetencion() );
        return $a_Valores['Descripcion'];
    }

    //[TIPO_DOCUMENTO_DESCRIPCION] [TABLA_2_CODIGO_SUNAT]
    static $a_TipoDocumento = array
    ( 
        "DNI" => "1", "RUC" => "6", "PASAPORTE" => "7", "CARNET_EXTRANJERIA" => "4" , "OTROS_DOCUMENTOS" => "0", "CEDULA_DIPLOMATICA" => "A",
    );

    public static function getArrayTipoDocumento( $s_Estado = null )
    {
        if( !is_null( $s_Estado ) )
        {
            if( isset( MST_PersonaMastBN::$a_TipoDocumento[$s_Estado] ) )
            {
                return MST_PersonaMastBN::$a_TipoDocumento[$s_Estado];
            }
            else
            {
                return "----";
            }
        }
        return MST_PersonaMastBN::$a_TipoDocumento;
    }
    
    public function getTipoDocumentoSunat()
    {
        return MST_PersonaMastBN::getArrayTipoDocumento( $this->getTipoDocumento() );
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    //TABLA ANEXA Nº 7: NACIONALIDAD
    const TIPO_PERUANO    = 1;
    const TIPO_EXTRANJERO = 2;

    static $a_Nacionalidad = array
    (
        MST_PersonaMastBN::TIPO_PERUANO => "PERUANO", MST_PersonaMastBN::TIPO_EXTRANJERO => "EXTRANJERO"
    );

    public static function getArrayNacionalidad( $s_Nacionalidad = null )
    {
        if( !is_null( $s_Nacionalidad ) )
        {
            if( isset( MST_PersonaMastBN::$a_Nacionalidad[$s_Nacionalidad] ) )
            {
                return MST_PersonaMastBN::$a_Nacionalidad[$s_Nacionalidad];
            }
            else
            {
                return "----";
            }
        }
        return MST_PersonaMastBN::$a_Nacionalidad;
    }

    public function getNacionalidadDesc()
    {
        return MST_PersonaMastBN::getArrayNacionalidad( $this->getNacionalidad() );
    }
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    const PERSONA_NATURAL  = "N";
    const PERSONA_JURIDICA = "J";

    static $a_TipoPersona = array
    ( 
        MST_PersonaMastBN::PERSONA_NATURAL => "NATURAL", MST_PersonaMastBN::PERSONA_JURIDICA => "JURIDICA"
    );

    public static function getArrayTipoPersona( $s_TipoPersona = null )
    {
        if( !is_null( $s_TipoPersona ) )
        {
            if( isset( MST_PersonaMastBN::$a_TipoPersona[$s_TipoPersona] ) )
            {
                return MST_PersonaMastBN::$a_TipoPersona[$s_TipoPersona];
            }
            else
            {
                return "----";
            }
        }
        return MST_PersonaMastBN::$a_TipoPersona;
    }

    public function getTipoPersonaDesc()
    {
        return MST_PersonaMastBN::getArrayTipoPersona( $this->getTipoPersona() );
    }
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    public function getUsuarioLogin()
    {
        return MST_PersonaMastFN::recuperarUsuarioLogin( $this->getIdPersona() );
    }
    
    public function getEsPersonaNatural()
    {
        if( $this->getTipoPersona() == "N" )
        {
            return true;
        }
        return false;
    }
    
    public function getNombrePersonaNatural()
    {
        if( $this->getEsPersonaNatural() )
        {
            return $this->getNombres();
        }
        return "";
    }
    
    public function getApellidosPersonaNatural()
    {
        if( $this->getEsPersonaNatural() )
        {
            return $this->getApellidoPaterno()." ".$this->getApellidoMaterno();
        }
        return "";
    }
    
    public function getNombreConcatenado()
    {
        return $this->getNombres()." ".$this->getApellidoPaterno()." ".$this->getApellidoMaterno();
    }
    
    public function getNombreCompletoLLeno()
    {
    	if( !$this->getNombres() )
    	{
    		return $this->getNombreCompleto();
    	}
    	else 
    	{
    		return $this->getNombreConcatenado();
    	}
    }
    
    public function getDepartamentoDesc()
    {
        $o_MST_UbigeoFN = new MST_UbigeoFN();
        $o_MST_UbigeoBN = $o_MST_UbigeoFN->selectByPK( $this->getDepartamento() );
        if( $o_MST_UbigeoBN )
        {
            return $o_MST_UbigeoBN->getDescripcion();
        }
        return "";
    }
    
    public function getProvinciaDesc()
    {
        $o_MST_UbigeoFN = new MST_UbigeoFN();
        $o_MST_UbigeoBN = $o_MST_UbigeoFN->selectByPK( $this->getProvincia() );
        if( $o_MST_UbigeoBN )
        {
            return $o_MST_UbigeoBN->getDescripcion();
        }
        return "";
    }
    
    public function getDistritoDesc()
    {
        $o_MST_UbigeoFN = new MST_UbigeoFN();
        $o_MST_UbigeoBN = $o_MST_UbigeoFN->selectByPK( $this->getDistrito() );
        if( $o_MST_UbigeoBN )
        {
            return $o_MST_UbigeoBN->getDescripcion();
        }
        return "";
    }

    public function getCanalCliente()
    {
        $o_MST_ClienteMastFN = new MST_ClienteMastFN();
        $o_MST_ClienteMastBN = $o_MST_ClienteMastFN->selectByPK( $this->getIdPersona() );
        if( $o_MST_ClienteMastBN )
        {
            return $o_MST_ClienteMastBN->getCodCanal();
        }
        return "";
    }
    
    public function getNivelPrecioCliente()
    {
        $o_MST_ClienteMastFN = new MST_ClienteMastFN();
        $o_MST_ClienteMastBN = $o_MST_ClienteMastFN->selectByPK( $this->getIdPersona() );
        if( $o_MST_ClienteMastBN )
        {
            return $o_MST_ClienteMastBN->getTipoVenta();
        }
        return "";
    }

    public function getClienteVendedorId()
    {
        $o_MST_ClienteMastFN = new MST_ClienteMastFN();
        $o_MST_ClienteMastBN = $o_MST_ClienteMastFN->selectByPK( $this->getIdPersona() );
        if( $o_MST_ClienteMastBN )
        {
            return $o_MST_ClienteMastBN->getVendedor();
        }
        return "";
    }

    public function getObjectCliente()
    {
        $o_MST_ClienteMastFN = new MST_ClienteMastFN();
        $o_MST_ClienteMastBN = $o_MST_ClienteMastFN->selectByPK( $this->getIdPersona() );
        if( !$o_MST_ClienteMastBN )
        {
            $o_MST_ClienteMastBN = new MST_ClienteMastBN();
        }
        return $o_MST_ClienteMastBN;
    }
    
    public function getVendedorAsignado()
    {
        return MST_ClienteMastBN::buscar_vendedor_asignado( $this->getIdPersona() );
    }

    public function getCreditoHold()
    {
        $o_MST_ClienteMastFN = new MST_ClienteMastFN();
        $o_MST_ClienteMastBN = $o_MST_ClienteMastFN->selectByPK( $this->getIdPersona() );
        if( $o_MST_ClienteMastBN )
        {
            return $o_MST_ClienteMastBN->getCreditoHold();
        }
        return "";
    }

    public function getObjectVendedor()
    {
        $o_VTA_VendedorFN = new VTA_VendedorFN();
        $o_VTA_VendedorBN = $o_VTA_VendedorFN->selectByPK( $this->getIdPersona() );
        if( !$o_VTA_VendedorBN )
        {
            $o_VTA_VendedorBN = new VTA_VendedorBN();
        }
        return $o_VTA_VendedorBN;
    }

    public function getObjectPersonaEmpleado()
    {
        $o_MST_PersonaEmpleadoFN = new MST_PersonaEmpleadoFN();
        $o_MST_PersonaEmpleadoBN = $o_MST_PersonaEmpleadoFN->selectByPK( $this->getIdPersona() );
        if( $o_MST_PersonaEmpleadoBN )
        {
            return $o_MST_PersonaEmpleadoBN;
        }
        return new MST_PersonaEmpleadoBN();
    }

    public function esNacionalidadLocal()
    {
        if( $this->getNacionalidad() == MST_PersonaMastBN::TIPO_PERUANO )
        {
            return true;
        }
        return false;
    }
}
?>