<?php
/* Metodos de acceso a los campos de la tabla MST_ListaPrecioCabecera redefinidos por el usuario */
class MST_ListaPrecioCabeceraBN extends BaseMST_ListaPrecioCabeceraBN
{
    public function getIdConcat()
    {
        if( $this->getIdCompania() )
        {
            return $this->getIdCompania()."_".$this->getIdSucursal();
        }
        return null;
    }
    
    public function getCompaniaDesc()
    {
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $this->getIdCompania() );
        return $o_GSS_CompaniaBN->getDescripcionCorta();
    }
    
    public function getSucursalDesc()
    {
        $o_GSS_SucursalFN = new GSS_SucursalFN();
        $o_GSS_SucursalBN = $o_GSS_SucursalFN->selectByPK( $this->getIdSucursal() );
        if( $o_GSS_SucursalBN )
        {
            return $o_GSS_SucursalBN->getDescripcion();
        }
        return "";
    }
    
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    //TABLA DE TIPO DE ORDEN - COMERCIAL
    static $a_DataStatic3 = array
    (
            "1" => "VENTA"
    );
    
    public static function getArrayTipoLista( $s_Value = null )
    {
        if( !is_null( $s_Value ) )
        {
            if( isset( MST_ListaPrecioCabeceraBN::$a_DataStatic3[$s_Value] ) )
            {
                return MST_ListaPrecioCabeceraBN::$a_DataStatic3[$s_Value];
            }
            else
            {
                return "----";
            }
        }
        return MST_ListaPrecioCabeceraBN::$a_DataStatic3;
    }
    
    public function getTipoListaDesc()
    {
        $s_Valor = !is_null( $this->getIdTipoLista() ) ? MST_ListaPrecioCabeceraBN::getArrayTipoLista( $this->getIdTipoLista() ) : "----";
        return $s_Valor;
    }
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
}
?>