<?php
/* Metodos de acceso a los campos de la tabla MST_Color redefinidos por el usuario */
class MST_ColorBN extends BaseMST_ColorBN
{
    //ESTADO
    const ESTADO_ACTIVO   = "A";
    const ESTADO_INACTIVO = "I";

    public static function getArrayEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
            MST_ColorBN::ESTADO_ACTIVO   => "ACTIVO",
            MST_ColorBN::ESTADO_INACTIVO => "INACTIVO"
        );
        if( !is_null( $sEstado ) )
        {
            return $a_sEstado[$sEstado];
        }
        return $a_sEstado;
    }

    public function getEstadoDesc()
    {
        return MST_ColorBN::getArrayEstados( $this->getEstado() );
    }

    public function getProveedorDesc()
    {
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $this->getIdProveedor() );
        if( $o_MST_PersonaMastBN )
        {
            return $o_MST_PersonaMastBN->getNombreCompleto();
        }
        return "";
    }

    protected $isChecked;

    public function getIsChecked()
    {
        return $this->isChecked;
    }

    public function setIsChecked( $isChecked ): void
    {
        $this->isChecked = $isChecked;
    }
}
?>