<?php
/* M�todos de acceso a los campos de la tabla GSS_Compania redefinidos por el usuario */
class GSS_CompaniaBN extends BaseGSS_CompaniaBN
{
    public function getObjCompaniaUsuario( $IdUsuario )
    {
        $o_SEG_UsuarioCompaniaFN = new SEG_UsuarioCompaniaFN();
        $o_SEG_UsuarioCompaniaFN->setIdCompania( $this->getIdCompania() );
        $o_SEG_UsuarioCompaniaFN->setIdUsuario( $IdUsuario );
        $a_SEG_UsuarioCompania = $o_SEG_UsuarioCompaniaFN->select();
        if( $a_SEG_UsuarioCompania )
        {
            return $a_SEG_UsuarioCompania[0];
        }
        return null;
    }

    public function getLogoFileFinal()
    {
        $s_LogoFile    = $this->getLogoFile();
        $s_LogoFileDir = $this->getLogoFileDir();
        if( !file_exists( $s_LogoFileDir ) )
        {
            $s_LogoFile = Constantes::ROOT_DIR_IMG."no_disponible.png";
        }
        return $s_LogoFile;
    }

    public function getLogoBackFileFinal()
    {
        $s_LogoFile    = $this->getLogoBackFileWeb();
        $s_LogoFileDir = $this->getLogoBackFileDir();
        if( !file_exists( $s_LogoFileDir ) )
        {
            $s_LogoFile = Constantes::ROOT_DIR_IMG."no_disponible.png";
        }
        return $s_LogoFile;
    }

    public function getLogoFileToPDF()
    {
        $a_Data  = explode( "/", $this->getLogoFile() );
        if( $a_Data )
        {
            $s_NombreArchivo = end( $a_Data );
            $s_DirConcat = "web/images/logo/".$s_NombreArchivo;
            return $s_DirConcat;
        }
        return Constantes::ROOT_DIR_IMG."no_disponible.png";
    }

    public function getLogoBackFileToPDF()
    {
        $a_Data  = explode( "/", $this->getLogoBackFileWeb() );
        if( $a_Data )
        {
            $s_NombreArchivo = end( $a_Data );
            $s_DirConcat = "web/images/logo/".$s_NombreArchivo;
            return $s_DirConcat;
        }
        return Constantes::ROOT_DIR_IMG."no_disponible.png";
    }
}
?>