<?php
/* Metodos de acceso a los campos de la tabla FCO_Cierre redefinidos por el usuario */
class FCO_CierreBN extends BaseFCO_CierreBN
{
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    const ESTADO_ABIERTO = "A"; //abierto
    const ESTADO_CERRADO = "C"; //cerrado

    static $a_Estados = array
    ( 
        FCO_CierreBN::ESTADO_ABIERTO => "ABIERTO", FCO_CierreBN::ESTADO_CERRADO => "CERRADO"
    );

    public static function getArrayEstados( $s_Estado = null )
    {
        if( !is_null( $s_Estado ) )
        {
            if( isset( FCO_CierreBN::$a_Estados[$s_Estado] ) )
            {
                return FCO_CierreBN::$a_Estados[$s_Estado];
            }
            else
            {
                return "----";
            }
        }
        return FCO_CierreBN::$a_Estados;
    }

    public function getEstadoDesc()
    {
        return FCO_CierreBN::getArrayEstados( $this->getEstado() );
    }
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    public function getObjectCaja()
    {
        $o_FCO_CajaFN = new FCO_CajaFN();
        $o_FCO_CajaBN = $o_FCO_CajaFN->selectByPK( $this->getIdCaja() );
        return $o_FCO_CajaBN;
    }

    public function getCajaNombre()
    {
        $o_FCO_CajaBN = $this->getObjectCaja();
        return $o_FCO_CajaBN->getDescripcion();
    }

    public function getObjectSucursal()
    {
        $o_GSS_SucursalFN = new GSS_SucursalFN();
        $o_GSS_SucursalBN = $o_GSS_SucursalFN->selectByPK( $this->getIdSucursal() );
        return $o_GSS_SucursalBN;
    }

    public function getSucursalNombre()
    {
        $o_GSS_SucursalBN = $this->getObjectSucursal();
        return $o_GSS_SucursalBN->getDescripcion();
    }

    public function getObjectTurno()
    {
        $o_MST_TurnoFN = new MST_TurnoFN();
        $o_MST_TurnoBN = $o_MST_TurnoFN->selectByPK( $this->getIdTurno() );
        return $o_MST_TurnoBN;
    }

    public function getTipoTunoDesc()
    {
        $o_MST_TurnoBN = $this->getObjectTurno();
        return $o_MST_TurnoBN->getDescripcion();
    }
}
?>
