<?php
/* Metodos de acceso a los campos de la tabla CP_Aplicacion redefinidos por el usuario */
class CP_AplicacionBN extends BaseCP_AplicacionBN
{
    const ESTADO_PENDINTE = "PE";
    const ESTADO_APLICADO = "AP";
    const ESTADO_ANULADO  = "AN";

    public static function getArrayEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
            FCO_AplicacionBN::ESTADO_PENDINTE => "PENDINTE",
            FCO_AplicacionBN::ESTADO_APLICADO => "APLICADO",
            FCO_AplicacionBN::ESTADO_ANULADO  => "ANULADO"
        );
        if( !is_null( $sEstado ) )
        {
            return $a_sEstado[$sEstado];
        }
        return $a_sEstado;
    }
    public function getEstadoDesc()
    {
        return FCO_AplicacionBN::getArrayEstados( $this->getEstado() );
    }

    const T_APLICACION_PAGO   = "PAGO";
    const T_APLICACION_NOTCRE = "NOTA_CREDITO";

    public static function getArrayTipoAplicacion( $sEstado = null )
    {
        $a_sEstado = array
        (
            FCO_AplicacionBN::T_APLICACION_PAGO   => "PAGO",
            FCO_AplicacionBN::T_APLICACION_NOTCRE => "NOTA_CREDITO"
        );
        if( !is_null( $sEstado ) )
        {
            return $a_sEstado[$sEstado];
        }
        return $a_sEstado;
    }
    public function getTipoAplicacionDesc()
    {
        return FCO_AplicacionBN::getArrayTipoAplicacion( $this->getNombreTipo() );
    }

    protected static $Object = array();
    private static function getObjectSingleton( $i_IdDocRecibo )
    {
        if ( !isset( static::$Object[$i_IdDocRecibo] ) )
        {
            $o_FCO_DocReciboFN = new CP_DocReciboFN();
            static::$Object[$i_IdDocRecibo] = $o_FCO_DocReciboFN->selectByPK( $i_IdDocRecibo );
        }
        return static::$Object[$i_IdDocRecibo];
    }
    public function getObjectDocRecibo()
    {
        $o_VTA_DocumentoBN = CP_AplicacionBN::getObjectSingleton( $this->getIdDocRecibo() );
        return $o_VTA_DocumentoBN;
    }

    public function getObjectMonedaDocRef()
    {
        $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
        $o_GSS_MonedaMastBN = $o_GSS_MonedaMastFN->selectByPK( $this->getIdMonedaRef() );
        return $o_GSS_MonedaMastBN ;
    }

    public function getObjectBanco()
    {
        $o_GSS_BancoFN = new GSS_BancoFN();
        $o_GSS_BancoBN = $o_GSS_BancoFN->selectByPK( $this->getIdBanco() );
        return $o_GSS_BancoBN ;
    }

    public function getBancoDesc()
    {
        $o_GSS_BancoBN = $this->getObjectBanco();
        return $o_GSS_BancoBN->getDescripcionLocal();
    }

    public function getObjectCuentaBancaria()
    {
        $o_MST_CuentaBancariaFN = new MST_CuentaBancariaFN();
        $o_MST_CuentaBancariaBN = $o_MST_CuentaBancariaFN->selectByPK( $this->getIdCuenta() );
        return $o_MST_CuentaBancariaBN;
    }

    public function getObjectTipoPago()
    {
        $o_FCO_TipoPagoFN = new FCO_TipoPagoFN();
        $o_FCO_TipoPagoBN = $o_FCO_TipoPagoFN->selectByPK( $this->getIdTipoPago() );
        return $o_FCO_TipoPagoBN;
    }
    public function getTipoPagoDescripcion()
    {
        $o_FCO_TipoPagoBN = $this->getObjectTipoPago();
        return $o_FCO_TipoPagoBN->getNombre();
    }

    public function getMontoAplicadoSiEsSoles()
    {
        if( $this->getIdMonedaRef() == "LO" )
        {
            return $this->getMontoAplicacionMN();
        }
        return "";
    }

    public function getMontoAplicadoSiEsDolares()
    {
        if( $this->getIdMonedaRef() == "EX" )
        {
            return $this->getMontoAplicacionME();
        }
        return "";
    }

    public function getSerieDocRef()
    {
        return substr( $this->getSerieNumeroDocRef(), 0, 4 );
    }

    public function getNumeroDocRef()
    {
        return substr( $this->getSerieNumeroDocRef(), 6, 10 );
    }
}
?>