<?php
/* M�todos de acceso a los campos de la tabla COM_OrdenCompraDetalle redefinidos por el usuario */
class COM_OrdenCompraDetalleBN extends BaseCOM_OrdenCompraDetalleBN
{
    public function getObjectUnidad()
    {
        $o_MST_UnidadMastFN = new MST_UnidadMastFN();
        $o_MST_UnidadMastBN = $o_MST_UnidadMastFN->selectByPK( $this->getIdUnidad() );
        return $o_MST_UnidadMastBN;
    }
    
    public function getObjectItem()
    {
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $this->getIdItem() );
        if( $o_ALM_ItemMastBN )
        {
            return $o_ALM_ItemMastBN;
        }
        $o_ALM_ItemMastBN = new ALM_ItemMastBN();
        $o_ALM_ItemMastBN->setDescripcionCompleta( "El Item no existe." );
        $o_ALM_ItemMastBN->setNoAfectoImpuestoVentasFlag( "-" );
        return $o_ALM_ItemMastBN; 
    }

    public function getMarcaDesc()
    {
        $o_ALM_MarcaFN = new ALM_MarcaFN();
        $o_ALM_MarcaBN = $o_ALM_MarcaFN->selectByPK( $this->getObjectItem()->getIdMarca() );
        if( $o_ALM_MarcaBN )
        {
            return $o_ALM_MarcaBN->getDescripcionLocal();
        }
        return "";
    }
    
    public function getIdOrdenCompraDetConcat()
    {
        if( $this->getIdCompania() )
        {
            return $this->getIdCompania()."_".$this->getIdOrdenCompra()."_".$this->getIdSecuencia();
        }
        return null;
    }
    
    public function getBuscarStockActual()
    {
        $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
        $o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $this->getIdCompania(), $this->getIdOrdenCompra() );
        //BUSCAR EL STOCK
        $o_ALM_ItemAlmacenStockFN = new ALM_ItemAlmacenStockFN();
        $o_ALM_ItemAlmacenStockBN = $o_ALM_ItemAlmacenStockFN->selectByPK( $this->getIdCompania(), $this->getIdItem(), $o_COM_OrdenCompraCabeceraBN->getIdAlmacenEntrega(), ALM_ItemAlmacenStockBN::CONDICION_POR_DEFECTO, ALM_ItemAlmacenStockBN::LOTE_POR_DEFECTO );
        if( $o_ALM_ItemAlmacenStockBN )
        {    
            return $o_ALM_ItemAlmacenStockBN->getStockActual();
        }
        return "0";
    }
    
    public function getBuscarStockActualKgr()
    {
        $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
        $o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $this->getIdCompania(), $this->getIdOrdenCompra() );
        //BUSCAR EL STOCK
        $o_ALM_ItemAlmacenStockFN = new ALM_ItemAlmacenStockFN();
        $o_ALM_ItemAlmacenStockBN = $o_ALM_ItemAlmacenStockFN->selectByPK( $this->getIdCompania(), $this->getIdItem(), $o_COM_OrdenCompraCabeceraBN->getIdAlmacenEntrega(), ALM_ItemAlmacenStockBN::CONDICION_POR_DEFECTO, ALM_ItemAlmacenStockBN::LOTE_POR_DEFECTO );
        if( $o_ALM_ItemAlmacenStockBN )
        {    
            return $o_ALM_ItemAlmacenStockBN->getStockActualDoble();
        }
        return "0";
    }

    public function getBuscarStockActualUni()
    {
        $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
        $o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $this->getIdCompania(), $this->getIdOrdenCompra() );
        //BUSCAR EL STOCK
        $o_ALM_ItemAlmacenStockFN = new ALM_ItemAlmacenStockFN();
        $o_ALM_ItemAlmacenStockBN = $o_ALM_ItemAlmacenStockFN->selectByPK( $this->getIdCompania(), $this->getIdItem(), $o_COM_OrdenCompraCabeceraBN->getIdAlmacenEntrega(), ALM_ItemAlmacenStockBN::CONDICION_POR_DEFECTO, ALM_ItemAlmacenStockBN::LOTE_POR_DEFECTO );
        if( $o_ALM_ItemAlmacenStockBN )
        {    
            return $o_ALM_ItemAlmacenStockBN->getStockActualDoble();
        }
        return "0";
    }
    
    public function getCantidadSerieEscaneado()
    {
        $o_SR_PreSerieEscaneoFN = new SR_PreSerieEscaneoFN();
        $o_SR_PreSerieEscaneoFN->setReferenciaTipo( COM_OrdenCompraCabeceraBN::REF_TIPO_DOCUMENTO_DEFECTO ); //OC
        $o_SR_PreSerieEscaneoFN->setReferenciaNumero( $this->getIdOrdenCompra() );
        $o_SR_PreSerieEscaneoFN->setProductoId( $this->getIdItem() );
        $i_Count = $o_SR_PreSerieEscaneoFN->selectNumRows();
        if( !$i_Count )
        {
            $o_SR_SerieEscaneoFN = new SR_SerieEscaneoFN();
            $o_SR_SerieEscaneoFN->setReferenciaTipo( COM_OrdenCompraCabeceraBN::REF_TIPO_DOCUMENTO_DEFECTO );
            $o_SR_SerieEscaneoFN->setReferenciaNumero( $this->getIdOrdenCompra() );
            $o_SR_SerieEscaneoFN->setProductoId( $this->getIdItem() );
            $i_Count = $o_SR_SerieEscaneoFN->selectNumRows();
        }
        return $i_Count;
    }
}
?>