<?php
/* M�todos de acceso a los campos de la tabla ALM_TransaccionDetalle redefinidos por el usuario */
class ALM_TransaccionDetalleBN extends BaseALM_TransaccionDetalleBN
{
    const LOTE_POR_DEFECTO      = "000";
    const CONDICION_POR_DEFECTO = "0";
    
    const TIPO_ITEM_TR = "02";
    
    //protected $s_IdAlmacen;
    protected $s_IdTransaccionOperacion;
    protected $TipoCambioRef;
    protected $MonedaCodRef;
    
    public function getObjectUnidad()
    {
        if( $this->getUnidadCodigo() )
        {
            $o_MST_UnidadMastFN = new MST_UnidadMastFN();
            $o_MST_UnidadMastBN = $o_MST_UnidadMastFN->selectByPK( $this->getUnidadCodigo() );
        }
        else 
        {
            $o_MST_UnidadMastBN = new MST_UnidadMastBN();
            $o_MST_UnidadMastBN->setDescripcionCorta( "-" );
        }
        return $o_MST_UnidadMastBN;
    }
    
    public function getObjectItem()
    {
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $this->getIdItem() );
        return $o_ALM_ItemMastBN;
    }

    public function getItemCantidadMedidaAsignada()
    {
        return $this->getObjectItem()->getCantidadUnidad();
    }
    
    public function getObjectAlmacen()
    {
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $this->getIdAlmacen() );
        return $o_ALM_AlmacenMastBN;
    }
    
    public function getIdTransaccionDetalleConcat()
    {
        if( $this->getIdCompania() )
        {
            return $this->getIdCompania()."_".$this->getIdTipoDocumento()."_".$this->getIdNumeroDocumento()."_".$this->getIdSecuencia();
        }
        return null;
    }
    
    /*public function setIdAlmacen( $v )
    {
        $this->s_IdAlmacen = $v;
    }
    
    public function getIdAlmacen()
    {
        return $this->s_IdAlmacen;
    }*/
    
    public function setIdTransaccionOperacion( $v )
    {
        $this->s_IdTransaccionOperacion = $v;
    }
    
    public function getIdTransaccionOperacion()
    {
        return $this->s_IdTransaccionOperacion;
    }
    
    protected $FechaVencimientoLote;
    /**
     * @return the $FechaVencimientoLote
     */
    public function getFechaVencimientoLote()
    {
        return $this->FechaVencimientoLote;
    }

    /**
     * @param field_type $FechaVencimientoLote
     */
    public function setFechaVencimientoLote($FechaVencimientoLote)
    {
        $this->FechaVencimientoLote = $FechaVencimientoLote;
    }
    
    public function getIdAlmacenParent()
    {
        $o_ALM_TransaccionCabeceraFN = new ALM_TransaccionCabeceraFN();
        $o_ALM_TransaccionCabeceraBN = $o_ALM_TransaccionCabeceraFN->selectByPK( $this->getIdCompania(), $this->getIdTipoDocumento(), $this->getIdNumeroDocumento() );
        return $o_ALM_TransaccionCabeceraBN->getIdAlmacen();
    }

    public function getFechaVencimientoLoteFormato()
    {
        $o_ALM_ItemAlmacenStockFN = new ALM_ItemAlmacenStockFN();
        $o_ALM_ItemAlmacenStockBN = $o_ALM_ItemAlmacenStockFN->selectByPK( $this->getIdCompania(), $this->getIdItem(), $this->getIdAlmacenParent(), $this->getIdCondicion(), $this->getLote() );
        if( $o_ALM_ItemAlmacenStockBN )
        {
            return substr( $o_ALM_ItemAlmacenStockBN->getFechaVencimiento(), 0, 10 );
        }
        return "";
    }
    
    /**
     * @return the $TipoCambioRef
     */
    public function getTipoCambioRef()
    {
        return $this->TipoCambioRef;
    }

    /**
     * @param field_type $TipoCambioRef
     */
    public function setTipoCambioRef($TipoCambioRef)
    {
        $this->TipoCambioRef = $TipoCambioRef;
    }

    /**
     * @return the $MonedaCodRef
     */
    public function getMonedaCodRef()
    {
        return $this->MonedaCodRef;
    }

    /**
     * @param field_type $MonedaCodRef
     */
    public function setMonedaCodRef($MonedaCodRef)
    {
        $this->MonedaCodRef = $MonedaCodRef;
    }

    protected $ALM_TransaccionCabecera;
    public function setObjectTransaccionCabecera( $v )
    {
        $this->ALM_TransaccionCabecera = $v;
    }

    /**
     * @return ALM_TransaccionCabeceraBN
     */
    public function getObjectTransaccionCabecera()
    {
        return $this->ALM_TransaccionCabecera;
    }
}
?>