<?php
/* M�todos de acceso a los campos de la tabla ALM_TransaccionCabecera redefinidos por el usuario */
class ALM_TransaccionCabeceraBN extends BaseALM_TransaccionCabeceraBN
{
    //TIPO TRANSACCION
    const TIPO_INGRESO       = "I";
    const TIPO_SALIDA        = "E";
    const TIPO_TRANSFERENCIA = "T";
    
    protected $a_ALM_TransaccionDetalle;
    protected $a_ALM_TransaccionKardex;
    
    protected $b_GenerarKardex = true;
    
    public function setGenerarKardex( $v )
    {
        $this->b_GenerarKardex = $v;
    }
    public function getGenerarKardex()
    {
        return $this->b_GenerarKardex;
    }
    
    public function getIdTransaccionCabeceraConcat()
    {
        if( $this->getIdCompania() )
        {
            return $this->getIdCompania()."_".$this->getIdTipoDocumento()."_".$this->getIdNumeroDocumento();
        }
        return null;
    }
    
    public static function getArrayTipoTransaccion( $s_TipoTrans = null )
    {
        $a_TipoTrans = array
                            (
                                ALM_TransaccionCabeceraBN::TIPO_INGRESO         => "INGRESO",
                                ALM_TransaccionCabeceraBN::TIPO_SALIDA          => "SALIDA",
                                ALM_TransaccionCabeceraBN::TIPO_TRANSFERENCIA   => "TRANSFERENCIA"
                            );
        if( !is_null( $s_TipoTrans ) )
        {
            return $a_TipoTrans[$s_TipoTrans];
        }
        return $a_TipoTrans;
    }
    
    public function setArrayMovientoDetalle( $a_ALM_TransaccionDetalle )
    {
        $this->a_ALM_TransaccionDetalle = $a_ALM_TransaccionDetalle;
    }

    /**
     * @return ALM_TransaccionDetalleBN[]
     */
    public function getArrayMovientoDetalle()
    {
        return $this->a_ALM_TransaccionDetalle;
    }
    
    public function setArrayMovientoKardex( $v )
    {
        $this->a_ALM_TransaccionKardex = $v;
    }

    /**
     * @return ALM_KardexBN[]
     */
    public function getArrayMovientoKardex()
    {
        return $this->a_ALM_TransaccionKardex;
    }
    
    public function getFechaDocumentoPer()
    {
        return substr( $this->getFechaDocumento(), 0 ,10 );
    }
    
    public function getObjectTipoDocumentoFiscal()
    {
        $o_VTA_TipoDocumentoFN = new VTA_TipoDocumentoFN();
        $o_VTA_TipoDocumentoBN = $o_VTA_TipoDocumentoFN->selectByPK( $this->getTipoDocumentoFiscal() );
        return $o_VTA_TipoDocumentoBN;
    }
    
    public function getTipoDocumentoFiscalDesc()
    {
        $o_VTA_TipoDocumentoFN = new VTA_TipoDocumentoFN();
        $o_VTA_TipoDocumentoFN->setIdTipoDocumento( $this->getTipoDocumentoFiscal() );
        $a_VTA_TipoDocumento = $o_VTA_TipoDocumentoFN->select();
        if( $a_VTA_TipoDocumento )
        {
            $o_VTA_TipoDocumentoBN = $a_VTA_TipoDocumento[0];
            return $o_VTA_TipoDocumentoBN->getDescripcionLocal();
        }
        return "";
    }

    public function getDocumentoRefFiscal()
    {
        if( $this->getTipoDocumentoFiscal() )
        {
            return $this->getSerieDocumentoFiscal()."-".$this->getNumeroDocumentoFiscal();
        }
        return "";
    }
    
    public function getArrayFacturaProveedor()
    {
        $o_ALM_OrdenGuiaFacturaFN = new ALM_OrdenGuiaFacturaFN();
        $o_ALM_OrdenGuiaFacturaFN->setIdCompania( $this->getIdCompania() );
        $o_ALM_OrdenGuiaFacturaFN->setIdOrdenCompra( $this->getReferenciaNumeroDocumento() );
        //$o_ALM_OrdenGuiaFacturaFN->setSerieGuia( $this->getSerieDocumentoFiscal() );
        //$o_ALM_OrdenGuiaFacturaFN->setNumeroGuia( $this->getNumeroDocumentoFiscal() );
        //$o_ALM_OrdenGuiaFacturaFN->setIdPersona( $this->getCodigoProveedor() );
        //$o_ALM_OrdenGuiaFacturaFN->setIdAlmacen( $this->getIdAlmacen() );
        //$o_ALM_OrdenGuiaFacturaFN->setTipoDoc( ALM_OrdenGuiaFacturaBN::TIPO_DOCUMENTO_FACT );
        //$o_ALM_OrdenGuiaFacturaFN->setIdOrdenGuia( $this->getReferenciaInterno() );
        $o_ALM_OrdenGuiaFacturaFN->setIdTipoDocumentoRef( $this->getIdTipoDocumento() );
        $o_ALM_OrdenGuiaFacturaFN->setIdNumeroDocumentoRef( $this->getIdNumeroDocumento() );
        $a_ALM_OrdenGuiaFactura = $o_ALM_OrdenGuiaFacturaFN->select();
        if( $a_ALM_OrdenGuiaFactura )
        {
            return $a_ALM_OrdenGuiaFactura;
            /*if( count( $a_ALM_OrdenGuiaFactura ) == 1 )
            {
                $o_ALM_OrdenGuiaFacturaBN = $a_ALM_OrdenGuiaFactura[0];
                return $o_ALM_OrdenGuiaFacturaBN->getSerieFacturaConcat();
            }*/
        }
        return array();
    }

    public function getObjectProveedor()
    {
        if( $this->getCodigoProveedor() )
        {
            $o_MST_PersonaMastFN = new MST_PersonaMastFN();
            $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $this->getCodigoProveedor() );
            if( !$o_MST_PersonaMastBN )
            {
                $o_MST_PersonaMastBN = new MST_PersonaMastBN();
            }
        }
        else
        {
            $o_MST_PersonaMastBN = new MST_PersonaMastBN();
        }
        return $o_MST_PersonaMastBN;
    }
    
    public function getObjectCliente()
    {
        if( $this->getCodigoCliente() )
        {
            $o_MST_PersonaMastFN = new MST_PersonaMastFN();
            $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $this->getCodigoCliente() );
            if( !$o_MST_PersonaMastBN )
            {
                $o_MST_PersonaMastBN = new MST_PersonaMastBN();
            }
        }
        else
        {
            $o_MST_PersonaMastBN = new MST_PersonaMastBN();
        }
        return $o_MST_PersonaMastBN;
    }
    
    public function getObjectAlmacen()
    {
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $this->getIdAlmacen() );
        return $o_ALM_AlmacenMastBN;
    }

    public function getAlmacenOrigenDesc()
    {
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $this->getIdAlmacen() );
        return $o_ALM_AlmacenMastBN->getDescripcionLocal();
    }
    
    public function getAlmacenDestinoDesc()
    {
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $this->getAlmacenTraslado() );
        if( $o_ALM_AlmacenMastBN )
        {
            return $o_ALM_AlmacenMastBN->getDescripcionLocal();
        }
        return "";
    }
    
    public function getDescTipoTransaccionMast()
    {
        $o_ALM_TransaccionMastFN = new ALM_TransaccionMastFN();
        $o_ALM_TransaccionMastBN = $o_ALM_TransaccionMastFN->selectByPK( $this->getIdTransaccion() );
        if( $o_ALM_TransaccionMastBN )
        {
            return $o_ALM_TransaccionMastBN->getDescripcionLocal();
        }
        return "";
    }
    
    public function getDescTipoDocumento()
    {
        //Documento a Generar
        $o_ALM_TipoDocumentoFN = new ALM_TipoDocumentoFN();
        $o_ALM_TipoDocumentoBN = $o_ALM_TipoDocumentoFN->selectByPK( $this->getIdTipoDocumento() );
        if( $o_ALM_TipoDocumentoBN )
        {
            return $o_ALM_TipoDocumentoBN->getDescripcion();
        }
        return "";
    }
    
    public function getDescTipoDocumentoDocRef()
    {
        //DOCUMENTO REFERENCIA
        $o_ALM_TipoDocumentoDocRefBN = ALM_TipoDocumentoFN::buscarDocumentoReferencia( $this->getReferenciaTipoDocumento() );
        
        if( $o_ALM_TipoDocumentoDocRefBN )
        {
            return $o_ALM_TipoDocumentoDocRefBN->getDescripcion();
        }
        return "";
    }
    
    public function getArrayObjectTransDetalle()
    {
        $o_ALM_TransaccionDetalleFN = new ALM_TransaccionDetalleFN();
        $o_ALM_TransaccionDetalleFN->setIdCompania( $this->getIdCompania() );
        $o_ALM_TransaccionDetalleFN->setIdTipoDocumento( $this->getIdTipoDocumento() );
        $o_ALM_TransaccionDetalleFN->setIdNumeroDocumento( $this->getIdNumeroDocumento() );
        $a_ALM_TransaccionDetalle = $o_ALM_TransaccionDetalleFN->select();
        return $a_ALM_TransaccionDetalle;
    }

    public function getObjectCajaChicaDet()
    {
        $o_ALM_CajaChicaDetFN = new ALM_CajaChicaDetFN();
        $o_ALM_CajaChicaDetFN->setReferenciaIdTransaccion( $this->getIdNumeroDocumento() );
        $a_ALM_CajaChicaDet = $o_ALM_CajaChicaDetFN->select();
        if( !$a_ALM_CajaChicaDet )
        {
            return new ALM_CajaChicaDetBN();
        }
        $o_ALM_CajaChicaDetBN = $a_ALM_CajaChicaDet[0];
        return $o_ALM_CajaChicaDetBN;
    }

    public function getArrayCajaChicaArchivos()
    {
        $a_ALM_CajaChicaArvhivos = array();
        if( $this->getIdNumeroDocumento() )
        {
            //primero buscamos la cabecera
            $o_ALM_CajaChicaDetBN = $this->getObjectCajaChicaDet();

            if( $o_ALM_CajaChicaDetBN->getIdCajaDet() )
            {
                //luego buscamos los detalles
                $o_ALM_CajaChicaArhivosFN = new ALM_CajaChicaArhivosFN();
                $o_ALM_CajaChicaArhivosFN->setIdCajaDet( $o_ALM_CajaChicaDetBN->getIdCajaDet() );
                $a_ALM_CajaChicaArvhivos = $o_ALM_CajaChicaArhivosFN->select();
            }
        }
        return $a_ALM_CajaChicaArvhivos;
    }

    const CTRL_ESTADO_SERIE_NOEXISTE  = "X";
    const CTRL_ESTADO_SERIE_TERMINADO = "T";
    const CTRL_ESTADO_SERIE_PENDIENTE = "P";

    public static function getArrayControlEstadoSerie( $s_TipoTrans = null )
    {
        $a_TipoTrans = array
        (
            ALM_TransaccionCabeceraBN::CTRL_ESTADO_SERIE_NOEXISTE    => "NO TIENE",
            ALM_TransaccionCabeceraBN::CTRL_ESTADO_SERIE_TERMINADO   => "TERMINADO",
            ALM_TransaccionCabeceraBN::CTRL_ESTADO_SERIE_PENDIENTE   => "PENDIENTE"
        );
        if( !is_null( $s_TipoTrans ) )
        {
            return $a_TipoTrans[$s_TipoTrans];
        }
        return $a_TipoTrans;
    }
}
?>