<?php
/* Metodos de acceso a los campos de la tabla ALM_RequerimientoDetalle redefinidos por el usuario */
class ALM_RequerimientoDetalleBN extends BaseALM_RequerimientoDetalleBN
{
    const ESTADO_ACTIVO   = "A";
    const ESTADO_INACTIVO = "I";
    
    protected static $instance = null;
    
    public function getObjetocabecera()
    {
        if ( !isset( self::$instance ) )
        {
            $o_ALM_RequerimientoCabeceraFN = new ALM_RequerimientoCabeceraFN();
            $o_ALM_RequerimientoCabeceraBN = $o_ALM_RequerimientoCabeceraFN->selectByPK( $this->getIdRequerimiento() );
            self::$instance = $o_ALM_RequerimientoCabeceraBN;
            //self::$instance->initialize();
        }
        return self::$instance;
    }
    
    public function getIdAlmacen()
    {
        
        return GSS_SucursalFN::recuperarIdAlmacen( $this->getObjetocabecera()->getIdSucursal() );
    }
    
    public function getCodigoBarras()
    {
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $this->getIdItem() );
        return $o_ALM_ItemMastBN->getCodigoBarras();
    }
    
    public function getDescripcionItem()
    {
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $this->getIdItem() );
        return $o_ALM_ItemMastBN->getDescripcionCompleta();
    }
    
    public function getStockAlmacenActual()
    {
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $this->getIdItem() );
        return $o_ALM_ItemMastBN->getStockAlmacenActual( $this->getIdAlmacen() );
    }
    
    public function getExisteDetalleLote()
    {
        $o_ALM_RequerimientoDetalleLoteFN = new ALM_RequerimientoDetalleLoteFN();
        $o_ALM_RequerimientoDetalleLoteFN->setIdRequerimientoDetalle( $this->getIdRequerimientoDetalle() );
        $i_CantRows = $o_ALM_RequerimientoDetalleLoteFN->selectNumRows();
        if( $i_CantRows > 0 )
        {
            return true;
        }
        return false;
    }
    
    protected $a_ArrayObjectRequerimientoDetalleLote;
    /**
     * @return the $a_ArrayObjectRequerimientoDetalleLote
     */
    public function getArrayObjectRequerimientoDetalleLote()
    {
        return $this->a_ArrayObjectRequerimientoDetalleLote;
    }

    /**
     * @param field_type $a_ArrayObjectRequerimientoDetalleLote
     */
    public function setArrayObjectRequerimientoDetalleLote($a_ArrayObjectRequerimientoDetalleLote)
    {
        $this->a_ArrayObjectRequerimientoDetalleLote = $a_ArrayObjectRequerimientoDetalleLote;
    }

}
?>