<?php
/* Metodos de acceso a los campos de la tabla ALM_OrdenGuiaFactura redefinidos por el usuario */
class ALM_OrdenGuiaFacturaBN extends BaseALM_OrdenGuiaFacturaBN
{
    //ESTADO
    const ESTADO_POR_INGRESAR  = "X";
    const ESTADO_PREPARACION   = "P";
    const ESTADO_ASOCIADO      = "A";
    
    //TIPO DOCUMENTOS QUE MANEJA
    const TIPO_DOCUMENTO_GUIA   = "GR";
    const TIPO_DOCUMENTO_FACT   = "FP";
    const TIPO_DOCUMENTO_NC     = "NC";
    
    public static function getArrayEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
            ALM_OrdenGuiaFacturaBN::ESTADO_POR_INGRESAR => "POR INGRESAR",
            ALM_OrdenGuiaFacturaBN::ESTADO_PREPARACION  => "PREPARACION",
            ALM_OrdenGuiaFacturaBN::ESTADO_ASOCIADO     => "ASOCIADO"
        );
        if( !is_null( $sEstado ) )
        {
            return $a_sEstado[$sEstado];
        }
        return $a_sEstado;
    }
    
    public function getEstadoDesc()
    {
        return ALM_OrdenGuiaFacturaBN::getArrayEstados( $this->getEstado() );
    }
    
    public function getIdConcat()
    {
        return $this->getIdOrdenGuia();
    }
    
    public function getSucursalDesc()
    {
        $o_GSS_SucursalFN = new GSS_SucursalFN();
        $o_GSS_SucursalBN = $o_GSS_SucursalFN->selectByPK( $this->getIdSucursal() );
        if( $o_GSS_SucursalBN )
        {
            return $o_GSS_SucursalBN->getDescripcion();
        }
        return "";
    }
    
    public function getProveedorDes()
    {
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $this->getIdPersona() );
        if( $o_MST_PersonaMastBN )
        {
            return $o_MST_PersonaMastBN->getNombreCompleto();
        }
        return "";
    }
    
    public function getObjectOrdenCompra()
    {
        $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
        $o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $this->getIdCompania(), $this->getIdOrdenCompra() );
        if( !$o_COM_OrdenCompraCabeceraBN )
        {
            $o_COM_OrdenCompraCabeceraBN = new COM_OrdenCompraCabeceraBN();
        }
        return $o_COM_OrdenCompraCabeceraBN;
    }
    
    public function getFechaOrdenCompra()
    {
        $o_COM_OrdenCompraCabeceraBN = $this->getObjectOrdenCompra();
        if( $o_COM_OrdenCompraCabeceraBN )
        {
            return $o_COM_OrdenCompraCabeceraBN->getFechaCreacion();
        }
        return "";
    }
    
    public function getRUCProveedor()
    {
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $this->getIdPersona() );
        return $o_MST_PersonaMastBN->getDocumento();
    }
    
    public function getSerieGuiaConcat()
    {
        return $this->getSerieGuia()."-".$this->getNumeroGuia();
    }
    
    public function getSerieFacturaConcat()
    {
        if( $this->getSerieFactura() )
        {
            return $this->getObjectTipoDocumento()->getTipoDocumentoCod()." ".$this->getSerieFactura()."-".$this->getNumeroFactura();
        }
        return "";
    }
    
    public function getSerieFacturaResumen()
    {
        if( $this->getSerieFactura() )
        {
            return $this->getSerieFactura()."-".$this->getNumeroFactura();
        }
        return "";
    }
    
    public function getArrayObjectTransacciones()
    {
        $s_TipoDocumentoFiscal = ALM_OrdenGuiaFacturaBN::TIPO_DOCUMENTO_GUIA;
        if( $this->getTipoDoc() == ALM_OrdenGuiaFacturaBN::TIPO_DOCUMENTO_NC )
        {
            $s_TipoDocumentoFiscal = ALM_OrdenGuiaFacturaBN::TIPO_DOCUMENTO_NC;
        }
        $o_ALM_TransaccionCabeceraFN = new ALM_TransaccionCabeceraFN();
        $o_ALM_TransaccionCabeceraFN->setReferenciaTipoDocumento( COM_OrdenCompraCabeceraBN::REF_TIPO_DOCUMENTO_DEFECTO );
        $o_ALM_TransaccionCabeceraFN->setReferenciaNumeroDocumento( $this->getIdOrdenCompra() );
        $o_ALM_TransaccionCabeceraFN->setTipoDocumentoFiscal( $s_TipoDocumentoFiscal );
        $o_ALM_TransaccionCabeceraFN->setSerieDocumentoFiscal( $this->getSerieGuia() );
        $o_ALM_TransaccionCabeceraFN->setNumeroDocumentoFiscal( $this->getNumeroGuia() );
        $a_ALM_TransaccionCabecera = $o_ALM_TransaccionCabeceraFN->select();
        
        $a_ALM_TransaccionCabecera = $o_ALM_TransaccionCabeceraFN->select();
        return $a_ALM_TransaccionCabecera;
    }
    
    public function getObjectTipoDocumento()
    {
        $o_VTA_TipoDocumentoFN = new VTA_TipoDocumentoFN();
        $o_VTA_TipoDocumentoBN = $o_VTA_TipoDocumentoFN->selectByPK( $this->getTipoDoc() );
        return $o_VTA_TipoDocumentoBN;
    }
    
    public function getTipoDocumentoDesc()
    {
        return $this->getObjectTipoDocumento()->getDescripcionLocal();
    }
    
    public function getObjectOrdenGuiaReferencia()
    {
        $o_ALM_OrdenGuiaFacturaFN = new ALM_OrdenGuiaFacturaFN();
        $o_ALM_OrdenGuiaFacturaBN = $o_ALM_OrdenGuiaFacturaFN->selectByPK( $this->getIdOrdenGuiaReferencia() );
        return $o_ALM_OrdenGuiaFacturaBN;
    }
}
?>