<?php
/* M�todos de acceso a los campos de la tabla ALM_Kardex redefinidos por el usuario */
class ALM_KardexBN extends BaseALM_KardexBN
{
    //PARA EL KARDEX - SUN INFORMACION ES PERSONALIZADA
    const INGRESO_POR_BONIFICACION   = "IBO";
    ///////////////////////////////////////////////////
    
    public function getTipoDocumentoComprobante()
    {
        $o_VTA_TipoDocumentoFN = new VTA_TipoDocumentoFN();
        $o_VTA_TipoDocumentoBN = $o_VTA_TipoDocumentoFN->selectByPK( $this->getTipoDocumentoFiscal() );
        ///pr( $this->getTipoDocumentoFiscal() );
        //pr( $o_VTA_TipoDocumentoBN );
        if( $o_VTA_TipoDocumentoBN )
        {
            return $o_VTA_TipoDocumentoBN->getCodigoFiscal()." ".strtoupper( $o_VTA_TipoDocumentoBN->getDescripcionLocal() );
        }
        else
        {
            if( $this->getTipoDocumentoFiscal() == "NI" )
            {
                $o_ALM_TransaccionMastFN = new ALM_TransaccionMastFN();
                $o_ALM_TransaccionMastBN = $o_ALM_TransaccionMastFN->selectByPK( $this->getIdTransaccion() );
                if( $o_ALM_TransaccionMastBN )
                {
                    $s_CodFiscal = "";
                    if( $this->getIdTransaccion() == "STI" )
                    {
                        $s_CodFiscal = "IN";
                    }
                    return $s_CodFiscal." ".strtoupper( $o_ALM_TransaccionMastBN->getDescripcionLocal() );
                }
            }
            $o_ALM_TransaccionMastFN = new ALM_TransaccionMastFN();
            $o_ALM_TransaccionMastBN = $o_ALM_TransaccionMastFN->selectByPK( $this->getIdTransaccion() );
            return strtoupper( $o_ALM_TransaccionMastBN->getDescripcionLocal() );
        }
        return "";
    }
    
    public function getTipoOperacionKardex()
    {
        $o_ALM_TransaccionMastFN = new ALM_TransaccionMastFN();
        $o_ALM_TransaccionMastBN = $o_ALM_TransaccionMastFN->selectByPK( $this->getIdTransaccion() );
        //pr( $this->getIdTransaccion() );
        if( $o_ALM_TransaccionMastBN )
        {
            $s_TipoOpeFiscal = $o_ALM_TransaccionMastBN->getCodigoSunat();
            $s_Descripcion   = $o_ALM_TransaccionMastBN->getDescripcionLocal();
            return $s_TipoOpeFiscal." ".$s_Descripcion;
            /*$o_MST_TipoOperacionMastFN = new MST_TipoOperacionMastFN();
            $o_MST_TipoOperacionMastBN = $o_MST_TipoOperacionMastFN->selectByPK( $s_TipoOpeFiscal );
            if( $o_MST_TipoOperacionMastBN )
            {
                return $s_TipoOpeFiscal." ".$o_MST_TipoOperacionMastBN->getDescripcion();
            }*/
        }
        return "";
    }

    public function getObjectItem()
    {
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $this->getIdItem() );
        return $o_ALM_ItemMastBN;
    }
    
    public function getDescripcionItem()
    {
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $this->getIdItem() );
        return $o_ALM_ItemMastBN->getDescripcionCompleta();
    }
    
    public function getDescripcionAlmacen()
    {
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $this->getIdAlmacen() );
        return $o_ALM_AlmacenMastBN->getDescripcionLocal();
    }
    
    public function getFechaTransaccion()
    {
        return substr( $this->getIdFecha(), 0 , 10 );
    }
    
    public function getTipoOperacion()
    {
        $o_ALM_TransaccionMastFN = new ALM_TransaccionMastFN();
        $o_ALM_TransaccionMastBN = $o_ALM_TransaccionMastFN->selectByPK( $this->getIdTransaccion() );
        if( $o_ALM_TransaccionMastBN )
        {
            return $o_ALM_TransaccionMastBN->getIngresoEgresoFlag();
        }
        return "XXX";
    }
    
    public function getStockIngreso()
    {
        $o_ALM_TransaccionMastFN = new ALM_TransaccionMastFN();
        $o_ALM_TransaccionMastBN = $o_ALM_TransaccionMastFN->selectByPK( $this->getIdTransaccion() );
        if( $o_ALM_TransaccionMastBN )
        {
            if( $o_ALM_TransaccionMastBN->getIngresoEgresoFlag() == ALM_TransaccionCabeceraBN::TIPO_INGRESO )
            {
                //return $this->getCantidad()." / ".$this->getCantidadDoble();
                return $this->getCantidad();
            }
        }
        return "";
    }
    
    public function getStockSalida()
    {
        $o_ALM_TransaccionMastFN = new ALM_TransaccionMastFN();
        $o_ALM_TransaccionMastBN = $o_ALM_TransaccionMastFN->selectByPK( $this->getIdTransaccion() );
        if( $o_ALM_TransaccionMastBN )
        {
            if( $o_ALM_TransaccionMastBN->getIngresoEgresoFlag() == ALM_TransaccionCabeceraBN::TIPO_SALIDA )
            {
                //return $this->getCantidad()." / ".$this->getCantidadDoble();
                return $this->getCantidad();
            }
        }
        return "";
    }
    
    public function getIdUnidadCompra()
    {
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $this->getIdItem() );
        return $o_ALM_ItemMastBN->getUnidadCompra();
    }
    
    public function getUnidadDescripcion()
    {
        $s_IdUnidadCompra = $this->getIdUnidadCompra();
        $o_MST_UnidadMastFN = new MST_UnidadMastFN();
        $o_MST_UnidadMastBN = $o_MST_UnidadMastFN->selectByPK( $s_IdUnidadCompra );
        if( $o_MST_UnidadMastBN )
        {
            return $o_MST_UnidadMastBN->getDescripcionCorta();
        }
        return "NO_UNIDAD";
    }
    
    public function getDocumentoRefFiscal()
    {
        if( $this->getTipoDocumentoFiscal() )
        {
            return $this->getTipoDocumentoFiscal()." ".$this->getSerieDocumentoFiscal()."-".$this->getNumeroDocumentoFiscal();
        }
        return "";
    }
    
    protected $o_DetalleTransaccion;
    public function setObjetoDetalleTransaccion( $o_Object )
    {
        $this->o_DetalleTransaccion = $o_Object;
    }

    /**
     * @return ALM_TransaccionDetalleBN
     */
    public function getObjetoDetalleTransaccion()
    {
        return $this->o_DetalleTransaccion;
    }
    
    public function getPerProvClieDescripcion()
    {
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastBN = new MST_PersonaMastBN();
        if( $this->getCodigoCliente() )
        {
            $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $this->getCodigoCliente() );
        }
        if ( $this->getCodigoProveedor() )
        {
            $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $this->getCodigoProveedor() );
        }
        if( $o_MST_PersonaMastBN )
        {
            return $o_MST_PersonaMastBN->getNombreCompletoLLeno();
        }
        return "";
    }
    
    public function getReferenciaTipoDocumentoDesc()
    {
        /*$o_ALM_TipoDocumentoFN = new ALM_TipoDocumentoFN(); //PARA DOCUMENTO DE REFENCIA
        $o_ALM_TipoDocumentoBN = $o_ALM_TipoDocumentoFN->selectByPK( $this->getReferenciaTipoDocumento() );
        $s_Descripcion = "";
        if( $o_ALM_TipoDocumentoBN )
        {
            $s_Descripcion = $o_ALM_TipoDocumentoBN->getDescripcion();
        }
        return $s_Descripcion;*/
    }
    
    public function getIdTransaccionDesc()
    {
        $o_ALM_TransaccionMastFN = new ALM_TransaccionMastFN();
        $o_ALM_TransaccionMastBN = $o_ALM_TransaccionMastFN->selectByPK( $this->getIdTransaccion() );
        return $o_ALM_TransaccionMastBN->getDescripcionLocal();
    }
    
    public function getObjectTransaccionCabecera()
    {
        $o_ALM_TransaccionCabeceraFN = new ALM_TransaccionCabeceraFN();
        $o_ALM_TransaccionCabeceraBN = $o_ALM_TransaccionCabeceraFN->selectByPK( $this->getIdCompania(), $this->getReferenciaTipoDocumento(), $this->getReferenciaNumeroDocumento() );
        return $o_ALM_TransaccionCabeceraBN; 
    }
    
    public function getFechaVencimientoLote()
    {
        $o_ALM_ItemAlmacenStockFN = new ALM_ItemAlmacenStockFN();
        $o_ALM_ItemAlmacenStockBN = $o_ALM_ItemAlmacenStockFN->selectByPK( $this->getIdCompania(), $this->getIdItem(), $this->getIdAlmacen(), $this->getIdCondicion(), $this->getIdLote() );
        if( $o_ALM_ItemAlmacenStockBN )
        {
            return $o_ALM_ItemAlmacenStockBN->getFechaVencimiento();
        }
        return "";
    }
    
    protected $s_IdTransaccionOperacion;
    protected $TipoCambioRef;
    protected $MonedaCodRef;
    /**
     * @return the $TipoCambioRef
     */
    public function getTipoCambioRef()
    {
        return $this->TipoCambioRef;
    }

    /**
     * @param field_type $TipoCambioRef
     */
    public function setTipoCambioRef($TipoCambioRef)
    {
        $this->TipoCambioRef = $TipoCambioRef;
    }
    /**
     * @return the $MonedaCodRef
     */
    public function getMonedaCodRef()
    {
        return $this->MonedaCodRef;
    }

    /**
     * @param field_type $MonedaCodRef
     */
    public function setMonedaCodRef($MonedaCodRef)
    {
        $this->MonedaCodRef = $MonedaCodRef;
    }

    public function setIdTransaccionOperacion( $v )
    {
        $this->s_IdTransaccionOperacion = $v;
    }
    
    public function getIdTransaccionOperacion()
    {
        return $this->s_IdTransaccionOperacion;
    }

    protected $ALM_ItemAlmacenStockBN;
    public function getALMItemAlmacenStockBN()
    {
        return $this->ALM_ItemAlmacenStockBN;
    }
    public function setALMItemAlmacenStockBN( $ALM_ItemAlmacenStockBN )
    {
        $this->ALM_ItemAlmacenStockBN = $ALM_ItemAlmacenStockBN;
    }

    protected $ALM_ItemMastBN;
    public function getALMItemMastBN()
    {
        return $this->ALM_ItemMastBN;
    }
    public function setALMItemMastBN( $ALM_ItemMastBN )
    {
        $this->ALM_ItemMastBN = $ALM_ItemMastBN;
    }
}