<?php
/* M�todos de acceso a los campos de la tabla ALM_InventarioFisicoDetalle redefinidos por el usuario */
class ALM_InventarioFisicoDetalleBN extends BaseALM_InventarioFisicoDetalleBN
{
    const TIPO_DOCUMENTO_REFERENCIA  = "AJ";
    
    public function getIdInventarioFisicoDetConcat()
    {
        return $this->getIdCompania()."_".$this->getIdNumeroInventario()."_".$this->getIdSecuencia();
    }
    
    public function getObjectAlmacen()
    {
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $this->getIdAlmacen() );
        return $o_ALM_AlmacenMastBN;
    }
    
    public function getObjectItem()
    {
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $this->getIdItem() );
        return $o_ALM_ItemMastBN;
    }
    
    public function getObjectUnidadMast()
    {
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $this->getIdItem() );
        
        $o_MST_UnidadMastFN = new MST_UnidadMastFN();
        $o_MST_UnidadMastBN = $o_MST_UnidadMastFN->selectByPK( $o_ALM_ItemMastBN->getUnidadAlmacenaje() );
        
        return $o_MST_UnidadMastBN;
    }
    
    public function getStockActualUnidad()
    {
        //BUSCAR EL STOCK
        $o_ALM_ItemAlmacenStockFN = new ALM_ItemAlmacenStockFN();
        $o_ALM_ItemAlmacenStockBN = $o_ALM_ItemAlmacenStockFN->selectByPK( $this->getIdCompania(), $this->getIdItem(), $this->getIdAlmacen(), ALM_ItemAlmacenStockBN::CONDICION_POR_DEFECTO, ALM_ItemAlmacenStockBN::LOTE_POR_DEFECTO );
        if( $o_ALM_ItemAlmacenStockBN )
        {    
            return $o_ALM_ItemAlmacenStockBN->getStockActualDoble();
        }
        return "0";
    }
}
?>