<?php
/* Metodos de acceso a los campos de la tabla ALM_CajaChicaDet redefinidos por el usuario */
class ALM_CajaChicaDetBN extends BaseALM_CajaChicaDetBN
{
    const ESTADO_APROBADO  = "A";
    const ESTADO_CANCELADO = "C";

    public static function getArrayEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
            ALM_CajaChicaDetBN::ESTADO_APROBADO   => "APROBADO",
            ALM_CajaChicaDetBN::ESTADO_CANCELADO => "CANCELADO"
        );
        if( !is_null( $sEstado ) )
        {
            return $a_sEstado[$sEstado];
        }
        return $a_sEstado;
    }

    public function getEstadoDesc()
    {
        return ALM_CajaChicaDetBN::getArrayEstados( $this->getEstado() );
    }

    public function getConcatReferenciaDoc()
    {
        return $this->getReferenciaTipoDocumento()." ".$this->getReferenciaSerieDocumento()."-".$this->getReferenciaNumeroDocumento();
    }

    public function getCantRegCajaChicaItem()
    {
        $o_ALM_CajaChicaItemFN = new ALM_CajaChicaItemFN();
        $o_ALM_CajaChicaItemFN->setIdCajaDet( $this->getIdCajaDet() );
        return $o_ALM_CajaChicaItemFN->selectNumRows();
    }

    public function getArrayCajaChicaItem()
    {
        $a_ALM_CajaChicaItem = array();
        if( $this->getIdCajaDet() )
        {
            $o_ALM_CajaChicaItemFN = new ALM_CajaChicaItemFN();
            $o_ALM_CajaChicaItemFN->setIdCajaDet( $this->getIdCajaDet() );
            $a_ALM_CajaChicaItem = $o_ALM_CajaChicaItemFN->select();
        }
        return $a_ALM_CajaChicaItem;
    }

    public function getArrayCajaChicaArchivos()
    {
        $a_ALM_CajaChicaArvhivos = array();
        if( $this->getIdCajaDet() )
        {
            $o_ALM_CajaChicaArhivosFN = new ALM_CajaChicaArhivosFN();
            $o_ALM_CajaChicaArhivosFN->setIdCajaDet( $this->getIdCajaDet() );
            $a_ALM_CajaChicaArvhivos = $o_ALM_CajaChicaArhivosFN->select();
        }
        return $a_ALM_CajaChicaArvhivos;
    }
}
?>