<?php
/* Metodos de acceso a los campos de la tabla ALM_CajaChicaCab redefinidos por el usuario */
class ALM_CajaChicaCabBN extends BaseALM_CajaChicaCabBN
{
    const ESTADO_CERRADO = "C";
    const ESTADO_ABIERTO = "A";

    public static function getArrayEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
            ALM_CajaChicaCabBN::ESTADO_CERRADO => "CERRADO",
            ALM_CajaChicaCabBN::ESTADO_ABIERTO => "ABIERTO"
        );
        if( !is_null( $sEstado ) )
        {
            return $a_sEstado[$sEstado];
        }
        return $a_sEstado;
    }

    public function getEstadoDesc()
    {
        return ALM_CajaChicaCabBN::getArrayEstados( $this->getEstado() );
    }

    public function getCantRegCajaChicaDetalle()
    {
        $o_ALM_CajaChicaDetFN = new ALM_CajaChicaDetFN();
        $o_ALM_CajaChicaDetFN->setIdCaja( $this->getIdCaja() );
        return $o_ALM_CajaChicaDetFN->selectNumRows();
    }

    public function getArrayCajaChicaDet()
    {
        $o_ALM_CajaChicaDetFN = new ALM_CajaChicaDetFN();
        $o_ALM_CajaChicaDetFN->setIdCaja( $this->getIdCaja() );
        $a_ALM_CajaChicaDet = $o_ALM_CajaChicaDetFN->select();
        return $a_ALM_CajaChicaDet;
    }

    public function getMontoTotalDetalles()
    {
        $o_ALM_CajaChicaDetFN = new ALM_CajaChicaDetFN();
        $o_ALM_CajaChicaDetFN->setIdCaja( $this->getIdCaja() );
        $a_ALM_CajaChicaDet = $o_ALM_CajaChicaDetFN->select();
        $f_MontoTotal = 0;
        foreach ( $a_ALM_CajaChicaDet as $o_ALM_CajaChicaDetBN ) 
        {
            $f_MontoTotal = $f_MontoTotal + $o_ALM_CajaChicaDetBN->getMontoTotal();
        }
        return $f_MontoTotal;
    }

    public function getArrayCajaChicaLog()
    {
        if( $this->getIdCaja() )
        {
            $o_ALM_CajaChicaLogFN = new ALM_CajaChicaLogFN();
            $o_ALM_CajaChicaLogFN->setIdCaja( $this->getIdCaja() );
            $o_ALM_CajaChicaLogFN->addOrderBy( ALM_CajaChicaLogFN::IdCajaLog, false );
            return $o_ALM_CajaChicaLogFN->select();
        }
        return array();
    }

}
?>