<?php
class TransporteBL
{
    public function guardarRuta( TR_RutaBN $o_TR_RutaBN )
    {
        $con = Conexion::getConexion();
        $con->begin();
        try 
        {
            if( !myUser::getUser()->getIdBusiness() )
            {
                throw new Exception( "Se termino la session." );
            }
            $o_TR_RutaFN = new TR_RutaFN();
            $o_TR_RutaFN->setRutaFechaProgramada( $o_TR_RutaBN->getRutaFechaProgramada() );
            $o_TR_RutaFN->setIdTurno( $o_TR_RutaBN->getIdTurno() );
            $o_TR_RutaFN->setIdVehiculo( $o_TR_RutaBN->getIdVehiculo() );
            $o_TR_RutaFN->setIdChofer( $o_TR_RutaBN->getIdChofer() );
            $a_TR_Ruta = $o_TR_RutaFN->select();
            if( !$a_TR_Ruta )
            {
                //CUANDO ES NUEVO
                $this->validarValoresxDefecto( $o_TR_RutaBN );
                
                $o_TR_RutaDP = new TR_RutaDP( $o_TR_RutaBN );
                $o_TR_RutaDP->generaRutaId();
                $b_Result = $o_TR_RutaDP->save();
                $o_TR_RutaBN->setIdRuta( $o_TR_RutaDP->getIdRuta() );
                $o_TR_RutaBN->setRutaDocumento( $o_TR_RutaDP->getRutaDocumento() );
            }
            else
            {
                //YA SE ENCUENTRA REGISTRADO Y SE TIENE QUE AGREGAR UN DOCUMENTO PARA LA RUTA.
                $o_TR_RutaBN->setIdRuta( $a_TR_Ruta[0]->getIdRuta() );
                $o_TR_RutaBN->setRutaDocumento( $a_TR_Ruta[0]->getRutaDocumento() );
            }
            
            $this->agregarDetalleRuta( $o_TR_RutaBN );
            
            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( $o_Exception->getMessage() ) ;
        }
        return true;
    }
    
    private function validarValoresxDefecto( TR_RutaBN $o_TR_RutaBN )
    {
        $this->validacionEstadoSession();
        $o_TR_RutaBN->setRutaFechaEmision( date( "Y-m-d H:i:s" ) );
        $o_TR_RutaBN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_TR_RutaBN->setIdSucursal( myUser::getUser()->getIdSucursal() );
        $o_TR_RutaBN->setEstado( TR_RutaBN::ESTADO_ABIERTO );
        $o_TR_RutaBN->setUsuarioCreacion( myUser::getUser()->getUserId() );
        $o_TR_RutaBN->setFechaCreacion( date( "Y-m-d H:i:s" ) );
        $o_TR_RutaBN->setUsuarioModificacion( myUser::getUser()->getUserId() );
        $o_TR_RutaBN->setFechaModificacion( date( "Y-m-d H:i:s" ) );
    }
    
    private function validacionEstadoSession()
    {
        if( !myUser::getUser()->getIdBusiness() )
        {
            throw new Exception( "Se termino la session." );
        }
    }
    
    public function agregarDetalleRuta( TR_RutaBN $o_TR_RutaBN )
    {
        $o_ObjectoDocumento = $o_TR_RutaBN->getObjectoDocumento();
        $i_IdCliente = $o_ObjectoDocumento->getClienteNumero();
        $s_DocReferencia = $o_ObjectoDocumento->getDocumentoTipoSerieNumero();
        $s_DocumentRefId = $o_ObjectoDocumento->getNumeroDocumento();
        
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $i_IdCliente );
        
        $o_TR_RutaDetalleBN = new TR_RutaDetalleBN();
        $o_TR_RutaDetalleBN->setIdRuta( $o_TR_RutaBN->getIdRuta() );
        $o_TR_RutaDetalleBN->setRutaDetPais( "PERU" );
        $o_TR_RutaDetalleBN->setRutaDetDpto( $o_MST_PersonaMastBN->getDepartamentoDesc() );
        $o_TR_RutaDetalleBN->setRutaDetCiudad( $o_MST_PersonaMastBN->getProvinciaDesc() );
        $o_TR_RutaDetalleBN->setRutaDetDir1( $o_MST_PersonaMastBN->getDistritoDesc() );
        $o_TR_RutaDetalleBN->setRutaDetDir2( $o_MST_PersonaMastBN->getDireccion() );
        $o_TR_RutaDetalleBN->setIdUbigeo( $o_MST_PersonaMastBN->getDistrito() );
        $o_TR_RutaDetalleBN->setRutaDocDespacho( $s_DocReferencia );
        $o_TR_RutaDetalleBN->setDocumentRefId( $s_DocumentRefId );
        $o_TR_RutaDetalleBN->setRutaDetEstado( TR_RutaDetalleBN::ESTADO_PENDIENTE );
        $o_TR_RutaDetalleBN->setFechaCreacion( date( "Y-m-d H:i:s" ) );
        $o_TR_RutaDetalleBN->setUsuarioCreacion( myUser::getUser()->getUserId() );
        $o_TR_RutaDetalleBN->setFechaModificacion( date( "Y-m-d H:i:s" ) );
        $o_TR_RutaDetalleBN->setUsuarioModificacion( myUser::getUser()->getUserId() );
        
        $o_TR_RutaDetalleDP = new TR_RutaDetalleDP( $o_TR_RutaDetalleBN );
        $o_TR_RutaDetalleDP->recuperarId();
        $b_Result = $o_TR_RutaDetalleDP->save();
        return true;
    }
    
    public function cambiarEstadoRuta( TR_RutaBN $o_TR_RutaBN )
    {
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            $this->validacionEstadoSession();
            
            //Validacion de cambio de ruta, solo los que son diferentes a terminado
            $o_TR_RutaFN = new TR_RutaFN();
            $o_TMP_TR_RutaBN = $o_TR_RutaFN->selectByPK( $o_TR_RutaBN->getIdRuta() );
            if( $o_TMP_TR_RutaBN->getEstado() == TR_RutaBN::ESTADO_TERMINADO )
            {
                throw new Exception( "La Ruta se encuentra Terminado" );
            }
            
            $o_TR_RutaDP = new TR_RutaDP( $o_TR_RutaBN );
            $o_TR_RutaDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_TR_RutaDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $b_Result = $o_TR_RutaDP->update();
        
            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( $o_Exception->getMessage() ) ;
        }
        return true;
    }
    
    public function cambiarEstadoRutaDetalle( TR_RutaBN $o_TR_RutaBN )
    {
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            $this->validacionEstadoSession();
        
            $o_TR_RutaDetalleBN = $o_TR_RutaBN->getObjetoRutaDetalle();
            
            $o_TR_RutaDetalleDP = new TR_RutaDetalleDP( $o_TR_RutaDetalleBN );
            $o_TR_RutaDetalleDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_TR_RutaDetalleDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $b_Result = $o_TR_RutaDetalleDP->update();
        
            $this->validarProcesoCompletado( $o_TR_RutaBN );
            
            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( $o_Exception->getMessage() ) ;
        }
        return true;
    }
    
    public function validarProcesoCompletado( TR_RutaBN $o_TR_RutaBN )
    {
        $b_Control = true;
        
        $o_TR_RutaDetalleFN = new TR_RutaDetalleFN();
        $o_TR_RutaDetalleFN->setIdRuta( $o_TR_RutaBN->getIdRuta() );
        $o_TR_RutaDetalleFN->addCondition( TR_RutaDetalleFN::RutaDetEstado, "NOT IN", "('E','R')", false );
        $a_TR_RutaDetalle = $o_TR_RutaDetalleFN->select();
        if( $a_TR_RutaDetalle )
        {
            $b_Control = false;
        }
        if( $b_Control )
        {
            $o_TR_RutaBN->setEstado( TR_RutaBN::ESTADO_TERMINADO );
            $b_Result = $this->cambiarEstadoRuta( $o_TR_RutaBN );
        }
        return true;
    }
    
}