<?php
class InventarioBL
{
    public function EjecutarInventarioTruchas( ALM_InventarioFisicoBN $o_ALM_InventarioFisicoBN )
    {
        ini_set( 'memory_limit', '1024M' );
        ini_set( 'max_execution_time', 5000 );

        $con = Conexion::getConexion();
        $con->begin();
        try 
        {
            $s_IdCompania         = $o_ALM_InventarioFisicoBN->getIdCompania();
            $s_IdNumeroInventario = $o_ALM_InventarioFisicoBN->getIdNumeroInventario();
            
            $o_ALM_InventarioFisicoFN = new ALM_InventarioFisicoFN();
            $o_ALM_InventarioFisicoBN = $o_ALM_InventarioFisicoFN->selectByPK( $s_IdCompania, $s_IdNumeroInventario );
            if( !$o_ALM_InventarioFisicoBN )
            {
                throw new Exception( "No se encuentra registrado el Inventario." );
            }
            
            if( $o_ALM_InventarioFisicoBN->getEstado() != ALM_InventarioFisicoBN::ESTADO_PENDIENTE )
            {
                throw new Exception( "No se puede ejecutar el procedimiento por tener un estado diferente a pendiente." );
            }
            
            $o_ALM_InventarioFisicoDetalleFN = new ALM_InventarioFisicoDetalleFN();
            $o_ALM_InventarioFisicoDetalleFN->setIdCompania( $s_IdCompania );
            $o_ALM_InventarioFisicoDetalleFN->setIdNumeroInventario( $s_IdNumeroInventario );
            $i_CountReg = $o_ALM_InventarioFisicoDetalleFN->selectNumRows();
            if( $i_CountReg == 0 )
            {
                throw new Exception( "No se registro detalles." );
            }
            
            
            $a_ResultCont = ALM_InventarioFisicoFN::compararCountRegistrovsConteo( $s_IdCompania, $s_IdNumeroInventario );
            if(  $a_ResultCont['COUNT_REG'] !=  $a_ResultCont['COUNT_UPD'] )
            {
                //throw new Exception( "No se encuentra terminado el conteo  de todos los detalles." );
            }
            
            //$a_ALM_InventarioFisicoDetalle = ALM_InventarioFisicoDetalleFN::buscarListaCabeceraTransaccion( $s_IdCompania, $s_IdNumeroInventario );
            
            //AHORA SE BUSCA LOS DETALLES
            $o_ALM_InventarioFisicoDetalleFN = new ALM_InventarioFisicoDetalleFN();
            $o_ALM_InventarioFisicoDetalleFN->setIdCompania( $s_IdCompania );
            $o_ALM_InventarioFisicoDetalleFN->setIdNumeroInventario( $s_IdNumeroInventario );
            $o_ALM_InventarioFisicoDetalleFN->addCondition( ALM_InventarioFisicoDetalleFN::StockFisico, "<>", 0 );
            $a_ALM_InventarioFisicoDetalle = $o_ALM_InventarioFisicoDetalleFN->select();
            foreach ( $a_ALM_InventarioFisicoDetalle as $i_Key => $o_ALM_InventarioFisicoDetalleBN )
            {
                //SE SETEA LA CABECERA
                $b_Control = true;
                switch ( $o_ALM_InventarioFisicoDetalleBN->getTipoOperacion() )
                {
                    case ALM_TransaccionCabeceraBN::TIPO_INGRESO:
                        $IdTransaccion   = ALM_InventarioFisicoBN::TIPO_SOB_INVENTARIO;
                        $IdTipoDocumento = ALM_InventarioFisicoBN::TIPO_DOCUMENTO_ING;
                    break;
                    case ALM_TransaccionCabeceraBN::TIPO_SALIDA:
                        $IdTransaccion   = ALM_InventarioFisicoBN::TIPO_FAL_INVENTARIO;
                        $IdTipoDocumento = ALM_InventarioFisicoBN::TIPO_DOCUMENTO_SAL;
                    break;
                    case ALM_InventarioFisicoBN::TIPO_NORMAL_SIN_MOV:
                        $IdTransaccion   = null;
                        $IdTipoDocumento = null;
                        $b_Control = false;
                    break;
                    default:
                        throw new Exception( "No tiene registrado una operacion para la transaccion." );
                }
                //pr( $o_ALM_InventarioFisicoDetalleBN );
                $IdAlmacen                  = $o_ALM_InventarioFisicoDetalleBN->getIdAlmacen();
                $IdTransaccionOperacion     = $o_ALM_InventarioFisicoDetalleBN->getTipoOperacion();
                $FechaDocumento             = date( "Y-m-d" );
                $ReferenciaTipoDocumento    = ALM_InventarioFisicoBN::TIPO_DOC_REFERENCIA;
                $ReferenciaNumeroDocumento  = $s_IdNumeroInventario;
                $GuiaProveedor              = "";
                $Comentario                 = "";
                
                $o_ALM_TransaccionCabeceraBN = new ALM_TransaccionCabeceraBN();
                $o_ALM_TransaccionCabeceraBN->setIdTransaccion( $IdTransaccion );
                //$o_ALM_TransaccionCabeceraBN->setAlmacenTraslado( $AlmacenTraslado );
                $o_ALM_TransaccionCabeceraBN->setIdAlmacen( $IdAlmacen );
                $o_ALM_TransaccionCabeceraBN->setIdTransaccionOperacion( $IdTransaccionOperacion );
                $o_ALM_TransaccionCabeceraBN->setFechaDocumento( $FechaDocumento );
                //$o_ALM_TransaccionCabeceraBN->setTipodeCambio( floatval( $TipodeCambio ) );
                $o_ALM_TransaccionCabeceraBN->setReferenciaTipoDocumento( $ReferenciaTipoDocumento );
                $o_ALM_TransaccionCabeceraBN->setReferenciaNumeroDocumento( $ReferenciaNumeroDocumento );
                $o_ALM_TransaccionCabeceraBN->setGuiaProveedor( $GuiaProveedor );
                $o_ALM_TransaccionCabeceraBN->setIdCompania( ( int ) $s_IdCompania );
                $o_ALM_TransaccionCabeceraBN->setIdTipoDocumento( $IdTipoDocumento );
                $o_ALM_TransaccionCabeceraBN->setComentario( $Comentario );
                // FIN SETEO CABACERA
                
                //AQUI SE EMPIEZA EL SETEO DE LOS DETALLES
                $s_IdItem     = $o_ALM_InventarioFisicoDetalleBN->getIdItem();
                $i_Cantidad   = abs( $o_ALM_InventarioFisicoDetalleBN->getStockDiferencia() );
                $s_IdUnidad   = $o_ALM_InventarioFisicoDetalleBN->getIdUnidad();
                $s_RefTipoDoc = ALM_InventarioFisicoDetalleBN::TIPO_DOCUMENTO_REFERENCIA;
                $s_RefNumDoc  = $o_ALM_InventarioFisicoDetalleBN->getIdNumeroInventario();
                $f_PrUnitario = floatval( $o_ALM_InventarioFisicoDetalleBN->getPrecioUnitario() );
                $i_RefSecuen  = ( int ) $o_ALM_InventarioFisicoDetalleBN->getIdSecuencia();
                
                $o_ALM_TransaccionDetalleBN = new ALM_TransaccionDetalleBN();
                $o_ALM_TransaccionDetalleBN->setIdItem( $s_IdItem );
                $o_ALM_TransaccionDetalleBN->setIdAlmacen( $IdAlmacen );
                $o_ALM_TransaccionDetalleBN->setCantidad( floatval( $i_Cantidad ) );
                $o_ALM_TransaccionDetalleBN->setUnidadCodigo( $s_IdUnidad );
                $o_ALM_TransaccionDetalleBN->setReferenciaTipoDocumento( $s_RefTipoDoc );
                $o_ALM_TransaccionDetalleBN->setReferenciaNumeroDocumento( $s_RefNumDoc );
                $o_ALM_TransaccionDetalleBN->setReferenciaSecuencia( $i_RefSecuen );
                $o_ALM_TransaccionDetalleBN->setPrecioUnitario( $f_PrUnitario );
                
                //SE BUSCA EL STOCK UNIDADES - PARA REALIZAR EL MOVIMIENTO MAS ADELANTE
                $o_Tmp_ALM_TransaccionCabeceraBN = $o_ALM_TransaccionCabeceraBN;
                $o_Tmp_ALM_TransaccionDetalleBN  = $o_ALM_TransaccionDetalleBN;
                $o_ALM_ItemAlmacenStockFN = new ALM_ItemAlmacenStockFN();
                $o_ALM_ItemAlmacenStockBN = $o_ALM_ItemAlmacenStockFN->selectByPK( myUser::getUser()->getIdBusiness(), $s_IdItem, $IdAlmacen, ALM_ItemAlmacenStockBN::CONDICION_POR_DEFECTO, ALM_ItemAlmacenStockBN::LOTE_POR_DEFECTO );
                if( $o_ALM_ItemAlmacenStockBN )
                {
                    $b_ControlIng = false;
                    $f_CantidadUnidades  = $o_ALM_ItemAlmacenStockBN->getStockActualDoble();
                    $i_SumaCantidadUni   = ALM_InventarioFisicoDetalleFN::buscarCantidadUndidades( $s_IdCompania, $ReferenciaNumeroDocumento, $i_RefSecuen );
                    $f_CantidadUnidadDif = $i_SumaCantidadUni - $f_CantidadUnidades;
                    if( $IdTransaccionOperacion == ALM_TransaccionCabeceraBN::TIPO_INGRESO )
                    {
                        if( $f_CantidadUnidadDif >= 0 )
                        {
                            //ES LO CORRECTO POR TEORIA
                            $o_ALM_TransaccionDetalleBN->setCantidadDoble( $f_CantidadUnidadDif );
                        }
                        else 
                        {
                            throw new Exception( "Error Interno por el Inventario. No concordo la Teoria por el Movimiento - Detalle, con las unidades." );
                        }
                    }
                    if( $IdTransaccionOperacion == ALM_TransaccionCabeceraBN::TIPO_SALIDA )
                    {
                        if( $f_CantidadUnidadDif <= 0 )
                        {
                            //ES LO CORRECTO POR TEORIA
                            $o_ALM_TransaccionDetalleBN->setCantidadDoble( abs( $f_CantidadUnidadDif ) );
                        }
                        else 
                        {
                            throw new Exception( "Error Interno por el Inventario. No concordo la Teoria por el Movimiento - Detalle, con las unidades." );
                        }
                    }
                }
                
                $a_MovientoDetalle   = array();
                $a_MovientoDetalle[] = $o_ALM_TransaccionDetalleBN;

                $o_ALM_TransaccionCabeceraBN->setArrayMovientoDetalle( $a_MovientoDetalle );
                //FIN BUSQUEDA DE LOS DETALLES

                //SE REALIZA EL MOVIMIENTO POR EL DETALLE PARA AJUSTAR LAS CANTIDAD
                //pr( $o_ALM_TransaccionCabeceraBN );
                if( $b_Control )
                {
                    $o_MovimientoBL = new MovimientoBL();
                    $b_Control = $o_MovimientoBL->GuardarMovientoTransaccion( $o_ALM_TransaccionCabeceraBN );
                    pr( "TRANSACCION POR LOS DETALLES ( $i_Key ) :" );
                    pr( $o_ALM_TransaccionCabeceraBN );
                }
                //FIN DEL MOVIMIENTO CABECERA

                //LUEGO DE REALIZAR EL MOVIMIENTO SE PREGUNTA SI HABRA MOVIMIENTO POR UNIDADES
                //NO SE PROGRAMA HASTA QUE SE ENCUENTRE UN CASO
                pr( "-----------------------------------------------------------------------------------------------------------------------------------" );
                $a_ALM_TransaccionDetalle = $o_ALM_TransaccionCabeceraBN->getArrayMovientoDetalle();
                foreach ( $a_ALM_TransaccionDetalle as $i_Key => $o_ALM_TransaccionDetalleBN )
                {
                    // ACTUALIZAR LLAVES COMO REFERENCIA EN LAS TABLAS DE INVENTARIO
                    $o_ALM_InventarioFisicoDetalleDP = new ALM_InventarioFisicoDetalleDP();
                    $o_ALM_InventarioFisicoDetalleDP->setIdCompania( ( int ) $s_IdCompania );
                    $o_ALM_InventarioFisicoDetalleDP->setIdNumeroInventario( $o_ALM_TransaccionDetalleBN->getReferenciaNumeroDocumento() );
                    $o_ALM_InventarioFisicoDetalleDP->setIdSecuencia( $o_ALM_TransaccionDetalleBN->getReferenciaSecuencia() );
                    
                    $o_ALM_InventarioFisicoDetalleDP->setIdTipoDocumentoRef( $o_ALM_TransaccionDetalleBN->getReferenciaTipoDocumento() );
                    $o_ALM_InventarioFisicoDetalleDP->setIdNumeroDocumentoRef( $o_ALM_TransaccionDetalleBN->getIdNumeroDocumento() );
                    $o_ALM_InventarioFisicoDetalleDP->setIdSecuenciaRef( $o_ALM_TransaccionDetalleBN->getIdSecuencia() );
                    
                    $b_Result = $o_ALM_InventarioFisicoDetalleDP->update();
                    /////FIN ACTUALIZAR TABLAS DE INVENTARIO
                    //SE REALIZA LAS DES DEMAS TRANSACCIONES
                    $this->EjecutarInventarioTruchasPensaje( $o_ALM_TransaccionDetalleBN );
                    //FIN DE LAS DEMAS TRANSACCIONES
                }
                pr( "-----------------------------------------------------------------------------------------------------------------------------------" );
            }
            
            $o_ALM_InventarioFisicoDP = new ALM_InventarioFisicoDP();
            $o_ALM_InventarioFisicoDP->setIdCompania( ( int ) $s_IdCompania );
            $o_ALM_InventarioFisicoDP->setIdNumeroInventario( $s_IdNumeroInventario );
            $o_ALM_InventarioFisicoDP->setEstado( ALM_InventarioFisicoBN::ESTADO_CERRADO );
            $b_Result = $o_ALM_InventarioFisicoDP->update();
            
            $con->commit();
            return true;
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( $o_Exception->getMessage() );
        }
    }
    
    private function EjecutarInventarioTruchasPensaje( $o_ALM_TransaccionDetalleOrgBN )
    {
        $s_IdCompania = myUser::getUser()->getIdBusiness();
        $o_ALM_InventarioFisicoPesajeFN = new ALM_InventarioFisicoPesajeFN();
        $o_ALM_InventarioFisicoPesajeFN->setIdCompania( ( int ) $s_IdCompania );
        $o_ALM_InventarioFisicoPesajeFN->setIdNumeroInventario( $o_ALM_TransaccionDetalleOrgBN->getReferenciaNumeroDocumento() );
        $o_ALM_InventarioFisicoPesajeFN->setIdSecuencia( $o_ALM_TransaccionDetalleOrgBN->getReferenciaSecuencia() );
        $a_ALM_InventarioFisicoPesaje = $o_ALM_InventarioFisicoPesajeFN->select();
        foreach ( $a_ALM_InventarioFisicoPesaje as $i_Key => $a_ALM_InventarioFisicoPesajeBN )
        {
            $s_CorrelativoPesaje = $this->getCorrelativoPorPesaje();
            $s_TipoDocRefPesaje  = ALM_InventarioFisicoPesajeBN::TIPO_DOC_REFERENCIA;
            //PRIMER CABECERA Y DETALLE - SALIDA:
            //CABECERA - 1
            $IdTransaccion              = ALM_InventarioFisicoPesajeBN::TIPO_ID_TRANSACCION_E;
            $IdTipoDocumento            = ALM_InventarioFisicoPesajeBN::TIPO_DOCUMENTO_SAL;
            $IdAlmacen                  = $o_ALM_TransaccionDetalleOrgBN->getIdAlmacen();
            $IdTransaccionOperacion     = ALM_TransaccionCabeceraBN::TIPO_SALIDA;
            $FechaDocumento             = date( "Y-m-d" );
            $ReferenciaTipoDocumento    = $s_TipoDocRefPesaje;
            $ReferenciaNumeroDocumento  = $s_CorrelativoPesaje;
            $GuiaProveedor              = "";
            $Comentario                 = "PESAJE SALIDA";
            
            $o_ALM_TransaccionCabeceraBN = new ALM_TransaccionCabeceraBN();
            $o_ALM_TransaccionCabeceraBN->setIdTransaccion( $IdTransaccion );
            $o_ALM_TransaccionCabeceraBN->setIdTipoDocumento( $IdTipoDocumento );
            //$o_ALM_TransaccionCabeceraBN->setAlmacenTraslado( $AlmacenTraslado );
            $o_ALM_TransaccionCabeceraBN->setIdAlmacen( $IdAlmacen );
            $o_ALM_TransaccionCabeceraBN->setIdTransaccionOperacion( $IdTransaccionOperacion );
            $o_ALM_TransaccionCabeceraBN->setFechaDocumento( $FechaDocumento );
            //$o_ALM_TransaccionCabeceraBN->setTipodeCambio( floatval( $TipodeCambio ) );
            $o_ALM_TransaccionCabeceraBN->setReferenciaTipoDocumento( $ReferenciaTipoDocumento );
            $o_ALM_TransaccionCabeceraBN->setReferenciaNumeroDocumento( $ReferenciaNumeroDocumento );
            $o_ALM_TransaccionCabeceraBN->setGuiaProveedor( $GuiaProveedor );
            $o_ALM_TransaccionCabeceraBN->setIdCompania( ( int ) $s_IdCompania );
            $o_ALM_TransaccionCabeceraBN->setComentario( $Comentario );
            //FIN CABECERA - 1
            
            //DETALLE - 1
            $s_IdItem     = $o_ALM_TransaccionDetalleOrgBN->getIdItem();
            $i_Cantidad   = $a_ALM_InventarioFisicoPesajeBN->getStockFisico();
            $i_CantidadUni= $a_ALM_InventarioFisicoPesajeBN->getStockUnidades(); //nuevo
            $s_IdUnidad   = $a_ALM_InventarioFisicoPesajeBN->getIdUnidad();
            $s_RefTipoDoc = ALM_InventarioFisicoDetalleBN::TIPO_DOCUMENTO_REFERENCIA;
            $s_RefNumDoc  = $a_ALM_InventarioFisicoPesajeBN->getIdNumeroInventario();
            $f_PrUnitario = floatval( $o_ALM_TransaccionDetalleOrgBN->getPrecioUnitario() );
            $i_RefSecuen  = ( int ) $a_ALM_InventarioFisicoPesajeBN->getIdPesaje();
            
            $o_ALM_TransaccionDetalleBN = new ALM_TransaccionDetalleBN();
            $o_ALM_TransaccionDetalleBN->setIdItem( $s_IdItem );
            $o_ALM_TransaccionDetalleBN->setCantidad( floatval( $i_Cantidad ) );
            $o_ALM_TransaccionDetalleBN->setCantidadDoble( floatval( $i_CantidadUni ) ); //nuevo
            $o_ALM_TransaccionDetalleBN->setUnidadCodigo( $s_IdUnidad );
            $o_ALM_TransaccionDetalleBN->setReferenciaTipoDocumento( $s_RefTipoDoc );
            $o_ALM_TransaccionDetalleBN->setReferenciaNumeroDocumento( $s_RefNumDoc );
            $o_ALM_TransaccionDetalleBN->setReferenciaSecuencia( $i_RefSecuen );
            $o_ALM_TransaccionDetalleBN->setPrecioUnitario( $f_PrUnitario );
            
            $a_MovientoDetalle   = null;
            $a_MovientoDetalle[] = $o_ALM_TransaccionDetalleBN;
            
            $o_ALM_TransaccionCabeceraBN->setArrayMovientoDetalle( $a_MovientoDetalle );

            $o_MovimientoBL = new MovimientoBL();
            $b_Control = $o_MovimientoBL->GuardarMovientoTransaccion( $o_ALM_TransaccionCabeceraBN );
            pr( "TRANSACCION $Comentario( MOV PESAJE $i_Key ):" );
            pr( $o_ALM_TransaccionCabeceraBN );
            sleep( 1 );
            //FIN DETALLE - 1
            //FIN DEL PRIMER CABECERA Y DETALLE - SALIDA
            
            pr( "-----------------------------------------------------------" );
            
            //PRIMER CABECERA Y DETALLE - INGRESO:
            //CABECERA - 2
            $IdTransaccion              = ALM_InventarioFisicoPesajeBN::TIPO_ID_TRANSACCION_I;
            $IdTipoDocumento            = ALM_InventarioFisicoPesajeBN::TIPO_DOCUMENTO_ING;
            $IdAlmacen                  = $a_ALM_InventarioFisicoPesajeBN->getIdAlmacenDestino();
            $IdTransaccionOperacion     = ALM_TransaccionCabeceraBN::TIPO_INGRESO;
            $FechaDocumento             = date( "Y-m-d" );
            $ReferenciaTipoDocumento    = $s_TipoDocRefPesaje;
            $ReferenciaNumeroDocumento  = $s_CorrelativoPesaje;
            $GuiaProveedor              = "";
            $Comentario                 = "PESAJE INGRESO";
            
            $o_ALM_TransaccionCabeceraBN = new ALM_TransaccionCabeceraBN();
            $o_ALM_TransaccionCabeceraBN->setIdTransaccion( $IdTransaccion );
            $o_ALM_TransaccionCabeceraBN->setIdTipoDocumento( $IdTipoDocumento );
            //$o_ALM_TransaccionCabeceraBN->setAlmacenTraslado( $AlmacenTraslado );
            $o_ALM_TransaccionCabeceraBN->setIdAlmacen( $IdAlmacen );
            $o_ALM_TransaccionCabeceraBN->setIdTransaccionOperacion( $IdTransaccionOperacion );
            $o_ALM_TransaccionCabeceraBN->setFechaDocumento( $FechaDocumento );
            //$o_ALM_TransaccionCabeceraBN->setTipodeCambio( floatval( $TipodeCambio ) );
            $o_ALM_TransaccionCabeceraBN->setReferenciaTipoDocumento( $ReferenciaTipoDocumento );
            $o_ALM_TransaccionCabeceraBN->setReferenciaNumeroDocumento( $ReferenciaNumeroDocumento );
            $o_ALM_TransaccionCabeceraBN->setGuiaProveedor( $GuiaProveedor );
            $o_ALM_TransaccionCabeceraBN->setIdCompania( ( int ) $s_IdCompania );
            $o_ALM_TransaccionCabeceraBN->setComentario( $Comentario );
            //FIN CABECERA
            
            //DETALLE - 2
            $s_IdItem     = $a_ALM_InventarioFisicoPesajeBN->getIdItemDestino();
            $i_Cantidad   = $a_ALM_InventarioFisicoPesajeBN->getStockFisico();
            $i_CantidadUni= $a_ALM_InventarioFisicoPesajeBN->getStockUnidades(); //nuevo
            $s_IdUnidad   = $a_ALM_InventarioFisicoPesajeBN->getIdUnidad();
            $s_RefTipoDoc = ALM_InventarioFisicoDetalleBN::TIPO_DOCUMENTO_REFERENCIA;
            $s_RefNumDoc  = $a_ALM_InventarioFisicoPesajeBN->getIdNumeroInventario();
            $f_PrUnitario = floatval( $o_ALM_TransaccionDetalleOrgBN->getPrecioUnitario() );
            $i_RefSecuen  = ( int ) $a_ALM_InventarioFisicoPesajeBN->getIdPesaje();
            
            $o_ALM_TransaccionDetalleBN = new ALM_TransaccionDetalleBN();
            $o_ALM_TransaccionDetalleBN->setIdItem( $s_IdItem );
            $o_ALM_TransaccionDetalleBN->setCantidad( floatval( $i_Cantidad ) );
            $o_ALM_TransaccionDetalleBN->setCantidadDoble( floatval( $i_CantidadUni ) ); //nuevo
            $o_ALM_TransaccionDetalleBN->setUnidadCodigo( $s_IdUnidad );
            $o_ALM_TransaccionDetalleBN->setReferenciaTipoDocumento( $s_RefTipoDoc );
            $o_ALM_TransaccionDetalleBN->setReferenciaNumeroDocumento( $s_RefNumDoc );
            $o_ALM_TransaccionDetalleBN->setReferenciaSecuencia( $i_RefSecuen );
            $o_ALM_TransaccionDetalleBN->setPrecioUnitario( $f_PrUnitario );
            
            $a_MovientoDetalle   = null;
            $a_MovientoDetalle[] = $o_ALM_TransaccionDetalleBN;
            
            $o_ALM_TransaccionCabeceraBN->setArrayMovientoDetalle( $a_MovientoDetalle );

            $o_MovimientoBL = new MovimientoBL();
            $b_Control = $o_MovimientoBL->GuardarMovientoTransaccion( $o_ALM_TransaccionCabeceraBN );
            pr( "TRANSACCION $Comentario( MOV $i_Key ):" );
            pr( $o_ALM_TransaccionCabeceraBN );
            sleep( 1 );
            //FIN DETALLE - 2
            //FIN DEL PRIMER CABECERA Y DETALLE - INGRESO
            pr( "-----------------------------------------------------------" );
            
            //AHORA SE ACTUALIZAR LA REFERENCIA
            $o_ALM_InventarioFisicoPesajeDP = new ALM_InventarioFisicoPesajeDP();
            $o_ALM_InventarioFisicoPesajeDP->setIdCompania( ( int ) $a_ALM_InventarioFisicoPesajeBN->getIdCompania() );
            $o_ALM_InventarioFisicoPesajeDP->setIdNumeroInventario( $a_ALM_InventarioFisicoPesajeBN->getIdNumeroInventario() );
            $o_ALM_InventarioFisicoPesajeDP->setIdSecuencia( $a_ALM_InventarioFisicoPesajeBN->getIdSecuencia() );
            $o_ALM_InventarioFisicoPesajeDP->setIdPesaje( $a_ALM_InventarioFisicoPesajeBN->getIdPesaje() );
            $o_ALM_InventarioFisicoPesajeDP->setIdTipoDocumentoRef( $s_TipoDocRefPesaje );
            $o_ALM_InventarioFisicoPesajeDP->setIdNumeroDocumentoRef( $s_CorrelativoPesaje );
            $o_ALM_InventarioFisicoPesajeDP->setIdSecuenciaRef( $a_ALM_InventarioFisicoPesajeBN->getIdPesaje() );
            $b_Result = $o_ALM_InventarioFisicoPesajeDP->update();
        }
    }
    
    private function getCorrelativoPorPesaje()
    {
        $o_utilGenerateId = new utilGenerateId();
        $o_utilGenerateId->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_utilGenerateId->setTipoCorrelativo( "INV" );
        $o_utilGenerateId->setSerie( "PES" );
        $i_Id = $o_utilGenerateId->generateStringId();
        return $i_Id;
    }
    
    public function AnularInventario( ALM_InventarioFisicoBN $o_ALM_InventarioFisicoBN ) 
    {
        $con = Conexion::getConexion();
        $con->begin();
        try 
        {
            $o_ALM_InventarioFisicoFN = new ALM_InventarioFisicoFN();
            $o_ALM_InventarioFisicoBN = $o_ALM_InventarioFisicoFN->selectByPK( $o_ALM_InventarioFisicoBN->getIdCompania(), $o_ALM_InventarioFisicoBN->getIdNumeroInventario() );
            
            if( $o_ALM_InventarioFisicoBN->getEstado() == ALM_InventarioFisicoBN::ESTADO_PENDIENTE )
            {
                $o_ALM_InventarioFisicoDP = new ALM_InventarioFisicoDP();
                $o_ALM_InventarioFisicoDP->setIdCompania( $o_ALM_InventarioFisicoBN->getIdCompania() );
                $o_ALM_InventarioFisicoDP->setIdNumeroInventario( $o_ALM_InventarioFisicoBN->getIdNumeroInventario() );
                $o_ALM_InventarioFisicoDP->setEstado( ALM_InventarioFisicoBN::ESTADO_ANULADO );
                $b_Result = $o_ALM_InventarioFisicoDP->update();
                if( $b_Result )
                {
                    $o_ALM_InventarioFisicoDetalleFN = new ALM_InventarioFisicoDetalleFN();
                    $o_ALM_InventarioFisicoDetalleFN->setIdCompania( $o_ALM_InventarioFisicoBN->getIdCompania() );
                    $o_ALM_InventarioFisicoDetalleFN->setIdNumeroInventario( $o_ALM_InventarioFisicoBN->getIdNumeroInventario() );
                    $a_ALM_InventarioFisicoDetalle = $o_ALM_InventarioFisicoDetalleFN->select();
                    if( $a_ALM_InventarioFisicoDetalle )
                    {
                        foreach ( $a_ALM_InventarioFisicoDetalle as $i_Key => $o_ALM_InventarioFisicoDetalleBN )
                        {
                            $o_ALM_InventarioFisicoDetalleDP = new ALM_InventarioFisicoDetalleDP();
                            $o_ALM_InventarioFisicoDetalleDP->setIdCompania( $o_ALM_InventarioFisicoBN->getIdCompania() );
                            $o_ALM_InventarioFisicoDetalleDP->setIdNumeroInventario( $o_ALM_InventarioFisicoBN->getIdNumeroInventario() );
                            $o_ALM_InventarioFisicoDetalleDP->setIdSecuencia( $o_ALM_InventarioFisicoDetalleBN->getIdSecuencia() );
                            $o_ALM_InventarioFisicoDetalleDP->setEstado( ALM_InventarioFisicoBN::ESTADO_ANULADO );
                            $b_Result = $o_ALM_InventarioFisicoDetalleDP->update();
                        }
                    }
                }
            }
            else 
            {
                throw new Exception( "No se puede Anular el Inventario por tener el estado ".ALM_InventarioFisicoBN::getArrayEstados( $o_ALM_InventarioFisicoBN->getEstado() ) );
            }
            $con->commit();
            return true;
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( $o_Exception->getMessage() );
        }
    }
}