<?php
class GrupoPromocionBL
{
    public function guardarPromocion( PR_GrupoBN $o_PR_GrupoBN )
    {
        $con = Conexion::getConexion();
        $con->begin();
        try 
        {
            $this->validarValoresxDefecto( $o_PR_GrupoBN );
            
            $b_Result = false;
            $o_PR_GrupoDP = new PR_GrupoDP( $o_PR_GrupoBN );
            if( $o_PR_GrupoBN->getIdPrGrupo() )
            {
                $o_PR_GrupoDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_PR_GrupoDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $b_Result = $o_PR_GrupoDP->update();
            }
            else
            {
                $s_IdPrGrupo = $o_PR_GrupoDP->generaPromoId();
                
                $o_PR_GrupoDP->setIdPrGrupo( $s_IdPrGrupo );
                $o_PR_GrupoBN->setIdPrGrupo( $s_IdPrGrupo );
                $o_PR_GrupoDP->setEstado( PR_GrupoBN::ESTADO_PENDIENTE );
                $o_PR_GrupoDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_PR_GrupoDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_PR_GrupoDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_PR_GrupoDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $b_Result = $o_PR_GrupoDP->save();
                
                if( $b_Result )
                {
                    $o_ALM_ItemMastFN = new ALM_ItemMastFN();
                    $o_ALM_ItemMastFN->setIdLinea( $o_PR_GrupoBN->getIdLinea() );
                    $o_ALM_ItemMastFN->setIdFamilia( $o_PR_GrupoBN->getIdFamilia() );
                    $o_ALM_ItemMastFN->setEstado( "A" );
                    $a_ALM_ItemMast = $o_ALM_ItemMastFN->select();
                    if( $a_ALM_ItemMast )
                    {
                        foreach ( $a_ALM_ItemMast as $i_Key => $o_ALM_ItemMastBN )
                        {
                            $o_PR_GrupoBN->setObjectItemMastBN( $o_ALM_ItemMastBN );
                            $this->agregarItemConPromocion( $o_PR_GrupoBN );
                        }
                    }
                }
            }
            $this->aplicarExpiracionPromocion();
            
            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( $o_Exception->getMessage() ) ;
        }
        return true;
    }
    
    private function validarValoresxDefecto( PR_GrupoBN $o_PR_GrupoBN )
    {
        if( $o_PR_GrupoBN->getIdLinea() )
        {
            $o_PR_GrupoBN->setIdLinea( ( int ) $o_PR_GrupoBN->getIdLinea() );
        }
        if( $o_PR_GrupoBN->getIdFamilia() )
        {
            $o_PR_GrupoBN->setIdFamilia( ( int ) $o_PR_GrupoBN->getIdFamilia() );
        }
    }
    
    public function agregarItemConPromocion( PR_GrupoBN $o_PR_GrupoBN )
    {
        $f_Porcentaje = floatval( $o_PR_GrupoBN->getValor() ) / 100;
        $o_ALM_ItemMastBN = $o_PR_GrupoBN->getObjectItemMastBN();
        
        $o_MST_ListaPrecioDetalleFN = new MST_ListaPrecioDetalleFN();
        $o_MST_ListaPrecioDetalleBN = $o_MST_ListaPrecioDetalleFN->selectByPK( $o_PR_GrupoBN->getIdCompania(), $o_PR_GrupoBN->getIdSucursal(), $o_ALM_ItemMastBN->getIdItem(), 1 );
        if( $o_MST_ListaPrecioDetalleBN )
        {
            $f_PrecioVenta = $o_MST_ListaPrecioDetalleBN->getPrecioVenta();
            $f_Buffer      = utilMath::fnround( $f_PrecioVenta * $f_Porcentaje, 2 );
            $f_PrecioVentaDscto = $f_PrecioVenta - $f_Buffer;
        
            $o_PR_ListaItemDP = new PR_ListaItemDP();
            $o_PR_ListaItemDP->setIdPrGrupo( $o_PR_GrupoBN->getIdPrGrupo() );
            $o_PR_ListaItemDP->setIdPrListaItem( $o_PR_ListaItemDP->recuperarId() );
            $o_PR_ListaItemDP->setIdItem( $o_ALM_ItemMastBN->getIdItem() );
            $o_PR_ListaItemDP->setTipoPrecio( 1 );
            $o_PR_ListaItemDP->setPrecioVenta( $f_PrecioVenta );
            $o_PR_ListaItemDP->setPrecioDscto( $f_PrecioVentaDscto );
            $o_PR_ListaItemDP->setBufferDscto( $f_Buffer );
            $o_PR_ListaItemDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
            $o_PR_ListaItemDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
            $b_Result = $o_PR_ListaItemDP->save();
        }
        return true;
    }
    
    public function publicarPromocion( PR_GrupoBN $o_PR_GrupoBN )
    {
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            $o_PR_GrupoDP = new PR_GrupoDP( $o_PR_GrupoBN );
            $o_PR_GrupoDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_PR_GrupoDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_PR_GrupoDP->setEstado( PR_GrupoBN::ESTADO_PUBLICADO );
            $b_Result = $o_PR_GrupoDP->update();
            
            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( $o_Exception->getMessage() ) ;
        }
        return true;
    }
    
    public function aplicarExpiracionPromocion()
    {
        $o_PR_GrupoFN = new PR_GrupoFN();
        $o_PR_GrupoFN->setEstado( PR_GrupoBN::ESTADO_PUBLICADO );
        $a_PR_Grupo = $o_PR_GrupoFN->select();
        foreach ( $a_PR_Grupo as $i_Key => $o_PR_GrupoBN )
        {
            $o_PR_GrupoBN->getFechaInicio();
            $s_FechaExpiracion = $o_PR_GrupoBN->getFechaExpiracion();
            $b_Result = UtilDate::validarFecha1Mayor( date( "Y-m-d" ), $s_FechaExpiracion );
            if( $b_Result )
            {
                $this->expirarPromocion( $o_PR_GrupoBN );
            }
        }
    }
    
    public function anularPromocion( PR_GrupoBN $o_PR_GrupoBN )
    {
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            $o_PR_GrupoDP = new PR_GrupoDP( $o_PR_GrupoBN );
            $o_PR_GrupoDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_PR_GrupoDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_PR_GrupoDP->setEstado( PR_GrupoBN::ESTADO_ANULADO );
            $b_Result = $o_PR_GrupoDP->update();
            
            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( $o_Exception->getMessage() ) ;
        }
        return true;
    }
    
    public function reAbrirPromocion( PR_GrupoBN $o_PR_GrupoBN )
    {
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            $o_PR_GrupoDP = new PR_GrupoDP( $o_PR_GrupoBN );
            $o_PR_GrupoDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_PR_GrupoDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_PR_GrupoDP->setEstado( PR_GrupoBN::ESTADO_PENDIENTE );
            $b_Result = $o_PR_GrupoDP->update();
        
            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( $o_Exception->getMessage() ) ;
        }
        return true;
    }
    
    public function expirarPromocion( PR_GrupoBN $o_PR_GrupoBN )
    {
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            $o_PR_GrupoDP = new PR_GrupoDP( $o_PR_GrupoBN );
            $o_PR_GrupoDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_PR_GrupoDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_PR_GrupoDP->setEstado( PR_GrupoBN::ESTADO_EXPIRADO );
            $b_Result = $o_PR_GrupoDP->update();
    
            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( $o_Exception->getMessage() ) ;
        }
        return true;
    }
}
