<?php
class FacturacionElectronicaBL
{
    private function recuperarInfoDocumento( VTA_FacturacionElectronicaBN $o_VTA_FacturacionElectronicaBN )
    {
        //ahora buscamos el documento
        $o_VTA_DocumentoFN = new VTA_DocumentoFN();
        $o_VTA_DocumentoBN = $o_VTA_DocumentoFN->selectByPK( $o_VTA_FacturacionElectronicaBN->getTipo(), $o_VTA_FacturacionElectronicaBN->getIdCompania(), $o_VTA_FacturacionElectronicaBN->getFactElecId() );

        if( $o_VTA_DocumentoBN )
        {
            if( !$o_VTA_DocumentoBN->getCodigoFiscalxTipoDocumento() )
            {
                return false;
            }

            //$o_MST_PersonaMastBN = MST_PersonaMastFN::buscarClientePorId( $o_VTA_DocumentoBN->getClienteNumero() );
            $o_VTA_FacturacionElectronicaBN->setIdCompania( intval( $o_VTA_FacturacionElectronicaBN->getIdCompania() ) );
            $o_VTA_FacturacionElectronicaBN->setFactElecId( intval( $o_VTA_FacturacionElectronicaBN->getFactElecId() ) );
            $o_VTA_FacturacionElectronicaBN->setSerie( $o_VTA_DocumentoBN->getDocumentoSerie() );
            $o_VTA_FacturacionElectronicaBN->setNumero( $o_VTA_DocumentoBN->getDocumentoNUmero() );
            $o_VTA_FacturacionElectronicaBN->setFechaEmision( $o_VTA_DocumentoBN->getFechaDocumento() );
            if( UtilDate::validarFecha1Mayor( $o_VTA_DocumentoBN->getFechaVencimiento(), $o_VTA_DocumentoBN->getFechaDocumento() ) )
            {
                $o_VTA_FacturacionElectronicaBN->setFechaVencimiento( $o_VTA_DocumentoBN->getFechaVencimiento() );
            }
            $o_VTA_FacturacionElectronicaBN->setTipoComprobante( $o_VTA_DocumentoBN->getCodigoFiscalPrsxTipoDocumento() );
            $o_VTA_FacturacionElectronicaBN->setTipoComprobanteDesc( $o_VTA_DocumentoBN->getTipoDocumentoDesc() );
            $o_VTA_FacturacionElectronicaBN->setSerieNum( $o_VTA_DocumentoBN->getDocumentoTipoSerieNumero() );
            $o_VTA_FacturacionElectronicaBN->setClienteTipoDoc( $o_VTA_DocumentoBN->getClienteTipoDoc() );
            $o_VTA_FacturacionElectronicaBN->setClienteDocNum( $o_VTA_DocumentoBN->getClienteRUC() );
            $o_VTA_FacturacionElectronicaBN->setCodCliente( $o_VTA_DocumentoBN->getClienteNumero() );
            $o_VTA_FacturacionElectronicaBN->setClienteNom( $o_VTA_DocumentoBN->getClienteNombre() );
            $o_VTA_FacturacionElectronicaBN->setClienteDireccion( $o_VTA_DocumentoBN->getClienteDireccion() );
            $o_VTA_FacturacionElectronicaBN->setClienteEmail( $o_VTA_DocumentoBN->getObjectCliente()->getEmail() );
            $o_VTA_FacturacionElectronicaBN->setTipoMoneda( $o_VTA_DocumentoBN->getMonedaDocumento() );
            ////////////////////////////////////////////////////////////////////////////////////////////////////////
            //aquie el tipo de cambio tiene q ser el de venta de la sunat
            $f_TipodeCambio = GSS_TipoCambioFN::getStaticTipoCambioVenta( substr( $o_VTA_DocumentoBN->getFechaDocumento(), 0, 10 ) );
            $o_VTA_FacturacionElectronicaBN->setTipoCambio( $f_TipodeCambio );
            ////////////////////////////////////////////////////////////////////////////////////////////////////////
            if( $o_VTA_DocumentoBN->esGravadaConImpuesto() )
            {
                $o_VTA_FacturacionElectronicaBN->setPorcentajeIGV( 18.00 );
            }
            else
            {
                $o_VTA_FacturacionElectronicaBN->setPorcentajeIGV( 0 );
            }
            $o_VTA_FacturacionElectronicaBN->setMontoDescuento( round( $o_VTA_DocumentoBN->getMontoDescuentos(), 2 ) );
            $o_VTA_FacturacionElectronicaBN->setMontoAnticipo( $o_VTA_DocumentoBN->getMontoAnticipo() );
            $o_VTA_FacturacionElectronicaBN->setMontoExonerado( $o_VTA_DocumentoBN->getMontoExonerado() );
            $o_VTA_FacturacionElectronicaBN->setMontoAfecto( $o_VTA_DocumentoBN->getMontoAfecto() );
            $o_VTA_FacturacionElectronicaBN->setMontoInafecto( $o_VTA_DocumentoBN->getMontoNoAfecto() );
            $o_VTA_FacturacionElectronicaBN->setSubTotal( round( $o_VTA_DocumentoBN->getMontoSubTotal(), 2 ) );
            $o_VTA_FacturacionElectronicaBN->setImpuesto( round( $o_VTA_DocumentoBN->getMontoImpuestos(), 2 ) );
            $o_VTA_FacturacionElectronicaBN->setMontoTotal( round( $o_VTA_DocumentoBN->getMontoTotal(), 2 ) );
            $o_VTA_FacturacionElectronicaBN->setEstadoWeb( $o_VTA_DocumentoBN->getEstado() );

            $o_VTA_FacturacionElectronicaBN->setUsuarioCreacion( myUser::getUser()->getUserId() );
            //$o_VTA_FacturacionElectronicaBN->setFechaCreacion( date( "Y-m-d H:i:s" ) ); 
            $o_VTA_FacturacionElectronicaBN->setUsuarioModificacion( myUser::getUser()->getUserId() );
            //$o_VTA_FacturacionElectronicaBN->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            
            return true;
        }
        return false;
    }

    public function registrarBandeja( VTA_FacturacionElectronicaBN $o_VTA_FacturacionElectronicaBN )
    {
        //validacion por el tipo de documentos admitidos para la facturacion electronica
        $o_VTA_TipoDocumentoFN = new VTA_TipoDocumentoFN();
        $o_VTA_TipoDocumentoBN = $o_VTA_TipoDocumentoFN->selectByPK( $o_VTA_FacturacionElectronicaBN->getTipo() );
        if( $o_VTA_TipoDocumentoBN )
        {
            if( $o_VTA_TipoDocumentoBN->getEsFiscalFlag() != "S" )
            {
                return false;
            }
        }

        $con = Conexion::getConexion();
        $con->begin();

        $b_Result = true;

        try
        {
            myUser::getUser()->validar_session();

            if( !$o_VTA_FacturacionElectronicaBN->getFactElecId() )
            {
                throw new Exception( "El Id Factura es importante." );
            }

            //se valida si ya existe el documento
            $o_VTA_FacturacionElectronicaFN = new VTA_FacturacionElectronicaFN();
            $o_ObjRs = $o_VTA_FacturacionElectronicaFN->selectByPK( $o_VTA_FacturacionElectronicaBN->getFactElecId() );
            if( $o_ObjRs )
            {
                throw new Exception( "El Id Factura ya se encuentra registrado." );
            }

            $b_Result = $this->recuperarInfoDocumento( $o_VTA_FacturacionElectronicaBN );

            if( $b_Result )
            {
                $o_VTA_FacturacionElectronicaBN->setIdSucursal( myUser::getUser()->getIdSucursal() );
                $o_VTA_FacturacionElectronicaDP = new VTA_FacturacionElectronicaDP( $o_VTA_FacturacionElectronicaBN );
                $o_VTA_FacturacionElectronicaDP->save();
            }

            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( "FAEL/RB: ".$o_Exception->getMessage() );
        }

        return $b_Result;
    }

    public function anularComprobante( VTA_FacturacionElectronicaBN $o_VTA_FacturacionElectronicaBN )
    {
        $con = Conexion::getConexion();
        $con->begin();

        $b_Result = true;

        try
        {
            myUser::getUser()->validar_session();

            if( !$o_VTA_FacturacionElectronicaBN->getFactElecId() )
            {
                throw new Exception( "El Id Factura es importante." );
            }

            $s_Motivo = $o_VTA_FacturacionElectronicaBN->getAnuMotivo();

            //aqui se pregunta si esta enviado a la sunat, sino, no se actualiza nada
            $o_VTA_FacturacionElectronicaFN = new VTA_FacturacionElectronicaFN();
            $o_TMP_VTA_FacturacionElectronicaBN = $o_VTA_FacturacionElectronicaFN->selectByPK( $o_VTA_FacturacionElectronicaBN->getFactElecId() );
            if( $o_TMP_VTA_FacturacionElectronicaBN )
            {
                //var_dump( $o_VTA_FacturacionElectronicaBN );
                /*if( $o_VTA_FacturacionElectronicaBN->getAceptadaxSunat() == "NO" || !$o_VTA_FacturacionElectronicaBN->getAceptadaxSunat() )
                {
                    $con->commit();
                    return $b_Result;
                }*/

                $o_VTA_FacturacionElectronicaDP = new VTA_FacturacionElectronicaDP();
                $o_VTA_FacturacionElectronicaDP->setFactElecId( intval( $o_VTA_FacturacionElectronicaBN->getFactElecId() ) );
                $o_VTA_FacturacionElectronicaDP->setEstadoWeb( VTA_DocumentoBN::ESTADO_ANULADO );
                $o_VTA_FacturacionElectronicaDP->setAnuMotivo( $s_Motivo );
                $o_VTA_FacturacionElectronicaDP->setAnuAceptadaPorSunat( "NO" );
                $o_VTA_FacturacionElectronicaDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_VTA_FacturacionElectronicaDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_VTA_FacturacionElectronicaDP->update();
            }
            else
            {
                throw new Exception( "No existe el comprobante." );
            }

            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( "FAEL/AC: ".$o_Exception->getMessage() );
        }

        return $b_Result;
    }
}