<?php
class CotizacionesBL
{
    private function validacionesParametros( VTA_OrdenBN &$o_VTA_OrdenBN )
    {
        if( !$o_VTA_OrdenBN->getOrdenImpuestoFlag() )
        {
            $o_VTA_OrdenBN->getOrdenImpuestoFlag( "Y" );
        }
    }

    public function iniciarOrdenVenta( VTA_OrdenBN $o_VTA_OrdenBN )
    {
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            myUser::getUser()->validar_session();
            
            
            if( !GSS_TipoCambioFN::getStaticTipoCambioCobranza() )
            {
                if( $o_VTA_OrdenBN->getMonedaCambioValor() )
                {
                    $o_VTA_OrdenBN->setMonedaCambioValor( $o_VTA_OrdenBN->getMonedaCambioValor() );
                }
                else
                {
                    throw new Exception( "Debe de registrar el Tipo de Cambio de hoy." );
                }
            }
            else
            {
                $o_VTA_OrdenBN->setMonedaCambioValor( GSS_TipoCambioFN::getStaticTipoCambioCobranza() );
            }
            
            //ahora la validacion de tipo de cambio es, si es local 1
            /*if( $o_VTA_OrdenBN->getMonedaCod() == "LO" )
            {
                $o_VTA_OrdenBN->setMonedaCambioValor( 1 );
            }*/
            
            usleep( 100000 );
            
            if( !$o_VTA_OrdenBN->getOrdenId() )
            {

                $a_Ids = VTA_OrdenDP::generarId( $o_VTA_OrdenBN->getOrdenTipoId() );
            
                $o_VTA_OrdenBN->setOrdenId( $a_Ids['id'] );
                $o_VTA_OrdenBN->setOrdenNum( $a_Ids['cod'] );
                
                $o_VTA_OrdenDP = new VTA_OrdenDP( $o_VTA_OrdenBN );
                $o_VTA_OrdenDP->save();
            }
            else
            {
                /////////////////////////////////////////////////////////////////////////////////////////////////////////////
                //validacion por el cambio de moneda - 2020-07-15
                $o_VTA_OrdenFN = new VTA_OrdenFN();
                $o_TMP_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $o_VTA_OrdenBN->getOrdenId() );
                if
                ( 
                    ( $o_TMP_VTA_OrdenBN->getMonedaCod() != $o_VTA_OrdenBN->getMonedaCod() ) ||
                    ( $o_TMP_VTA_OrdenBN->getOrdenTipoId() != $o_VTA_OrdenBN->getOrdenTipoId() )
                )
                {
                    //se cambio la moneda
                    $o_VTA_OrdenDetalleFN = new VTA_OrdenDetalleFN();
                    $o_VTA_OrdenDetalleFN->setOrdenId( $o_VTA_OrdenBN->getOrdenId() );
                    $a_VTA_OrdenDetalle = $o_VTA_OrdenDetalleFN->select();
                    if( $a_VTA_OrdenDetalle )
                    {
                        throw new Exception( "Para realizar esta accion, no debe tener Item(s) en la Orden." );
                    }
                    
                    //ahora si es cambio de tipo, se tiene q actualizar el numero de orden
                    if( $o_TMP_VTA_OrdenBN->getOrdenTipoId() != $o_VTA_OrdenBN->getOrdenTipoId() )
                    {
                        $a_Ids = VTA_OrdenDP::generarIdNum( $o_VTA_OrdenBN->getOrdenTipoId() );
                        $o_VTA_OrdenBN->setOrdenNum( $a_Ids['cod'] );
                    }
                }
                /////////////////////////////////////////////////////////////////////////////////////////////////////////////

                $o_VTA_OrdenBN->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
                $o_VTA_OrdenBN->setUsuarioActualizacion( myUser::getUser()->getUserId() );

                $o_VTA_OrdenDP = new VTA_OrdenDP( $o_VTA_OrdenBN );
                $o_VTA_OrdenDP->update();
            }
            
            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( "CT/H: ".$o_Exception->getMessage() );
        }
        return true;
    }
    
    public function cambiarEstadoOrdenVenta( VTA_OrdenBN $o_VTA_OrdenBN )
    {
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            myUser::getUser()->validar_session();

            //validaciones 
            //1. Si la orden esta facturado, no se permite anular.
            $o_VTA_OrdenFN = new VTA_OrdenFN();
            $o_VTA_OrdenBN2 = $o_VTA_OrdenFN->selectByPK( $o_VTA_OrdenBN->getOrdenId() );
            
            if( $o_VTA_OrdenBN2->getOrdenEstado() == "F" )
            {
                if( !$o_VTA_OrdenBN->getAnularDocumemtoreferencia() )
                {
                    throw new Exception( "No se puede Anular la Cotizacion, actualmente tiene una Factura asociada." );
                }
            }
            //se agrega validacion por orden de produccion - sermaqui - 2021-04-06
            $o_PRD_OrdenCabFN = new PRD_OrdenCabFN();
            $o_PRD_OrdenCabFN->setDocNumRef( $o_VTA_OrdenBN2->getOrdenNum() );
            $o_PRD_OrdenCabFN->addCondition( PRD_OrdenCabFN::Estado, "IN", "('P','R','C')", false );
            $a_PRD_OrdenCab = $o_PRD_OrdenCabFN->select();
            if( $a_PRD_OrdenCab )
            {
                if( $o_VTA_OrdenBN->getOrdenEstado() != "F" )
                {
                    throw new Exception( "No se puede cambiar el estado de la Cotizacion, Esta pendiente por una Orden de Produccion." );
                }
            }

            //SE AGREGA VALIDACION POR LA CONDICION DE PAGO
            if( $o_VTA_OrdenBN->getOrdenEstado() != VTA_OrdenBN::ESTADO_ANULADO )
            {
                if( !$o_VTA_OrdenBN2->getCondicionVentaId() )
                {
                    throw new Exception( "No se encontro condicion de venta." );
                }
            }
            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            if( $o_VTA_OrdenBN2->getOrdenTipoId() == VTA_OrdenBN::ORDEN_MASTER )
            {
                goto end;
            }
            
            //AQUI SE VALIDA, Q SI ES ORDEN ESTANDAR, TENGA EL MEDIO DE PAGO TOTAL REGISTRADO
            if( $o_VTA_OrdenBN->getOrdenEstado() == VTA_OrdenBN::ESTADO_CERRADO )
            {
                //////////////////////
                //VALIDAMOS EL METODO DE PAGO
                $o_FCO_OrdenReciboFN = new FCO_OrdenReciboFN();
                $o_FCO_OrdenReciboFN->setOrdenId( $o_VTA_OrdenBN->getOrdenId() );
                $a_FCO_OrdenRecibo = $o_FCO_OrdenReciboFN->select();
                if( !$a_FCO_OrdenRecibo )
                {
                    throw new Exception( "No se encontro un Medio de Pago asociado." );
                }

                $f_SumaMonto = 0;
                foreach ( $a_FCO_OrdenRecibo as $o_FCO_OrdenReciboBN ) 
                {
                    //aqui una validacion por recibo, si no es efectivo se valida que el numero de recibo este ingresado
                    $o_FCO_DocReciboFN = new FCO_DocReciboFN();
                    $o_FCO_DocReciboBN = $o_FCO_DocReciboFN->selectByPK( $o_FCO_OrdenReciboBN->getIdDocRecibo() );
                    
                    if( $o_FCO_DocReciboBN )
                    {
                        if( $o_FCO_DocReciboBN->getEstado() == FCO_DocReciboBN::ESTADO_ANULADO )
                        {
                            throw new Exception( "El Recibo ".$o_FCO_DocReciboBN->getObjectTipoPago()->getNombre()." se encuentra Anulado." );
                        }
                        if( $o_FCO_DocReciboBN->getIdTipoPago() != 1 ) //si es diferente al medio de pago efecivo
                        {
                            if( !$o_FCO_DocReciboBN->getReciboNumero() )
                            {
                                throw new Exception( "El Medio de Pago ".$o_FCO_DocReciboBN->getObjectTipoPago()->getNombre()." no tiene el Numero de Operacion." );
                            }
                        }
                    }
                    else
                    {
                        throw new Exception( "No se encontro Medio de Pago asociado." );
                    }

                    if( $o_VTA_OrdenBN2->getMonedaCod() == "LO" )
                    {
                        $f_SumaMonto = $f_SumaMonto + $o_FCO_OrdenReciboBN->getMontoOrdenMN();
                    }
                    if( $o_VTA_OrdenBN2->getMonedaCod() == "EX" )
                    {
                        $f_SumaMonto = $f_SumaMonto + $o_FCO_OrdenReciboBN->getMontoOrdenME();
                    }
                }

                if( $f_SumaMonto < $o_VTA_OrdenBN2->getOrdenNeto() )
                {
                    throw new Exception( "La suma de las Aplicacion no cubre el Total de la Venta." );
                }
                if( $f_SumaMonto > $o_VTA_OrdenBN2->getOrdenNeto() )
                {
                    throw new Exception( "La suma de las Aplicacion sobrepasa el Total de la Venta." );
                }
            }
            end:
            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            //SOLO PARA EL CASO DE Q SEA POR ANULACION
            if( $o_VTA_OrdenBN->getOrdenEstado() == VTA_OrdenBN::ESTADO_ANULADO )
            {
                $o_VTA_OrdenBN2->setOrdenNum( $o_VTA_OrdenBN2->getOrdenNum()." [".$o_VTA_OrdenBN->getAnulacionComentario()."]" );
            }

            //AHORA SE REGISTRA HISTORIAL
            RegistroHistorialDP::registrarHistorial
            (
                array
                (
                        "Tabla"             => "VTA_Orden",                             //referencia de la tabla donde se hace el update o insert
                        "IdDocumento"       => $o_VTA_OrdenBN->getOrdenId(),            //id del registro cabecera
                        "IdCampo"           => $o_VTA_OrdenBN->getOrdenId(),            //puede ser el id de los detalles
                        "CampoValor"        => $o_VTA_OrdenBN2->getOrdenNum(),          //valor que se muestra al usuario
                        "Modulo"            => "COTIZACION",                            //modulo donde se realizo la accion
                        "CampoDescripcion"  => "ESTADO",                                //descripcion de la accion a realizar
                        "ValorAnterior"     => $o_VTA_OrdenBN2->getOrdenEstadoDesc(),   
                        "ValorNuevo"        => $o_VTA_OrdenBN->getOrdenEstadoDesc(),    
                )
            );
            
            //primero anulamos las lineas
            $o_VTA_OrdenDetalleBN = new VTA_OrdenDetalleBN();
            $o_VTA_OrdenDetalleBN->setOrdenId( $o_VTA_OrdenBN->getOrdenId() );
            $o_VTA_OrdenDetalleBN->setOrdenDetalleEstado( $o_VTA_OrdenBN->getOrdenEstado() );
            
            $o_CotizacionesDetalleBL = new CotizacionesDetalleBL();
            $o_CotizacionesDetalleBL->cambiarEstadoLineas( $o_VTA_OrdenDetalleBN );
            //////////////////////////////
            //ahora anulamos la cabecera
            $o_VTA_OrdenDP = new VTA_OrdenDP();
            $o_VTA_OrdenDP->setOrdenId( $o_VTA_OrdenBN->getOrdenId() );
            $o_VTA_OrdenDP->setOrdenEstado( $o_VTA_OrdenBN->getOrdenEstado() );
            //$o_VTA_OrdenDP->setEstadoDevolucion( "P" ); //se agrega por sermaqui | 2021-05-09
            $o_VTA_OrdenDP->setAnulacionComentario( $o_VTA_OrdenBN->getAnulacionComentario() );
            $o_VTA_OrdenDP->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
            $o_VTA_OrdenDP->setUsuarioActualizacion( myUser::getUser()->getUserId() );
            $o_VTA_OrdenDP->update();
            
            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( "CT/H: ".$o_Exception->getMessage() );
        }
        return true;
    }

    public function convertirOrdenEstandar( VTA_OrdenBN &$o_VTA_OrdenBN )
    {
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            myUser::getUser()->validar_session();

            $i_OrdenPadre   = $o_VTA_OrdenBN->getOrdenId();
            $i_DiasAlquiler = $o_VTA_OrdenBN->getDiasAlquiler();
            
            //se recupera la OrdenH
            $o_VTA_OrdenFN = new VTA_OrdenFN();
            $o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $i_OrdenPadre );

            $o_TMP_VTA_OrdenBN = clone $o_VTA_OrdenBN;
            $o_TMP_VTA_OrdenBN->setOrdenId( null );
            //$o_TMP_VTA_OrdenBN->setOrdenTipoId( 1 );
            $o_TMP_VTA_OrdenBN->setOrdenPadre( $i_OrdenPadre );
            $o_TMP_VTA_OrdenBN->setDiasAlquiler( $i_DiasAlquiler );
            $o_TMP_VTA_OrdenBN->setOrdenEstado( VTA_OrdenBN::ESTADO_ABIERTO );

            //ahora actualizamos la fecha
            $s_OrdenFecha = date( "Y-m-d H:i:s" );
            $OrdenVenc = UtilDate::obtenerOrdenFechaVenc( ( $i_DiasAlquiler * 24 ) );

            $o_TMP_VTA_OrdenBN->setOrdenFecha( $s_OrdenFecha );
            $o_TMP_VTA_OrdenBN->setOrdenVenc( $OrdenVenc );

            //se genera la orden estandar
            $this->iniciarOrdenVenta( $o_TMP_VTA_OrdenBN );
            
            $i_OrdenHijo    = $o_TMP_VTA_OrdenBN->getOrdenId();
            $s_OrdenHijoNum = $o_TMP_VTA_OrdenBN->getOrdenNum();
            ////////////////////////////////////////////////////////////////////////////////////////////////////////
            if( $o_VTA_OrdenBN->getOrdenTipoId() == 2 )
            {
                //se procede en cerrar la orden master
                $o_VTA_OrdenBN2 = new VTA_OrdenBN();
                $o_VTA_OrdenBN2->setOrdenId( $i_OrdenPadre );
                $o_VTA_OrdenBN2->setOrdenEstado( "C" );
                
                $this->cambiarEstadoOrdenVenta( $o_VTA_OrdenBN2 );
            }
            ////////////////////////////////////////////////////////////////////////////////////////////////////////

            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //ahora se genera los detalles
            /* SE COMENTA POR DIFERENCIA DE PROCESO POR EL CLIENTE - 2020-12-21
            $o_VTA_OrdenDetalleFN = new VTA_OrdenDetalleFN();
            $o_VTA_OrdenDetalleFN->setOrdenId( $i_OrdenPadre );
            $a_VTA_OrdenDetalle = $o_VTA_OrdenDetalleFN->select();
            if( $a_VTA_OrdenDetalle )
            {
                foreach ( $a_VTA_OrdenDetalle as $o_VTA_OrdenDetalleBN )
                {
                    $s_NivelPrecio   = $o_VTA_OrdenDetalleBN->getOrdenDetallePrecioNivel();
                    
                    $o_TMP_VTA_OrdenDetalleBN = new VTA_OrdenDetalleBN();
                    $o_TMP_VTA_OrdenDetalleBN->setOrdenId( $i_OrdenHijo );
                    $o_TMP_VTA_OrdenDetalleBN->setItemCod( $o_VTA_OrdenDetalleBN->getItemCod() );
                    $o_TMP_VTA_OrdenDetalleBN->setAlmacenCod( $o_VTA_OrdenDetalleBN->getAlmacenCod() );
                    $o_TMP_VTA_OrdenDetalleBN->setOrdenDetalleCantidad( $o_VTA_OrdenDetalleBN->getOrdenDetalleCantidad() );
                    $o_TMP_VTA_OrdenDetalleBN->setOrdenDetallePrecioNivel( $s_NivelPrecio );
                    if( $s_NivelPrecio == "P" )
                    {
                        $o_TMP_VTA_OrdenDetalleBN->setPrecioUnidadIncImpuesto( $o_VTA_OrdenDetalleBN->getPrecioUnidadIncImpuesto() );
                        $o_TMP_VTA_OrdenDetalleBN->setPrecioUnidadIncImpuestoMN( $o_VTA_OrdenDetalleBN->getPrecioUnidadIncImpuestoMN() );
                        $o_TMP_VTA_OrdenDetalleBN->setOrdenDetalleImpuestoUnidad( $o_VTA_OrdenDetalleBN->getOrdenDetalleImpuestoUnidad() );
                        $o_TMP_VTA_OrdenDetalleBN->setOrdenDetalleImpuestoUnidadMN( $o_VTA_OrdenDetalleBN->getOrdenDetalleImpuestoUnidadMN() );
                        $o_TMP_VTA_OrdenDetalleBN->setOrdenDetallePrecioUnidad( $o_VTA_OrdenDetalleBN->getOrdenDetallePrecioUnidad() );
                        $o_TMP_VTA_OrdenDetalleBN->setOrdenDetallePrecioUnidadMN( $o_VTA_OrdenDetalleBN->getOrdenDetallePrecioUnidadMN() );

                        $o_TMP_VTA_OrdenDetalleBN->setCambioPrecio( true );
                    }
                    $o_CotizacionesDetalleBL = new CotizacionesDetalleBL();
                    $o_CotizacionesDetalleBL->iniciarProceso( $o_TMP_VTA_OrdenDetalleBN );
                }
            }
            */
            
            //SE TIENE QUE BUSCAR LA ORDEN PADRE INICIAL
            //SE AGREGA OTRO PROCEDIMIENTO, QUE COPIA DETALLES SOLO DE PRODUCTOS FINAL Y LO CONVIERTE EN SERVICIO
            $o_VTA_OrdenDetalleFN = new VTA_OrdenDetalleFN();
            $o_VTA_OrdenDetalleFN->setOrdenId( $i_OrdenPadre );
            $o_VTA_OrdenDetalleFN->setItemTipo( VTA_OrdenDetalleBN::TIPO_PRODUCTO_FINAL );
            $a_VTA_OrdenDetalle = $o_VTA_OrdenDetalleFN->select();
            $b_Comentario = false;
            if( !$a_VTA_OrdenDetalle )
            {
                $o_VTA_OrdenDetalleFN = new VTA_OrdenDetalleFN();
                $o_VTA_OrdenDetalleFN->setOrdenId( $i_OrdenPadre );
                $o_VTA_OrdenDetalleFN->setItemTipo( VTA_OrdenDetalleBN::TIPO_PRODUCTO_SERVICIO );
                $a_VTA_OrdenDetalle = $o_VTA_OrdenDetalleFN->select();
                $b_Comentario = true;
            }
            
            if( $a_VTA_OrdenDetalle )
            {
                foreach ( $a_VTA_OrdenDetalle as $o_VTA_OrdenDetalleBN )
                {
                    $s_OrdenDetalleDescripcion = $o_VTA_OrdenDetalleBN->getOrdenDetalleDescripcion();
                    $f_PrecioUnidadIncImpuesto = $o_VTA_OrdenDetalleBN->getPrecioUnidadIncImpuesto();
                    $f_PrecioUnidadIncImpuestoMN = $o_VTA_OrdenDetalleBN->getPrecioUnidadIncImpuestoMN();
                    $f_OrdenDetalleImpuestoUnidad = $o_VTA_OrdenDetalleBN->getOrdenDetalleImpuestoUnidad();
                    $f_OrdenDetalleImpuestoUnidadMN = $o_VTA_OrdenDetalleBN->getOrdenDetalleImpuestoUnidadMN();
                    $f_OrdenDetallePrecioUnidad = $o_VTA_OrdenDetalleBN->getOrdenDetallePrecioUnidad();
                    $f_OrdenDetallePrecioUnidadMN = $o_VTA_OrdenDetalleBN->getOrdenDetallePrecioUnidadMN();
                }
                
                if( $b_Comentario )
                {
                    $o_VTA_OrdenDetalleFN = new VTA_OrdenDetalleFN();
                    $o_VTA_OrdenDetalleFN->setOrdenId( $i_OrdenPadre );
                    $o_VTA_OrdenDetalleFN->setItemTipo( VTA_OrdenDetalleBN::TIPO_COMENTARIO );
                    $a_VTA_OrdenDetalle = $o_VTA_OrdenDetalleFN->select();
                    
                    foreach ( $a_VTA_OrdenDetalle as $o_VTA_OrdenDetalleBN )
                    {
                        $s_OrdenDetalleDescripcion = $o_VTA_OrdenDetalleBN->getOrdenDetalleDescripcion();
                    }
                }
                
                //PRIMERO SE REGISTRA EL SERVICIO
                $o_TMP_VTA_OrdenDetalleBN = new VTA_OrdenDetalleBN();
                $o_TMP_VTA_OrdenDetalleBN->setOrdenId( $i_OrdenHijo );
                $o_TMP_VTA_OrdenDetalleBN->setItemTipo( VTA_OrdenDetalleBN::TIPO_PRODUCTO_SERVICIO );
                $o_TMP_VTA_OrdenDetalleBN->setItemCod( "01299" );
                $o_TMP_VTA_OrdenDetalleBN->setAlmacenCod( $o_TMP_VTA_OrdenBN->getAlmacenCod() );
                $o_TMP_VTA_OrdenDetalleBN->setOrdenDetalleCantidad( 1 );
                $o_TMP_VTA_OrdenDetalleBN->setOrdenDetallePrecioNivel( "P" );
                $o_TMP_VTA_OrdenDetalleBN->setPrecioUnidadIncImpuesto( $f_PrecioUnidadIncImpuesto );
                $o_TMP_VTA_OrdenDetalleBN->setPrecioUnidadIncImpuestoMN( $f_PrecioUnidadIncImpuestoMN );
                $o_TMP_VTA_OrdenDetalleBN->setOrdenDetalleImpuestoUnidad( $f_OrdenDetalleImpuestoUnidad );
                $o_TMP_VTA_OrdenDetalleBN->setOrdenDetalleImpuestoUnidadMN( $f_OrdenDetalleImpuestoUnidadMN );
                $o_TMP_VTA_OrdenDetalleBN->setOrdenDetallePrecioUnidad( $f_OrdenDetallePrecioUnidad );
                $o_TMP_VTA_OrdenDetalleBN->setOrdenDetallePrecioUnidadMN( $f_OrdenDetallePrecioUnidadMN );
                $o_TMP_VTA_OrdenDetalleBN->setCambioPrecio( true );
                
                $o_CotizacionesDetalleBL = new CotizacionesDetalleBL();
                $o_CotizacionesDetalleBL->iniciarProceso( $o_TMP_VTA_OrdenDetalleBN );
                //pr( $o_TMP_VTA_OrdenDetalleBN );
                
                
                
                //LUEGO SE REGISTRA EL COMENTARIO, QUE ES LA DESCRIPCION DEL PRODUCTO FINAL
                $o_TMP_VTA_OrdenDetalleBN = new VTA_OrdenDetalleBN();
                $o_TMP_VTA_OrdenDetalleBN->setOrdenId( $i_OrdenHijo );
                $o_TMP_VTA_OrdenDetalleBN->setItemTipo( VTA_OrdenDetalleBN::TIPO_COMENTARIO );
                $o_TMP_VTA_OrdenDetalleBN->setOrdenDetalleDescripcion( $s_OrdenDetalleDescripcion );
                $o_TMP_VTA_OrdenDetalleBN->setOrdenDetalleEstado( VTA_OrdenBN::ESTADO_ABIERTO );
                //$o_TMP_VTA_OrdenDetalleBN->setItemCod();
                $o_TMP_VTA_OrdenDetalleBN->setAlmacenCod( $o_VTA_OrdenDetalleBN->getAlmacenCod() );
                //$o_TMP_VTA_OrdenDetalleBN->setOrdenDetalleCantidad( $o_VTA_OrdenDetalleBN->getOrdenDetalleCantidad() );
                //$o_TMP_VTA_OrdenDetalleBN->setOrdenDetallePrecioNivel( $s_NivelPrecio );
                
                $o_CotizacionesDetalleBL = new CotizacionesDetalleBL();
                $o_CotizacionesDetalleBL->iniciarProceso( $o_TMP_VTA_OrdenDetalleBN );
                
                
            }
            else
            {
                throw new Exception( "No se encontro el Producto Final para la Orden Padre." );
            }
            
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            //ahora se actualiza los id generados
            $o_VTA_OrdenBN->setOrdenId( $i_OrdenHijo );
            $o_VTA_OrdenBN->setOrdenPadre( $i_OrdenPadre );
            $o_VTA_OrdenBN->setOrdenNum( $s_OrdenHijoNum );
            
            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( "CT/COE: ".$o_Exception->getMessage() );
        }
        return true;
    }

    public function cambiarOrdenFacturada( VTA_OrdenBN $o_VTA_OrdenBN )
    {
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            myUser::getUser()->validar_session();
            
            $o_VTA_OrdenBN2 = new VTA_OrdenBN();
            $o_VTA_OrdenBN2->setOrdenId( $o_VTA_OrdenBN->getOrdenId() );
            $o_VTA_OrdenBN2->setOrdenEstado( "F" );
            
            //se cambia la orden de venta a facturada
            $this->cambiarEstadoOrdenVenta( $o_VTA_OrdenBN2 );

            /////////////////////////////////////////////////////////////////////////////////
            //ahora actualizamos mas data a la cabecera
            //usleep( 500000 );
            $o_VTA_OrdenDP = new VTA_OrdenDP();
            $o_VTA_OrdenDP->setOrdenId( $o_VTA_OrdenBN->getOrdenId() );

            $o_VTA_OrdenDP->setReferenciaTipoDocId( $o_VTA_OrdenBN->getReferenciaTipoDocId() );
            $o_VTA_OrdenDP->setDocReferenciaTipo( $o_VTA_OrdenBN->getDocReferenciaTipo() );
            $o_VTA_OrdenDP->setDocReferenciaNum( $o_VTA_OrdenBN->getDocReferenciaNum() );
            $o_VTA_OrdenDP->setDocReferenciaId( $o_VTA_OrdenBN->getDocReferenciaId() );
            $o_VTA_OrdenDP->setDocReferenciaFecha( $o_VTA_OrdenBN->getDocReferenciaFecha() );

            $o_VTA_OrdenDP->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
            $o_VTA_OrdenDP->setUsuarioActualizacion( myUser::getUser()->getUserId() );
            $o_VTA_OrdenDP->update();
            /////////////////////////////////////////////////////////////////////////////////

            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( "CT/H: ".$o_Exception->getMessage() );
        }
        return true;
    }

    public function copiarOrdenVenta( VTA_OrdenBN &$o_VTA_OrdenBN )
    {
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            myUser::getUser()->validar_session();

            //tiene el mismo procedimiento, se puede reutilizar, pero de todas maneras se mejoro el procedimiento por el tema de orden master (sermaqui).
            $this->convertirOrdenEstandar( $o_VTA_OrdenBN );
            
            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( "CT/COV: ".$o_Exception->getMessage() );
        }
        return true;
    }

    public function anularOrdenesExpirados()
    {
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            myUser::getUser()->validar_session();

            $a_DataExpirado = VTA_OrdenFN::findExpiredOrder();

            foreach ( $a_DataExpirado as $o_VTA_OrdenBN )
            {
                $o_TMP_VTA_OrdenBN = new VTA_OrdenBN();
                $o_TMP_VTA_OrdenBN->setOrdenId( $o_VTA_OrdenBN->getOrdenId() );
                $o_TMP_VTA_OrdenBN->setOrdenEstado( "A" );
                $this->cambiarEstadoOrdenVenta( $o_TMP_VTA_OrdenBN );
            }
            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( "CT/AOE: ".$o_Exception->getMessage() );
        }
        return true;
    }
}