<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: VTA_TipoDocumento.xml */
/* Generado: 2021-07-16 07:04:07 */

/* Busqueda de registros de la tabla VTA_TipoDocumento. */
abstract class BaseVTA_TipoDocumentoFN extends VTA_TipoDocumentoBN
{
    /* Declaracion de constantes */
    const IdTipoDocumento = "VTA_TipoDocumento.IdTipoDocumento";
    const DescripcionLocal = "VTA_TipoDocumento.DescripcionLocal";
    const TipoDocumentoCod = "VTA_TipoDocumento.TipoDocumentoCod";
    const Secuencia = "VTA_TipoDocumento.Secuencia";
    const DescripcionIngles = "VTA_TipoDocumento.DescripcionIngles";
    const EsFiscalFlag = "VTA_TipoDocumento.EsFiscalFlag";
    const CodigoFiscal = "VTA_TipoDocumento.CodigoFiscal";
    const CodigoFiscalPrs = "VTA_TipoDocumento.CodigoFiscalPrs";
    const GenerarProvisionFlag = "VTA_TipoDocumento.GenerarProvisionFlag";
    const CuentaContableLocal = "VTA_TipoDocumento.CuentaContableLocal";
    const CuentaContableDolares = "VTA_TipoDocumento.CuentaContableDolares";
    const CuentaDudosaLocal = "VTA_TipoDocumento.CuentaDudosaLocal";
    const CuentaDudosaDolares = "VTA_TipoDocumento.CuentaDudosaDolares";
    const CuentaDudosaProvisionLocal = "VTA_TipoDocumento.CuentaDudosaProvisionLocal";
    const CuentaDudosaProvisionDolares = "VTA_TipoDocumento.CuentaDudosaProvisionDolares";
    const Clasificacion = "VTA_TipoDocumento.Clasificacion";
    const NumeroLineasImpresion = "VTA_TipoDocumento.NumeroLineasImpresion";
    const DisponibleIngresoManualFlag = "VTA_TipoDocumento.DisponibleIngresoManualFlag";
    const Estado = "VTA_TipoDocumento.Estado";
    const UsuarioModificacion = "VTA_TipoDocumento.UsuarioModificacion";
    const FechaModificacion = "VTA_TipoDocumento.FechaModificacion";
    const UsuarioCreacion = "VTA_TipoDocumento.UsuarioCreacion";
    const FechaCreacion = "VTA_TipoDocumento.FechaCreacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "VTA_TipoDocumento.IdTipoDocumento AS IdTipoDocumento, ";
        $s_SQLQuery .= "VTA_TipoDocumento.DescripcionLocal AS DescripcionLocal, ";
        $s_SQLQuery .= "VTA_TipoDocumento.TipoDocumentoCod AS TipoDocumentoCod, ";
        $s_SQLQuery .= "VTA_TipoDocumento.Secuencia AS Secuencia, ";
        $s_SQLQuery .= "VTA_TipoDocumento.DescripcionIngles AS DescripcionIngles, ";
        $s_SQLQuery .= "VTA_TipoDocumento.EsFiscalFlag AS EsFiscalFlag, ";
        $s_SQLQuery .= "VTA_TipoDocumento.CodigoFiscal AS CodigoFiscal, ";
        $s_SQLQuery .= "VTA_TipoDocumento.CodigoFiscalPrs AS CodigoFiscalPrs, ";
        $s_SQLQuery .= "VTA_TipoDocumento.GenerarProvisionFlag AS GenerarProvisionFlag, ";
        $s_SQLQuery .= "VTA_TipoDocumento.CuentaContableLocal AS CuentaContableLocal, ";
        $s_SQLQuery .= "VTA_TipoDocumento.CuentaContableDolares AS CuentaContableDolares, ";
        $s_SQLQuery .= "VTA_TipoDocumento.CuentaDudosaLocal AS CuentaDudosaLocal, ";
        $s_SQLQuery .= "VTA_TipoDocumento.CuentaDudosaDolares AS CuentaDudosaDolares, ";
        $s_SQLQuery .= "VTA_TipoDocumento.CuentaDudosaProvisionLocal AS CuentaDudosaProvisionLocal, ";
        $s_SQLQuery .= "VTA_TipoDocumento.CuentaDudosaProvisionDolares AS CuentaDudosaProvisionDolares, ";
        $s_SQLQuery .= "VTA_TipoDocumento.Clasificacion AS Clasificacion, ";
        $s_SQLQuery .= "VTA_TipoDocumento.NumeroLineasImpresion AS NumeroLineasImpresion, ";
        $s_SQLQuery .= "VTA_TipoDocumento.DisponibleIngresoManualFlag AS DisponibleIngresoManualFlag, ";
        $s_SQLQuery .= "VTA_TipoDocumento.Estado AS Estado, ";
        $s_SQLQuery .= "VTA_TipoDocumento.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "VTA_TipoDocumento.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "VTA_TipoDocumento.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "VTA_TipoDocumento.FechaCreacion AS FechaCreacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto VTA_TipoDocumentoBN */
    public function setByBN( VTA_TipoDocumentoBN $o_VTA_TipoDocumentoBN )
    {
        if ( !is_null( $o_VTA_TipoDocumentoBN->getIdTipoDocumento() ) )
        {
            $this->setIdTipoDocumento( $o_VTA_TipoDocumentoBN->getIdTipoDocumento() );
        }
        if ( !is_null( $o_VTA_TipoDocumentoBN->getDescripcionLocal() ) )
        {
            $this->setDescripcionLocal( $o_VTA_TipoDocumentoBN->getDescripcionLocal() );
        }
        if ( !is_null( $o_VTA_TipoDocumentoBN->getTipoDocumentoCod() ) )
        {
            $this->setTipoDocumentoCod( $o_VTA_TipoDocumentoBN->getTipoDocumentoCod() );
        }
        if ( !is_null( $o_VTA_TipoDocumentoBN->getSecuencia() ) )
        {
            $this->setSecuencia( $o_VTA_TipoDocumentoBN->getSecuencia() );
        }
        if ( !is_null( $o_VTA_TipoDocumentoBN->getDescripcionIngles() ) )
        {
            $this->setDescripcionIngles( $o_VTA_TipoDocumentoBN->getDescripcionIngles() );
        }
        if ( !is_null( $o_VTA_TipoDocumentoBN->getEsFiscalFlag() ) )
        {
            $this->setEsFiscalFlag( $o_VTA_TipoDocumentoBN->getEsFiscalFlag() );
        }
        if ( !is_null( $o_VTA_TipoDocumentoBN->getCodigoFiscal() ) )
        {
            $this->setCodigoFiscal( $o_VTA_TipoDocumentoBN->getCodigoFiscal() );
        }
        if ( !is_null( $o_VTA_TipoDocumentoBN->getCodigoFiscalPrs() ) )
        {
            $this->setCodigoFiscalPrs( $o_VTA_TipoDocumentoBN->getCodigoFiscalPrs() );
        }
        if ( !is_null( $o_VTA_TipoDocumentoBN->getGenerarProvisionFlag() ) )
        {
            $this->setGenerarProvisionFlag( $o_VTA_TipoDocumentoBN->getGenerarProvisionFlag() );
        }
        if ( !is_null( $o_VTA_TipoDocumentoBN->getCuentaContableLocal() ) )
        {
            $this->setCuentaContableLocal( $o_VTA_TipoDocumentoBN->getCuentaContableLocal() );
        }
        if ( !is_null( $o_VTA_TipoDocumentoBN->getCuentaContableDolares() ) )
        {
            $this->setCuentaContableDolares( $o_VTA_TipoDocumentoBN->getCuentaContableDolares() );
        }
        if ( !is_null( $o_VTA_TipoDocumentoBN->getCuentaDudosaLocal() ) )
        {
            $this->setCuentaDudosaLocal( $o_VTA_TipoDocumentoBN->getCuentaDudosaLocal() );
        }
        if ( !is_null( $o_VTA_TipoDocumentoBN->getCuentaDudosaDolares() ) )
        {
            $this->setCuentaDudosaDolares( $o_VTA_TipoDocumentoBN->getCuentaDudosaDolares() );
        }
        if ( !is_null( $o_VTA_TipoDocumentoBN->getCuentaDudosaProvisionLocal() ) )
        {
            $this->setCuentaDudosaProvisionLocal( $o_VTA_TipoDocumentoBN->getCuentaDudosaProvisionLocal() );
        }
        if ( !is_null( $o_VTA_TipoDocumentoBN->getCuentaDudosaProvisionDolares() ) )
        {
            $this->setCuentaDudosaProvisionDolares( $o_VTA_TipoDocumentoBN->getCuentaDudosaProvisionDolares() );
        }
        if ( !is_null( $o_VTA_TipoDocumentoBN->getClasificacion() ) )
        {
            $this->setClasificacion( $o_VTA_TipoDocumentoBN->getClasificacion() );
        }
        if ( !is_null( $o_VTA_TipoDocumentoBN->getNumeroLineasImpresion() ) )
        {
            $this->setNumeroLineasImpresion( $o_VTA_TipoDocumentoBN->getNumeroLineasImpresion() );
        }
        if ( !is_null( $o_VTA_TipoDocumentoBN->getDisponibleIngresoManualFlag() ) )
        {
            $this->setDisponibleIngresoManualFlag( $o_VTA_TipoDocumentoBN->getDisponibleIngresoManualFlag() );
        }
        if ( !is_null( $o_VTA_TipoDocumentoBN->getEstado() ) )
        {
            $this->setEstado( $o_VTA_TipoDocumentoBN->getEstado() );
        }
        if ( !is_null( $o_VTA_TipoDocumentoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_VTA_TipoDocumentoBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_VTA_TipoDocumentoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_VTA_TipoDocumentoBN->getFechaModificacion() );
        }
        if ( !is_null( $o_VTA_TipoDocumentoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_VTA_TipoDocumentoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_VTA_TipoDocumentoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_VTA_TipoDocumentoBN->getFechaCreacion() );
        }
    }

    /**
    * @return VTA_TipoDocumentoBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_IdTipoDocumento )
    {
        if( is_null( $s_IdTipoDocumento ) ){ $s_IdTipoDocumento = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM VTA_TipoDocumento ";
        $s_SQLQuery .= "WHERE IdTipoDocumento = '".$s_IdTipoDocumento."' ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_VTA_TipoDocumentoBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_VTA_TipoDocumentoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_VTA_TipoDocumentoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdTipoDocumento() ) ) $s_SQLQuery .= "VTA_TipoDocumento.IdTipoDocumento = '".$this->getIdTipoDocumento()."' AND ";
        if ( !is_null( $this->getDescripcionLocal() ) ) $s_SQLQuery .= "VTA_TipoDocumento.DescripcionLocal = '".$this->getDescripcionLocal()."' AND ";
        if ( !is_null( $this->getTipoDocumentoCod() ) ) $s_SQLQuery .= "VTA_TipoDocumento.TipoDocumentoCod = '".$this->getTipoDocumentoCod()."' AND ";
        if ( !is_null( $this->getSecuencia() ) ) $s_SQLQuery .= "VTA_TipoDocumento.Secuencia = '".$this->getSecuencia()."' AND ";
        if ( !is_null( $this->getDescripcionIngles() ) ) $s_SQLQuery .= "VTA_TipoDocumento.DescripcionIngles = '".$this->getDescripcionIngles()."' AND ";
        if ( !is_null( $this->getEsFiscalFlag() ) ) $s_SQLQuery .= "VTA_TipoDocumento.EsFiscalFlag = '".$this->getEsFiscalFlag()."' AND ";
        if ( !is_null( $this->getCodigoFiscal() ) ) $s_SQLQuery .= "VTA_TipoDocumento.CodigoFiscal = '".$this->getCodigoFiscal()."' AND ";
        if ( !is_null( $this->getCodigoFiscalPrs() ) ) $s_SQLQuery .= "VTA_TipoDocumento.CodigoFiscalPrs = '".$this->getCodigoFiscalPrs()."' AND ";
        if ( !is_null( $this->getGenerarProvisionFlag() ) ) $s_SQLQuery .= "VTA_TipoDocumento.GenerarProvisionFlag = '".$this->getGenerarProvisionFlag()."' AND ";
        if ( !is_null( $this->getCuentaContableLocal() ) ) $s_SQLQuery .= "VTA_TipoDocumento.CuentaContableLocal = '".$this->getCuentaContableLocal()."' AND ";
        if ( !is_null( $this->getCuentaContableDolares() ) ) $s_SQLQuery .= "VTA_TipoDocumento.CuentaContableDolares = '".$this->getCuentaContableDolares()."' AND ";
        if ( !is_null( $this->getCuentaDudosaLocal() ) ) $s_SQLQuery .= "VTA_TipoDocumento.CuentaDudosaLocal = '".$this->getCuentaDudosaLocal()."' AND ";
        if ( !is_null( $this->getCuentaDudosaDolares() ) ) $s_SQLQuery .= "VTA_TipoDocumento.CuentaDudosaDolares = '".$this->getCuentaDudosaDolares()."' AND ";
        if ( !is_null( $this->getCuentaDudosaProvisionLocal() ) ) $s_SQLQuery .= "VTA_TipoDocumento.CuentaDudosaProvisionLocal = '".$this->getCuentaDudosaProvisionLocal()."' AND ";
        if ( !is_null( $this->getCuentaDudosaProvisionDolares() ) ) $s_SQLQuery .= "VTA_TipoDocumento.CuentaDudosaProvisionDolares = '".$this->getCuentaDudosaProvisionDolares()."' AND ";
        if ( !is_null( $this->getClasificacion() ) ) $s_SQLQuery .= "VTA_TipoDocumento.Clasificacion = '".$this->getClasificacion()."' AND ";
        if ( !is_null( $this->getNumeroLineasImpresion() ) ) $s_SQLQuery .= "VTA_TipoDocumento.NumeroLineasImpresion = ".$this->getNumeroLineasImpresion()." AND ";
        if ( !is_null( $this->getDisponibleIngresoManualFlag() ) ) $s_SQLQuery .= "VTA_TipoDocumento.DisponibleIngresoManualFlag = '".$this->getDisponibleIngresoManualFlag()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "VTA_TipoDocumento.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "VTA_TipoDocumento.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "VTA_TipoDocumento.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "VTA_TipoDocumento.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "VTA_TipoDocumento.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM VTA_TipoDocumento WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return VTA_TipoDocumentoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM VTA_TipoDocumento WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_VTA_TipoDocumentoBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_VTA_TipoDocumentoBN = $this->insertObjectBN( $a_SQLRow );
                $a_VTA_TipoDocumentoBN[] = $o_VTA_TipoDocumentoBN;
            }
        }
        return $a_VTA_TipoDocumentoBN;
    }

    /* Devuelve un objeto VTA_TipoDocumentoBN desde un objeto propel */
    public function insertObjectBN( $a_VTA_TipoDocumento )
    {
        $o_VTA_TipoDocumentoBN = new VTA_TipoDocumentoBN();
        if ( !is_null( $a_VTA_TipoDocumento['IdTipoDocumento'] ) ) $o_VTA_TipoDocumentoBN->setIdTipoDocumento( $a_VTA_TipoDocumento['IdTipoDocumento'] );
        if ( !is_null( $a_VTA_TipoDocumento['DescripcionLocal'] ) ) $o_VTA_TipoDocumentoBN->setDescripcionLocal( $a_VTA_TipoDocumento['DescripcionLocal'] );
        if ( !is_null( $a_VTA_TipoDocumento['TipoDocumentoCod'] ) ) $o_VTA_TipoDocumentoBN->setTipoDocumentoCod( $a_VTA_TipoDocumento['TipoDocumentoCod'] );
        if ( !is_null( $a_VTA_TipoDocumento['Secuencia'] ) ) $o_VTA_TipoDocumentoBN->setSecuencia( $a_VTA_TipoDocumento['Secuencia'] );
        if ( !is_null( $a_VTA_TipoDocumento['DescripcionIngles'] ) ) $o_VTA_TipoDocumentoBN->setDescripcionIngles( $a_VTA_TipoDocumento['DescripcionIngles'] );
        if ( !is_null( $a_VTA_TipoDocumento['EsFiscalFlag'] ) ) $o_VTA_TipoDocumentoBN->setEsFiscalFlag( $a_VTA_TipoDocumento['EsFiscalFlag'] );
        if ( !is_null( $a_VTA_TipoDocumento['CodigoFiscal'] ) ) $o_VTA_TipoDocumentoBN->setCodigoFiscal( $a_VTA_TipoDocumento['CodigoFiscal'] );
        if ( !is_null( $a_VTA_TipoDocumento['CodigoFiscalPrs'] ) ) $o_VTA_TipoDocumentoBN->setCodigoFiscalPrs( $a_VTA_TipoDocumento['CodigoFiscalPrs'] );
        if ( !is_null( $a_VTA_TipoDocumento['GenerarProvisionFlag'] ) ) $o_VTA_TipoDocumentoBN->setGenerarProvisionFlag( $a_VTA_TipoDocumento['GenerarProvisionFlag'] );
        if ( !is_null( $a_VTA_TipoDocumento['CuentaContableLocal'] ) ) $o_VTA_TipoDocumentoBN->setCuentaContableLocal( $a_VTA_TipoDocumento['CuentaContableLocal'] );
        if ( !is_null( $a_VTA_TipoDocumento['CuentaContableDolares'] ) ) $o_VTA_TipoDocumentoBN->setCuentaContableDolares( $a_VTA_TipoDocumento['CuentaContableDolares'] );
        if ( !is_null( $a_VTA_TipoDocumento['CuentaDudosaLocal'] ) ) $o_VTA_TipoDocumentoBN->setCuentaDudosaLocal( $a_VTA_TipoDocumento['CuentaDudosaLocal'] );
        if ( !is_null( $a_VTA_TipoDocumento['CuentaDudosaDolares'] ) ) $o_VTA_TipoDocumentoBN->setCuentaDudosaDolares( $a_VTA_TipoDocumento['CuentaDudosaDolares'] );
        if ( !is_null( $a_VTA_TipoDocumento['CuentaDudosaProvisionLocal'] ) ) $o_VTA_TipoDocumentoBN->setCuentaDudosaProvisionLocal( $a_VTA_TipoDocumento['CuentaDudosaProvisionLocal'] );
        if ( !is_null( $a_VTA_TipoDocumento['CuentaDudosaProvisionDolares'] ) ) $o_VTA_TipoDocumentoBN->setCuentaDudosaProvisionDolares( $a_VTA_TipoDocumento['CuentaDudosaProvisionDolares'] );
        if ( !is_null( $a_VTA_TipoDocumento['Clasificacion'] ) ) $o_VTA_TipoDocumentoBN->setClasificacion( $a_VTA_TipoDocumento['Clasificacion'] );
        if ( !is_null( $a_VTA_TipoDocumento['NumeroLineasImpresion'] ) ) $o_VTA_TipoDocumentoBN->setNumeroLineasImpresion( ( integer ) $a_VTA_TipoDocumento['NumeroLineasImpresion'] );
        if ( !is_null( $a_VTA_TipoDocumento['DisponibleIngresoManualFlag'] ) ) $o_VTA_TipoDocumentoBN->setDisponibleIngresoManualFlag( $a_VTA_TipoDocumento['DisponibleIngresoManualFlag'] );
        if ( !is_null( $a_VTA_TipoDocumento['Estado'] ) ) $o_VTA_TipoDocumentoBN->setEstado( $a_VTA_TipoDocumento['Estado'] );
        if ( !is_null( $a_VTA_TipoDocumento['UsuarioModificacion'] ) ) $o_VTA_TipoDocumentoBN->setUsuarioModificacion( $a_VTA_TipoDocumento['UsuarioModificacion'] );
        if ( !is_null( $a_VTA_TipoDocumento['FechaModificacion'] ) ) $o_VTA_TipoDocumentoBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_VTA_TipoDocumento['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_VTA_TipoDocumento['UsuarioCreacion'] ) ) $o_VTA_TipoDocumentoBN->setUsuarioCreacion( $a_VTA_TipoDocumento['UsuarioCreacion'] );
        if ( !is_null( $a_VTA_TipoDocumento['FechaCreacion'] ) ) $o_VTA_TipoDocumentoBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_VTA_TipoDocumento['FechaCreacion'], "Y-m-d H:i:s" ) );
        return $o_VTA_TipoDocumentoBN;
    }
}
?>