<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: VTA_ProductoFinalDet.xml */
/* Generado: 2021-06-26 00:00:08 */

/* Busqueda de registros de la tabla VTA_ProductoFinalDet. */
abstract class BaseVTA_ProductoFinalDetFN extends VTA_ProductoFinalDetBN
{
    /* Declaracion de constantes */
    const ProFinalDetId = "VTA_ProductoFinalDet.ProFinalDetId";
    const ProFinalId = "VTA_ProductoFinalDet.ProFinalId";
    const OrdenId = "VTA_ProductoFinalDet.OrdenId";
    const Secuencia = "VTA_ProductoFinalDet.Secuencia";
    const IdItem = "VTA_ProductoFinalDet.IdItem";
    const IdAlmacen = "VTA_ProductoFinalDet.IdAlmacen";
    const IdUnidad = "VTA_ProductoFinalDet.IdUnidad";
    const DetalleDescripcion = "VTA_ProductoFinalDet.DetalleDescripcion";
    const Cantidad = "VTA_ProductoFinalDet.Cantidad";
    const CantidadRecibida = "VTA_ProductoFinalDet.CantidadRecibida";
    const PesoUnitario = "VTA_ProductoFinalDet.PesoUnitario";
    const PesoTotal = "VTA_ProductoFinalDet.PesoTotal";
    const PrecioUnitarioAlq = "VTA_ProductoFinalDet.PrecioUnitarioAlq";
    const ImpuestoUnitarioAlq = "VTA_ProductoFinalDet.ImpuestoUnitarioAlq";
    const PrecioUnitarioConIGVAlq = "VTA_ProductoFinalDet.PrecioUnitarioConIGVAlq";
    const MontoSubTotalAlq = "VTA_ProductoFinalDet.MontoSubTotalAlq";
    const ImpuestoTotalAlq = "VTA_ProductoFinalDet.ImpuestoTotalAlq";
    const TotalConIGVAlq = "VTA_ProductoFinalDet.TotalConIGVAlq";
    const PrecioUnitarioVal = "VTA_ProductoFinalDet.PrecioUnitarioVal";
    const ImpuestoUnitarioVal = "VTA_ProductoFinalDet.ImpuestoUnitarioVal";
    const PrecioUnitarioConIGVVal = "VTA_ProductoFinalDet.PrecioUnitarioConIGVVal";
    const MontoSubTotalVal = "VTA_ProductoFinalDet.MontoSubTotalVal";
    const ImpuestoTotalVal = "VTA_ProductoFinalDet.ImpuestoTotalVal";
    const TotalConIGVVal = "VTA_ProductoFinalDet.TotalConIGVVal";
    const UsuarioCreacion = "VTA_ProductoFinalDet.UsuarioCreacion";
    const FechaCreacion = "VTA_ProductoFinalDet.FechaCreacion";
    const UsuarioModificacion = "VTA_ProductoFinalDet.UsuarioModificacion";
    const FechaModificacion = "VTA_ProductoFinalDet.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "VTA_ProductoFinalDet.ProFinalDetId AS ProFinalDetId, ";
        $s_SQLQuery .= "VTA_ProductoFinalDet.ProFinalId AS ProFinalId, ";
        $s_SQLQuery .= "VTA_ProductoFinalDet.OrdenId AS OrdenId, ";
        $s_SQLQuery .= "VTA_ProductoFinalDet.Secuencia AS Secuencia, ";
        $s_SQLQuery .= "VTA_ProductoFinalDet.IdItem AS IdItem, ";
        $s_SQLQuery .= "VTA_ProductoFinalDet.IdAlmacen AS IdAlmacen, ";
        $s_SQLQuery .= "VTA_ProductoFinalDet.IdUnidad AS IdUnidad, ";
        $s_SQLQuery .= "VTA_ProductoFinalDet.DetalleDescripcion AS DetalleDescripcion, ";
        $s_SQLQuery .= "VTA_ProductoFinalDet.Cantidad AS Cantidad, ";
        $s_SQLQuery .= "VTA_ProductoFinalDet.CantidadRecibida AS CantidadRecibida, ";
        $s_SQLQuery .= "VTA_ProductoFinalDet.PesoUnitario AS PesoUnitario, ";
        $s_SQLQuery .= "VTA_ProductoFinalDet.PesoTotal AS PesoTotal, ";
        $s_SQLQuery .= "VTA_ProductoFinalDet.PrecioUnitarioAlq AS PrecioUnitarioAlq, ";
        $s_SQLQuery .= "VTA_ProductoFinalDet.ImpuestoUnitarioAlq AS ImpuestoUnitarioAlq, ";
        $s_SQLQuery .= "VTA_ProductoFinalDet.PrecioUnitarioConIGVAlq AS PrecioUnitarioConIGVAlq, ";
        $s_SQLQuery .= "VTA_ProductoFinalDet.MontoSubTotalAlq AS MontoSubTotalAlq, ";
        $s_SQLQuery .= "VTA_ProductoFinalDet.ImpuestoTotalAlq AS ImpuestoTotalAlq, ";
        $s_SQLQuery .= "VTA_ProductoFinalDet.TotalConIGVAlq AS TotalConIGVAlq, ";
        $s_SQLQuery .= "VTA_ProductoFinalDet.PrecioUnitarioVal AS PrecioUnitarioVal, ";
        $s_SQLQuery .= "VTA_ProductoFinalDet.ImpuestoUnitarioVal AS ImpuestoUnitarioVal, ";
        $s_SQLQuery .= "VTA_ProductoFinalDet.PrecioUnitarioConIGVVal AS PrecioUnitarioConIGVVal, ";
        $s_SQLQuery .= "VTA_ProductoFinalDet.MontoSubTotalVal AS MontoSubTotalVal, ";
        $s_SQLQuery .= "VTA_ProductoFinalDet.ImpuestoTotalVal AS ImpuestoTotalVal, ";
        $s_SQLQuery .= "VTA_ProductoFinalDet.TotalConIGVVal AS TotalConIGVVal, ";
        $s_SQLQuery .= "VTA_ProductoFinalDet.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "VTA_ProductoFinalDet.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "VTA_ProductoFinalDet.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "VTA_ProductoFinalDet.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto VTA_ProductoFinalDetBN */
    public function setByBN( VTA_ProductoFinalDetBN $o_VTA_ProductoFinalDetBN )
    {
        if ( !is_null( $o_VTA_ProductoFinalDetBN->getProFinalDetId() ) )
        {
            $this->setProFinalDetId( $o_VTA_ProductoFinalDetBN->getProFinalDetId() );
        }
        if ( !is_null( $o_VTA_ProductoFinalDetBN->getProFinalId() ) )
        {
            $this->setProFinalId( $o_VTA_ProductoFinalDetBN->getProFinalId() );
        }
        if ( !is_null( $o_VTA_ProductoFinalDetBN->getOrdenId() ) )
        {
            $this->setOrdenId( $o_VTA_ProductoFinalDetBN->getOrdenId() );
        }
        if ( !is_null( $o_VTA_ProductoFinalDetBN->getSecuencia() ) )
        {
            $this->setSecuencia( $o_VTA_ProductoFinalDetBN->getSecuencia() );
        }
        if ( !is_null( $o_VTA_ProductoFinalDetBN->getIdItem() ) )
        {
            $this->setIdItem( $o_VTA_ProductoFinalDetBN->getIdItem() );
        }
        if ( !is_null( $o_VTA_ProductoFinalDetBN->getIdAlmacen() ) )
        {
            $this->setIdAlmacen( $o_VTA_ProductoFinalDetBN->getIdAlmacen() );
        }
        if ( !is_null( $o_VTA_ProductoFinalDetBN->getIdUnidad() ) )
        {
            $this->setIdUnidad( $o_VTA_ProductoFinalDetBN->getIdUnidad() );
        }
        if ( !is_null( $o_VTA_ProductoFinalDetBN->getDetalleDescripcion() ) )
        {
            $this->setDetalleDescripcion( $o_VTA_ProductoFinalDetBN->getDetalleDescripcion() );
        }
        if ( !is_null( $o_VTA_ProductoFinalDetBN->getCantidad() ) )
        {
            $this->setCantidad( $o_VTA_ProductoFinalDetBN->getCantidad() );
        }
        if ( !is_null( $o_VTA_ProductoFinalDetBN->getCantidadRecibida() ) )
        {
            $this->setCantidadRecibida( $o_VTA_ProductoFinalDetBN->getCantidadRecibida() );
        }
        if ( !is_null( $o_VTA_ProductoFinalDetBN->getPesoUnitario() ) )
        {
            $this->setPesoUnitario( $o_VTA_ProductoFinalDetBN->getPesoUnitario() );
        }
        if ( !is_null( $o_VTA_ProductoFinalDetBN->getPesoTotal() ) )
        {
            $this->setPesoTotal( $o_VTA_ProductoFinalDetBN->getPesoTotal() );
        }
        if ( !is_null( $o_VTA_ProductoFinalDetBN->getPrecioUnitarioAlq() ) )
        {
            $this->setPrecioUnitarioAlq( $o_VTA_ProductoFinalDetBN->getPrecioUnitarioAlq() );
        }
        if ( !is_null( $o_VTA_ProductoFinalDetBN->getImpuestoUnitarioAlq() ) )
        {
            $this->setImpuestoUnitarioAlq( $o_VTA_ProductoFinalDetBN->getImpuestoUnitarioAlq() );
        }
        if ( !is_null( $o_VTA_ProductoFinalDetBN->getPrecioUnitarioConIGVAlq() ) )
        {
            $this->setPrecioUnitarioConIGVAlq( $o_VTA_ProductoFinalDetBN->getPrecioUnitarioConIGVAlq() );
        }
        if ( !is_null( $o_VTA_ProductoFinalDetBN->getMontoSubTotalAlq() ) )
        {
            $this->setMontoSubTotalAlq( $o_VTA_ProductoFinalDetBN->getMontoSubTotalAlq() );
        }
        if ( !is_null( $o_VTA_ProductoFinalDetBN->getImpuestoTotalAlq() ) )
        {
            $this->setImpuestoTotalAlq( $o_VTA_ProductoFinalDetBN->getImpuestoTotalAlq() );
        }
        if ( !is_null( $o_VTA_ProductoFinalDetBN->getTotalConIGVAlq() ) )
        {
            $this->setTotalConIGVAlq( $o_VTA_ProductoFinalDetBN->getTotalConIGVAlq() );
        }
        if ( !is_null( $o_VTA_ProductoFinalDetBN->getPrecioUnitarioVal() ) )
        {
            $this->setPrecioUnitarioVal( $o_VTA_ProductoFinalDetBN->getPrecioUnitarioVal() );
        }
        if ( !is_null( $o_VTA_ProductoFinalDetBN->getImpuestoUnitarioVal() ) )
        {
            $this->setImpuestoUnitarioVal( $o_VTA_ProductoFinalDetBN->getImpuestoUnitarioVal() );
        }
        if ( !is_null( $o_VTA_ProductoFinalDetBN->getPrecioUnitarioConIGVVal() ) )
        {
            $this->setPrecioUnitarioConIGVVal( $o_VTA_ProductoFinalDetBN->getPrecioUnitarioConIGVVal() );
        }
        if ( !is_null( $o_VTA_ProductoFinalDetBN->getMontoSubTotalVal() ) )
        {
            $this->setMontoSubTotalVal( $o_VTA_ProductoFinalDetBN->getMontoSubTotalVal() );
        }
        if ( !is_null( $o_VTA_ProductoFinalDetBN->getImpuestoTotalVal() ) )
        {
            $this->setImpuestoTotalVal( $o_VTA_ProductoFinalDetBN->getImpuestoTotalVal() );
        }
        if ( !is_null( $o_VTA_ProductoFinalDetBN->getTotalConIGVVal() ) )
        {
            $this->setTotalConIGVVal( $o_VTA_ProductoFinalDetBN->getTotalConIGVVal() );
        }
        if ( !is_null( $o_VTA_ProductoFinalDetBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_VTA_ProductoFinalDetBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_VTA_ProductoFinalDetBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_VTA_ProductoFinalDetBN->getFechaCreacion() );
        }
        if ( !is_null( $o_VTA_ProductoFinalDetBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_VTA_ProductoFinalDetBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_VTA_ProductoFinalDetBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_VTA_ProductoFinalDetBN->getFechaModificacion() );
        }
    }

    /**
    * @return VTA_ProductoFinalDetBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_ProFinalDetId )
    {
        if( is_null( $i_ProFinalDetId ) ){ $i_ProFinalDetId = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM VTA_ProductoFinalDet ";
        $s_SQLQuery .= "WHERE ProFinalDetId = ".$i_ProFinalDetId." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_VTA_ProductoFinalDetBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_VTA_ProductoFinalDetBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_VTA_ProductoFinalDetBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getProFinalDetId() ) ) $s_SQLQuery .= "VTA_ProductoFinalDet.ProFinalDetId = ".$this->getProFinalDetId()." AND ";
        if ( !is_null( $this->getProFinalId() ) ) $s_SQLQuery .= "VTA_ProductoFinalDet.ProFinalId = ".$this->getProFinalId()." AND ";
        if ( !is_null( $this->getOrdenId() ) ) $s_SQLQuery .= "VTA_ProductoFinalDet.OrdenId = ".$this->getOrdenId()." AND ";
        if ( !is_null( $this->getSecuencia() ) ) $s_SQLQuery .= "VTA_ProductoFinalDet.Secuencia = '".$this->getSecuencia()."' AND ";
        if ( !is_null( $this->getIdItem() ) ) $s_SQLQuery .= "VTA_ProductoFinalDet.IdItem = '".$this->getIdItem()."' AND ";
        if ( !is_null( $this->getIdAlmacen() ) ) $s_SQLQuery .= "VTA_ProductoFinalDet.IdAlmacen = '".$this->getIdAlmacen()."' AND ";
        if ( !is_null( $this->getIdUnidad() ) ) $s_SQLQuery .= "VTA_ProductoFinalDet.IdUnidad = ".$this->getIdUnidad()." AND ";
        if ( !is_null( $this->getDetalleDescripcion() ) ) $s_SQLQuery .= "VTA_ProductoFinalDet.DetalleDescripcion = '".$this->getDetalleDescripcion()."' AND ";
        if ( !is_null( $this->getCantidad() ) ) $s_SQLQuery .= "VTA_ProductoFinalDet.Cantidad = ".$this->getCantidad()." AND ";
        if ( !is_null( $this->getCantidadRecibida() ) ) $s_SQLQuery .= "VTA_ProductoFinalDet.CantidadRecibida = ".$this->getCantidadRecibida()." AND ";
        if ( !is_null( $this->getPesoUnitario() ) ) $s_SQLQuery .= "VTA_ProductoFinalDet.PesoUnitario = ".$this->getPesoUnitario()." AND ";
        if ( !is_null( $this->getPesoTotal() ) ) $s_SQLQuery .= "VTA_ProductoFinalDet.PesoTotal = ".$this->getPesoTotal()." AND ";
        if ( !is_null( $this->getPrecioUnitarioAlq() ) ) $s_SQLQuery .= "VTA_ProductoFinalDet.PrecioUnitarioAlq = ".$this->getPrecioUnitarioAlq()." AND ";
        if ( !is_null( $this->getImpuestoUnitarioAlq() ) ) $s_SQLQuery .= "VTA_ProductoFinalDet.ImpuestoUnitarioAlq = ".$this->getImpuestoUnitarioAlq()." AND ";
        if ( !is_null( $this->getPrecioUnitarioConIGVAlq() ) ) $s_SQLQuery .= "VTA_ProductoFinalDet.PrecioUnitarioConIGVAlq = ".$this->getPrecioUnitarioConIGVAlq()." AND ";
        if ( !is_null( $this->getMontoSubTotalAlq() ) ) $s_SQLQuery .= "VTA_ProductoFinalDet.MontoSubTotalAlq = ".$this->getMontoSubTotalAlq()." AND ";
        if ( !is_null( $this->getImpuestoTotalAlq() ) ) $s_SQLQuery .= "VTA_ProductoFinalDet.ImpuestoTotalAlq = ".$this->getImpuestoTotalAlq()." AND ";
        if ( !is_null( $this->getTotalConIGVAlq() ) ) $s_SQLQuery .= "VTA_ProductoFinalDet.TotalConIGVAlq = ".$this->getTotalConIGVAlq()." AND ";
        if ( !is_null( $this->getPrecioUnitarioVal() ) ) $s_SQLQuery .= "VTA_ProductoFinalDet.PrecioUnitarioVal = ".$this->getPrecioUnitarioVal()." AND ";
        if ( !is_null( $this->getImpuestoUnitarioVal() ) ) $s_SQLQuery .= "VTA_ProductoFinalDet.ImpuestoUnitarioVal = ".$this->getImpuestoUnitarioVal()." AND ";
        if ( !is_null( $this->getPrecioUnitarioConIGVVal() ) ) $s_SQLQuery .= "VTA_ProductoFinalDet.PrecioUnitarioConIGVVal = ".$this->getPrecioUnitarioConIGVVal()." AND ";
        if ( !is_null( $this->getMontoSubTotalVal() ) ) $s_SQLQuery .= "VTA_ProductoFinalDet.MontoSubTotalVal = ".$this->getMontoSubTotalVal()." AND ";
        if ( !is_null( $this->getImpuestoTotalVal() ) ) $s_SQLQuery .= "VTA_ProductoFinalDet.ImpuestoTotalVal = ".$this->getImpuestoTotalVal()." AND ";
        if ( !is_null( $this->getTotalConIGVVal() ) ) $s_SQLQuery .= "VTA_ProductoFinalDet.TotalConIGVVal = ".$this->getTotalConIGVVal()." AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "VTA_ProductoFinalDet.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "VTA_ProductoFinalDet.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "VTA_ProductoFinalDet.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "VTA_ProductoFinalDet.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM VTA_ProductoFinalDet WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return VTA_ProductoFinalDetBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM VTA_ProductoFinalDet WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_VTA_ProductoFinalDetBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_VTA_ProductoFinalDetBN = $this->insertObjectBN( $a_SQLRow );
                $a_VTA_ProductoFinalDetBN[] = $o_VTA_ProductoFinalDetBN;
            }
        }
        return $a_VTA_ProductoFinalDetBN;
    }

    /* Devuelve un objeto VTA_ProductoFinalDetBN desde un objeto propel */
    public function insertObjectBN( $a_VTA_ProductoFinalDet )
    {
        $o_VTA_ProductoFinalDetBN = new VTA_ProductoFinalDetBN();
        if ( !is_null( $a_VTA_ProductoFinalDet['ProFinalDetId'] ) ) $o_VTA_ProductoFinalDetBN->setProFinalDetId( ( integer ) $a_VTA_ProductoFinalDet['ProFinalDetId'] );
        if ( !is_null( $a_VTA_ProductoFinalDet['ProFinalId'] ) ) $o_VTA_ProductoFinalDetBN->setProFinalId( ( integer ) $a_VTA_ProductoFinalDet['ProFinalId'] );
        if ( !is_null( $a_VTA_ProductoFinalDet['OrdenId'] ) ) $o_VTA_ProductoFinalDetBN->setOrdenId( ( integer ) $a_VTA_ProductoFinalDet['OrdenId'] );
        if ( !is_null( $a_VTA_ProductoFinalDet['Secuencia'] ) ) $o_VTA_ProductoFinalDetBN->setSecuencia( $a_VTA_ProductoFinalDet['Secuencia'] );
        if ( !is_null( $a_VTA_ProductoFinalDet['IdItem'] ) ) $o_VTA_ProductoFinalDetBN->setIdItem( $a_VTA_ProductoFinalDet['IdItem'] );
        if ( !is_null( $a_VTA_ProductoFinalDet['IdAlmacen'] ) ) $o_VTA_ProductoFinalDetBN->setIdAlmacen( $a_VTA_ProductoFinalDet['IdAlmacen'] );
        if ( !is_null( $a_VTA_ProductoFinalDet['IdUnidad'] ) ) $o_VTA_ProductoFinalDetBN->setIdUnidad( ( integer ) $a_VTA_ProductoFinalDet['IdUnidad'] );
        if ( !is_null( $a_VTA_ProductoFinalDet['DetalleDescripcion'] ) ) $o_VTA_ProductoFinalDetBN->setDetalleDescripcion( $a_VTA_ProductoFinalDet['DetalleDescripcion'] );
        if ( !is_null( $a_VTA_ProductoFinalDet['Cantidad'] ) ) $o_VTA_ProductoFinalDetBN->setCantidad( ( float ) $a_VTA_ProductoFinalDet['Cantidad'] );
        if ( !is_null( $a_VTA_ProductoFinalDet['CantidadRecibida'] ) ) $o_VTA_ProductoFinalDetBN->setCantidadRecibida( ( float ) $a_VTA_ProductoFinalDet['CantidadRecibida'] );
        if ( !is_null( $a_VTA_ProductoFinalDet['PesoUnitario'] ) ) $o_VTA_ProductoFinalDetBN->setPesoUnitario( ( float ) $a_VTA_ProductoFinalDet['PesoUnitario'] );
        if ( !is_null( $a_VTA_ProductoFinalDet['PesoTotal'] ) ) $o_VTA_ProductoFinalDetBN->setPesoTotal( ( float ) $a_VTA_ProductoFinalDet['PesoTotal'] );
        if ( !is_null( $a_VTA_ProductoFinalDet['PrecioUnitarioAlq'] ) ) $o_VTA_ProductoFinalDetBN->setPrecioUnitarioAlq( ( float ) $a_VTA_ProductoFinalDet['PrecioUnitarioAlq'] );
        if ( !is_null( $a_VTA_ProductoFinalDet['ImpuestoUnitarioAlq'] ) ) $o_VTA_ProductoFinalDetBN->setImpuestoUnitarioAlq( ( float ) $a_VTA_ProductoFinalDet['ImpuestoUnitarioAlq'] );
        if ( !is_null( $a_VTA_ProductoFinalDet['PrecioUnitarioConIGVAlq'] ) ) $o_VTA_ProductoFinalDetBN->setPrecioUnitarioConIGVAlq( ( float ) $a_VTA_ProductoFinalDet['PrecioUnitarioConIGVAlq'] );
        if ( !is_null( $a_VTA_ProductoFinalDet['MontoSubTotalAlq'] ) ) $o_VTA_ProductoFinalDetBN->setMontoSubTotalAlq( ( float ) $a_VTA_ProductoFinalDet['MontoSubTotalAlq'] );
        if ( !is_null( $a_VTA_ProductoFinalDet['ImpuestoTotalAlq'] ) ) $o_VTA_ProductoFinalDetBN->setImpuestoTotalAlq( ( float ) $a_VTA_ProductoFinalDet['ImpuestoTotalAlq'] );
        if ( !is_null( $a_VTA_ProductoFinalDet['TotalConIGVAlq'] ) ) $o_VTA_ProductoFinalDetBN->setTotalConIGVAlq( ( float ) $a_VTA_ProductoFinalDet['TotalConIGVAlq'] );
        if ( !is_null( $a_VTA_ProductoFinalDet['PrecioUnitarioVal'] ) ) $o_VTA_ProductoFinalDetBN->setPrecioUnitarioVal( ( float ) $a_VTA_ProductoFinalDet['PrecioUnitarioVal'] );
        if ( !is_null( $a_VTA_ProductoFinalDet['ImpuestoUnitarioVal'] ) ) $o_VTA_ProductoFinalDetBN->setImpuestoUnitarioVal( ( float ) $a_VTA_ProductoFinalDet['ImpuestoUnitarioVal'] );
        if ( !is_null( $a_VTA_ProductoFinalDet['PrecioUnitarioConIGVVal'] ) ) $o_VTA_ProductoFinalDetBN->setPrecioUnitarioConIGVVal( ( float ) $a_VTA_ProductoFinalDet['PrecioUnitarioConIGVVal'] );
        if ( !is_null( $a_VTA_ProductoFinalDet['MontoSubTotalVal'] ) ) $o_VTA_ProductoFinalDetBN->setMontoSubTotalVal( ( float ) $a_VTA_ProductoFinalDet['MontoSubTotalVal'] );
        if ( !is_null( $a_VTA_ProductoFinalDet['ImpuestoTotalVal'] ) ) $o_VTA_ProductoFinalDetBN->setImpuestoTotalVal( ( float ) $a_VTA_ProductoFinalDet['ImpuestoTotalVal'] );
        if ( !is_null( $a_VTA_ProductoFinalDet['TotalConIGVVal'] ) ) $o_VTA_ProductoFinalDetBN->setTotalConIGVVal( ( float ) $a_VTA_ProductoFinalDet['TotalConIGVVal'] );
        if ( !is_null( $a_VTA_ProductoFinalDet['UsuarioCreacion'] ) ) $o_VTA_ProductoFinalDetBN->setUsuarioCreacion( $a_VTA_ProductoFinalDet['UsuarioCreacion'] );
        if ( !is_null( $a_VTA_ProductoFinalDet['FechaCreacion'] ) ) $o_VTA_ProductoFinalDetBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_VTA_ProductoFinalDet['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_VTA_ProductoFinalDet['UsuarioModificacion'] ) ) $o_VTA_ProductoFinalDetBN->setUsuarioModificacion( $a_VTA_ProductoFinalDet['UsuarioModificacion'] );
        if ( !is_null( $a_VTA_ProductoFinalDet['FechaModificacion'] ) ) $o_VTA_ProductoFinalDetBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_VTA_ProductoFinalDet['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_VTA_ProductoFinalDetBN;
    }
}
?>