<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: VTA_OrdenArchivos.xml */
/* Generado: 2021-06-26 00:00:07 */

/* Busqueda de registros de la tabla VTA_OrdenArchivos. */
abstract class BaseVTA_OrdenArchivosFN extends VTA_OrdenArchivosBN
{
    /* Declaracion de constantes */
    const OrdenId = "VTA_OrdenArchivos.OrdenId";
    const IdSecuencia = "VTA_OrdenArchivos.IdSecuencia";
    const TipoArchivoId = "VTA_OrdenArchivos.TipoArchivoId";
    const Nombre = "VTA_OrdenArchivos.Nombre";
    const Tipo = "VTA_OrdenArchivos.Tipo";
    const TipoCompleto = "VTA_OrdenArchivos.TipoCompleto";
    const Tamanio = "VTA_OrdenArchivos.Tamanio";
    const UbicacionURL = "VTA_OrdenArchivos.UbicacionURL";
    const UbicacionFisica = "VTA_OrdenArchivos.UbicacionFisica";
    const FechaCreacion = "VTA_OrdenArchivos.FechaCreacion";
    const UsuarioCreacion = "VTA_OrdenArchivos.UsuarioCreacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "VTA_OrdenArchivos.OrdenId AS OrdenId, ";
        $s_SQLQuery .= "VTA_OrdenArchivos.IdSecuencia AS IdSecuencia, ";
        $s_SQLQuery .= "VTA_OrdenArchivos.TipoArchivoId AS TipoArchivoId, ";
        $s_SQLQuery .= "VTA_OrdenArchivos.Nombre AS Nombre, ";
        $s_SQLQuery .= "VTA_OrdenArchivos.Tipo AS Tipo, ";
        $s_SQLQuery .= "VTA_OrdenArchivos.TipoCompleto AS TipoCompleto, ";
        $s_SQLQuery .= "VTA_OrdenArchivos.Tamanio AS Tamanio, ";
        $s_SQLQuery .= "VTA_OrdenArchivos.UbicacionURL AS UbicacionURL, ";
        $s_SQLQuery .= "VTA_OrdenArchivos.UbicacionFisica AS UbicacionFisica, ";
        $s_SQLQuery .= "VTA_OrdenArchivos.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "VTA_OrdenArchivos.UsuarioCreacion AS UsuarioCreacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto VTA_OrdenArchivosBN */
    public function setByBN( VTA_OrdenArchivosBN $o_VTA_OrdenArchivosBN )
    {
        if ( !is_null( $o_VTA_OrdenArchivosBN->getOrdenId() ) )
        {
            $this->setOrdenId( $o_VTA_OrdenArchivosBN->getOrdenId() );
        }
        if ( !is_null( $o_VTA_OrdenArchivosBN->getIdSecuencia() ) )
        {
            $this->setIdSecuencia( $o_VTA_OrdenArchivosBN->getIdSecuencia() );
        }
        if ( !is_null( $o_VTA_OrdenArchivosBN->getTipoArchivoId() ) )
        {
            $this->setTipoArchivoId( $o_VTA_OrdenArchivosBN->getTipoArchivoId() );
        }
        if ( !is_null( $o_VTA_OrdenArchivosBN->getNombre() ) )
        {
            $this->setNombre( $o_VTA_OrdenArchivosBN->getNombre() );
        }
        if ( !is_null( $o_VTA_OrdenArchivosBN->getTipo() ) )
        {
            $this->setTipo( $o_VTA_OrdenArchivosBN->getTipo() );
        }
        if ( !is_null( $o_VTA_OrdenArchivosBN->getTipoCompleto() ) )
        {
            $this->setTipoCompleto( $o_VTA_OrdenArchivosBN->getTipoCompleto() );
        }
        if ( !is_null( $o_VTA_OrdenArchivosBN->getTamanio() ) )
        {
            $this->setTamanio( $o_VTA_OrdenArchivosBN->getTamanio() );
        }
        if ( !is_null( $o_VTA_OrdenArchivosBN->getUbicacionURL() ) )
        {
            $this->setUbicacionURL( $o_VTA_OrdenArchivosBN->getUbicacionURL() );
        }
        if ( !is_null( $o_VTA_OrdenArchivosBN->getUbicacionFisica() ) )
        {
            $this->setUbicacionFisica( $o_VTA_OrdenArchivosBN->getUbicacionFisica() );
        }
        if ( !is_null( $o_VTA_OrdenArchivosBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_VTA_OrdenArchivosBN->getFechaCreacion() );
        }
        if ( !is_null( $o_VTA_OrdenArchivosBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_VTA_OrdenArchivosBN->getUsuarioCreacion() );
        }
    }

    /**
    * @return VTA_OrdenArchivosBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_OrdenId, $i_IdSecuencia )
    {
        if( is_null( $i_OrdenId ) ){ $i_OrdenId = -1; } 
        if( is_null( $i_IdSecuencia ) ){ $i_IdSecuencia = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM VTA_OrdenArchivos ";
        $s_SQLQuery .= "WHERE OrdenId = ".$i_OrdenId." ";
        $s_SQLQuery .= "AND IdSecuencia = ".$i_IdSecuencia." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_VTA_OrdenArchivosBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_VTA_OrdenArchivosBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_VTA_OrdenArchivosBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getOrdenId() ) ) $s_SQLQuery .= "VTA_OrdenArchivos.OrdenId = ".$this->getOrdenId()." AND ";
        if ( !is_null( $this->getIdSecuencia() ) ) $s_SQLQuery .= "VTA_OrdenArchivos.IdSecuencia = ".$this->getIdSecuencia()." AND ";
        if ( !is_null( $this->getTipoArchivoId() ) ) $s_SQLQuery .= "VTA_OrdenArchivos.TipoArchivoId = ".$this->getTipoArchivoId()." AND ";
        if ( !is_null( $this->getNombre() ) ) $s_SQLQuery .= "VTA_OrdenArchivos.Nombre = '".$this->getNombre()."' AND ";
        if ( !is_null( $this->getTipo() ) ) $s_SQLQuery .= "VTA_OrdenArchivos.Tipo = '".$this->getTipo()."' AND ";
        if ( !is_null( $this->getTipoCompleto() ) ) $s_SQLQuery .= "VTA_OrdenArchivos.TipoCompleto = '".$this->getTipoCompleto()."' AND ";
        if ( !is_null( $this->getTamanio() ) ) $s_SQLQuery .= "VTA_OrdenArchivos.Tamanio = ".$this->getTamanio()." AND ";
        if ( !is_null( $this->getUbicacionURL() ) ) $s_SQLQuery .= "VTA_OrdenArchivos.UbicacionURL = '".$this->getUbicacionURL()."' AND ";
        if ( !is_null( $this->getUbicacionFisica() ) ) $s_SQLQuery .= "VTA_OrdenArchivos.UbicacionFisica = '".$this->getUbicacionFisica()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "VTA_OrdenArchivos.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "VTA_OrdenArchivos.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM VTA_OrdenArchivos WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return VTA_OrdenArchivosBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM VTA_OrdenArchivos WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_VTA_OrdenArchivosBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_VTA_OrdenArchivosBN = $this->insertObjectBN( $a_SQLRow );
                $a_VTA_OrdenArchivosBN[] = $o_VTA_OrdenArchivosBN;
            }
        }
        return $a_VTA_OrdenArchivosBN;
    }

    /* Devuelve un objeto VTA_OrdenArchivosBN desde un objeto propel */
    public function insertObjectBN( $a_VTA_OrdenArchivos )
    {
        $o_VTA_OrdenArchivosBN = new VTA_OrdenArchivosBN();
        if ( !is_null( $a_VTA_OrdenArchivos['OrdenId'] ) ) $o_VTA_OrdenArchivosBN->setOrdenId( ( integer ) $a_VTA_OrdenArchivos['OrdenId'] );
        if ( !is_null( $a_VTA_OrdenArchivos['IdSecuencia'] ) ) $o_VTA_OrdenArchivosBN->setIdSecuencia( ( integer ) $a_VTA_OrdenArchivos['IdSecuencia'] );
        if ( !is_null( $a_VTA_OrdenArchivos['TipoArchivoId'] ) ) $o_VTA_OrdenArchivosBN->setTipoArchivoId( ( integer ) $a_VTA_OrdenArchivos['TipoArchivoId'] );
        if ( !is_null( $a_VTA_OrdenArchivos['Nombre'] ) ) $o_VTA_OrdenArchivosBN->setNombre( $a_VTA_OrdenArchivos['Nombre'] );
        if ( !is_null( $a_VTA_OrdenArchivos['Tipo'] ) ) $o_VTA_OrdenArchivosBN->setTipo( $a_VTA_OrdenArchivos['Tipo'] );
        if ( !is_null( $a_VTA_OrdenArchivos['TipoCompleto'] ) ) $o_VTA_OrdenArchivosBN->setTipoCompleto( $a_VTA_OrdenArchivos['TipoCompleto'] );
        if ( !is_null( $a_VTA_OrdenArchivos['Tamanio'] ) ) $o_VTA_OrdenArchivosBN->setTamanio( ( integer ) $a_VTA_OrdenArchivos['Tamanio'] );
        if ( !is_null( $a_VTA_OrdenArchivos['UbicacionURL'] ) ) $o_VTA_OrdenArchivosBN->setUbicacionURL( $a_VTA_OrdenArchivos['UbicacionURL'] );
        if ( !is_null( $a_VTA_OrdenArchivos['UbicacionFisica'] ) ) $o_VTA_OrdenArchivosBN->setUbicacionFisica( $a_VTA_OrdenArchivos['UbicacionFisica'] );
        if ( !is_null( $a_VTA_OrdenArchivos['FechaCreacion'] ) ) $o_VTA_OrdenArchivosBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_VTA_OrdenArchivos['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_VTA_OrdenArchivos['UsuarioCreacion'] ) ) $o_VTA_OrdenArchivosBN->setUsuarioCreacion( $a_VTA_OrdenArchivos['UsuarioCreacion'] );
        return $o_VTA_OrdenArchivosBN;
    }
}
?>