<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: TR_Vehiculo.xml */
/* Generado: 2021-09-09 16:56:52 */

/* Busqueda de registros de la tabla TR_Vehiculo. */
abstract class BaseTR_VehiculoFN extends TR_VehiculoBN
{
    /* Declaracion de constantes */
    const IdVehiculo = "TR_Vehiculo.IdVehiculo";
    const IdCompania = "TR_Vehiculo.IdCompania";
    const IdSucursal = "TR_Vehiculo.IdSucursal";
    const VehiculoPlaca = "TR_Vehiculo.VehiculoPlaca";
    const VehiculoPlaca2 = "TR_Vehiculo.VehiculoPlaca2";
    const VehiculoMarca = "TR_Vehiculo.VehiculoMarca";
    const VehiculoMdelo = "TR_Vehiculo.VehiculoMdelo";
    const NroMotor = "TR_Vehiculo.NroMotor";
    const Altura = "TR_Vehiculo.Altura";
    const Volumen = "TR_Vehiculo.Volumen";
    const NroSOAT = "TR_Vehiculo.NroSOAT";
    const VencSOAT = "TR_Vehiculo.VencSOAT";
    const NroMTC = "TR_Vehiculo.NroMTC";
    const RUCtransportista = "TR_Vehiculo.RUCtransportista";
    const Estado = "TR_Vehiculo.Estado";
    const FechaCreacion = "TR_Vehiculo.FechaCreacion";
    const UsuarioCreacion = "TR_Vehiculo.UsuarioCreacion";
    const FechaModificacion = "TR_Vehiculo.FechaModificacion";
    const UsuarioModificacion = "TR_Vehiculo.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "TR_Vehiculo.IdVehiculo AS IdVehiculo, ";
        $s_SQLQuery .= "TR_Vehiculo.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "TR_Vehiculo.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "TR_Vehiculo.VehiculoPlaca AS VehiculoPlaca, ";
        $s_SQLQuery .= "TR_Vehiculo.VehiculoPlaca2 AS VehiculoPlaca2, ";
        $s_SQLQuery .= "TR_Vehiculo.VehiculoMarca AS VehiculoMarca, ";
        $s_SQLQuery .= "TR_Vehiculo.VehiculoMdelo AS VehiculoMdelo, ";
        $s_SQLQuery .= "TR_Vehiculo.NroMotor AS NroMotor, ";
        $s_SQLQuery .= "TR_Vehiculo.Altura AS Altura, ";
        $s_SQLQuery .= "TR_Vehiculo.Volumen AS Volumen, ";
        $s_SQLQuery .= "TR_Vehiculo.NroSOAT AS NroSOAT, ";
        $s_SQLQuery .= "TR_Vehiculo.VencSOAT AS VencSOAT, ";
        $s_SQLQuery .= "TR_Vehiculo.NroMTC AS NroMTC, ";
        $s_SQLQuery .= "TR_Vehiculo.RUCtransportista AS RUCtransportista, ";
        $s_SQLQuery .= "TR_Vehiculo.Estado AS Estado, ";
        $s_SQLQuery .= "TR_Vehiculo.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "TR_Vehiculo.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "TR_Vehiculo.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "TR_Vehiculo.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto TR_VehiculoBN */
    public function setByBN( TR_VehiculoBN $o_TR_VehiculoBN )
    {
        if ( !is_null( $o_TR_VehiculoBN->getIdVehiculo() ) )
        {
            $this->setIdVehiculo( $o_TR_VehiculoBN->getIdVehiculo() );
        }
        if ( !is_null( $o_TR_VehiculoBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_TR_VehiculoBN->getIdCompania() );
        }
        if ( !is_null( $o_TR_VehiculoBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_TR_VehiculoBN->getIdSucursal() );
        }
        if ( !is_null( $o_TR_VehiculoBN->getVehiculoPlaca() ) )
        {
            $this->setVehiculoPlaca( $o_TR_VehiculoBN->getVehiculoPlaca() );
        }
        if ( !is_null( $o_TR_VehiculoBN->getVehiculoPlaca2() ) )
        {
            $this->setVehiculoPlaca2( $o_TR_VehiculoBN->getVehiculoPlaca2() );
        }
        if ( !is_null( $o_TR_VehiculoBN->getVehiculoMarca() ) )
        {
            $this->setVehiculoMarca( $o_TR_VehiculoBN->getVehiculoMarca() );
        }
        if ( !is_null( $o_TR_VehiculoBN->getVehiculoMdelo() ) )
        {
            $this->setVehiculoMdelo( $o_TR_VehiculoBN->getVehiculoMdelo() );
        }
        if ( !is_null( $o_TR_VehiculoBN->getNroMotor() ) )
        {
            $this->setNroMotor( $o_TR_VehiculoBN->getNroMotor() );
        }
        if ( !is_null( $o_TR_VehiculoBN->getAltura() ) )
        {
            $this->setAltura( $o_TR_VehiculoBN->getAltura() );
        }
        if ( !is_null( $o_TR_VehiculoBN->getVolumen() ) )
        {
            $this->setVolumen( $o_TR_VehiculoBN->getVolumen() );
        }
        if ( !is_null( $o_TR_VehiculoBN->getNroSOAT() ) )
        {
            $this->setNroSOAT( $o_TR_VehiculoBN->getNroSOAT() );
        }
        if ( !is_null( $o_TR_VehiculoBN->getVencSOAT() ) )
        {
            $this->setVencSOAT( $o_TR_VehiculoBN->getVencSOAT() );
        }
        if ( !is_null( $o_TR_VehiculoBN->getNroMTC() ) )
        {
            $this->setNroMTC( $o_TR_VehiculoBN->getNroMTC() );
        }
        if ( !is_null( $o_TR_VehiculoBN->getRUCtransportista() ) )
        {
            $this->setRUCtransportista( $o_TR_VehiculoBN->getRUCtransportista() );
        }
        if ( !is_null( $o_TR_VehiculoBN->getEstado() ) )
        {
            $this->setEstado( $o_TR_VehiculoBN->getEstado() );
        }
        if ( !is_null( $o_TR_VehiculoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_TR_VehiculoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_TR_VehiculoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_TR_VehiculoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_TR_VehiculoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_TR_VehiculoBN->getFechaModificacion() );
        }
        if ( !is_null( $o_TR_VehiculoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_TR_VehiculoBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return TR_VehiculoBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdVehiculo )
    {
        if( is_null( $i_IdVehiculo ) ){ $i_IdVehiculo = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM TR_Vehiculo ";
        $s_SQLQuery .= "WHERE IdVehiculo = ".$i_IdVehiculo." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_TR_VehiculoBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_TR_VehiculoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_TR_VehiculoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdVehiculo() ) ) $s_SQLQuery .= "TR_Vehiculo.IdVehiculo = ".$this->getIdVehiculo()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "TR_Vehiculo.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "TR_Vehiculo.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getVehiculoPlaca() ) ) $s_SQLQuery .= "TR_Vehiculo.VehiculoPlaca = '".$this->getVehiculoPlaca()."' AND ";
        if ( !is_null( $this->getVehiculoPlaca2() ) ) $s_SQLQuery .= "TR_Vehiculo.VehiculoPlaca2 = '".$this->getVehiculoPlaca2()."' AND ";
        if ( !is_null( $this->getVehiculoMarca() ) ) $s_SQLQuery .= "TR_Vehiculo.VehiculoMarca = '".$this->getVehiculoMarca()."' AND ";
        if ( !is_null( $this->getVehiculoMdelo() ) ) $s_SQLQuery .= "TR_Vehiculo.VehiculoMdelo = '".$this->getVehiculoMdelo()."' AND ";
        if ( !is_null( $this->getNroMotor() ) ) $s_SQLQuery .= "TR_Vehiculo.NroMotor = '".$this->getNroMotor()."' AND ";
        if ( !is_null( $this->getAltura() ) ) $s_SQLQuery .= "TR_Vehiculo.Altura = '".$this->getAltura()."' AND ";
        if ( !is_null( $this->getVolumen() ) ) $s_SQLQuery .= "TR_Vehiculo.Volumen = '".$this->getVolumen()."' AND ";
        if ( !is_null( $this->getNroSOAT() ) ) $s_SQLQuery .= "TR_Vehiculo.NroSOAT = '".$this->getNroSOAT()."' AND ";
        if ( !is_null( $this->getVencSOAT() ) ) $s_SQLQuery .= "TR_Vehiculo.VencSOAT = '".$this->getVencSOAT()."' AND ";
        if ( !is_null( $this->getNroMTC() ) ) $s_SQLQuery .= "TR_Vehiculo.NroMTC = '".$this->getNroMTC()."' AND ";
        if ( !is_null( $this->getRUCtransportista() ) ) $s_SQLQuery .= "TR_Vehiculo.RUCtransportista = '".$this->getRUCtransportista()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "TR_Vehiculo.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "TR_Vehiculo.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "TR_Vehiculo.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "TR_Vehiculo.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "TR_Vehiculo.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM TR_Vehiculo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return TR_VehiculoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM TR_Vehiculo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_TR_VehiculoBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_TR_VehiculoBN = $this->insertObjectBN( $a_SQLRow );
                $a_TR_VehiculoBN[] = $o_TR_VehiculoBN;
            }
        }
        return $a_TR_VehiculoBN;
    }

    /* Devuelve un objeto TR_VehiculoBN desde un objeto propel */
    public function insertObjectBN( $a_TR_Vehiculo )
    {
        $o_TR_VehiculoBN = new TR_VehiculoBN();
        if ( !is_null( $a_TR_Vehiculo['IdVehiculo'] ) ) $o_TR_VehiculoBN->setIdVehiculo( ( integer ) $a_TR_Vehiculo['IdVehiculo'] );
        if ( !is_null( $a_TR_Vehiculo['IdCompania'] ) ) $o_TR_VehiculoBN->setIdCompania( ( integer ) $a_TR_Vehiculo['IdCompania'] );
        if ( !is_null( $a_TR_Vehiculo['IdSucursal'] ) ) $o_TR_VehiculoBN->setIdSucursal( ( integer ) $a_TR_Vehiculo['IdSucursal'] );
        if ( !is_null( $a_TR_Vehiculo['VehiculoPlaca'] ) ) $o_TR_VehiculoBN->setVehiculoPlaca( $a_TR_Vehiculo['VehiculoPlaca'] );
        if ( !is_null( $a_TR_Vehiculo['VehiculoPlaca2'] ) ) $o_TR_VehiculoBN->setVehiculoPlaca2( $a_TR_Vehiculo['VehiculoPlaca2'] );
        if ( !is_null( $a_TR_Vehiculo['VehiculoMarca'] ) ) $o_TR_VehiculoBN->setVehiculoMarca( $a_TR_Vehiculo['VehiculoMarca'] );
        if ( !is_null( $a_TR_Vehiculo['VehiculoMdelo'] ) ) $o_TR_VehiculoBN->setVehiculoMdelo( $a_TR_Vehiculo['VehiculoMdelo'] );
        if ( !is_null( $a_TR_Vehiculo['NroMotor'] ) ) $o_TR_VehiculoBN->setNroMotor( $a_TR_Vehiculo['NroMotor'] );
        if ( !is_null( $a_TR_Vehiculo['Altura'] ) ) $o_TR_VehiculoBN->setAltura( $a_TR_Vehiculo['Altura'] );
        if ( !is_null( $a_TR_Vehiculo['Volumen'] ) ) $o_TR_VehiculoBN->setVolumen( $a_TR_Vehiculo['Volumen'] );
        if ( !is_null( $a_TR_Vehiculo['NroSOAT'] ) ) $o_TR_VehiculoBN->setNroSOAT( $a_TR_Vehiculo['NroSOAT'] );
        if ( !is_null( $a_TR_Vehiculo['VencSOAT'] ) ) $o_TR_VehiculoBN->setVencSOAT( utilTimestamp::getTimestamp( $a_TR_Vehiculo['VencSOAT'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_TR_Vehiculo['NroMTC'] ) ) $o_TR_VehiculoBN->setNroMTC( $a_TR_Vehiculo['NroMTC'] );
        if ( !is_null( $a_TR_Vehiculo['RUCtransportista'] ) ) $o_TR_VehiculoBN->setRUCtransportista( $a_TR_Vehiculo['RUCtransportista'] );
        if ( !is_null( $a_TR_Vehiculo['Estado'] ) ) $o_TR_VehiculoBN->setEstado( $a_TR_Vehiculo['Estado'] );
        if ( !is_null( $a_TR_Vehiculo['FechaCreacion'] ) ) $o_TR_VehiculoBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_TR_Vehiculo['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_TR_Vehiculo['UsuarioCreacion'] ) ) $o_TR_VehiculoBN->setUsuarioCreacion( $a_TR_Vehiculo['UsuarioCreacion'] );
        if ( !is_null( $a_TR_Vehiculo['FechaModificacion'] ) ) $o_TR_VehiculoBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_TR_Vehiculo['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_TR_Vehiculo['UsuarioModificacion'] ) ) $o_TR_VehiculoBN->setUsuarioModificacion( $a_TR_Vehiculo['UsuarioModificacion'] );
        return $o_TR_VehiculoBN;
    }
}
?>