<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: TR_Chofer.xml */
/* Generado: 2021-09-09 16:55:24 */

/* Busqueda de registros de la tabla TR_Chofer. */
abstract class BaseTR_ChoferFN extends TR_ChoferBN
{
    /* Declaracion de constantes */
    const IdChofer = "TR_Chofer.IdChofer";
    const IdCompania = "TR_Chofer.IdCompania";
    const IdSucursal = "TR_Chofer.IdSucursal";
    const ChoferDocumento = "TR_Chofer.ChoferDocumento";
    const ChoferApellidoP = "TR_Chofer.ChoferApellidoP";
    const ChoferApellidoM = "TR_Chofer.ChoferApellidoM";
    const ChoferNombre = "TR_Chofer.ChoferNombre";
    const ChoferTelefono = "TR_Chofer.ChoferTelefono";
    const ChoferLicencia = "TR_Chofer.ChoferLicencia";
    const ChoferCategoria = "TR_Chofer.ChoferCategoria";
    const ChoferDireccion = "TR_Chofer.ChoferDireccion";
    const ChoferUbigeo = "TR_Chofer.ChoferUbigeo";
    const ChoferAyudante = "TR_Chofer.ChoferAyudante";
    const Estado = "TR_Chofer.Estado";
    const FechaCreacion = "TR_Chofer.FechaCreacion";
    const UsuarioCreacion = "TR_Chofer.UsuarioCreacion";
    const FechaModificacion = "TR_Chofer.FechaModificacion";
    const UsuarioModificacion = "TR_Chofer.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "TR_Chofer.IdChofer AS IdChofer, ";
        $s_SQLQuery .= "TR_Chofer.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "TR_Chofer.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "TR_Chofer.ChoferDocumento AS ChoferDocumento, ";
        $s_SQLQuery .= "TR_Chofer.ChoferApellidoP AS ChoferApellidoP, ";
        $s_SQLQuery .= "TR_Chofer.ChoferApellidoM AS ChoferApellidoM, ";
        $s_SQLQuery .= "TR_Chofer.ChoferNombre AS ChoferNombre, ";
        $s_SQLQuery .= "TR_Chofer.ChoferTelefono AS ChoferTelefono, ";
        $s_SQLQuery .= "TR_Chofer.ChoferLicencia AS ChoferLicencia, ";
        $s_SQLQuery .= "TR_Chofer.ChoferCategoria AS ChoferCategoria, ";
        $s_SQLQuery .= "TR_Chofer.ChoferDireccion AS ChoferDireccion, ";
        $s_SQLQuery .= "TR_Chofer.ChoferUbigeo AS ChoferUbigeo, ";
        $s_SQLQuery .= "TR_Chofer.ChoferAyudante AS ChoferAyudante, ";
        $s_SQLQuery .= "TR_Chofer.Estado AS Estado, ";
        $s_SQLQuery .= "TR_Chofer.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "TR_Chofer.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "TR_Chofer.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "TR_Chofer.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto TR_ChoferBN */
    public function setByBN( TR_ChoferBN $o_TR_ChoferBN )
    {
        if ( !is_null( $o_TR_ChoferBN->getIdChofer() ) )
        {
            $this->setIdChofer( $o_TR_ChoferBN->getIdChofer() );
        }
        if ( !is_null( $o_TR_ChoferBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_TR_ChoferBN->getIdCompania() );
        }
        if ( !is_null( $o_TR_ChoferBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_TR_ChoferBN->getIdSucursal() );
        }
        if ( !is_null( $o_TR_ChoferBN->getChoferDocumento() ) )
        {
            $this->setChoferDocumento( $o_TR_ChoferBN->getChoferDocumento() );
        }
        if ( !is_null( $o_TR_ChoferBN->getChoferApellidoP() ) )
        {
            $this->setChoferApellidoP( $o_TR_ChoferBN->getChoferApellidoP() );
        }
        if ( !is_null( $o_TR_ChoferBN->getChoferApellidoM() ) )
        {
            $this->setChoferApellidoM( $o_TR_ChoferBN->getChoferApellidoM() );
        }
        if ( !is_null( $o_TR_ChoferBN->getChoferNombre() ) )
        {
            $this->setChoferNombre( $o_TR_ChoferBN->getChoferNombre() );
        }
        if ( !is_null( $o_TR_ChoferBN->getChoferTelefono() ) )
        {
            $this->setChoferTelefono( $o_TR_ChoferBN->getChoferTelefono() );
        }
        if ( !is_null( $o_TR_ChoferBN->getChoferLicencia() ) )
        {
            $this->setChoferLicencia( $o_TR_ChoferBN->getChoferLicencia() );
        }
        if ( !is_null( $o_TR_ChoferBN->getChoferCategoria() ) )
        {
            $this->setChoferCategoria( $o_TR_ChoferBN->getChoferCategoria() );
        }
        if ( !is_null( $o_TR_ChoferBN->getChoferDireccion() ) )
        {
            $this->setChoferDireccion( $o_TR_ChoferBN->getChoferDireccion() );
        }
        if ( !is_null( $o_TR_ChoferBN->getChoferUbigeo() ) )
        {
            $this->setChoferUbigeo( $o_TR_ChoferBN->getChoferUbigeo() );
        }
        if ( !is_null( $o_TR_ChoferBN->getChoferAyudante() ) )
        {
            $this->setChoferAyudante( $o_TR_ChoferBN->getChoferAyudante() );
        }
        if ( !is_null( $o_TR_ChoferBN->getEstado() ) )
        {
            $this->setEstado( $o_TR_ChoferBN->getEstado() );
        }
        if ( !is_null( $o_TR_ChoferBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_TR_ChoferBN->getFechaCreacion() );
        }
        if ( !is_null( $o_TR_ChoferBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_TR_ChoferBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_TR_ChoferBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_TR_ChoferBN->getFechaModificacion() );
        }
        if ( !is_null( $o_TR_ChoferBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_TR_ChoferBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return TR_ChoferBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdChofer )
    {
        if( is_null( $i_IdChofer ) ){ $i_IdChofer = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM TR_Chofer ";
        $s_SQLQuery .= "WHERE IdChofer = ".$i_IdChofer." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_TR_ChoferBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_TR_ChoferBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_TR_ChoferBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdChofer() ) ) $s_SQLQuery .= "TR_Chofer.IdChofer = ".$this->getIdChofer()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "TR_Chofer.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "TR_Chofer.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getChoferDocumento() ) ) $s_SQLQuery .= "TR_Chofer.ChoferDocumento = '".$this->getChoferDocumento()."' AND ";
        if ( !is_null( $this->getChoferApellidoP() ) ) $s_SQLQuery .= "TR_Chofer.ChoferApellidoP = '".$this->getChoferApellidoP()."' AND ";
        if ( !is_null( $this->getChoferApellidoM() ) ) $s_SQLQuery .= "TR_Chofer.ChoferApellidoM = '".$this->getChoferApellidoM()."' AND ";
        if ( !is_null( $this->getChoferNombre() ) ) $s_SQLQuery .= "TR_Chofer.ChoferNombre = '".$this->getChoferNombre()."' AND ";
        if ( !is_null( $this->getChoferTelefono() ) ) $s_SQLQuery .= "TR_Chofer.ChoferTelefono = '".$this->getChoferTelefono()."' AND ";
        if ( !is_null( $this->getChoferLicencia() ) ) $s_SQLQuery .= "TR_Chofer.ChoferLicencia = '".$this->getChoferLicencia()."' AND ";
        if ( !is_null( $this->getChoferCategoria() ) ) $s_SQLQuery .= "TR_Chofer.ChoferCategoria = '".$this->getChoferCategoria()."' AND ";
        if ( !is_null( $this->getChoferDireccion() ) ) $s_SQLQuery .= "TR_Chofer.ChoferDireccion = '".$this->getChoferDireccion()."' AND ";
        if ( !is_null( $this->getChoferUbigeo() ) ) $s_SQLQuery .= "TR_Chofer.ChoferUbigeo = '".$this->getChoferUbigeo()."' AND ";
        if ( !is_null( $this->getChoferAyudante() ) ) $s_SQLQuery .= "TR_Chofer.ChoferAyudante = '".$this->getChoferAyudante()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "TR_Chofer.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "TR_Chofer.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "TR_Chofer.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "TR_Chofer.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "TR_Chofer.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM TR_Chofer WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return TR_ChoferBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM TR_Chofer WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_TR_ChoferBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_TR_ChoferBN = $this->insertObjectBN( $a_SQLRow );
                $a_TR_ChoferBN[] = $o_TR_ChoferBN;
            }
        }
        return $a_TR_ChoferBN;
    }

    /* Devuelve un objeto TR_ChoferBN desde un objeto propel */
    public function insertObjectBN( $a_TR_Chofer )
    {
        $o_TR_ChoferBN = new TR_ChoferBN();
        if ( !is_null( $a_TR_Chofer['IdChofer'] ) ) $o_TR_ChoferBN->setIdChofer( ( integer ) $a_TR_Chofer['IdChofer'] );
        if ( !is_null( $a_TR_Chofer['IdCompania'] ) ) $o_TR_ChoferBN->setIdCompania( ( integer ) $a_TR_Chofer['IdCompania'] );
        if ( !is_null( $a_TR_Chofer['IdSucursal'] ) ) $o_TR_ChoferBN->setIdSucursal( ( integer ) $a_TR_Chofer['IdSucursal'] );
        if ( !is_null( $a_TR_Chofer['ChoferDocumento'] ) ) $o_TR_ChoferBN->setChoferDocumento( $a_TR_Chofer['ChoferDocumento'] );
        if ( !is_null( $a_TR_Chofer['ChoferApellidoP'] ) ) $o_TR_ChoferBN->setChoferApellidoP( $a_TR_Chofer['ChoferApellidoP'] );
        if ( !is_null( $a_TR_Chofer['ChoferApellidoM'] ) ) $o_TR_ChoferBN->setChoferApellidoM( $a_TR_Chofer['ChoferApellidoM'] );
        if ( !is_null( $a_TR_Chofer['ChoferNombre'] ) ) $o_TR_ChoferBN->setChoferNombre( $a_TR_Chofer['ChoferNombre'] );
        if ( !is_null( $a_TR_Chofer['ChoferTelefono'] ) ) $o_TR_ChoferBN->setChoferTelefono( $a_TR_Chofer['ChoferTelefono'] );
        if ( !is_null( $a_TR_Chofer['ChoferLicencia'] ) ) $o_TR_ChoferBN->setChoferLicencia( $a_TR_Chofer['ChoferLicencia'] );
        if ( !is_null( $a_TR_Chofer['ChoferCategoria'] ) ) $o_TR_ChoferBN->setChoferCategoria( $a_TR_Chofer['ChoferCategoria'] );
        if ( !is_null( $a_TR_Chofer['ChoferDireccion'] ) ) $o_TR_ChoferBN->setChoferDireccion( $a_TR_Chofer['ChoferDireccion'] );
        if ( !is_null( $a_TR_Chofer['ChoferUbigeo'] ) ) $o_TR_ChoferBN->setChoferUbigeo( $a_TR_Chofer['ChoferUbigeo'] );
        if ( !is_null( $a_TR_Chofer['ChoferAyudante'] ) ) $o_TR_ChoferBN->setChoferAyudante( $a_TR_Chofer['ChoferAyudante'] );
        if ( !is_null( $a_TR_Chofer['Estado'] ) ) $o_TR_ChoferBN->setEstado( $a_TR_Chofer['Estado'] );
        if ( !is_null( $a_TR_Chofer['FechaCreacion'] ) ) $o_TR_ChoferBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_TR_Chofer['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_TR_Chofer['UsuarioCreacion'] ) ) $o_TR_ChoferBN->setUsuarioCreacion( $a_TR_Chofer['UsuarioCreacion'] );
        if ( !is_null( $a_TR_Chofer['FechaModificacion'] ) ) $o_TR_ChoferBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_TR_Chofer['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_TR_Chofer['UsuarioModificacion'] ) ) $o_TR_ChoferBN->setUsuarioModificacion( $a_TR_Chofer['UsuarioModificacion'] );
        return $o_TR_ChoferBN;
    }
}
?>