<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_PreSerieEscaneo.xml */
/* Generado: 2021-06-26 00:00:04 */

/* Busqueda de registros de la tabla SR_PreSerieEscaneo. */
abstract class BaseSR_PreSerieEscaneoFN extends SR_PreSerieEscaneoBN
{
    /* Declaracion de constantes */
    const MovimientoDetalleId = "SR_PreSerieEscaneo.MovimientoDetalleId";
    const SerieId = "SR_PreSerieEscaneo.SerieId";
    const ProductoId = "SR_PreSerieEscaneo.ProductoId";
    const Fecha = "SR_PreSerieEscaneo.Fecha";
    const Operacion = "SR_PreSerieEscaneo.Operacion";
    const Almacen = "SR_PreSerieEscaneo.Almacen";
    const ReferenciaTipo = "SR_PreSerieEscaneo.ReferenciaTipo";
    const ReferenciaNumero = "SR_PreSerieEscaneo.ReferenciaNumero";
    const Comentario = "SR_PreSerieEscaneo.Comentario";
    const UsuarioRegistro = "SR_PreSerieEscaneo.UsuarioRegistro";
    const FechaRegistro = "SR_PreSerieEscaneo.FechaRegistro";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "SR_PreSerieEscaneo.MovimientoDetalleId AS MovimientoDetalleId, ";
        $s_SQLQuery .= "SR_PreSerieEscaneo.SerieId AS SerieId, ";
        $s_SQLQuery .= "SR_PreSerieEscaneo.ProductoId AS ProductoId, ";
        $s_SQLQuery .= "SR_PreSerieEscaneo.Fecha AS Fecha, ";
        $s_SQLQuery .= "SR_PreSerieEscaneo.Operacion AS Operacion, ";
        $s_SQLQuery .= "SR_PreSerieEscaneo.Almacen AS Almacen, ";
        $s_SQLQuery .= "SR_PreSerieEscaneo.ReferenciaTipo AS ReferenciaTipo, ";
        $s_SQLQuery .= "SR_PreSerieEscaneo.ReferenciaNumero AS ReferenciaNumero, ";
        $s_SQLQuery .= "SR_PreSerieEscaneo.Comentario AS Comentario, ";
        $s_SQLQuery .= "SR_PreSerieEscaneo.UsuarioRegistro AS UsuarioRegistro, ";
        $s_SQLQuery .= "SR_PreSerieEscaneo.FechaRegistro AS FechaRegistro ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto SR_PreSerieEscaneoBN */
    public function setByBN( SR_PreSerieEscaneoBN $o_SR_PreSerieEscaneoBN )
    {
        if ( !is_null( $o_SR_PreSerieEscaneoBN->getMovimientoDetalleId() ) )
        {
            $this->setMovimientoDetalleId( $o_SR_PreSerieEscaneoBN->getMovimientoDetalleId() );
        }
        if ( !is_null( $o_SR_PreSerieEscaneoBN->getSerieId() ) )
        {
            $this->setSerieId( $o_SR_PreSerieEscaneoBN->getSerieId() );
        }
        if ( !is_null( $o_SR_PreSerieEscaneoBN->getProductoId() ) )
        {
            $this->setProductoId( $o_SR_PreSerieEscaneoBN->getProductoId() );
        }
        if ( !is_null( $o_SR_PreSerieEscaneoBN->getFecha() ) )
        {
            $this->setFecha( $o_SR_PreSerieEscaneoBN->getFecha() );
        }
        if ( !is_null( $o_SR_PreSerieEscaneoBN->getOperacion() ) )
        {
            $this->setOperacion( $o_SR_PreSerieEscaneoBN->getOperacion() );
        }
        if ( !is_null( $o_SR_PreSerieEscaneoBN->getAlmacen() ) )
        {
            $this->setAlmacen( $o_SR_PreSerieEscaneoBN->getAlmacen() );
        }
        if ( !is_null( $o_SR_PreSerieEscaneoBN->getReferenciaTipo() ) )
        {
            $this->setReferenciaTipo( $o_SR_PreSerieEscaneoBN->getReferenciaTipo() );
        }
        if ( !is_null( $o_SR_PreSerieEscaneoBN->getReferenciaNumero() ) )
        {
            $this->setReferenciaNumero( $o_SR_PreSerieEscaneoBN->getReferenciaNumero() );
        }
        if ( !is_null( $o_SR_PreSerieEscaneoBN->getComentario() ) )
        {
            $this->setComentario( $o_SR_PreSerieEscaneoBN->getComentario() );
        }
        if ( !is_null( $o_SR_PreSerieEscaneoBN->getUsuarioRegistro() ) )
        {
            $this->setUsuarioRegistro( $o_SR_PreSerieEscaneoBN->getUsuarioRegistro() );
        }
        if ( !is_null( $o_SR_PreSerieEscaneoBN->getFechaRegistro() ) )
        {
            $this->setFechaRegistro( $o_SR_PreSerieEscaneoBN->getFechaRegistro() );
        }
    }

    /**
    * @return SR_PreSerieEscaneoBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_MovimientoDetalleId, $i_SerieId )
    {
        if( is_null( $i_MovimientoDetalleId ) ){ $i_MovimientoDetalleId = -1; } 
        if( is_null( $i_SerieId ) ){ $i_SerieId = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SR_PreSerieEscaneo ";
        $s_SQLQuery .= "WHERE MovimientoDetalleId = ".$i_MovimientoDetalleId." ";
        $s_SQLQuery .= "AND SerieId = ".$i_SerieId." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_SR_PreSerieEscaneoBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_SR_PreSerieEscaneoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_SR_PreSerieEscaneoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getMovimientoDetalleId() ) ) $s_SQLQuery .= "SR_PreSerieEscaneo.MovimientoDetalleId = ".$this->getMovimientoDetalleId()." AND ";
        if ( !is_null( $this->getSerieId() ) ) $s_SQLQuery .= "SR_PreSerieEscaneo.SerieId = ".$this->getSerieId()." AND ";
        if ( !is_null( $this->getProductoId() ) ) $s_SQLQuery .= "SR_PreSerieEscaneo.ProductoId = '".$this->getProductoId()."' AND ";
        if ( !is_null( $this->getFecha() ) ) $s_SQLQuery .= "SR_PreSerieEscaneo.Fecha = '".$this->getFecha()."' AND ";
        if ( !is_null( $this->getOperacion() ) ) $s_SQLQuery .= "SR_PreSerieEscaneo.Operacion = '".$this->getOperacion()."' AND ";
        if ( !is_null( $this->getAlmacen() ) ) $s_SQLQuery .= "SR_PreSerieEscaneo.Almacen = '".$this->getAlmacen()."' AND ";
        if ( !is_null( $this->getReferenciaTipo() ) ) $s_SQLQuery .= "SR_PreSerieEscaneo.ReferenciaTipo = '".$this->getReferenciaTipo()."' AND ";
        if ( !is_null( $this->getReferenciaNumero() ) ) $s_SQLQuery .= "SR_PreSerieEscaneo.ReferenciaNumero = '".$this->getReferenciaNumero()."' AND ";
        if ( !is_null( $this->getComentario() ) ) $s_SQLQuery .= "SR_PreSerieEscaneo.Comentario = '".$this->getComentario()."' AND ";
        if ( !is_null( $this->getUsuarioRegistro() ) ) $s_SQLQuery .= "SR_PreSerieEscaneo.UsuarioRegistro = '".$this->getUsuarioRegistro()."' AND ";
        if ( !is_null( $this->getFechaRegistro() ) ) $s_SQLQuery .= "SR_PreSerieEscaneo.FechaRegistro = '".$this->getFechaRegistro()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM SR_PreSerieEscaneo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return SR_PreSerieEscaneoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SR_PreSerieEscaneo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_SR_PreSerieEscaneoBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_SR_PreSerieEscaneoBN = $this->insertObjectBN( $a_SQLRow );
                $a_SR_PreSerieEscaneoBN[] = $o_SR_PreSerieEscaneoBN;
            }
        }
        return $a_SR_PreSerieEscaneoBN;
    }

    /* Devuelve un objeto SR_PreSerieEscaneoBN desde un objeto propel */
    public function insertObjectBN( $a_SR_PreSerieEscaneo )
    {
        $o_SR_PreSerieEscaneoBN = new SR_PreSerieEscaneoBN();
        if ( !is_null( $a_SR_PreSerieEscaneo['MovimientoDetalleId'] ) ) $o_SR_PreSerieEscaneoBN->setMovimientoDetalleId( ( integer ) $a_SR_PreSerieEscaneo['MovimientoDetalleId'] );
        if ( !is_null( $a_SR_PreSerieEscaneo['SerieId'] ) ) $o_SR_PreSerieEscaneoBN->setSerieId( ( integer ) $a_SR_PreSerieEscaneo['SerieId'] );
        if ( !is_null( $a_SR_PreSerieEscaneo['ProductoId'] ) ) $o_SR_PreSerieEscaneoBN->setProductoId( $a_SR_PreSerieEscaneo['ProductoId'] );
        if ( !is_null( $a_SR_PreSerieEscaneo['Fecha'] ) ) $o_SR_PreSerieEscaneoBN->setFecha( utilTimestamp::getTimestamp( $a_SR_PreSerieEscaneo['Fecha'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SR_PreSerieEscaneo['Operacion'] ) ) $o_SR_PreSerieEscaneoBN->setOperacion( $a_SR_PreSerieEscaneo['Operacion'] );
        if ( !is_null( $a_SR_PreSerieEscaneo['Almacen'] ) ) $o_SR_PreSerieEscaneoBN->setAlmacen( $a_SR_PreSerieEscaneo['Almacen'] );
        if ( !is_null( $a_SR_PreSerieEscaneo['ReferenciaTipo'] ) ) $o_SR_PreSerieEscaneoBN->setReferenciaTipo( $a_SR_PreSerieEscaneo['ReferenciaTipo'] );
        if ( !is_null( $a_SR_PreSerieEscaneo['ReferenciaNumero'] ) ) $o_SR_PreSerieEscaneoBN->setReferenciaNumero( $a_SR_PreSerieEscaneo['ReferenciaNumero'] );
        if ( !is_null( $a_SR_PreSerieEscaneo['Comentario'] ) ) $o_SR_PreSerieEscaneoBN->setComentario( $a_SR_PreSerieEscaneo['Comentario'] );
        if ( !is_null( $a_SR_PreSerieEscaneo['UsuarioRegistro'] ) ) $o_SR_PreSerieEscaneoBN->setUsuarioRegistro( $a_SR_PreSerieEscaneo['UsuarioRegistro'] );
        if ( !is_null( $a_SR_PreSerieEscaneo['FechaRegistro'] ) ) $o_SR_PreSerieEscaneoBN->setFechaRegistro( utilTimestamp::getTimestamp( $a_SR_PreSerieEscaneo['FechaRegistro'], "Y-m-d H:i:s" ) );
        return $o_SR_PreSerieEscaneoBN;
    }
}
?>